/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.UnsupportedTypeException;
import com.amazon.carbonado.lob.Blob;
import com.amazon.carbonado.repo.jdbc.JDBCBlob;
import com.amazon.carbonado.repo.jdbc.JDBCBlobLoader;
import com.amazon.carbonado.repo.jdbc.JDBCClob;
import com.amazon.carbonado.repo.jdbc.JDBCClobLoader;
import com.amazon.carbonado.repo.jdbc.JDBCExceptionTransformer;
import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import com.amazon.carbonado.repo.jdbc.JDBCSequenceValueProducer;
import com.amazon.carbonado.sequence.SequenceValueGenerator;
import com.amazon.carbonado.sequence.SequenceValueProducer;
import com.amazon.carbonado.sequence.StoredSequence;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.cojen.util.ThrowUnchecked;

class JDBCSupportStrategy {
    private static final int BLOB_BUFFER_SIZE = 4000;
    private static final int CLOB_BUFFER_SIZE = 2000;
    protected final JDBCRepository mRepo;
    private String mSequenceSelectStatement;
    private boolean mForceStoredSequence = false;
    private String mTruncateTableStatement;

    static JDBCSupportStrategy createStrategy(JDBCRepository repo) {
        String databaseProductName = repo.getDatabaseProductName().trim();
        if (databaseProductName != null && databaseProductName.length() > 0) {
            String strategyName = Character.toUpperCase(databaseProductName.charAt(0)) + databaseProductName.substring(1).toLowerCase();
            if (strategyName.indexOf(32) > 0) {
                strategyName = strategyName.substring(0, strategyName.indexOf(32));
            }
            strategyName = strategyName.replaceAll("[^A-Za-z0-9]", "");
            String className = "com.amazon.carbonado.repo.jdbc." + strategyName + "SupportStrategy";
            try {
                Class<?> clazz = Class.forName(className);
                return (JDBCSupportStrategy)clazz.getDeclaredConstructor(JDBCRepository.class).newInstance(repo);
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                ThrowUnchecked.fireFirstDeclaredCause((Throwable)e, (Class[])new Class[0]);
            }
        }
        return new JDBCSupportStrategy(repo);
    }

    protected JDBCSupportStrategy(JDBCRepository repo) {
        this.mRepo = repo;
    }

    JDBCExceptionTransformer createExceptionTransformer() {
        return new JDBCExceptionTransformer();
    }

    SequenceValueProducer createSequenceValueProducer(String name) throws RepositoryException {
        if (name == null) {
            throw new IllegalArgumentException("Sequence name is null");
        }
        String format = this.getSequenceSelectStatement();
        if (format != null && format.length() > 0 && !this.isForceStoredSequence()) {
            String sequenceQuery = String.format(format, name);
            return new JDBCSequenceValueProducer(this.mRepo, sequenceQuery);
        }
        try {
            return new SequenceValueGenerator(this.mRepo, name);
        }
        catch (UnsupportedTypeException e) {
            if (e.getType() != StoredSequence.class) {
                throw e;
            }
            throw new PersistException("Native sequences are not currently supported for \"" + this.mRepo.getDatabaseProductName() + "\". Instead, define a table named " + "CARBONADO_SEQUENCE as required by " + StoredSequence.class.getName() + '.');
        }
    }

    JDBCBlob convertBlob(java.sql.Blob blob, JDBCBlobLoader loader) {
        return blob == null ? null : new JDBCBlob(this.mRepo, blob, loader);
    }

    JDBCClob convertClob(Clob clob, JDBCClobLoader loader) {
        return clob == null ? null : new JDBCClob(this.mRepo, clob, loader);
    }

    Blob setBlobValue(PreparedStatement ps, int column, Blob blob) throws PersistException {
        try {
            if (blob instanceof JDBCBlob) {
                ps.setBlob(column, ((JDBCBlob)blob).getInternalBlobForPersist());
                return null;
            }
            long length = blob.getLength();
            if ((long)((int)length) != length) {
                throw new PersistException("BLOB length is too long: " + length);
            }
            ps.setBinaryStream(column, blob.openInputStream(), (int)length);
            return null;
        }
        catch (SQLException e) {
            throw this.mRepo.toPersistException(e);
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
    }

    com.amazon.carbonado.lob.Clob setClobValue(PreparedStatement ps, int column, com.amazon.carbonado.lob.Clob clob) throws PersistException {
        try {
            if (clob instanceof JDBCClob) {
                ps.setClob(column, ((JDBCClob)clob).getInternalClobForPersist());
                return null;
            }
            long length = clob.getLength();
            if ((long)((int)length) != length) {
                throw new PersistException("CLOB length is too long: " + length);
            }
            ps.setCharacterStream(column, clob.openReader(), (int)length);
            return null;
        }
        catch (SQLException e) {
            throw this.mRepo.toPersistException(e);
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
    }

    void updateBlob(Blob oldBlob, Blob newBlob) throws PersistException {
        try {
            int amt;
            OutputStream out = oldBlob.openOutputStream();
            InputStream in = newBlob.openInputStream();
            byte[] buf = new byte[4000];
            while ((amt = in.read(buf)) > 0) {
                out.write(buf, 0, amt);
            }
            in.close();
            out.close();
            oldBlob.setLength(newBlob.getLength());
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
        catch (IOException e) {
            throw this.mRepo.toPersistException(e);
        }
    }

    void updateClob(com.amazon.carbonado.lob.Clob oldClob, com.amazon.carbonado.lob.Clob newClob) throws PersistException {
        try {
            int amt;
            Writer out = oldClob.openWriter();
            Reader in = newClob.openReader();
            char[] buf = new char[2000];
            while ((amt = in.read(buf)) > 0) {
                out.write(buf, 0, amt);
            }
            in.close();
            out.close();
            oldClob.setLength(newClob.getLength());
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
        catch (IOException e) {
            throw this.mRepo.toPersistException(e);
        }
    }

    boolean printPlan(Appendable app, int indentLevel, String statement) throws FetchException, IOException {
        return false;
    }

    String getSequenceSelectStatement() {
        return this.mSequenceSelectStatement;
    }

    void setSequenceSelectStatement(String sequenceSelectStatement) {
        this.mSequenceSelectStatement = sequenceSelectStatement;
    }

    boolean isForceStoredSequence() {
        return this.mForceStoredSequence;
    }

    void setForceStoredSequence(boolean forceStoredSequence) {
        this.mForceStoredSequence = forceStoredSequence;
    }

    String getTruncateTableStatement() {
        return this.mTruncateTableStatement;
    }

    void setTruncateTableStatement(String truncateTableStatement) {
        this.mTruncateTableStatement = truncateTableStatement;
    }

    SliceOption getSliceOption() {
        return SliceOption.NOT_SUPPORTED;
    }

    String buildSelectWithSlice(String select, boolean from, boolean to) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SliceOption {
        NOT_SUPPORTED,
        LIMIT_ONLY,
        OFFSET_ONLY,
        LIMIT_AND_OFFSET,
        OFFSET_AND_LIMIT,
        FROM_AND_TO;

    }
}

