/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.TriggerFactory;
import com.amazon.carbonado.UnsupportedTypeException;
import com.amazon.carbonado.capability.IndexInfo;
import com.amazon.carbonado.capability.IndexInfoCapability;
import com.amazon.carbonado.capability.ShutdownCapability;
import com.amazon.carbonado.capability.StorableInfoCapability;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.repo.jdbc.JDBCConnectionCapability;
import com.amazon.carbonado.repo.jdbc.JDBCExceptionTransformer;
import com.amazon.carbonado.repo.jdbc.JDBCStorableInfo;
import com.amazon.carbonado.repo.jdbc.JDBCStorableIntrospector;
import com.amazon.carbonado.repo.jdbc.JDBCStorableProperty;
import com.amazon.carbonado.repo.jdbc.JDBCStorage;
import com.amazon.carbonado.repo.jdbc.JDBCSupportStrategy;
import com.amazon.carbonado.repo.jdbc.JDBCTransaction;
import com.amazon.carbonado.repo.jdbc.JDBCTransactionManager;
import com.amazon.carbonado.repo.jdbc.SchemaResolver;
import com.amazon.carbonado.sequence.SequenceCapability;
import com.amazon.carbonado.sequence.SequenceValueProducer;
import com.amazon.carbonado.spi.AbstractRepository;
import com.amazon.carbonado.txn.TransactionManager;
import com.amazon.carbonado.txn.TransactionScope;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cojen.util.ThrowUnchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JDBCRepository
extends AbstractRepository<JDBCTransaction>
implements Repository,
IndexInfoCapability,
ShutdownCapability,
StorableInfoCapability,
JDBCConnectionCapability,
SequenceCapability {
    private final Log mLog = LogFactory.getLog(this.getClass());
    private final boolean mIsMaster;
    final Iterable<TriggerFactory> mTriggerFactories;
    private final AtomicReference<Repository> mRootRef;
    private final String mDatabaseProductName;
    private final DataSource mDataSource;
    private final boolean mDataSourceClose;
    private final String mCatalog;
    private final String mSchema;
    private final Integer mFetchSize;
    private final boolean mPrimaryKeyCheckDisabled;
    private Map<String, Boolean> mAutoVersioningMap;
    private Map<String, Boolean> mSuppressReloadMap;
    private Map<Connection, Object> mOpenConnections;
    private final Lock mOpenConnectionsLock;
    private final boolean mSupportsSavepoints;
    private final boolean mSupportsSelectForUpdate;
    private final boolean mSupportsScrollInsensitiveReadOnly;
    private final IsolationLevel mDefaultIsolationLevel;
    private final int mJdbcDefaultIsolationLevel;
    private final JDBCSupportStrategy mSupportStrategy;
    private JDBCExceptionTransformer mExceptionTransformer;
    private final SchemaResolver mResolver;
    private final JDBCTransactionManager mTxnMgr;
    final IsolationLevel mReadUncommittedLevel;
    final IsolationLevel mReadCommittedLevel;
    final IsolationLevel mRepeatableReadLevel;
    final IsolationLevel mSerializableLevel;

    public static boolean closeDataSource(DataSource ds) throws SQLException {
        try {
            Method closeMethod = ds.getClass().getMethod("close", new Class[0]);
            try {
                closeMethod.invoke((Object)ds, new Object[0]);
            }
            catch (Throwable e) {
                ThrowUnchecked.fireFirstDeclaredCause((Throwable)e, (Class[])new Class[]{SQLException.class});
            }
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    static IsolationLevel mapIsolationLevelFromJdbc(int jdbcLevel) {
        switch (jdbcLevel) {
            default: {
                return IsolationLevel.NONE;
            }
            case 1: {
                return IsolationLevel.READ_UNCOMMITTED;
            }
            case 2: {
                return IsolationLevel.READ_COMMITTED;
            }
            case 4: {
                return IsolationLevel.REPEATABLE_READ;
            }
            case 8: 
        }
        return IsolationLevel.SERIALIZABLE;
    }

    static int mapIsolationLevelToJdbc(IsolationLevel level) {
        switch (level) {
            default: {
                return 0;
            }
            case READ_UNCOMMITTED: {
                return 1;
            }
            case READ_COMMITTED: {
                return 2;
            }
            case REPEATABLE_READ: {
                return 4;
            }
            case SNAPSHOT: {
                return 8;
            }
            case SERIALIZABLE: 
        }
        return 8;
    }

    private static IsolationLevel selectIsolationLevel(DatabaseMetaData md, IsolationLevel desiredLevel) throws SQLException, RepositoryException {
        block6: while (!md.supportsTransactionIsolationLevel(JDBCRepository.mapIsolationLevelToJdbc(desiredLevel))) {
            switch (desiredLevel) {
                case READ_UNCOMMITTED: {
                    desiredLevel = IsolationLevel.READ_COMMITTED;
                    continue block6;
                }
                case READ_COMMITTED: {
                    desiredLevel = IsolationLevel.REPEATABLE_READ;
                    continue block6;
                }
                case REPEATABLE_READ: {
                    desiredLevel = IsolationLevel.SERIALIZABLE;
                    continue block6;
                }
                case SNAPSHOT: {
                    desiredLevel = IsolationLevel.SERIALIZABLE;
                    continue block6;
                }
            }
            return null;
        }
        return desiredLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JDBCRepository(AtomicReference<Repository> rootRef, String name, boolean isMaster, Iterable<TriggerFactory> triggerFactories, DataSource dataSource, boolean dataSourceClose, String catalog, String schema, Integer fetchSize, Map<String, Boolean> autoVersioningMap, Map<String, Boolean> suppressReloadMap, String sequenceSelectStatement, boolean forceStoredSequence, boolean primaryKeyCheckDisabled, SchemaResolver resolver) throws RepositoryException {
        super(name);
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource cannot be null");
        }
        this.mIsMaster = isMaster;
        this.mTriggerFactories = triggerFactories;
        this.mRootRef = rootRef;
        this.mDataSource = dataSource;
        this.mDataSourceClose = dataSourceClose;
        this.mCatalog = catalog;
        this.mSchema = schema;
        this.mFetchSize = fetchSize;
        this.mPrimaryKeyCheckDisabled = primaryKeyCheckDisabled;
        this.mAutoVersioningMap = autoVersioningMap;
        this.mSuppressReloadMap = suppressReloadMap;
        this.mResolver = resolver;
        this.mOpenConnections = new IdentityHashMap<Connection, Object>();
        this.mOpenConnectionsLock = new ReentrantLock(true);
        this.mExceptionTransformer = new JDBCExceptionTransformer();
        this.mTxnMgr = new JDBCTransactionManager(this);
        this.getLog().info((Object)("Opening repository \"" + this.getName() + '\"'));
        Connection con = this.getConnection();
        try {
            boolean supportsSavepoints;
            DatabaseMetaData md = con.getMetaData();
            if (md == null || !md.supportsTransactions()) {
                throw new RepositoryException("Database does not support transactions");
            }
            this.mDatabaseProductName = md.getDatabaseProductName();
            try {
                supportsSavepoints = md.supportsSavepoints();
            }
            catch (AbstractMethodError e) {
                supportsSavepoints = false;
            }
            if (supportsSavepoints) {
                con.setAutoCommit(false);
                try {
                    con.setSavepoint();
                }
                catch (SQLException e) {
                    this.mLog.warn((Object)("JDBC driver for " + this.mDatabaseProductName + " reports supporting savepoints, but it " + "doesn't appear to work: " + e));
                    supportsSavepoints = false;
                }
                finally {
                    con.rollback();
                    con.setAutoCommit(true);
                }
            }
            this.mSupportsSavepoints = supportsSavepoints;
            this.mSupportsSelectForUpdate = md.supportsSelectForUpdate();
            this.mSupportsScrollInsensitiveReadOnly = md.supportsResultSetConcurrency(1004, 1007);
            this.mJdbcDefaultIsolationLevel = md.getDefaultTransactionIsolation();
            this.mDefaultIsolationLevel = JDBCRepository.mapIsolationLevelFromJdbc(this.mJdbcDefaultIsolationLevel);
            this.mReadUncommittedLevel = JDBCRepository.selectIsolationLevel(md, IsolationLevel.READ_UNCOMMITTED);
            this.mReadCommittedLevel = JDBCRepository.selectIsolationLevel(md, IsolationLevel.READ_COMMITTED);
            this.mRepeatableReadLevel = JDBCRepository.selectIsolationLevel(md, IsolationLevel.REPEATABLE_READ);
            this.mSerializableLevel = JDBCRepository.selectIsolationLevel(md, IsolationLevel.SERIALIZABLE);
        }
        catch (SQLException e) {
            throw this.toRepositoryException(e);
        }
        finally {
            try {
                this.closeConnection(con);
            }
            catch (SQLException e) {}
        }
        this.mSupportStrategy = JDBCSupportStrategy.createStrategy(this);
        if (forceStoredSequence) {
            this.mSupportStrategy.setSequenceSelectStatement(null);
        } else if (sequenceSelectStatement != null && sequenceSelectStatement.length() > 0) {
            this.mSupportStrategy.setSequenceSelectStatement(sequenceSelectStatement);
        }
        this.mSupportStrategy.setForceStoredSequence(forceStoredSequence);
        this.mExceptionTransformer = this.mSupportStrategy.createExceptionTransformer();
        this.getLog().info((Object)("Opened repository \"" + this.getName() + '\"'));
        this.setAutoShutdownEnabled(true);
    }

    public DataSource getDataSource() {
        return this.mDataSource;
    }

    @Override
    public boolean isTransactionForUpdate() {
        return this.localTransactionScope().isForUpdate();
    }

    public <S extends Storable> JDBCStorableInfo<S> examineStorable(Class<S> type) throws RepositoryException, SupportException {
        try {
            return JDBCStorableIntrospector.examine(type, this.mDataSource, this.mCatalog, this.mSchema, this.mResolver, this.mPrimaryKeyCheckDisabled);
        }
        catch (SQLException e) {
            throw this.toRepositoryException(e);
        }
    }

    @Override
    public <S extends Storable> IndexInfo[] getIndexInfo(Class<S> storableType) throws RepositoryException {
        return ((JDBCStorage)this.storageFor(storableType)).getIndexInfo();
    }

    @Override
    public String[] getUserStorableTypeNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Storage storage : this.allStorage()) {
            names.add(storage.getStorableType().getName());
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public boolean isSupported(Class<Storable> type) {
        if (type == null) {
            return false;
        }
        try {
            this.examineStorable(type);
            return true;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public boolean isPropertySupported(Class<Storable> type, String name) {
        if (type == null || name == null) {
            return false;
        }
        try {
            JDBCStorableProperty<Storable> prop = this.examineStorable(type).getAllProperties().get(name);
            return prop == null ? false : prop.isSupported();
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    <S extends Storable> JDBCStorableProperty<S> getJDBCStorableProperty(StorableProperty<S> property) throws RepositoryException, SupportException {
        JDBCStorableInfo<S> info = this.examineStorable(property.getEnclosingType());
        JDBCStorableProperty<S> jProperty = info.getAllProperties().get(property.getName());
        if (!jProperty.isSupported()) {
            throw new UnsupportedOperationException("Property is not supported: " + property.getName());
        }
        return jProperty;
    }

    @Override
    public String getDatabaseProductName() {
        return this.mDatabaseProductName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws FetchException {
        try {
            if (this.mOpenConnections == null) {
                throw new FetchException("Repository is closed");
            }
            JDBCTransaction txn = this.localTransactionScope().getTxn();
            if (txn != null) {
                return txn.getConnection();
            }
            Connection con = this.mDataSource.getConnection();
            con.setAutoCommit(true);
            this.mOpenConnectionsLock.lock();
            try {
                if (this.mOpenConnections == null) {
                    con.close();
                    throw new FetchException("Repository is closed");
                }
                this.mOpenConnections.put(con, null);
            }
            finally {
                this.mOpenConnectionsLock.unlock();
            }
            return con;
        }
        catch (Exception e) {
            throw this.toFetchException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnectionForTxn(IsolationLevel level) throws FetchException {
        try {
            if (this.mOpenConnections == null) {
                throw new FetchException("Repository is closed");
            }
            Connection con = this.mDataSource.getConnection();
            if (level == IsolationLevel.NONE) {
                con.setAutoCommit(true);
            } else {
                con.setAutoCommit(false);
                if (level != this.mDefaultIsolationLevel) {
                    con.setTransactionIsolation(JDBCRepository.mapIsolationLevelToJdbc(level));
                }
            }
            this.mOpenConnectionsLock.lock();
            try {
                if (this.mOpenConnections == null) {
                    con.close();
                    throw new FetchException("Repository is closed");
                }
                this.mOpenConnections.put(con, null);
            }
            finally {
                this.mOpenConnectionsLock.unlock();
            }
            return con;
        }
        catch (Exception e) {
            throw this.toFetchException(e);
        }
    }

    @Override
    public void yieldConnection(Connection con) throws FetchException {
        try {
            if (con.getAutoCommit()) {
                this.closeConnection(con);
            }
        }
        catch (Exception e) {
            throw this.toFetchException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeConnection(Connection con) throws SQLException {
        this.mOpenConnectionsLock.lock();
        try {
            if (this.mOpenConnections != null) {
                this.mOpenConnections.remove(con);
            }
        }
        finally {
            this.mOpenConnectionsLock.unlock();
        }
        con.close();
    }

    boolean supportsSavepoints() {
        return this.mSupportsSavepoints;
    }

    boolean supportsSelectForUpdate() {
        return this.mSupportsSelectForUpdate;
    }

    boolean supportsScrollInsensitiveReadOnly() {
        return this.mSupportsScrollInsensitiveReadOnly;
    }

    IsolationLevel selectIsolationLevel(Transaction parent, IsolationLevel desiredLevel) {
        if (desiredLevel == null) {
            desiredLevel = parent == null ? this.mDefaultIsolationLevel : parent.getIsolationLevel();
        } else if (parent != null) {
            IsolationLevel parentLevel = parent.getIsolationLevel();
            if (parentLevel.compareTo(desiredLevel) >= 0) {
                desiredLevel = parentLevel;
            } else {
                return null;
            }
        }
        switch (desiredLevel) {
            case NONE: {
                return IsolationLevel.NONE;
            }
            case READ_UNCOMMITTED: {
                return this.mReadUncommittedLevel;
            }
            case READ_COMMITTED: {
                return this.mReadCommittedLevel;
            }
            case REPEATABLE_READ: {
                return this.mRepeatableReadLevel;
            }
            case SERIALIZABLE: {
                return this.mSerializableLevel;
            }
        }
        return null;
    }

    JDBCSupportStrategy getSupportStrategy() {
        return this.mSupportStrategy;
    }

    Repository getRootRepository() {
        return this.mRootRef.get();
    }

    Integer getFetchSize() {
        return this.mFetchSize;
    }

    @Override
    public FetchException toFetchException(Throwable e) {
        return this.mExceptionTransformer.toFetchException(e);
    }

    @Override
    public PersistException toPersistException(Throwable e) {
        return this.mExceptionTransformer.toPersistException(e);
    }

    public RepositoryException toRepositoryException(Throwable e) {
        return this.mExceptionTransformer.toRepositoryException(e);
    }

    @Override
    public boolean isUniqueConstraintError(SQLException e) {
        return this.mExceptionTransformer.isUniqueConstraintError(e);
    }

    JDBCExceptionTransformer getExceptionTransformer() {
        return this.mExceptionTransformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shutdownHook() {
        this.mOpenConnectionsLock.lock();
        try {
            if (this.mOpenConnections != null) {
                for (Connection con : this.mOpenConnections.keySet()) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        this.getLog().warn(null, (Throwable)e);
                    }
                }
                this.mOpenConnections = null;
            }
        }
        finally {
            this.mOpenConnectionsLock.unlock();
        }
        if (this.mDataSourceClose) {
            this.mLog.info((Object)("Closing DataSource: " + this.mDataSource));
            try {
                if (!JDBCRepository.closeDataSource(this.mDataSource)) {
                    this.mLog.info((Object)("DataSource doesn't have a close method: " + this.mDataSource.getClass().getName()));
                }
            }
            catch (SQLException e) {
                this.mLog.error((Object)"Failed to close DataSource", (Throwable)e);
            }
        }
    }

    @Override
    protected Log getLog() {
        return this.mLog;
    }

    @Override
    protected <S extends Storable> Storage<S> createStorage(Class<S> type) throws RepositoryException {
        JDBCStorableInfo<S> info = this.examineStorable(type);
        if (!info.isSupported()) {
            throw new UnsupportedTypeException("Independent type not supported", type);
        }
        Boolean autoVersioning = false;
        if (this.mAutoVersioningMap != null && (autoVersioning = this.mAutoVersioningMap.get(type.getName())) == null && (autoVersioning = this.mAutoVersioningMap.get(null)) == null) {
            autoVersioning = false;
        }
        Boolean suppressReload = false;
        if (this.mSuppressReloadMap != null && (suppressReload = this.mSuppressReloadMap.get(type.getName())) == null && (suppressReload = this.mSuppressReloadMap.get(null)) == null) {
            suppressReload = false;
        }
        return new JDBCStorage<S>(this, info, this.mIsMaster, autoVersioning, suppressReload);
    }

    @Override
    protected SequenceValueProducer createSequenceValueProducer(String name) throws RepositoryException {
        return this.mSupportStrategy.createSequenceValueProducer(name);
    }

    @Override
    protected final TransactionManager<JDBCTransaction> transactionManager() {
        return this.mTxnMgr;
    }

    @Override
    protected final TransactionScope<JDBCTransaction> localTransactionScope() {
        return this.mTxnMgr.localScope();
    }
}

