/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchNoneException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistNoneException;
import com.amazon.carbonado.lob.AbstractBlob;
import com.amazon.carbonado.repo.jdbc.JDBCBlobLoader;
import com.amazon.carbonado.repo.jdbc.JDBCLob;
import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import com.amazon.carbonado.repo.jdbc.JDBCTransaction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

class JDBCBlob
extends AbstractBlob
implements JDBCLob {
    private static final int DEFAULT_BUFFER = 4000;
    protected final JDBCRepository mRepo;
    private Blob mBlob;
    private final JDBCBlobLoader mLoader;

    JDBCBlob(JDBCRepository repo, Blob blob, JDBCBlobLoader loader) {
        super(repo);
        this.mRepo = repo;
        this.mBlob = blob;
        this.mLoader = loader;
    }

    public InputStream openInputStream() throws FetchException {
        try {
            return this.getInternalBlobForFetch().getBinaryStream();
        }
        catch (SQLException e) {
            throw this.mRepo.toFetchException(e);
        }
    }

    public InputStream openInputStream(long pos) throws FetchException {
        try {
            if (pos == 0L) {
                return this.getInternalBlobForFetch().getBinaryStream();
            }
            return new Input(this.getInternalBlobForFetch(), 4000, pos);
        }
        catch (SQLException e) {
            throw this.mRepo.toFetchException(e);
        }
    }

    public InputStream openInputStream(long pos, int bufferSize) throws FetchException {
        try {
            if (pos == 0L) {
                return this.getInternalBlobForFetch().getBinaryStream();
            }
            if (bufferSize <= 0) {
                bufferSize = 4000;
            }
            return new Input(this.getInternalBlobForFetch(), bufferSize, pos);
        }
        catch (SQLException e) {
            throw this.mRepo.toFetchException(e);
        }
    }

    public long getLength() throws FetchException {
        try {
            return this.getInternalBlobForFetch().length();
        }
        catch (SQLException e) {
            throw this.mRepo.toFetchException(e);
        }
    }

    public OutputStream openOutputStream() throws PersistException {
        return this.openOutputStream(0L);
    }

    public OutputStream openOutputStream(long pos) throws PersistException {
        try {
            return this.getInternalBlobForPersist().setBinaryStream(pos);
        }
        catch (SQLException e) {
            throw this.mRepo.toPersistException(e);
        }
    }

    public OutputStream openOutputStream(long pos, int bufferSize) throws PersistException {
        return this.openOutputStream(pos);
    }

    public void setLength(long length) throws PersistException {
        try {
            this.getInternalBlobForPersist().truncate(length);
        }
        catch (SQLException e) {
            throw this.mRepo.toPersistException(e);
        }
    }

    public Object getLocator() {
        return null;
    }

    public void close() {
        this.mBlob = null;
    }

    Blob getInternalBlobForFetch() throws FetchException {
        if (this.mBlob == null) {
            this.mBlob = this.mLoader.load(this.mRepo);
            if (this.mBlob == null) {
                throw new FetchNoneException("Blob value is null");
            }
            try {
                JDBCTransaction txn = this.mRepo.localTransactionScope().getTxn();
                if (txn != null) {
                    txn.register(this);
                }
            }
            catch (Exception e) {
                throw this.mRepo.toFetchException(e);
            }
        }
        return this.mBlob;
    }

    Blob getInternalBlobForPersist() throws PersistException {
        if (this.mBlob == null) {
            try {
                this.mBlob = this.mLoader.load(this.mRepo);
                if (this.mBlob == null) {
                    throw new PersistNoneException("Blob value is null");
                }
                JDBCTransaction txn = this.mRepo.localTransactionScope().getTxn();
                if (txn != null) {
                    txn.register(this);
                }
            }
            catch (Exception e) {
                throw this.mRepo.toPersistException(e);
            }
        }
        return this.mBlob;
    }

    private static class Input
    extends InputStream {
        private final Blob mBlob;
        private final int mBufferSize;
        private long mPos;
        private byte[] mBuffer;
        private int mBufferPos;

        Input(Blob blob, int bufferSize, long pos) {
            this.mBlob = blob;
            this.mBufferSize = bufferSize;
            this.mPos = pos;
        }

        public int read() throws IOException {
            if (this.fillBuffer() <= 0) {
                return -1;
            }
            return this.mBuffer[this.mBufferPos++];
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int avail = this.fillBuffer();
            if (avail <= 0) {
                return -1;
            }
            if (len > avail) {
                len = avail;
            }
            System.arraycopy(this.mBuffer, this.mBufferPos, b, off, len);
            this.mBufferPos += len;
            return len;
        }

        public long skip(long n) throws IOException {
            long length;
            if (n <= 0L) {
                return 0L;
            }
            long newPos = this.mPos + n;
            try {
                length = this.mBlob.length();
            }
            catch (SQLException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            if (newPos >= length) {
                newPos = length;
                n = newPos - this.mPos;
            }
            long newBufferPos = (long)this.mBufferPos + n;
            if (this.mBuffer == null || newBufferPos >= (long)this.mBuffer.length) {
                this.mBuffer = null;
                this.mBufferPos = 0;
            } else {
                this.mBufferPos = (int)newBufferPos;
            }
            this.mPos = newPos;
            return n;
        }

        private int fillBuffer() throws IOException {
            try {
                if (this.mBuffer == null || this.mBufferPos >= this.mBuffer.length) {
                    this.mBuffer = this.mBlob.getBytes(this.mPos, this.mBufferSize);
                    this.mPos += (long)this.mBuffer.length;
                    this.mBufferPos = 0;
                }
                return this.mBuffer.length - this.mBufferPos;
            }
            catch (SQLException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
    }
}

