/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.indexed;

import com.amazon.carbonado.CorruptEncodingException;
import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchTimeoutException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistTimeoutException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.UniqueConstraintException;
import com.amazon.carbonado.cursor.MergeSortBuffer;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.RelOp;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableKey;
import com.amazon.carbonado.repo.indexed.IndexEntryAccessor;
import com.amazon.carbonado.repo.indexed.IndexedCursor;
import com.amazon.carbonado.repo.indexed.IndexedRepository;
import com.amazon.carbonado.repo.indexed.IndexedStorage;
import com.amazon.carbonado.synthetic.SyntheticStorableReferenceAccess;
import com.amazon.carbonado.util.Throttle;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ManagedIndex<S extends Storable>
implements IndexEntryAccessor<S> {
    private static final int BUILD_SORT_BUFFER_SIZE = 65536;
    private static final int BUILD_INFO_DELAY_MILLIS = 5000;
    static final int BUILD_BATCH_SIZE = 128;
    static final int BUILD_THROTTLE_WINDOW = 1280;
    static final int BUILD_THROTTLE_SLEEP_PRECISION = 10;
    private static final int BUILD_TXN_TIMEOUT_MILLIS;
    private final IndexedRepository mRepository;
    private final Storage<S> mMasterStorage;
    private final StorableIndex mIndex;
    private final SyntheticStorableReferenceAccess<S> mAccessor;
    private final Storage<?> mIndexEntryStorage;
    private Query<?> mSingleMatchQuery;

    private static String[] naturalOrdering(Class<? extends Storable> type) {
        StorableKey<? extends Storable> pk = StorableIntrospector.examine(type).getPrimaryKey();
        String[] naturalOrdering = new String[pk.getProperties().size()];
        int i = 0;
        for (OrderedProperty<? extends Storable> prop : pk.getProperties()) {
            String orderBy = prop.getDirection() == Direction.DESCENDING ? prop.toString() : prop.getChainedProperty().toString();
            naturalOrdering[i++] = orderBy;
        }
        return naturalOrdering;
    }

    ManagedIndex(IndexedRepository repository, Storage<S> masterStorage, StorableIndex<S> index, SyntheticStorableReferenceAccess<S> accessor, Storage<?> indexEntryStorage) throws SupportException {
        this.mRepository = repository;
        this.mMasterStorage = masterStorage;
        this.mIndex = index;
        this.mAccessor = accessor;
        this.mIndexEntryStorage = indexEntryStorage;
    }

    @Override
    public String getName() {
        return this.mIndex.getNameDescriptor();
    }

    @Override
    public String[] getPropertyNames() {
        int i = this.mIndex.getPropertyCount();
        String[] names = new String[i];
        while (--i >= 0) {
            names[i] = this.mIndex.getProperty(i).getName();
        }
        return names;
    }

    @Override
    public Direction[] getPropertyDirections() {
        int i = this.mIndex.getPropertyCount();
        Direction[] directions = new Direction[i];
        while (--i >= 0) {
            directions[i] = this.mIndex.getPropertyDirection(i);
        }
        return directions;
    }

    @Override
    public boolean isUnique() {
        return this.mIndex.isUnique();
    }

    @Override
    public boolean isClustered() {
        return false;
    }

    public StorableIndex getIndex() {
        return this.mIndex;
    }

    @Override
    public Storage<?> getIndexEntryStorage() {
        return this.mIndexEntryStorage;
    }

    @Override
    public void copyToMasterPrimaryKey(Storable indexEntry, S master) throws FetchException {
        this.mAccessor.copyToMasterPrimaryKey(indexEntry, master);
    }

    @Override
    public void copyFromMaster(Storable indexEntry, S master) throws FetchException {
        this.mAccessor.copyFromMaster(indexEntry, master);
    }

    @Override
    public boolean isConsistent(Storable indexEntry, S master) throws FetchException {
        return this.mAccessor.isConsistent(indexEntry, master);
    }

    @Override
    public void repair(double desiredSpeed) throws RepositoryException {
        this.buildIndex(desiredSpeed);
    }

    @Override
    public Comparator<? extends Storable> getComparator() {
        return this.mAccessor.getComparator();
    }

    Cursor<S> fetchOne(IndexedStorage storage, Object[] identityValues) throws FetchException {
        return this.fetchOne(storage, identityValues, null);
    }

    Cursor<S> fetchOne(IndexedStorage storage, Object[] identityValues, Query.Controller controller) throws FetchException {
        Query<?> query = this.mSingleMatchQuery;
        if (query == null) {
            StorableIndex index = this.mIndex;
            Filter filter = Filter.getOpenFilter(this.mIndexEntryStorage.getStorableType());
            for (int i = 0; i < index.getPropertyCount(); ++i) {
                filter = filter.and(index.getProperty(i).getName(), RelOp.EQ);
            }
            query = this.mIndexEntryStorage.query(filter);
            this.mSingleMatchQuery = query;
        }
        return this.fetchFromIndexEntryQuery(storage, query.withValues(identityValues), controller);
    }

    Cursor<S> fetchFromIndexEntryQuery(IndexedStorage storage, Query<?> indexEntryQuery) throws FetchException {
        return this.fetchFromIndexEntryQuery(storage, indexEntryQuery, null);
    }

    Cursor<S> fetchFromIndexEntryQuery(IndexedStorage storage, Query<?> indexEntryQuery, Query.Controller controller) throws FetchException {
        return new IndexedCursor<S>(indexEntryQuery.fetch(controller), storage, this.mAccessor);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IndexInfo ");
        try {
            this.mIndex.appendTo(b);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return b.toString();
    }

    boolean deleteIndexEntry(S userStorable) throws PersistException {
        try {
            return this.makeIndexEntry(userStorable).tryDelete();
        }
        catch (PersistException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IllegalArgumentException) {
                return false;
            }
            throw e;
        }
    }

    boolean insertIndexEntry(S userStorable) throws PersistException {
        return this.insertIndexEntry(userStorable, this.makeIndexEntry(userStorable));
    }

    boolean updateIndexEntry(S userStorable, S oldUserStorable) throws PersistException {
        Storable newIndexEntry;
        block5: {
            newIndexEntry = this.makeIndexEntry(userStorable);
            if (oldUserStorable != null) {
                Storable oldIndexEntry;
                try {
                    oldIndexEntry = this.makeIndexEntry(oldUserStorable);
                }
                catch (PersistException e) {
                    Throwable cause = e.getCause();
                    if (!(cause instanceof IllegalArgumentException)) {
                        throw e;
                    }
                    break block5;
                }
                if (oldIndexEntry.equalPrimaryKeys(newIndexEntry)) {
                    return true;
                }
                oldIndexEntry.tryDelete();
            }
        }
        return this.insertIndexEntry(userStorable, newIndexEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildIndex(double desiredSpeed) throws RepositoryException {
        Comparator<Storable> c;
        MergeSortBuffer buffer;
        Log log = LogFactory.getLog(IndexedStorage.class);
        Query<S> masterQuery = this.mMasterStorage.query().orderBy(ManagedIndex.naturalOrdering(this.mMasterStorage.getStorableType()));
        Transaction txn = this.mRepository.enterTopTransaction(IsolationLevel.READ_COMMITTED);
        try {
            if (!masterQuery.exists()) {
                if (this.mIndexEntryStorage.query().exists()) {
                    txn.exit();
                    this.mIndexEntryStorage.truncate();
                }
                return;
            }
        }
        finally {
            txn.exit();
        }
        txn = this.mRepository.enterTopTransaction(IsolationLevel.NONE);
        try {
            Cursor<S> cursor = masterQuery.fetch();
            try {
                if (log.isInfoEnabled()) {
                    StringBuilder b = new StringBuilder();
                    b.append("Preparing index on ");
                    b.append(this.mMasterStorage.getStorableType().getName());
                    b.append(": ");
                    try {
                        this.mIndex.appendTo(b);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    log.info((Object)b.toString());
                }
                buffer = new MergeSortBuffer(this.mIndexEntryStorage, null, 65536);
                c = this.getComparator();
                buffer.prepare(c);
                long nextReportTime = System.currentTimeMillis() + 5000L;
                Storable lastUserStorable = null;
                int skippedCount = 0;
                while (cursor.hasNext()) {
                    long now;
                    Storable userStorable;
                    try {
                        userStorable = (Storable)cursor.next();
                        skippedCount = 0;
                    }
                    catch (CorruptEncodingException e) {
                        log.warn((Object)("Omitting corrupt record from index: " + e.toString()));
                        cursor.close();
                        cursor = lastUserStorable == null ? masterQuery.fetch() : masterQuery.fetchAfter(lastUserStorable);
                        cursor.skipNext(++skippedCount);
                        continue;
                    }
                    buffer.add(this.makeIndexEntry(userStorable));
                    if (log.isInfoEnabled() && (now = System.currentTimeMillis()) >= nextReportTime) {
                        log.info((Object)("Prepared " + buffer.size() + " index entries"));
                        nextReportTime = now + 5000L;
                    }
                    lastUserStorable = userStorable;
                }
            }
            finally {
                cursor.close();
            }
        }
        finally {
            txn.exit();
        }
        buffer.sort();
        if (this.isUnique()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Verifying index");
            }
            Object last = null;
            for (Object obj : buffer) {
                if (last != null && c.compare((Storable)last, (Storable)obj) == 0) {
                    buffer.close();
                    throw new UniqueConstraintException("Cannot build unique index because duplicates exist: " + this + ", " + last + " == " + obj);
                }
                last = obj;
            }
        }
        int bufferSize = buffer.size();
        if (log.isInfoEnabled()) {
            log.info((Object)("Begin build of " + bufferSize + " index entries"));
        }
        Query<?> indexEntryQuery = this.mIndexEntryStorage.query().orderBy(ManagedIndex.naturalOrdering(this.mIndexEntryStorage.getStorableType()));
        Throttle throttle = desiredSpeed < 1.0 ? new Throttle(1280) : null;
        long totalInserted = 0L;
        long totalUpdated = 0L;
        long totalDeleted = 0L;
        long totalProgress = 0L;
        txn = this.enterBuildTxn();
        try {
            Cursor<?> indexEntryCursor = indexEntryQuery.fetch();
            Storable existingIndexEntry = null;
            if (!indexEntryCursor.hasNext()) {
                indexEntryCursor.close();
                indexEntryCursor = null;
            }
            boolean retry = false;
            Storable indexEntry = null;
            Storable lastIndexEntry = null;
            Iterator<?> it = buffer.iterator();
            while (true) {
                if (!retry) {
                    Object obj;
                    if (it.hasNext()) {
                        obj = it.next();
                    } else {
                        if (indexEntryCursor == null || !indexEntryCursor.hasNext()) break;
                        obj = null;
                    }
                    indexEntry = (Storable)obj;
                }
                try {
                    if (indexEntry != null) {
                        if (indexEntry.tryInsert()) {
                            ++totalInserted;
                        } else {
                            Object existing = indexEntry.copy();
                            boolean doUpdate = false;
                            if (!existing.tryLoad()) {
                                doUpdate = true;
                            } else if (!existing.equalProperties(indexEntry)) {
                                indexEntry.copyVersionProperty(existing);
                                boolean bl = doUpdate = !existing.equalProperties(indexEntry);
                            }
                            if (doUpdate) {
                                indexEntry.tryDelete();
                                indexEntry.tryInsert();
                                ++totalUpdated;
                            }
                        }
                    }
                    if (indexEntryCursor != null) {
                        while (true) {
                            int compare;
                            if (existingIndexEntry == null) {
                                if (indexEntryCursor.hasNext()) {
                                    existingIndexEntry = (Storable)indexEntryCursor.next();
                                } else {
                                    indexEntryCursor.close();
                                    indexEntryCursor = null;
                                    break;
                                }
                            }
                            if ((compare = c.compare(existingIndexEntry, indexEntry)) == 0) {
                                existingIndexEntry = null;
                                break;
                            }
                            if (compare > 0) break;
                            existingIndexEntry.tryDelete();
                            if (++totalDeleted % 128L == 0L) {
                                txn.commit();
                                txn.exit();
                                this.logProgress(log, totalProgress, bufferSize, totalInserted, totalUpdated, totalDeleted);
                                txn = this.enterBuildTxn();
                                indexEntryCursor.close();
                                indexEntryCursor = indexEntryQuery.fetchAfter(existingIndexEntry);
                                if (!indexEntryCursor.hasNext()) {
                                    indexEntryCursor.close();
                                    indexEntryCursor = null;
                                    break;
                                }
                            }
                            existingIndexEntry = null;
                            ManagedIndex.throttle(throttle, desiredSpeed);
                        }
                    }
                    if (indexEntry != null) {
                        ++totalProgress;
                    }
                    lastIndexEntry = indexEntry;
                    retry = false;
                }
                catch (RepositoryException e) {
                    if (e instanceof FetchTimeoutException || e instanceof PersistTimeoutException) {
                        log.warn((Object)("Lock conflict during index repair; will retry: " + indexEntry + ", " + e));
                        retry = true;
                    }
                    throw e;
                }
                if (retry || totalProgress % 128L == 0L) {
                    txn.commit();
                    txn.exit();
                    this.logProgress(log, totalProgress, bufferSize, totalInserted, totalUpdated, totalDeleted);
                    txn = this.enterBuildTxn();
                    if (indexEntryCursor != null) {
                        indexEntryCursor.close();
                        existingIndexEntry = null;
                        indexEntryCursor = indexEntry == null || lastIndexEntry == null ? indexEntryQuery.fetch() : (!retry ? indexEntryQuery.fetchAfter(indexEntry) : indexEntryQuery.fetchAfter(lastIndexEntry));
                    }
                }
                ManagedIndex.throttle(throttle, desiredSpeed);
            }
            txn.commit();
        }
        finally {
            txn.exit();
            buffer.close();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Finished building " + totalProgress + " index entries " + this.progressSubMessgage(totalInserted, totalUpdated, totalDeleted)));
        }
    }

    private Transaction enterBuildTxn() {
        Transaction txn = this.mRepository.enterTopTransaction(IsolationLevel.READ_COMMITTED);
        txn.setForUpdate(true);
        txn.setDesiredLockTimeout(BUILD_TXN_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        return txn;
    }

    private static void throttle(Throttle throttle, double desiredSpeed) throws RepositoryException {
        if (throttle != null) {
            try {
                throttle.throttle(desiredSpeed, 10L);
            }
            catch (InterruptedException e) {
                throw new RepositoryException("Index build interrupted");
            }
        }
    }

    private void logProgress(Log log, long totalProgress, int bufferSize, long totalInserted, long totalUpdated, long totalDeleted) {
        if (log.isInfoEnabled()) {
            String format = "Index build progress: %.3f%% " + this.progressSubMessgage(totalInserted, totalUpdated, totalDeleted);
            double percent = 100.0 * (double)totalProgress / (double)bufferSize;
            log.info((Object)String.format(format, percent));
        }
    }

    private String progressSubMessgage(long totalInserted, long totalUpdated, long totalDeleted) {
        StringBuilder b = new StringBuilder();
        b.append('(');
        if (totalInserted > 0L) {
            b.append(totalInserted);
            b.append(" inserted");
        }
        if (totalUpdated > 0L) {
            if (b.length() > 1) {
                b.append(", ");
            }
            b.append(totalUpdated);
            b.append(" updated");
        }
        if (totalDeleted > 0L) {
            if (b.length() > 1) {
                b.append(", ");
            }
            b.append(totalDeleted);
            b.append(" deleted");
        }
        if (b.length() == 1) {
            b.append("no changes made");
        }
        b.append(')');
        return b.toString();
    }

    private Storable makeIndexEntry(S userStorable) throws PersistException {
        try {
            Object indexEntry = this.mIndexEntryStorage.prepare();
            this.mAccessor.copyFromMaster((Storable)indexEntry, userStorable);
            return indexEntry;
        }
        catch (UndeclaredThrowableException e) {
            Throwable cause = e.getCause();
            if (cause instanceof PersistException) {
                throw (PersistException)cause;
            }
            throw new PersistException(cause);
        }
        catch (Exception e) {
            if (e instanceof PersistException) {
                throw (PersistException)e;
            }
            throw new PersistException(e);
        }
    }

    private boolean insertIndexEntry(S userStorable, Storable indexEntry) throws PersistException {
        if (indexEntry.tryInsert()) {
            return true;
        }
        try {
            Object freshEntry = this.mIndexEntryStorage.prepare();
            this.mAccessor.copyFromMaster((Storable)freshEntry, userStorable);
            freshEntry.load();
            indexEntry.copyVersionProperty(freshEntry);
            if (freshEntry.equals(indexEntry)) {
                return true;
            }
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
        return false;
    }

    static {
        int timeout = 100;
        String prop = System.getProperty("com.amazon.carbonado.repo.indexed.BUILD_TXN_TIMEOUT_MILLIS");
        if (prop != null) {
            timeout = Integer.parseInt(prop);
        }
        BUILD_TXN_TIMEOUT_MILLIS = timeout;
    }
}

