/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.indexed;

import com.amazon.carbonado.CorruptEncodingException;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Trigger;
import com.amazon.carbonado.UniqueConstraintException;
import com.amazon.carbonado.repo.indexed.IndexedStorage;
import com.amazon.carbonado.repo.indexed.ManagedIndex;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IndexesTrigger<S extends Storable>
extends Trigger<S> {
    private final ManagedIndex<S>[] mManagedIndexes;

    IndexesTrigger(ManagedIndex<S>[] managedIndexes) {
        this.mManagedIndexes = managedIndexes;
    }

    @Override
    public void afterInsert(S storable, Object state) throws PersistException {
        for (ManagedIndex<S> managed : this.mManagedIndexes) {
            if (managed.insertIndexEntry(storable)) continue;
            throw new UniqueConstraintException("Alternate key constraint: " + storable.toString() + ", " + managed);
        }
    }

    @Override
    public void afterTryInsert(S storable, Object state) throws PersistException {
        for (ManagedIndex<S> managed : this.mManagedIndexes) {
            if (managed.insertIndexEntry(storable)) continue;
            throw this.abortTry();
        }
    }

    @Override
    public Object beforeUpdate(S storable) throws PersistException {
        Object copy = storable.copy();
        try {
            if (copy.tryLoad()) {
                return copy;
            }
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
        return null;
    }

    @Override
    public void afterUpdate(S storable, Object state) throws PersistException {
        Storable oldStorable = (Storable)state;
        for (ManagedIndex<Storable> managedIndex : this.mManagedIndexes) {
            managedIndex.updateIndexEntry((Storable)storable, oldStorable);
        }
    }

    @Override
    public Object beforeDelete(S storable) throws PersistException {
        Object copy = storable.copy();
        try {
            try {
                if (!copy.tryLoad()) {
                    return null;
                }
            }
            catch (CorruptEncodingException e) {
                LogFactory.getLog(IndexedStorage.class).warn((Object)("Unable to delete index entries because primary record is corrupt: " + copy.toStringKeyOnly()), (Throwable)e);
                return null;
            }
            for (ManagedIndex managed : this.mManagedIndexes) {
                managed.deleteIndexEntry(copy);
            }
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
        return null;
    }
}

