/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.indexed;

import com.amazon.carbonado.ConfigurationException;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryBuilder;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.TriggerFactory;
import com.amazon.carbonado.repo.indexed.IndexedRepository;
import com.amazon.carbonado.spi.AbstractRepositoryBuilder;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedRepositoryBuilder
extends AbstractRepositoryBuilder {
    private String mName;
    private boolean mIsMaster = true;
    private RepositoryBuilder mRepoBuilder;
    private boolean mIndexRepairEnabled = true;
    private double mIndexThrottle = 1.0;
    private boolean mAllClustered;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository build(AtomicReference<Repository> rootRef) throws RepositoryException {
        Repository wrapped;
        this.assertReady();
        boolean originalOption = this.mRepoBuilder.isMaster();
        try {
            this.mRepoBuilder.setMaster(this.mIsMaster);
            for (TriggerFactory factory : this.getTriggerFactories()) {
                this.mRepoBuilder.addTriggerFactory(factory);
            }
            wrapped = this.mRepoBuilder.build(rootRef);
        }
        finally {
            this.mRepoBuilder.setMaster(originalOption);
        }
        if (wrapped instanceof IndexedRepository) {
            return wrapped;
        }
        IndexedRepository repo = new IndexedRepository(rootRef, this.getName(), wrapped, this.isIndexRepairEnabled(), this.getIndexRepairThrottle(), this.isAllClustered());
        rootRef.set(repo);
        return repo;
    }

    @Override
    public String getName() {
        String name = this.mName;
        if (name == null && this.mRepoBuilder != null) {
            name = this.mRepoBuilder.getName();
        }
        return name;
    }

    @Override
    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public boolean isMaster() {
        return this.mIsMaster;
    }

    @Override
    public void setMaster(boolean b) {
        this.mIsMaster = b;
    }

    public RepositoryBuilder getWrappedRepository() {
        return this.mRepoBuilder;
    }

    public void setWrappedRepository(RepositoryBuilder repoBuilder) {
        this.mRepoBuilder = repoBuilder;
    }

    public boolean isIndexRepairEnabled() {
        return this.mIndexRepairEnabled;
    }

    public void setIndexRepairEnabled(boolean enabled) {
        this.mIndexRepairEnabled = enabled;
    }

    public double getIndexRepairThrottle() {
        return this.mIndexThrottle;
    }

    public void setIndexRepairThrottle(double desiredSpeed) {
        if (desiredSpeed < 0.0) {
            desiredSpeed = 0.0;
        } else if (desiredSpeed > 1.0) {
            desiredSpeed = 1.0;
        }
        this.mIndexThrottle = desiredSpeed;
    }

    public boolean isAllClustered() {
        return this.mAllClustered;
    }

    public void setAllClustered(boolean clustered) {
        this.mAllClustered = clustered;
    }

    @Override
    public void errorCheck(Collection<String> messages) throws ConfigurationException {
        super.errorCheck(messages);
        if (null == this.getWrappedRepository()) {
            messages.add("wrapped repository missing");
        }
    }
}

