/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.indexed;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.MalformedTypeException;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.capability.Capability;
import com.amazon.carbonado.capability.IndexInfo;
import com.amazon.carbonado.capability.IndexInfoCapability;
import com.amazon.carbonado.capability.StorableInfoCapability;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.qe.RepositoryAccess;
import com.amazon.carbonado.qe.StorageAccess;
import com.amazon.carbonado.repo.indexed.IndexAnalysis;
import com.amazon.carbonado.repo.indexed.IndexAnalysisPool;
import com.amazon.carbonado.repo.indexed.IndexEntryAccessCapability;
import com.amazon.carbonado.repo.indexed.IndexEntryAccessor;
import com.amazon.carbonado.repo.indexed.IndexedStorage;
import com.amazon.carbonado.repo.indexed.StoredIndexInfo;
import com.amazon.carbonado.repo.indexed.Unindexed;
import com.amazon.carbonado.spi.StoragePool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IndexedRepository
implements Repository,
RepositoryAccess,
IndexInfoCapability,
StorableInfoCapability,
IndexEntryAccessCapability {
    private final AtomicReference<Repository> mRootRef;
    private final Repository mRepository;
    private final String mName;
    private final boolean mIndexRepairEnabled;
    private final double mIndexThrottle;
    private final boolean mAllClustered;
    private final StoragePool mStoragePool;
    private final IndexAnalysisPool mIndexAnalysisPool;

    IndexedRepository(AtomicReference<Repository> rootRef, String name, Repository repository, boolean indexRepairEnabled, double indexThrottle, boolean allClustered) {
        if (repository.getCapability(IndexInfoCapability.class) == null) {
            throw new UnsupportedOperationException("Wrapped repository doesn't support being indexed -- it must support IndexInfoCapability.");
        }
        this.mRootRef = rootRef;
        this.mRepository = repository;
        this.mName = name;
        this.mIndexRepairEnabled = indexRepairEnabled;
        this.mIndexThrottle = indexThrottle;
        this.mAllClustered = allClustered;
        this.mIndexAnalysisPool = new IndexAnalysisPool(this);
        this.mStoragePool = new StoragePool(){

            @Override
            protected <S extends Storable> Storage<S> createStorage(Class<S> type) throws RepositoryException {
                Storage<S> masterStorage = IndexedRepository.this.mRepository.storageFor(type);
                if (Unindexed.class.isAssignableFrom(type)) {
                    int indexCount = IndexAnalysis.gatherDesiredIndexes(StorableIntrospector.examine(type)).size();
                    if (indexCount > 0) {
                        throw new MalformedTypeException(type, "Storable cannot have any indexes: " + type + ", " + indexCount);
                    }
                    return masterStorage;
                }
                IndexAnalysis analysis = (IndexAnalysis)IndexedRepository.this.mIndexAnalysisPool.get(masterStorage);
                return new IndexedStorage(analysis);
            }
        };
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public <S extends Storable> Storage<S> storageFor(Class<S> type) throws MalformedTypeException, SupportException, RepositoryException {
        return (Storage)this.mStoragePool.get(type);
    }

    @Override
    public Transaction enterTransaction() {
        return this.mRepository.enterTransaction();
    }

    @Override
    public Transaction enterTransaction(IsolationLevel level) {
        return this.mRepository.enterTransaction(level);
    }

    @Override
    public Transaction enterTopTransaction(IsolationLevel level) {
        return this.mRepository.enterTopTransaction(level);
    }

    @Override
    public IsolationLevel getTransactionIsolationLevel() {
        return this.mRepository.getTransactionIsolationLevel();
    }

    @Override
    public <C extends Capability> C getCapability(Class<C> capabilityType) {
        if (capabilityType.isInstance(this)) {
            return (C)this;
        }
        return this.mRepository.getCapability(capabilityType);
    }

    @Override
    public <S extends Storable> IndexInfo[] getIndexInfo(Class<S> storableType) throws RepositoryException {
        if (Unindexed.class.isAssignableFrom(storableType)) {
            return new IndexInfo[0];
        }
        Storage<S> masterStorage = this.mRepository.storageFor(storableType);
        IndexAnalysis analysis = (IndexAnalysis)this.mIndexAnalysisPool.get(masterStorage);
        IndexInfo[] infos = new IndexInfo[analysis.allIndexInfoMap.size()];
        return analysis.allIndexInfoMap.values().toArray(infos);
    }

    @Override
    public <S extends Storable> IndexEntryAccessor<S>[] getIndexEntryAccessors(Class<S> storableType) throws RepositoryException {
        if (Unindexed.class.isAssignableFrom(storableType)) {
            return new IndexEntryAccessor[0];
        }
        Storage<S> masterStorage = this.mRepository.storageFor(storableType);
        IndexAnalysis analysis = (IndexAnalysis)this.mIndexAnalysisPool.get(masterStorage);
        ArrayList<IndexEntryAccessor> accessors = new ArrayList<IndexEntryAccessor>(analysis.allIndexInfoMap.size());
        for (IndexInfo info : analysis.allIndexInfoMap.values()) {
            if (!(info instanceof IndexEntryAccessor)) continue;
            accessors.add((IndexEntryAccessor)info);
        }
        return accessors.toArray(new IndexEntryAccessor[accessors.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getUserStorableTypeNames() throws RepositoryException {
        StorableInfoCapability cap = this.mRepository.getCapability(StorableInfoCapability.class);
        if (cap == null) {
            return new String[0];
        }
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(cap.getUserStorableTypeNames()));
        names.remove(StoredIndexInfo.class.getName());
        Cursor<StoredIndexInfo> cursor = this.mRepository.storageFor(StoredIndexInfo.class).query().fetch();
        try {
            while (cursor.hasNext()) {
                StoredIndexInfo info = cursor.next();
                names.remove(info.getIndexName());
            }
        }
        finally {
            cursor.close();
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public boolean isSupported(Class<Storable> type) {
        StorableInfoCapability cap = this.mRepository.getCapability(StorableInfoCapability.class);
        return cap == null ? false : cap.isSupported(type);
    }

    @Override
    public boolean isPropertySupported(Class<Storable> type, String name) {
        StorableInfoCapability cap = this.mRepository.getCapability(StorableInfoCapability.class);
        return cap == null ? false : cap.isPropertySupported(type, name);
    }

    @Override
    public void close() {
        this.mRepository.close();
    }

    @Override
    public Repository getRootRepository() {
        return this.mRootRef.get();
    }

    @Override
    public <S extends Storable> StorageAccess<S> storageAccessFor(Class<S> type) throws SupportException, RepositoryException {
        return (StorageAccess)((Object)this.storageFor(type));
    }

    Storage<?> getIndexEntryStorageFor(Class<? extends Storable> indexEntryClass) throws RepositoryException {
        return this.mRepository.storageFor(indexEntryClass);
    }

    Repository getWrappedRepository() {
        return this.mRepository;
    }

    boolean isIndexRepairEnabled() {
        return this.mIndexRepairEnabled;
    }

    double getIndexRepairThrottle() {
        return this.mIndexThrottle;
    }

    boolean isAllClustered() {
        return this.mAllClustered;
    }
}

