/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.indexed;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.Trigger;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.repo.indexed.DependentStorableFetcher;
import com.amazon.carbonado.repo.indexed.IndexedRepository;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DerivedIndexesTrigger<S extends Storable, D extends Storable>
extends Trigger<S> {
    private final DependentStorableFetcher<S, D> mFetcher;

    DerivedIndexesTrigger(IndexedRepository repository, Class<S> sType, ChainedProperty<D> derivedTo) throws RepositoryException {
        this(new DependentStorableFetcher<S, D>(repository, sType, derivedTo));
    }

    private DerivedIndexesTrigger(DependentStorableFetcher<S, D> fetcher) {
        this.mFetcher = fetcher;
    }

    @Override
    public Object beforeInsert(S storable) throws PersistException {
        return this.createDependentIndexEntries(storable);
    }

    @Override
    public void afterInsert(S storable, Object state) throws PersistException {
        this.updateValues(storable, state);
    }

    @Override
    public Object beforeUpdate(S storable) throws PersistException {
        return this.createDependentIndexEntries(storable);
    }

    @Override
    public void afterUpdate(S storable, Object state) throws PersistException {
        this.updateValues(storable, state);
    }

    @Override
    public Object beforeDelete(S storable) throws PersistException {
        try {
            if (storable.copy().tryLoad()) {
                return this.createDependentIndexEntries(storable);
            }
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
        return null;
    }

    @Override
    public void afterDelete(S storable, Object state) throws PersistException {
        this.updateValues(storable, state);
    }

    public int hashCode() {
        return this.mFetcher.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DerivedIndexesTrigger) {
            DerivedIndexesTrigger other = (DerivedIndexesTrigger)obj;
            return this.mFetcher.equals(other.mFetcher);
        }
        return false;
    }

    private List<Storable> createDependentIndexEntries(S storable) throws PersistException {
        ArrayList<Storable> dependentIndexEntries = new ArrayList<Storable>();
        this.createDependentIndexEntries(storable, dependentIndexEntries);
        return dependentIndexEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDependentIndexEntries(S storable, List<Storable> dependentIndexEntries) throws PersistException {
        try {
            Transaction txn = this.mFetcher.enterTransaction();
            try {
                txn.setForUpdate(true);
                Cursor<D> dependencies = this.mFetcher.fetchDependenentStorables(storable);
                try {
                    while (dependencies.hasNext()) {
                        this.mFetcher.createIndexEntries((Storable)dependencies.next(), dependentIndexEntries);
                    }
                }
                finally {
                    dependencies.close();
                }
            }
            finally {
                txn.exit();
            }
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
    }

    private void updateValues(S storable, Object state) throws PersistException {
        if (state == null) {
            return;
        }
        List oldIndexEntries = (List)state;
        int size = oldIndexEntries.size();
        ArrayList<Storable> newIndexEntries = new ArrayList<Storable>(size);
        this.createDependentIndexEntries(storable, newIndexEntries);
        if (size != newIndexEntries.size()) {
            throw new PersistException("Amount of affected dependent indexes changed: " + size + " != " + newIndexEntries.size());
        }
        for (int i = 0; i < size; ++i) {
            Storable newIndexEntry;
            Storable oldIndexEntry = (Storable)oldIndexEntries.get(i);
            if (!oldIndexEntry.equalProperties(newIndexEntry = (Storable)newIndexEntries.get(i))) {
                oldIndexEntry.tryDelete();
            }
            newIndexEntry.tryInsert();
        }
    }
}

