/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.raw;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.gen.MasterFeature;
import com.amazon.carbonado.gen.MasterStorableGenerator;
import com.amazon.carbonado.gen.MasterSupport;
import com.amazon.carbonado.gen.TriggerSupport;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.raw.RawSupport;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.ClassInjector;
import org.cojen.util.WeakIdentityMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawStorableGenerator {
    public static final String ENCODE_KEY_METHOD_NAME = "encodeKey$";
    public static final String DECODE_KEY_METHOD_NAME = "decodeKey$";
    public static final String ENCODE_DATA_METHOD_NAME = "encodeData$";
    public static final String DECODE_DATA_METHOD_NAME = "decodeData$";
    private static Map<Class, Flavors<? extends Storable>> cCache = new WeakIdentityMap();

    private RawStorableGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends Storable> Class<? extends S> getAbstractClass(Class<S> type, boolean isMaster) throws SupportException, IllegalArgumentException {
        Map<Class, Flavors<? extends Storable>> map = cCache;
        synchronized (map) {
            Class abstractClass;
            Flavors<Storable<? extends Storable>> flavors = cCache.get(type);
            if (flavors == null) {
                flavors = new Flavors();
                cCache.put(type, flavors);
            } else {
                abstractClass = flavors.getClass(isMaster);
                if (abstractClass != null) {
                    return abstractClass;
                }
            }
            abstractClass = RawStorableGenerator.generateAbstractClass(type, isMaster);
            flavors.setClass(abstractClass, isMaster);
            return abstractClass;
        }
    }

    private static <S extends Storable> Class<? extends S> generateAbstractClass(Class<S> storableClass, boolean isMaster) throws SupportException {
        EnumSet<MasterFeature> features = isMaster ? EnumSet.of(MasterFeature.VERSIONING, MasterFeature.NORMALIZE, MasterFeature.UPDATE_FULL, MasterFeature.INSERT_SEQUENCES, MasterFeature.INSERT_CHECK_REQUIRED) : EnumSet.of(MasterFeature.NORMALIZE, MasterFeature.UPDATE_FULL);
        Class<S> abstractClass = MasterStorableGenerator.getAbstractClass(storableClass, features);
        ClassInjector ci = ClassInjector.create((String)storableClass.getName(), (ClassLoader)abstractClass.getClassLoader());
        ClassFile cf = new ClassFile(ci.getClassName(), abstractClass);
        cf.setModifiers(cf.getModifiers().toAbstract(true));
        cf.markSynthetic();
        cf.setSourceFile(RawStorableGenerator.class.getName());
        cf.setTarget("1.5");
        TypeDesc storableType = TypeDesc.forClass(Storable.class);
        TypeDesc triggerSupportType = TypeDesc.forClass(TriggerSupport.class);
        TypeDesc masterSupportType = TypeDesc.forClass(MasterSupport.class);
        TypeDesc rawSupportType = TypeDesc.forClass(RawSupport.class);
        TypeDesc byteArrayType = TypeDesc.forClass(byte[].class);
        for (int i = 1; i <= 3; ++i) {
            TypeDesc[] params = new TypeDesc[i];
            params[0] = rawSupportType;
            if (i >= 2) {
                params[1] = byteArrayType;
                if (i == 3) {
                    params[2] = byteArrayType;
                }
            }
            MethodInfo mi = cf.addConstructor(Modifiers.PUBLIC, params);
            CodeBuilder b = new CodeBuilder(mi);
            b.loadThis();
            b.loadLocal(b.getParameter(0));
            b.invokeSuperConstructor(new TypeDesc[]{masterSupportType});
            if (i >= 2) {
                params = new TypeDesc[]{byteArrayType};
                b.loadThis();
                b.loadLocal(b.getParameter(1));
                b.invokeVirtual(DECODE_KEY_METHOD_NAME, null, params);
                if (i == 3) {
                    b.loadThis();
                    b.loadLocal(b.getParameter(2));
                    b.invokeVirtual(DECODE_DATA_METHOD_NAME, null, params);
                    b.loadThis();
                    b.invokeVirtual("loadCompleted$", null, null);
                } else {
                    Collection<StorableProperty<S>> properties = StorableIntrospector.examine(storableClass).getPrimaryKeyProperties().values();
                    int count = properties.size();
                    int ordinal = 0;
                    int andMask = -1;
                    int orMask = 0;
                    for (StorableProperty<S> property : properties) {
                        orMask |= 1 << (ordinal & 0xF) * 2;
                        andMask &= ~(3 << (ordinal & 0xF) * 2);
                        if ((++ordinal & 0xF) != 0 && ordinal < count) continue;
                        String stateFieldName = "propertyState$" + (ordinal - 1 >> 4);
                        b.loadThis();
                        if (andMask == 0) {
                            b.loadConstant(orMask);
                        } else {
                            b.loadThis();
                            b.loadField(stateFieldName, TypeDesc.INT);
                            b.loadConstant(andMask);
                            b.math((byte)126);
                            b.loadConstant(orMask);
                            b.math((byte)-128);
                        }
                        b.storeField(stateFieldName, TypeDesc.INT);
                        andMask = -1;
                        orMask = 0;
                    }
                }
            }
            b.returnVoid();
        }
        cf.addMethod(Modifiers.PROTECTED.toAbstract(true), ENCODE_KEY_METHOD_NAME, byteArrayType, null);
        cf.addMethod(Modifiers.PROTECTED.toAbstract(true), DECODE_KEY_METHOD_NAME, null, new TypeDesc[]{byteArrayType});
        cf.addMethod(Modifiers.PROTECTED.toAbstract(true), ENCODE_DATA_METHOD_NAME, byteArrayType, null);
        cf.addMethod(Modifiers.PROTECTED.toAbstract(true), DECODE_DATA_METHOD_NAME, null, new TypeDesc[]{byteArrayType});
        MethodInfo mi = cf.addMethod(Modifiers.PROTECTED.toFinal(true), "doTryLoad$", TypeDesc.BOOLEAN, null);
        mi.addException(TypeDesc.forClass(FetchException.class));
        CodeBuilder b = new CodeBuilder(mi);
        b.loadThis();
        b.loadField("support$", triggerSupportType);
        b.checkCast(rawSupportType);
        b.loadThis();
        b.loadThis();
        b.invokeVirtual(ENCODE_KEY_METHOD_NAME, byteArrayType, null);
        TypeDesc[] params = new TypeDesc[]{storableType, byteArrayType};
        b.invokeInterface(rawSupportType, "tryLoad", byteArrayType, params);
        LocalVariable encodedDataVar = b.createLocalVariable(null, byteArrayType);
        b.storeLocal(encodedDataVar);
        b.loadLocal(encodedDataVar);
        Label notNull = b.createLabel();
        b.ifNullBranch((Location)notNull, false);
        b.loadConstant(false);
        b.returnValue(TypeDesc.BOOLEAN);
        notNull.setLocation();
        b.loadThis();
        b.loadLocal(encodedDataVar);
        params = new TypeDesc[]{byteArrayType};
        b.invokeVirtual(DECODE_DATA_METHOD_NAME, null, params);
        b.loadConstant(true);
        b.returnValue(TypeDesc.BOOLEAN);
        mi = cf.addMethod(Modifiers.PROTECTED.toFinal(true), "doTryInsert$master", TypeDesc.BOOLEAN, null);
        mi.addException(TypeDesc.forClass(PersistException.class));
        b = new CodeBuilder(mi);
        b.loadThis();
        b.loadField("support$", triggerSupportType);
        b.checkCast(rawSupportType);
        b.loadThis();
        b.loadThis();
        b.invokeVirtual(ENCODE_KEY_METHOD_NAME, byteArrayType, null);
        b.loadThis();
        b.invokeVirtual(ENCODE_DATA_METHOD_NAME, byteArrayType, null);
        params = new TypeDesc[]{storableType, byteArrayType, byteArrayType};
        b.invokeInterface(rawSupportType, "tryInsert", TypeDesc.BOOLEAN, params);
        b.returnValue(TypeDesc.BOOLEAN);
        mi = cf.addMethod(Modifiers.PROTECTED.toFinal(true), "doTryUpdate$master", TypeDesc.BOOLEAN, null);
        mi.addException(TypeDesc.forClass(PersistException.class));
        b = new CodeBuilder(mi);
        b.loadThis();
        b.loadField("support$", triggerSupportType);
        b.checkCast(rawSupportType);
        b.loadThis();
        b.loadThis();
        b.invokeVirtual(ENCODE_KEY_METHOD_NAME, byteArrayType, null);
        b.loadThis();
        b.invokeVirtual(ENCODE_DATA_METHOD_NAME, byteArrayType, null);
        params = new TypeDesc[]{storableType, byteArrayType, byteArrayType};
        b.invokeInterface(rawSupportType, "store", null, params);
        b.loadConstant(true);
        b.returnValue(TypeDesc.BOOLEAN);
        mi = cf.addMethod(Modifiers.PROTECTED.toFinal(true), "doTryDelete$master", TypeDesc.BOOLEAN, null);
        mi.addException(TypeDesc.forClass(PersistException.class));
        b = new CodeBuilder(mi);
        b.loadThis();
        b.loadField("support$", triggerSupportType);
        b.checkCast(rawSupportType);
        b.loadThis();
        b.loadThis();
        b.invokeVirtual(ENCODE_KEY_METHOD_NAME, byteArrayType, null);
        params = new TypeDesc[]{storableType, byteArrayType};
        b.invokeInterface(rawSupportType, "tryDelete", TypeDesc.BOOLEAN, params);
        b.returnValue(TypeDesc.BOOLEAN);
        return ci.defineClass(cf);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Flavors<S extends Storable> {
        private Reference<Class<? extends S>> mMasterFlavor;
        private Reference<Class<? extends S>> mNonMasterFlavor;

        Flavors() {
        }

        Class<? extends S> getClass(boolean isMaster) {
            Reference<Class<S>> ref = isMaster ? this.mMasterFlavor : this.mNonMasterFlavor;
            return ref != null ? ref.get() : null;
        }

        void setClass(Class<? extends S> clazz, boolean isMaster) {
            SoftReference<Class<S>> ref = new SoftReference<Class<S>>(clazz);
            if (isMaster) {
                this.mMasterFlavor = ref;
            } else {
                this.mNonMasterFlavor = ref;
            }
        }
    }
}

