/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.raw;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.raw.CompressionType;
import com.amazon.carbonado.raw.GenericEncodingStrategy;
import com.amazon.carbonado.raw.GzipCompressor;
import org.cojen.classfile.CodeAssembler;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.TypeDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompressedEncodingStrategy<S extends Storable>
extends GenericEncodingStrategy<S> {
    private final CompressionType mCompressionType;

    public CompressedEncodingStrategy(Class<S> type, StorableIndex<S> pkIndex, CompressionType compressionType) {
        super(type, pkIndex);
        this.mCompressionType = compressionType;
    }

    @Override
    protected void extraDataEncoding(CodeAssembler a, LocalVariable dataVar, int prefix, int suffix) {
        switch (this.mCompressionType) {
            case GZIP: {
                TypeDesc byteArrayType = TypeDesc.forClass(byte[].class);
                a.loadLocal(dataVar);
                a.loadConstant(prefix);
                a.invokeStatic(GzipCompressor.class.getName(), "compress", byteArrayType, new TypeDesc[]{byteArrayType, TypeDesc.INT});
                a.storeLocal(dataVar);
            }
        }
    }

    @Override
    protected void extraDataDecoding(CodeAssembler a, LocalVariable dataVar, int prefix, int suffix) {
        switch (this.mCompressionType) {
            case GZIP: {
                TypeDesc byteArrayType = TypeDesc.forClass(byte[].class);
                a.loadLocal(dataVar);
                a.loadConstant(prefix);
                a.invokeStatic(GzipCompressor.class.getName(), "decompress", byteArrayType, new TypeDesc[]{byteArrayType, TypeDesc.INT});
                a.storeLocal(dataVar);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CompressedEncodingStrategy other = (CompressedEncodingStrategy)obj;
            return super.equals(obj) && this.mCompressionType.equals((Object)other.mCompressionType);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.mCompressionType.hashCode();
    }
}

