/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableKey;
import com.amazon.carbonado.info.StorableProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorableIndexSet<S extends Storable>
extends TreeSet<StorableIndex<S>> {
    private static final long serialVersionUID = -5840661016235340456L;
    private static final Comparator<StorableIndex<?>> STORABLE_INDEX_COMPARATOR = new StorableIndexComparator();

    public StorableIndexSet() {
        super(STORABLE_INDEX_COMPARATOR);
    }

    public StorableIndexSet(StorableIndexSet<S> set) {
        super(STORABLE_INDEX_COMPARATOR);
        this.addAll(set);
    }

    public void addIndexes(StorableInfo<S> info) {
        int i = info.getIndexCount();
        while (--i >= 0) {
            this.add(info.getIndex(i));
        }
    }

    public void addIndexes(StorableInfo<S> info, Direction defaultDirection) {
        int i = info.getIndexCount();
        while (--i >= 0) {
            this.add(info.getIndex(i).setDefaultDirection(defaultDirection));
        }
    }

    public void addAlternateKeys(StorableInfo<S> info) {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        int i = info.getAlternateKeyCount();
        while (--i >= 0) {
            this.addKey(info.getAlternateKey(i));
        }
    }

    public void addPrimaryKey(StorableInfo<S> info) {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        this.addKey(info.getPrimaryKey());
    }

    public void addKey(StorableKey<S> key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.add(new StorableIndex<S>(key, Direction.UNSPECIFIED));
    }

    public void reduce() {
        this.reduce(Direction.UNSPECIFIED);
    }

    public void reduce(Direction defaultDirection) {
        ArrayList<StorableIndex<S>> group = new ArrayList<StorableIndex<S>>();
        TreeMap<StorableIndex<S>, StorableIndex<S>> mergedReplacements = new TreeMap<StorableIndex<S>, StorableIndex<S>>(STORABLE_INDEX_COMPARATOR);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            StorableIndex candidate = (StorableIndex)it.next();
            if (group.size() == 0 || this.isDifferentGroup((StorableIndex)group.get(0), candidate)) {
                group.clear();
                group.add(candidate);
                continue;
            }
            if (this.isRedundant(group, candidate, mergedReplacements)) {
                it.remove();
                continue;
            }
            group.add(candidate);
        }
        this.replaceEntries(mergedReplacements);
        this.setDefaultDirection(defaultDirection);
    }

    public void setDefaultDirection(Direction defaultDirection) {
        if (defaultDirection != Direction.UNSPECIFIED) {
            HashMap replacements = null;
            for (StorableIndex index : this) {
                StorableIndex replacement = index.setDefaultDirection(defaultDirection);
                if (replacement == index) continue;
                if (replacements == null) {
                    replacements = new HashMap();
                }
                replacements.put(index, replacement);
            }
            this.replaceEntries(replacements);
        }
    }

    public void markClustered(boolean clustered) {
        HashMap replacements = null;
        for (StorableIndex index : this) {
            StorableIndex replacement = index.clustered(clustered);
            if (replacement == index) continue;
            if (replacements == null) {
                replacements = new HashMap();
            }
            replacements.put(index, replacement);
        }
        this.replaceEntries(replacements);
    }

    public void uniquify(StorableInfo<S> info) {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        this.uniquify(info.getPrimaryKey());
    }

    public void uniquify(StorableKey<S> key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        HashMap replacements = null;
        for (StorableIndex index : this) {
            if (index.isUnique() || !this.isUniqueImplied(index)) continue;
            if (replacements == null) {
                replacements = new HashMap();
            }
            replacements.put(index, index.unique(true));
        }
        this.replaceEntries(replacements);
        replacements = null;
        for (StorableIndex index : this) {
            StorableIndex<S> replacement = index.uniquify(key);
            if (replacement == index) continue;
            if (replacements == null) {
                replacements = new HashMap();
            }
            replacements.put(index, replacement);
        }
        this.replaceEntries(replacements);
    }

    public StorableIndex<S> findPrimaryKeyIndex(StorableInfo<S> info) {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return this.findKeyIndex(info.getPrimaryKey());
    }

    public StorableIndex<S> findKeyIndex(StorableKey<S> key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Set<OrderedProperty<S>> orderedProps = key.getProperties();
        HashSet<StorableProperty<S>> keyProps = new HashSet<StorableProperty<S>>();
        for (OrderedProperty<S> orderedProp : orderedProps) {
            keyProps.add(orderedProp.getChainedProperty().getPrimeProperty());
        }
        block1: for (StorableIndex index : this) {
            if (!index.isUnique() || index.getPropertyCount() != keyProps.size()) continue;
            int i = index.getPropertyCount();
            while (--i >= 0) {
                if (keyProps.contains(index.getProperty(i))) continue;
                continue block1;
            }
            return index;
        }
        return null;
    }

    private boolean isUniqueImplied(StorableIndex<S> candidate) {
        if (candidate.isUnique()) {
            return true;
        }
        if (this.size() <= 1) {
            return false;
        }
        HashSet<StorableProperty<S>> candidateProps = new HashSet<StorableProperty<S>>();
        int i = candidate.getPropertyCount();
        while (--i >= 0) {
            candidateProps.add(candidate.getProperty(i));
        }
        block1: for (StorableIndex index : this) {
            if (!index.isUnique()) continue;
            int i2 = index.getPropertyCount();
            while (--i2 >= 0) {
                if (candidateProps.contains(index.getProperty(i2))) continue;
                continue block1;
            }
            return true;
        }
        return false;
    }

    private boolean isDifferentGroup(StorableIndex<S> groupLeader, StorableIndex<S> candidate) {
        int count = candidate.getPropertyCount();
        if (count > groupLeader.getPropertyCount()) {
            return true;
        }
        for (int i = 0; i < count; ++i) {
            StorableProperty<S> aProp = groupLeader.getProperty(i);
            StorableProperty<S> bProp = candidate.getProperty(i);
            if (aProp.getName().compareTo(bProp.getName()) == 0) continue;
            return true;
        }
        return candidate.isUnique() && count < groupLeader.getPropertyCount();
    }

    private boolean isRedundant(List<StorableIndex<S>> group, StorableIndex<S> candidate, Map<StorableIndex<S>, StorableIndex<S>> mergedReplacements) {
        int count = candidate.getPropertyCount();
        ListIterator<StorableIndex<S>> it = group.listIterator();
        block0: while (it.hasNext()) {
            StorableIndex<S> member = it.next();
            boolean moreQualified = false;
            boolean canReverse = true;
            boolean reverse = false;
            for (int i = 0; i < count; ++i) {
                Direction candidateOrder = candidate.getPropertyDirection(i);
                if (candidateOrder == Direction.UNSPECIFIED) continue;
                Direction memberOrder = member.getPropertyDirection(i);
                if (memberOrder == Direction.UNSPECIFIED) {
                    moreQualified = true;
                    continue;
                }
                if (reverse) {
                    candidateOrder = candidateOrder.reverse();
                }
                if (candidateOrder == memberOrder) {
                    canReverse = false;
                    continue;
                }
                if (!canReverse) continue block0;
                reverse = true;
                canReverse = false;
            }
            if (moreQualified) {
                Direction[] directions = member.getPropertyDirections();
                for (int i = 0; i < count; ++i) {
                    if (directions[i] != Direction.UNSPECIFIED) continue;
                    Direction direction = candidate.getPropertyDirection(i);
                    directions[i] = reverse ? direction.reverse() : direction;
                }
                StorableIndex<S> merged = new StorableIndex<S>(member.getProperties(), directions).unique(member.isUnique());
                mergedReplacements.put(member, merged);
                it.set(merged);
            }
            return true;
        }
        return false;
    }

    private void replaceEntries(Map<StorableIndex<S>, StorableIndex<S>> replacements) {
        if (replacements != null) {
            for (Map.Entry<StorableIndex<S>, StorableIndex<S>> e : replacements.entrySet()) {
                this.remove(e.getKey());
                this.add(e.getValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StorableIndexComparator
    implements Comparator<StorableIndex<?>>,
    Serializable {
        private static final long serialVersionUID = 2204885249683067349L;

        private StorableIndexComparator() {
        }

        @Override
        public int compare(StorableIndex<?> a, StorableIndex<?> b) {
            int i;
            if (a == b) {
                return 0;
            }
            int aCount = a.getPropertyCount();
            int bCount = b.getPropertyCount();
            int count = Math.min(aCount, bCount);
            for (i = 0; i < count; ++i) {
                StorableProperty<?> aProp = a.getProperty(i);
                StorableProperty<?> bProp = b.getProperty(i);
                int result = aProp.getName().compareTo(bProp.getName());
                if (aProp.getName().compareTo(bProp.getName()) == 0) continue;
                return result;
            }
            if (aCount > bCount) {
                return -1;
            }
            if (aCount < bCount) {
                return 1;
            }
            for (i = 0; i < count; ++i) {
                Direction bDirection;
                Direction aDirection;
                if (a.isUnique()) {
                    if (!b.isUnique()) {
                        return -1;
                    }
                } else if (b.isUnique()) {
                    return 1;
                }
                if ((aDirection = a.getPropertyDirection(i)) == (bDirection = b.getPropertyDirection(i))) continue;
                if (aDirection == Direction.ASCENDING) {
                    return -1;
                }
                if (bDirection == Direction.ASCENDING) {
                    return 1;
                }
                if (aDirection == Direction.DESCENDING) {
                    return -1;
                }
                if (bDirection != Direction.DESCENDING) continue;
                return 1;
            }
            return 0;
        }
    }
}

