/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.qe.AbstractQueryExecutor;
import com.amazon.carbonado.qe.OrderingList;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullScanQueryExecutor<S extends Storable>
extends AbstractQueryExecutor<S> {
    private final Support<S> mSupport;

    public FullScanQueryExecutor(Support<S> support) {
        if (support == null && this instanceof Support) {
            support = (Support)((Object)this);
        }
        if (support == null) {
            throw new IllegalArgumentException();
        }
        this.mSupport = support;
    }

    @Override
    public long count(FilterValues<S> values) throws FetchException {
        long count = this.mSupport.countAll();
        if (count == -1L) {
            count = super.count(values);
        }
        return count;
    }

    @Override
    public long count(FilterValues<S> values, Query.Controller controller) throws FetchException {
        long count = this.mSupport.countAll(controller);
        if (count == -1L) {
            count = super.count(values, controller);
        }
        return count;
    }

    @Override
    public Filter<S> getFilter() {
        return Filter.getOpenFilter(this.mSupport.getStorableType());
    }

    @Override
    public Cursor<S> fetch(FilterValues<S> values) throws FetchException {
        return this.mSupport.fetchAll();
    }

    @Override
    public Cursor<S> fetch(FilterValues<S> values, Query.Controller controller) throws FetchException {
        return this.mSupport.fetchAll(controller);
    }

    @Override
    public OrderingList<S> getOrdering() {
        return OrderingList.emptyList();
    }

    @Override
    public boolean printPlan(Appendable app, int indentLevel, FilterValues<S> values) throws IOException {
        this.indent(app, indentLevel);
        app.append("full scan: ");
        app.append(this.mSupport.getStorableType().getName());
        this.newline(app);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Support<S extends Storable> {
        public Class<S> getStorableType();

        public long countAll() throws FetchException;

        public long countAll(Query.Controller var1) throws FetchException;

        public Cursor<S> fetchAll() throws FetchException;

        public Cursor<S> fetchAll(Query.Controller var1) throws FetchException;
    }
}

