/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.cursor.FilteredCursor;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.qe.AbstractQueryExecutor;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.qe.QueryExecutor;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredQueryExecutor<S extends Storable>
extends AbstractQueryExecutor<S> {
    private final QueryExecutor<S> mExecutor;
    private final Filter<S> mFilter;

    public FilteredQueryExecutor(QueryExecutor<S> executor, Filter<S> filter) {
        if (executor == null) {
            throw new IllegalArgumentException();
        }
        if (filter == null || filter.isOpen() || filter.isClosed()) {
            throw new IllegalArgumentException();
        }
        this.mExecutor = executor;
        FilterValues<S> values = filter.initialFilterValues();
        if (values != null) {
            filter = values.getFilter();
        }
        this.mFilter = filter;
    }

    @Override
    public Cursor<S> fetch(FilterValues<S> values) throws FetchException {
        return FilteredCursor.applyFilter(this.mFilter, values, this.mExecutor.fetch(values));
    }

    @Override
    public Cursor<S> fetch(FilterValues<S> values, Query.Controller controller) throws FetchException {
        return FilteredCursor.applyFilter(this.mFilter, values, this.mExecutor.fetch(values, controller));
    }

    @Override
    public Filter<S> getFilter() {
        return this.mExecutor.getFilter().and(this.mFilter);
    }

    @Override
    public OrderingList<S> getOrdering() {
        return this.mExecutor.getOrdering();
    }

    @Override
    public boolean printNative(Appendable app, int indentLevel, FilterValues<S> values) throws IOException {
        return this.mExecutor.printNative(app, indentLevel, values);
    }

    @Override
    public boolean printPlan(Appendable app, int indentLevel, FilterValues<S> values) throws IOException {
        this.indent(app, indentLevel);
        app.append("filter: ");
        this.mFilter.appendTo(app, values);
        this.newline(app);
        this.mExecutor.printPlan(app, this.increaseIndent(indentLevel), values);
        return true;
    }
}

