/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.lob;

import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.lob.AbstractBlob;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class ByteArrayBlob
extends AbstractBlob {
    private final int mInitialCapacity;
    private byte[] mData;
    private int mLength;

    public ByteArrayBlob(int capacity) {
        if (capacity == 0) {
            throw new IllegalArgumentException();
        }
        this.mInitialCapacity = capacity;
        this.mData = new byte[capacity];
    }

    public ByteArrayBlob(byte[] data) {
        if (data.length == 0) {
            throw new IllegalArgumentException();
        }
        this.mLength = this.mInitialCapacity = data.length;
        this.mData = data;
    }

    public ByteArrayBlob(byte[] data, int length) {
        if (data.length < length) {
            throw new IllegalArgumentException();
        }
        this.mInitialCapacity = data.length;
        this.mData = data;
        this.mLength = length;
    }

    public InputStream openInputStream() {
        return new Input(this, 0L);
    }

    public InputStream openInputStream(long pos) {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position is negative: " + pos);
        }
        return new Input(this, pos);
    }

    public InputStream openInputStream(long pos, int bufferSize) {
        return this.openInputStream(pos);
    }

    public synchronized long getLength() {
        return this.mLength;
    }

    synchronized int read(long pos) {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position is negative: " + pos);
        }
        if (pos > Integer.MAX_VALUE) {
            return -1;
        }
        int ipos = (int)pos;
        if (ipos >= this.mLength) {
            return -1;
        }
        return this.mData[ipos];
    }

    synchronized int read(long pos, byte[] bytes) {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position is negative: " + pos);
        }
        if (bytes == null) {
            throw new IllegalArgumentException("Byte array is null");
        }
        if (pos > Integer.MAX_VALUE) {
            return -1;
        }
        int ipos = (int)pos;
        if (ipos > this.mLength) {
            return -1;
        }
        int length = bytes.length;
        if (ipos + length > this.mLength) {
            length = this.mLength - ipos;
        }
        if (length > 0) {
            System.arraycopy(this.mData, ipos, bytes, 0, length);
            return length;
        }
        return -1;
    }

    synchronized int read(long pos, byte[] bytes, int offset, int length) {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position is negative: " + pos);
        }
        if (bytes == null) {
            throw new IllegalArgumentException("Byte array is null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset is negative: " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length is negative: " + length);
        }
        if (pos > Integer.MAX_VALUE) {
            return -1;
        }
        int ipos = (int)pos;
        if (ipos > this.mLength) {
            return -1;
        }
        if (ipos + length > this.mLength) {
            length = this.mLength - ipos;
        }
        if (length > 0) {
            try {
                System.arraycopy(this.mData, ipos, bytes, offset, length);
            }
            catch (IndexOutOfBoundsException e) {
                if (offset >= bytes.length && length > 0) {
                    throw new IllegalArgumentException("Offset is too large: " + offset);
                }
                throw e;
            }
            return length;
        }
        return -1;
    }

    public OutputStream openOutputStream() {
        return new Output(this, 0L);
    }

    public OutputStream openOutputStream(long pos) {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position is negative: " + pos);
        }
        return new Output(this, pos);
    }

    public OutputStream openOutputStream(long pos, int bufferSize) {
        return this.openOutputStream(pos);
    }

    public synchronized void setLength(long length) throws PersistException {
        if (length < 0L) {
            throw new IllegalArgumentException("Length is negative: " + length);
        }
        if (length > Integer.MAX_VALUE) {
            throw new PersistException("Length too long: " + length);
        }
        int ilength = (int)length;
        if (ilength < this.mLength) {
            this.mLength = ilength;
            if (this.mData.length > this.mInitialCapacity) {
                this.mData = new byte[this.mInitialCapacity];
            }
        } else if (ilength > this.mLength) {
            if (ilength <= this.mData.length) {
                Arrays.fill(this.mData, this.mLength, ilength, (byte)0);
                this.mLength = ilength;
            } else {
                int newLength = this.mData.length * 2;
                if (newLength < ilength) {
                    newLength = ilength;
                }
                byte[] newData = new byte[newLength];
                System.arraycopy(this.mData, 0, newData, 0, this.mLength);
            }
            this.mLength = ilength;
        }
    }

    synchronized void write(long pos, int b) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position is negative: " + pos);
        }
        if (pos > Integer.MAX_VALUE) {
            throw new IOException("Position too high: " + pos);
        }
        int ipos = (int)pos;
        this.ensureLengthForWrite(ipos + 1);
        this.mData[ipos] = (byte)b;
    }

    synchronized void write(long pos, byte[] bytes) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position is negative: " + pos);
        }
        if (bytes == null) {
            throw new IllegalArgumentException("Byte array is null");
        }
        if (pos > Integer.MAX_VALUE) {
            throw new IOException("Position too high: " + pos);
        }
        if (pos + (long)bytes.length > Integer.MAX_VALUE) {
            throw new IOException("Position plus length too high: " + (pos + (long)bytes.length));
        }
        int ipos = (int)pos;
        this.ensureLengthForWrite(ipos + bytes.length);
        System.arraycopy(bytes, 0, this.mData, ipos, bytes.length);
    }

    synchronized void write(long pos, byte[] bytes, int offset, int length) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position is negative: " + pos);
        }
        if (bytes == null) {
            throw new IllegalArgumentException("Byte array is null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset is negative: " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length is negative: " + length);
        }
        if (pos > Integer.MAX_VALUE) {
            throw new IOException("Position too high: " + pos);
        }
        if (pos + (long)length > Integer.MAX_VALUE) {
            throw new IOException("Position plus length too high: " + (pos + (long)length));
        }
        int ipos = (int)pos;
        this.ensureLengthForWrite(ipos + length);
        System.arraycopy(bytes, offset, this.mData, ipos, length);
    }

    private void ensureLengthForWrite(int ilength) {
        if (ilength > this.mLength) {
            if (ilength <= this.mData.length) {
                this.mLength = ilength;
            } else {
                int newLength = this.mData.length * 2;
                if (newLength < ilength) {
                    newLength = ilength;
                }
                byte[] newData = new byte[newLength];
                System.arraycopy(this.mData, 0, newData, 0, this.mLength);
                this.mData = newData;
            }
            this.mLength = ilength;
        }
    }

    public Object getLocator() {
        return null;
    }

    private static class Output
    extends OutputStream {
        private final ByteArrayBlob mBlob;
        private long mPos;

        Output(ByteArrayBlob blob, long pos) {
            this.mBlob = blob;
            this.mPos = pos;
        }

        public void write(int b) throws IOException {
            this.mBlob.write(this.mPos, b);
            ++this.mPos;
        }

        public void write(byte[] b) throws IOException {
            this.mBlob.write(this.mPos, b);
            this.mPos += (long)b.length;
        }

        public void write(byte[] b, int offset, int length) throws IOException {
            this.mBlob.write(this.mPos, b, offset, length);
            this.mPos += (long)length;
        }
    }

    private static class Input
    extends InputStream {
        private final ByteArrayBlob mBlob;
        private long mPos;
        private long mMarkPos;

        Input(ByteArrayBlob blob, long pos) {
            this.mBlob = blob;
            this.mPos = pos;
            this.mMarkPos = pos;
        }

        public int read() {
            int b = this.mBlob.read(this.mPos);
            if (b >= 0) {
                ++this.mPos;
            }
            return b;
        }

        public int read(byte[] bytes) {
            int length = this.mBlob.read(this.mPos, bytes);
            if (length > 0) {
                this.mPos += (long)length;
            }
            return length;
        }

        public int read(byte[] bytes, int offset, int length) {
            if ((length = this.mBlob.read(this.mPos, bytes, offset, length)) > 0) {
                this.mPos += (long)length;
            }
            return length;
        }

        public long skip(long n) {
            long length;
            if (n <= 0L) {
                return 0L;
            }
            long newPos = this.mPos + n;
            if (newPos < 0L) {
                newPos = Long.MAX_VALUE;
            }
            if (newPos > (length = this.mBlob.getLength())) {
                newPos = length;
            }
            n = newPos - this.mPos;
            this.mPos = newPos;
            return n;
        }

        public int available() {
            long avail = this.mBlob.getLength() - this.mPos;
            if (avail > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)avail;
        }

        public void mark(int readlimit) {
            this.mMarkPos = this.mPos;
        }

        public void reset() {
            this.mPos = this.mMarkPos;
        }

        public boolean markSupported() {
            return true;
        }
    }
}

