/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.gen;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchNoneException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistNoneException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.Trigger;
import com.amazon.carbonado.UniqueConstraintException;
import com.amazon.carbonado.gen.CodeBuilderUtil;
import com.amazon.carbonado.gen.StorablePropertyMap;
import com.amazon.carbonado.gen.TriggerSupport;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableKey;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.info.StorablePropertyAdapter;
import com.amazon.carbonado.info.StorablePropertyAnnotation;
import com.amazon.carbonado.info.StorablePropertyConstraint;
import com.amazon.carbonado.lob.Lob;
import com.amazon.carbonado.raw.DataDecoder;
import com.amazon.carbonado.raw.DataEncoder;
import com.amazon.carbonado.raw.GenericEncodingStrategy;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeAssembler;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.ClassInjector;
import org.cojen.util.WeakIdentityMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StorableGenerator<S extends Storable> {
    public static final String DO_TRY_LOAD_METHOD_NAME = "doTryLoad$";
    public static final String DO_TRY_INSERT_METHOD_NAME = "doTryInsert$";
    public static final String DO_TRY_UPDATE_METHOD_NAME = "doTryUpdate$";
    public static final String DO_TRY_DELETE_METHOD_NAME = "doTryDelete$";
    public static final String CHECK_PK_FOR_INSERT_METHOD_NAME = "checkPkForInsert$";
    public static final String CHECK_PK_FOR_UPDATE_METHOD_NAME = "checkPkForUpdate$";
    public static final String CHECK_PK_FOR_DELETE_METHOD_NAME = "checkPkForDelete$";
    public static final String CHECK_PK_FOR_LOAD_METHOD_NAME = "checkPkForLoad$";
    public static final String IS_PK_INITIALIZED_METHOD_NAME = "isPkInitialized$";
    public static final String IS_PARTITION_KEY_INITIALIZED_METHOD_NAME = "isPartitionKeyInitialized$";
    public static final String IS_ALT_KEY_INITIALIZED_PREFIX = "isAltKeyInitialized$";
    public static final String IS_REQUIRED_DATA_INITIALIZED_METHOD_NAME = "isRequiredDataInitialized$";
    public static final String IS_VERSION_INITIALIZED_METHOD_NAME = "isVersionInitialized$";
    public static final String LOAD_COMPLETED_METHOD_NAME = "loadCompleted$";
    public static final String PROPERTY_STATE_FIELD_NAME = "propertyState$";
    public static final String ADAPTER_FIELD_ELEMENT = "$adapter$";
    public static final String CONSTRAINT_FIELD_ELEMENT = "$constraint$";
    public static final String SUPPORT_FIELD_NAME = "support$";
    public static final int PROPERTY_STATE_UNINITIALIZED = 0;
    public static final int PROPERTY_STATE_DIRTY = 3;
    public static final int PROPERTY_STATE_CLEAN = 1;
    public static final int PROPERTY_STATE_MASK = 3;
    private static final String PROPERTY_STATE_EXTRACT_METHOD_NAME = "extractState$";
    private static final String PRIVATE_INSERT_METHOD_NAME = "insert$";
    private static final String PRIVATE_UPDATE_METHOD_NAME = "update$";
    private static final String PRIVATE_DELETE_METHOD_NAME = "delete$";
    private static Map<Class, Reference<Class<? extends Storable>>> cAbstractCache = new WeakIdentityMap();
    private static final boolean cStrictAccess;
    private static final int EQUAL_KEYS = 0;
    private static final int EQUAL_PROPERTIES = 1;
    private static final int EQUAL_FULL = 2;
    private static final String UNCAUGHT_METHOD_NAME = "uncaught$";
    private static final String INSERT_OP = "Insert";
    private static final String UPDATE_OP = "Update";
    private static final String DELETE_OP = "Delete";
    private static final int SWITCH_FOR_STATE = 1;
    private static final int SWITCH_FOR_GET = 2;
    private static final int SWITCH_FOR_SET = 3;
    private final Class<S> mStorableType;
    private final TypeDesc mSupportType;
    private final StorableInfo<S> mInfo;
    private final Map<String, ? extends StorableProperty<S>> mAllProperties;
    private final ClassInjector mClassInjector;
    private final ClassFile mClassFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends Storable> Class<? extends S> getAbstractClass(Class<S> type) throws IllegalArgumentException {
        Map<Class, Reference<Class<? extends Storable>>> map = cAbstractCache;
        synchronized (map) {
            Class abstractClass;
            Reference<Class<? extends Storable>> ref = cAbstractCache.get(type);
            if (ref != null && (abstractClass = ref.get()) != null) {
                return abstractClass;
            }
            abstractClass = super.generateAndInjectClass();
            cAbstractCache.put(type, new SoftReference<Class<? extends Storable>>(abstractClass));
            return abstractClass;
        }
    }

    private StorableGenerator(Class<S> storableType) {
        this.mStorableType = storableType;
        this.mSupportType = TypeDesc.forClass(TriggerSupport.class);
        this.mInfo = StorableIntrospector.examine(storableType);
        this.mAllProperties = this.mInfo.getAllProperties();
        this.mClassInjector = ClassInjector.create((String)storableType.getName(), (ClassLoader)storableType.getClassLoader());
        this.mClassFile = CodeBuilderUtil.createStorableClassFile(this.mClassInjector, storableType, true, StorableGenerator.class.getName());
    }

    private Class<? extends S> generateAndInjectClass() {
        this.generateClass();
        Class abstractClass = this.mClassInjector.defineClass(this.mClassFile);
        return abstractClass;
    }

    private void generateClass() {
        this.defineUncaughtExceptionHandler();
        this.mClassFile.addField(Modifiers.PROTECTED.toFinal(true), SUPPORT_FIELD_NAME, this.mSupportType);
        TypeDesc[] params = new TypeDesc[]{this.mSupportType};
        boolean supportParam = false;
        MethodInfo mi = this.mClassFile.addConstructor(Modifiers.PROTECTED, params);
        CodeBuilder b = new CodeBuilder(mi);
        b.loadThis();
        b.invokeSuperConstructor(null);
        b.loadThis();
        b.loadLocal(b.getParameter(0));
        b.storeField(SUPPORT_FIELD_NAME, this.mSupportType);
        b.returnVoid();
        CodeBuilder clinit = null;
        Modifiers fieldModifiers = Modifiers.PROTECTED.toStatic(true).toFinal(true);
        for (StorableProperty<S> property : this.mAllProperties.values()) {
            StorablePropertyAdapter spa = property.getAdapter();
            if (spa == null) continue;
            String fieldName = property.getName() + ADAPTER_FIELD_ELEMENT + 0;
            TypeDesc adapterType = TypeDesc.forClass(spa.getAdapterConstructor().getDeclaringClass());
            this.mClassFile.addField(fieldModifiers, fieldName, adapterType);
            if (clinit == null) {
                clinit = new CodeBuilder(this.mClassFile.addInitializer());
            }
            clinit.newObject(adapterType);
            clinit.dup();
            clinit.loadConstant(TypeDesc.forClass(this.mStorableType));
            clinit.loadConstant(property.getName());
            this.loadPropertyAnnotation(clinit, property, spa.getAnnotation());
            clinit.invoke(spa.getAdapterConstructor());
            clinit.storeStaticField(fieldName, adapterType);
        }
        for (StorableProperty<S> property : this.mAllProperties.values()) {
            int count = property.getConstraintCount();
            for (int i = 0; i < count; ++i) {
                StorablePropertyConstraint spc = property.getConstraint(i);
                String fieldName = property.getName() + CONSTRAINT_FIELD_ELEMENT + i;
                TypeDesc constraintType = TypeDesc.forClass(spc.getConstraintConstructor().getDeclaringClass());
                this.mClassFile.addField(fieldModifiers, fieldName, constraintType);
                if (clinit == null) {
                    clinit = new CodeBuilder(this.mClassFile.addInitializer());
                }
                clinit.newObject(constraintType);
                clinit.dup();
                clinit.loadConstant(TypeDesc.forClass(this.mStorableType));
                clinit.loadConstant(property.getName());
                this.loadPropertyAnnotation(clinit, property, spc.getAnnotation());
                clinit.invoke(spc.getConstraintConstructor());
                clinit.storeStaticField(fieldName, constraintType);
            }
        }
        if (clinit != null) {
            clinit.returnVoid();
        }
        int versionOrdinal = -1;
        int maxOrdinal = this.mAllProperties.size() - 1;
        boolean requireStateField = false;
        for (StorableProperty<S> property : this.mAllProperties.values()) {
            CodeBuilder b2;
            StorablePropertyAdapter adapter;
            StorableProperty<S> internal;
            int i;
            CodeBuilder b3;
            MethodInfo mi2;
            int ordinal = property.getNumber();
            if (!property.isDerived() && property.isVersion()) {
                versionOrdinal = ordinal;
            }
            String name = property.getName();
            TypeDesc type = TypeDesc.forClass(property.getType());
            if (!property.isDerived()) {
                if (property.isJoin()) {
                    this.mClassFile.addField(Modifiers.PRIVATE.toTransient(true), name, type);
                    requireStateField = true;
                } else {
                    boolean isVolatile = !cStrictAccess && type.isDoubleWord();
                    this.mClassFile.addField(Modifiers.PROTECTED.toVolatile(isVolatile), name, type);
                    requireStateField = true;
                }
            }
            String stateFieldName = PROPERTY_STATE_FIELD_NAME + (ordinal >> 4);
            if (ordinal == maxOrdinal || (ordinal & 0xF) == 15) {
                if (requireStateField) {
                    this.mClassFile.addField(Modifiers.PROTECTED, stateFieldName, TypeDesc.INT);
                }
                requireStateField = false;
            }
            if (!property.isDerived()) {
                Method readMethod = property.getReadMethod();
                if (readMethod != null) {
                    mi2 = this.mClassFile.addMethod(readMethod);
                } else {
                    String readName = property.getReadMethodName();
                    mi2 = this.mClassFile.addMethod(Modifiers.PROTECTED, readName, type, null);
                    mi2.markSynthetic();
                    if (property.isJoin()) {
                        mi2.addException(TypeDesc.forClass(FetchException.class));
                    }
                }
                if (cStrictAccess || property.isJoin()) {
                    mi2.setModifiers(mi2.getModifiers().toSynchronized(true));
                }
                b3 = new CodeBuilder(mi2);
                if (!property.isJoin()) {
                    if (cStrictAccess) {
                        b3.loadThis();
                        b3.loadField(stateFieldName, TypeDesc.INT);
                        b3.loadConstant(3 << (ordinal & 0xF) * 2);
                        b3.math((byte)126);
                        Label isValid = b3.createLabel();
                        b3.ifZeroComparisonBranch((Location)isValid, "!=");
                        CodeBuilderUtil.throwConcatException(b3, IllegalStateException.class, "Cannot access uninitialized property: ", name);
                        isValid.setLocation();
                    }
                } else {
                    boolean canUseDirectForm;
                    b3.loadThis();
                    b3.loadField(stateFieldName, TypeDesc.INT);
                    b3.loadConstant(3 << (ordinal & 0xF) * 2);
                    b3.math((byte)126);
                    Label isLoaded = b3.createLabel();
                    b3.ifZeroComparisonBranch((Location)isLoaded, "!=");
                    LocalVariable join = b3.createLocalVariable(name, type);
                    Label shortCircuit = b3.createLabel();
                    int count = property.getJoinElementCount();
                    for (i = 0; i < count; ++i) {
                        internal = property.getInternalJoinElement(i);
                        StorableProperty<?> external = property.getExternalJoinElement(i);
                        if (!internal.isNullable() || external.isNullable()) {
                            continue;
                        }
                        for (i = 0; i < count; ++i) {
                            internal = property.getInternalJoinElement(i);
                            external = property.getExternalJoinElement(i);
                            if (!internal.isNullable() || external.isNullable()) continue;
                            this.loadThisProperty(b3, internal);
                            Label notNull = b3.createLabel();
                            b3.ifNullBranch((Location)notNull, false);
                            b3.loadNull();
                            b3.storeLocal(join);
                            b3.branch((Location)shortCircuit);
                            notNull.setLocation();
                        }
                    }
                    this.loadStorageForFetch(b3, TypeDesc.forClass(property.getJoinedType()));
                    TypeDesc storageType = TypeDesc.forClass(Storage.class);
                    boolean bl = canUseDirectForm = !property.isQuery();
                    if (canUseDirectForm) {
                        int joinCount = property.getJoinElementCount();
                        for (int i2 = 0; i2 < joinCount; ++i2) {
                            StorableProperty<?> external = property.getExternalJoinElement(i2);
                            if (external.getWriteMethod() != null) continue;
                            canUseDirectForm = false;
                        }
                    }
                    TypeDesc storableDesc = TypeDesc.forClass(Storable.class);
                    if (canUseDirectForm) {
                        b3.invokeInterface(storageType, "prepare", storableDesc, null);
                        b3.checkCast(type);
                        b3.storeLocal(join);
                        int count2 = property.getJoinElementCount();
                        for (int i3 = 0; i3 < count2; ++i3) {
                            b3.loadLocal(join);
                            StorableProperty<S> internal2 = property.getInternalJoinElement(i3);
                            StorableProperty<?> external = property.getExternalJoinElement(i3);
                            this.loadThisProperty(b3, internal2);
                            CodeBuilderUtil.convertValue(b3, internal2.getType(), external.getType());
                            b3.invoke(external.getWriteMethod());
                        }
                        b3.loadLocal(join);
                        b3.invokeInterface(storableDesc, "tryLoad", TypeDesc.BOOLEAN, null);
                        Label wasLoaded = b3.createLabel();
                        b3.ifZeroComparisonBranch((Location)wasLoaded, "!=");
                        b3.loadNull();
                        b3.storeLocal(join);
                        wasLoaded.setLocation();
                    } else {
                        StringBuilder queryBuilder = new StringBuilder();
                        int count3 = property.getJoinElementCount();
                        for (int i4 = 0; i4 < count3; ++i4) {
                            if (i4 > 0) {
                                queryBuilder.append(" & ");
                            }
                            queryBuilder.append(property.getExternalJoinElement(i4).getName());
                            queryBuilder.append(" = ?");
                        }
                        b3.loadConstant(queryBuilder.toString());
                        TypeDesc queryType = TypeDesc.forClass(Query.class);
                        b3.invokeInterface(storageType, "query", queryType, new TypeDesc[]{TypeDesc.STRING});
                        for (int i5 = 0; i5 < count3; ++i5) {
                            StorableProperty<S> internal3 = property.getInternalJoinElement(i5);
                            this.loadThisProperty(b3, internal3);
                            TypeDesc bindType = CodeBuilderUtil.bindQueryParam(internal3.getType());
                            CodeBuilderUtil.convertValue(b3, internal3.getType(), bindType.toClass());
                            b3.invokeInterface(queryType, "with", queryType, new TypeDesc[]{bindType});
                        }
                        if (property.isQuery()) {
                            b3.storeLocal(join);
                        } else {
                            b3.invokeInterface(queryType, "tryLoadOne", storableDesc, null);
                            b3.checkCast(type);
                            b3.storeLocal(join);
                        }
                    }
                    shortCircuit.setLocation();
                    b3.loadThis();
                    b3.loadLocal(join);
                    b3.storeField(property.getName(), type);
                    if (!property.isNullable()) {
                        b3.loadLocal(join);
                        b3.ifNullBranch((Location)isLoaded, true);
                    }
                    b3.loadThis();
                    b3.loadThis();
                    b3.loadField(stateFieldName, TypeDesc.INT);
                    b3.loadConstant(3 << (ordinal & 0xF) * 2);
                    b3.math((byte)-128);
                    b3.storeField(stateFieldName, TypeDesc.INT);
                    isLoaded.setLocation();
                }
                this.loadThisProperty(b3, property);
                b3.returnValue(type);
            }
            if (!property.isDerived() && !property.isQuery()) {
                boolean nullNotAllowed;
                Method writeMethod = property.getWriteMethod();
                if (writeMethod != null) {
                    mi2 = this.mClassFile.addMethod(writeMethod);
                } else {
                    String writeName = property.getWriteMethodName();
                    mi2 = this.mClassFile.addMethod(Modifiers.PROTECTED, writeName, null, new TypeDesc[]{type});
                    mi2.markSynthetic();
                }
                mi2.setModifiers(mi2.getModifiers().toSynchronized(true));
                b3 = new CodeBuilder(mi2);
                if (property.isPrimaryKeyMember()) {
                    b3.loadThis();
                    b3.loadField(stateFieldName, TypeDesc.INT);
                    b3.loadConstant(3 << (ordinal & 0xF) * 2);
                    b3.math((byte)126);
                    b3.loadConstant(1 << (ordinal & 0xF) * 2);
                    Label isMutable = b3.createLabel();
                    b3.ifComparisonBranch((Location)isMutable, "!=");
                    CodeBuilderUtil.throwException(b3, IllegalStateException.class, "Cannot alter primary key");
                    isMutable.setLocation();
                }
                int spcCount = property.getConstraintCount();
                boolean bl = nullNotAllowed = !property.getType().isPrimitive() && !property.isJoin() && !property.isNullable();
                if (nullNotAllowed || spcCount > 0) {
                    Label skipConstraints = b3.createLabel();
                    if (nullNotAllowed) {
                        b3.loadLocal(b3.getParameter(0));
                        Label notNull = b3.createLabel();
                        b3.ifNullBranch((Location)notNull, false);
                        CodeBuilderUtil.throwConcatException(b3, IllegalArgumentException.class, "Cannot set property \"", property.getName(), "\" to null");
                        notNull.setLocation();
                    } else if (!property.getType().isPrimitive()) {
                        b3.loadLocal(b3.getParameter(0));
                        b3.ifNullBranch((Location)skipConstraints, true);
                    }
                    for (int spcIndex = 0; spcIndex < spcCount; ++spcIndex) {
                        StorablePropertyConstraint spc = property.getConstraint(spcIndex);
                        String fieldName = property.getName() + CONSTRAINT_FIELD_ELEMENT + spcIndex;
                        TypeDesc constraintType = TypeDesc.forClass(spc.getConstraintConstructor().getDeclaringClass());
                        b3.loadStaticField(fieldName, constraintType);
                        b3.loadLocal(b3.getParameter(0));
                        b3.convert(b3.getParameter(0).getType(), TypeDesc.forClass(spc.getConstrainMethod().getParameterTypes()[0]));
                        b3.invoke(spc.getConstrainMethod());
                    }
                    skipConstraints.setLocation();
                }
                Label setValue = b3.createLabel();
                if (!property.isJoin() || Lob.class.isAssignableFrom(property.getType())) {
                    Label markDirty = b3.createLabel();
                    if (Lob.class.isAssignableFrom(property.getType())) {
                        b3.loadLocal(b3.getParameter(0));
                        b3.ifNullBranch((Location)markDirty, true);
                        this.loadThisProperty(b3, property);
                        LocalVariable tempProp = b3.createLocalVariable(null, type);
                        b3.storeLocal(tempProp);
                        b3.loadLocal(tempProp);
                        b3.ifNullBranch((Location)markDirty, true);
                        b3.loadLocal(tempProp);
                        b3.loadLocal(b3.getParameter(0));
                        CodeBuilderUtil.addValuesEqualCall(b3, type, false, setValue, true);
                    }
                    markDirty.setLocation();
                    this.markOrdinaryPropertyDirty(b3, property);
                } else {
                    b3.loadLocal(b3.getParameter(0));
                    if (property.isNullable()) {
                        b3.ifNullBranch((Location)setValue, true);
                    } else {
                        Label notNull = b3.createLabel();
                        b3.ifNullBranch((Location)notNull, false);
                        CodeBuilderUtil.throwConcatException(b3, IllegalArgumentException.class, "Non-nullable join property \"", property.getName(), "\" cannot be set to null");
                        notNull.setLocation();
                    }
                    int count = property.getJoinElementCount();
                    for (i = 0; i < count; ++i) {
                        internal = property.getInternalJoinElement(i);
                        if (internal.getWriteMethod() == null) continue;
                        StorableProperty<?> external = property.getExternalJoinElement(i);
                        b3.loadLocal(b3.getParameter(0));
                        b3.invoke(external.getReadMethod());
                        CodeBuilderUtil.convertValue(b3, external.getType(), internal.getType());
                        LocalVariable newInternalPropVar = b3.createLocalVariable(null, TypeDesc.forClass(internal.getType()));
                        b3.storeLocal(newInternalPropVar);
                        Label setInternalProp = b3.createLabel();
                        int ord = internal.getNumber();
                        b3.loadThis();
                        b3.loadField(PROPERTY_STATE_FIELD_NAME + (ord >> 4), TypeDesc.INT);
                        b3.loadConstant(3 << (ord & 0xF) * 2);
                        b3.math((byte)126);
                        b3.loadConstant(1 << (ord & 0xF) * 2);
                        b3.ifComparisonBranch((Location)setInternalProp, "!=");
                        b3.loadThis();
                        b3.invoke(internal.getReadMethod());
                        b3.loadLocal(newInternalPropVar);
                        Label skipSetInternalProp = b3.createLabel();
                        CodeBuilderUtil.addValuesEqualCall(b3, TypeDesc.forClass(internal.getType()), true, skipSetInternalProp, true);
                        setInternalProp.setLocation();
                        b3.loadThis();
                        b3.loadLocal(newInternalPropVar);
                        b3.invoke(internal.getWriteMethod());
                        skipSetInternalProp.setLocation();
                    }
                    b3.loadThis();
                    b3.loadThis();
                    b3.loadField(stateFieldName, TypeDesc.INT);
                    b3.loadConstant(3 << (ordinal & 0xF) * 2);
                    b3.math((byte)-128);
                    b3.storeField(stateFieldName, TypeDesc.INT);
                }
                setValue.setLocation();
                b3.loadThis();
                b3.loadLocal(b3.getParameter(0));
                b3.storeField(property.getName(), type);
                b3.returnVoid();
            }
            if (property.getAdapter() != null) {
                String readName = property.getReadMethodName() + '$';
                adapter = property.getAdapter();
                for (Method adaptMethod : adapter.findAdaptMethodsFrom(type.toClass())) {
                    TypeDesc toType = TypeDesc.forClass(adaptMethod.getReturnType());
                    MethodInfo mi3 = this.mClassFile.addMethod(Modifiers.PROTECTED, readName, toType, null);
                    mi3.markSynthetic();
                    b2 = new CodeBuilder(mi3);
                    String fieldName = property.getName() + ADAPTER_FIELD_ELEMENT + 0;
                    TypeDesc adapterType = TypeDesc.forClass(adapter.getAdapterConstructor().getDeclaringClass());
                    b2.loadStaticField(fieldName, adapterType);
                    this.loadThisProperty(b2, property);
                    b2.invoke(adaptMethod);
                    b2.returnValue(toType);
                }
            }
            if (property.getAdapter() != null && !property.isDerived()) {
                String writeName = property.getWriteMethodName() + '$';
                adapter = property.getAdapter();
                for (Method adaptMethod : adapter.findAdaptMethodsTo(type.toClass())) {
                    TypeDesc fromType = TypeDesc.forClass(adaptMethod.getParameterTypes()[0]);
                    MethodInfo mi4 = this.mClassFile.addMethod(Modifiers.PROTECTED, writeName, null, new TypeDesc[]{fromType});
                    mi4.markSynthetic();
                    mi4.setModifiers(mi4.getModifiers().toSynchronized(true));
                    b2 = new CodeBuilder(mi4);
                    b2.loadThis();
                    String fieldName = property.getName() + ADAPTER_FIELD_ELEMENT + 0;
                    TypeDesc adapterType = TypeDesc.forClass(adapter.getAdapterConstructor().getDeclaringClass());
                    b2.loadStaticField(fieldName, adapterType);
                    b2.loadLocal(b2.getParameter(0));
                    b2.invoke(adaptMethod);
                    b2.storeField(property.getName(), type);
                    b2.returnVoid();
                }
            }
            this.addPropertyBridges(property);
        }
        MethodInfo mi5 = this.addMethodIfNotFinal(Modifiers.PUBLIC.toSynchronized(true), "tryLoad", TypeDesc.BOOLEAN, null);
        if (mi5 != null) {
            mi5.addException(TypeDesc.forClass(FetchException.class));
            CodeBuilder b4 = new CodeBuilder(mi5);
            b4.loadThis();
            b4.invokeVirtual(CHECK_PK_FOR_LOAD_METHOD_NAME, null, null);
            CodeBuilder b1 = new CodeBuilder(this.mClassFile.addMethod(Modifiers.PROTECTED, CHECK_PK_FOR_LOAD_METHOD_NAME, null, null));
            b1.loadThis();
            b1.returnVoid();
            b4.loadThis();
            b4.invokeVirtual(IS_PK_INITIALIZED_METHOD_NAME, TypeDesc.BOOLEAN, null);
            Label pkInitialized = b4.createLabel();
            b4.ifZeroComparisonBranch((Location)pkInitialized, "!=");
            Label loaded = b4.createLabel();
            Label notLoaded = b4.createLabel();
            if (this.mInfo.getAlternateKeyCount() == 0) {
                CodeBuilderUtil.throwException(b4, IllegalStateException.class, "Primary key not fully specified");
            } else {
                this.loadStorageForFetch(b4, TypeDesc.forClass(this.mStorableType));
                Label runQuery = b4.createLabel();
                TypeDesc queryType = TypeDesc.forClass(Query.class);
                for (int i = 0; i < this.mInfo.getAlternateKeyCount(); ++i) {
                    b4.loadThis();
                    b4.invokeVirtual(IS_ALT_KEY_INITIALIZED_PREFIX + i, TypeDesc.BOOLEAN, null);
                    Label noAltKey = b4.createLabel();
                    b4.ifZeroComparisonBranch((Location)noAltKey, "==");
                    StorableKey<S> altKey = this.mInfo.getAlternateKey(i);
                    StringBuilder queryBuilder = new StringBuilder();
                    for (OrderedProperty<S> op : altKey.getProperties()) {
                        if (queryBuilder.length() > 0) {
                            queryBuilder.append(" & ");
                        }
                        queryBuilder.append(op.getChainedProperty().toString());
                        queryBuilder.append(" = ?");
                    }
                    b4.loadConstant(queryBuilder.toString());
                    b4.invokeInterface(TypeDesc.forClass(Storage.class), "query", queryType, new TypeDesc[]{TypeDesc.STRING});
                    for (OrderedProperty<S> op : altKey.getProperties()) {
                        StorableProperty<S> prop = op.getChainedProperty().getPrimeProperty();
                        this.loadThisProperty(b4, prop);
                        TypeDesc bindType = CodeBuilderUtil.bindQueryParam(prop.getType());
                        CodeBuilderUtil.convertValue(b4, prop.getType(), bindType.toClass());
                        b4.invokeInterface(queryType, "with", queryType, new TypeDesc[]{bindType});
                    }
                    StorableKey<S> parKey = this.mInfo.getPartitionKey();
                    if (parKey != null) {
                        for (OrderedProperty<S> op : parKey.getProperties()) {
                            if (altKey.getProperties().contains(op)) continue;
                            StorableProperty<S> prop = op.getChainedProperty().getPrimeProperty();
                            Label skip = b4.createLabel();
                            if (!prop.isDerived()) {
                                int num = prop.getNumber();
                                b4.loadThis();
                                b4.loadField(PROPERTY_STATE_FIELD_NAME + (num >> 4), TypeDesc.INT);
                                b4.loadConstant(3 << (num & 0xF) * 2);
                                b4.math((byte)126);
                                b4.ifZeroComparisonBranch((Location)skip, "==");
                            }
                            b4.loadConstant(prop.getName() + " = ?");
                            b4.invokeInterface(queryType, "and", queryType, new TypeDesc[]{TypeDesc.STRING});
                            this.loadThisProperty(b4, prop);
                            TypeDesc bindType = CodeBuilderUtil.bindQueryParam(prop.getType());
                            CodeBuilderUtil.convertValue(b4, prop.getType(), bindType.toClass());
                            b4.invokeInterface(queryType, "with", queryType, new TypeDesc[]{bindType});
                            skip.setLocation();
                        }
                    }
                    b4.branch((Location)runQuery);
                    noAltKey.setLocation();
                }
                CodeBuilderUtil.throwException(b4, IllegalStateException.class, "Primary or alternate key not fully specified");
                runQuery.setLocation();
                b4.loadThis();
                b4.loadField(SUPPORT_FIELD_NAME, this.mSupportType);
                b4.invoke(StorableGenerator.lookupMethod(this.mSupportType.toClass(), "locallyDisableLoadTrigger", new Class[0]));
                Label disableTriggerStart = b4.createLabel().setLocation();
                b4.invokeInterface(queryType, "tryLoadOne", TypeDesc.forClass(Storable.class), null);
                LocalVariable fetchedVar = b4.createLocalVariable(null, TypeDesc.OBJECT);
                b4.storeLocal(fetchedVar);
                Label disableTriggerEnd = b4.createLabel().setLocation();
                b4.loadThis();
                b4.loadField(SUPPORT_FIELD_NAME, this.mSupportType);
                b4.invoke(StorableGenerator.lookupMethod(this.mSupportType.toClass(), "locallyEnableLoadTrigger", new Class[0]));
                b4.loadLocal(fetchedVar);
                b4.ifNullBranch((Location)notLoaded, true);
                b4.loadThis();
                b4.invokeVirtual("markAllPropertiesDirty", null, null);
                b4.loadLocal(fetchedVar);
                b4.checkCast(TypeDesc.forClass(this.mStorableType));
                b4.loadThis();
                b4.invokeInterface(TypeDesc.forClass(Storable.class), "copyAllProperties", null, new TypeDesc[]{TypeDesc.forClass(Storable.class)});
                b4.branch((Location)loaded);
                b4.exceptionHandler((Location)disableTriggerStart, (Location)disableTriggerEnd, null);
                LocalVariable exceptionVar = b4.createLocalVariable(null, TypeDesc.OBJECT);
                b4.storeLocal(exceptionVar);
                b4.loadThis();
                b4.loadField(SUPPORT_FIELD_NAME, this.mSupportType);
                b4.invoke(StorableGenerator.lookupMethod(this.mSupportType.toClass(), "locallyEnableLoadTrigger", new Class[0]));
                b4.loadLocal(exceptionVar);
                b4.throwObject();
            }
            pkInitialized.setLocation();
            b4.loadThis();
            b4.invokeVirtual(DO_TRY_LOAD_METHOD_NAME, TypeDesc.BOOLEAN, null);
            b4.ifZeroComparisonBranch((Location)notLoaded, "==");
            loaded.setLocation();
            b4.loadThis();
            b4.invokeVirtual(LOAD_COMPLETED_METHOD_NAME, null, null);
            b4.loadConstant(true);
            b4.returnValue(TypeDesc.BOOLEAN);
            notLoaded.setLocation();
            b4.loadThis();
            b4.invokeVirtual("markPropertiesDirty", null, null);
            b4.loadConstant(false);
            b4.returnValue(TypeDesc.BOOLEAN);
            mi5 = this.mClassFile.addMethod(Modifiers.PROTECTED.toAbstract(true), DO_TRY_LOAD_METHOD_NAME, TypeDesc.BOOLEAN, null);
            mi5.addException(TypeDesc.forClass(FetchException.class));
        }
        mi5 = this.addMethodIfNotFinal(Modifiers.PUBLIC.toSynchronized(true), "load", null, null);
        if (mi5 != null) {
            mi5.addException(TypeDesc.forClass(FetchException.class));
            CodeBuilder b5 = new CodeBuilder(mi5);
            b5.loadThis();
            b5.invokeVirtual("tryLoad", TypeDesc.BOOLEAN, null);
            Label wasNotLoaded = b5.createLabel();
            b5.ifZeroComparisonBranch((Location)wasNotLoaded, "==");
            b5.returnVoid();
            wasNotLoaded.setLocation();
            TypeDesc noMatchesType = TypeDesc.forClass(FetchNoneException.class);
            b5.newObject(noMatchesType);
            b5.dup();
            b5.loadThis();
            b5.invokeVirtual("toStringKeyOnly", TypeDesc.STRING, null);
            b5.invokeConstructor(noMatchesType, new TypeDesc[]{TypeDesc.STRING});
            b5.throwObject();
        }
        TypeDesc triggerType = TypeDesc.forClass(Trigger.class);
        TypeDesc transactionType = TypeDesc.forClass(Transaction.class);
        MethodInfo mi6 = this.mClassFile.addMethod(Modifiers.PRIVATE.toSynchronized(true), PRIVATE_INSERT_METHOD_NAME, TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.BOOLEAN});
        mi6.addException(TypeDesc.forClass(PersistException.class));
        CodeBuilder b6 = new CodeBuilder(mi6);
        LocalVariable forTryVar = b6.getParameter(0);
        LocalVariable triggerVar = b6.createLocalVariable(null, triggerType);
        LocalVariable txnVar = b6.createLocalVariable(null, transactionType);
        LocalVariable stateVar = b6.createLocalVariable(null, TypeDesc.OBJECT);
        Label tryStart = this.addGetTriggerAndEnterTxn(b6, INSERT_OP, forTryVar, false, triggerVar, txnVar, stateVar);
        this.requirePkInitialized(b6, CHECK_PK_FOR_INSERT_METHOD_NAME);
        b6.loadThis();
        b6.invokeVirtual(DO_TRY_INSERT_METHOD_NAME, TypeDesc.BOOLEAN, null);
        Label notInserted = b6.createLabel();
        b6.ifZeroComparisonBranch((Location)notInserted, "==");
        this.addTriggerAfterAndExitTxn(b6, INSERT_OP, forTryVar, false, triggerVar, txnVar, stateVar);
        b6.loadThis();
        b6.invokeVirtual("markAllPropertiesClean", null, null);
        b6.loadConstant(true);
        b6.returnValue(TypeDesc.BOOLEAN);
        notInserted.setLocation();
        this.addTriggerFailedAndExitTxn(b6, INSERT_OP, triggerVar, txnVar, stateVar);
        b6.loadLocal(forTryVar);
        Label isForTry = b6.createLabel();
        b6.ifZeroComparisonBranch((Location)isForTry, "!=");
        TypeDesc constraintType = TypeDesc.forClass(UniqueConstraintException.class);
        b6.newObject(constraintType);
        b6.dup();
        b6.loadThis();
        b6.invokeVirtual("toString", TypeDesc.STRING, null);
        b6.invokeConstructor(constraintType, new TypeDesc[]{TypeDesc.STRING});
        b6.throwObject();
        isForTry.setLocation();
        b6.loadConstant(false);
        b6.returnValue(TypeDesc.BOOLEAN);
        this.addTriggerFailedAndExitTxn(b6, INSERT_OP, forTryVar, false, triggerVar, txnVar, stateVar, tryStart);
        mi6 = this.mClassFile.addMethod(Modifiers.PROTECTED.toAbstract(true), DO_TRY_INSERT_METHOD_NAME, TypeDesc.BOOLEAN, null);
        mi6.addException(TypeDesc.forClass(PersistException.class));
        mi6 = this.addMethodIfNotFinal(Modifiers.PUBLIC, "insert", null, null);
        if (mi6 != null) {
            mi6.addException(TypeDesc.forClass(PersistException.class));
            b6 = new CodeBuilder(mi6);
            b6.loadThis();
            b6.loadConstant(false);
            b6.invokePrivate(PRIVATE_INSERT_METHOD_NAME, TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.BOOLEAN});
            b6.pop();
            b6.returnVoid();
        }
        mi6 = this.addMethodIfNotFinal(Modifiers.PUBLIC, "tryInsert", TypeDesc.BOOLEAN, null);
        if (mi6 != null) {
            mi6.addException(TypeDesc.forClass(PersistException.class));
            b6 = new CodeBuilder(mi6);
            b6.loadThis();
            b6.loadConstant(true);
            b6.invokePrivate(PRIVATE_INSERT_METHOD_NAME, TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.BOOLEAN});
            b6.returnValue(TypeDesc.BOOLEAN);
        }
        mi6 = this.mClassFile.addMethod(Modifiers.PRIVATE.toSynchronized(true), PRIVATE_UPDATE_METHOD_NAME, TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.BOOLEAN});
        mi6.addException(TypeDesc.forClass(PersistException.class));
        b6 = new CodeBuilder(mi6);
        this.requirePkInitialized(b6, CHECK_PK_FOR_UPDATE_METHOD_NAME);
        if (versionOrdinal >= 0) {
            b6.loadThis();
            b6.loadField(PROPERTY_STATE_FIELD_NAME + (versionOrdinal >> 4), TypeDesc.INT);
            b6.loadConstant(3 << (versionOrdinal & 0xF) * 2);
            b6.math((byte)126);
            Label versionIsSet = b6.createLabel();
            b6.ifZeroComparisonBranch((Location)versionIsSet, "!=");
            CodeBuilderUtil.throwException(b6, IllegalStateException.class, "Version not set");
            versionIsSet.setLocation();
        }
        forTryVar = b6.getParameter(0);
        triggerVar = b6.createLocalVariable(null, triggerType);
        txnVar = b6.createLocalVariable(null, transactionType);
        stateVar = b6.createLocalVariable(null, TypeDesc.OBJECT);
        tryStart = this.addGetTriggerAndEnterTxn(b6, UPDATE_OP, forTryVar, false, triggerVar, txnVar, stateVar);
        b6.loadThis();
        b6.invokeVirtual(DO_TRY_UPDATE_METHOD_NAME, TypeDesc.BOOLEAN, null);
        Label notUpdated = b6.createLabel();
        b6.ifZeroComparisonBranch((Location)notUpdated, "==");
        this.addTriggerAfterAndExitTxn(b6, UPDATE_OP, forTryVar, false, triggerVar, txnVar, stateVar);
        b6.loadThis();
        b6.invokeVirtual("markAllPropertiesClean", null, null);
        b6.loadConstant(true);
        b6.returnValue(TypeDesc.BOOLEAN);
        notUpdated.setLocation();
        this.addTriggerFailedAndExitTxn(b6, UPDATE_OP, triggerVar, txnVar, stateVar);
        b6.loadThis();
        b6.invokeVirtual("markPropertiesDirty", null, null);
        b6.loadLocal(forTryVar);
        isForTry = b6.createLabel();
        b6.ifZeroComparisonBranch((Location)isForTry, "!=");
        TypeDesc persistNoneType = TypeDesc.forClass(PersistNoneException.class);
        b6.newObject(persistNoneType);
        b6.dup();
        b6.loadConstant("Cannot update missing object: ");
        b6.loadThis();
        b6.invokeVirtual("toString", TypeDesc.STRING, null);
        b6.invokeVirtual(TypeDesc.STRING, "concat", TypeDesc.STRING, new TypeDesc[]{TypeDesc.STRING});
        b6.invokeConstructor(persistNoneType, new TypeDesc[]{TypeDesc.STRING});
        b6.throwObject();
        isForTry.setLocation();
        b6.loadConstant(false);
        b6.returnValue(TypeDesc.BOOLEAN);
        this.addTriggerFailedAndExitTxn(b6, UPDATE_OP, forTryVar, false, triggerVar, txnVar, stateVar, tryStart);
        mi6 = this.mClassFile.addMethod(Modifiers.PROTECTED.toAbstract(true), DO_TRY_UPDATE_METHOD_NAME, TypeDesc.BOOLEAN, null);
        mi6.addException(TypeDesc.forClass(PersistException.class));
        mi6 = this.addMethodIfNotFinal(Modifiers.PUBLIC, "update", null, null);
        if (mi6 != null) {
            mi6.addException(TypeDesc.forClass(PersistException.class));
            b6 = new CodeBuilder(mi6);
            b6.loadThis();
            b6.loadConstant(false);
            b6.invokePrivate(PRIVATE_UPDATE_METHOD_NAME, TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.BOOLEAN});
            b6.pop();
            b6.returnVoid();
        }
        mi6 = this.addMethodIfNotFinal(Modifiers.PUBLIC, "tryUpdate", TypeDesc.BOOLEAN, null);
        if (mi6 != null) {
            mi6.addException(TypeDesc.forClass(PersistException.class));
            b6 = new CodeBuilder(mi6);
            b6.loadThis();
            b6.loadConstant(true);
            b6.invokePrivate(PRIVATE_UPDATE_METHOD_NAME, TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.BOOLEAN});
            b6.returnValue(TypeDesc.BOOLEAN);
        }
        mi6 = this.mClassFile.addMethod(Modifiers.PRIVATE.toSynchronized(true), PRIVATE_DELETE_METHOD_NAME, TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.BOOLEAN});
        mi6.addException(TypeDesc.forClass(PersistException.class));
        b6 = new CodeBuilder(mi6);
        this.requirePkInitialized(b6, CHECK_PK_FOR_DELETE_METHOD_NAME);
        forTryVar = b6.getParameter(0);
        triggerVar = b6.createLocalVariable(null, triggerType);
        txnVar = b6.createLocalVariable(null, transactionType);
        stateVar = b6.createLocalVariable(null, TypeDesc.OBJECT);
        tryStart = this.addGetTriggerAndEnterTxn(b6, DELETE_OP, forTryVar, false, triggerVar, txnVar, stateVar);
        b6.loadThis();
        b6.invokeVirtual(DO_TRY_DELETE_METHOD_NAME, TypeDesc.BOOLEAN, null);
        b6.loadThis();
        b6.invokeVirtual("markPropertiesDirty", null, null);
        Label notDeleted = b6.createLabel();
        b6.ifZeroComparisonBranch((Location)notDeleted, "==");
        this.addTriggerAfterAndExitTxn(b6, DELETE_OP, forTryVar, false, triggerVar, txnVar, stateVar);
        b6.loadConstant(true);
        b6.returnValue(TypeDesc.BOOLEAN);
        notDeleted.setLocation();
        this.addTriggerFailedAndExitTxn(b6, DELETE_OP, triggerVar, txnVar, stateVar);
        b6.loadLocal(forTryVar);
        isForTry = b6.createLabel();
        b6.ifZeroComparisonBranch((Location)isForTry, "!=");
        persistNoneType = TypeDesc.forClass(PersistNoneException.class);
        b6.newObject(persistNoneType);
        b6.dup();
        b6.loadConstant("Cannot delete missing object: ");
        b6.loadThis();
        b6.invokeVirtual("toString", TypeDesc.STRING, null);
        b6.invokeVirtual(TypeDesc.STRING, "concat", TypeDesc.STRING, new TypeDesc[]{TypeDesc.STRING});
        b6.invokeConstructor(persistNoneType, new TypeDesc[]{TypeDesc.STRING});
        b6.throwObject();
        isForTry.setLocation();
        b6.loadConstant(false);
        b6.returnValue(TypeDesc.BOOLEAN);
        this.addTriggerFailedAndExitTxn(b6, DELETE_OP, forTryVar, false, triggerVar, txnVar, stateVar, tryStart);
        mi6 = this.mClassFile.addMethod(Modifiers.PROTECTED.toAbstract(true), DO_TRY_DELETE_METHOD_NAME, TypeDesc.BOOLEAN, null);
        mi6.addException(TypeDesc.forClass(PersistException.class));
        mi6 = this.addMethodIfNotFinal(Modifiers.PUBLIC, "delete", null, null);
        if (mi6 != null) {
            mi6.addException(TypeDesc.forClass(PersistException.class));
            b6 = new CodeBuilder(mi6);
            b6.loadThis();
            b6.loadConstant(false);
            b6.invokePrivate(PRIVATE_DELETE_METHOD_NAME, TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.BOOLEAN});
            b6.pop();
            b6.returnVoid();
        }
        mi6 = this.addMethodIfNotFinal(Modifiers.PUBLIC, "tryDelete", TypeDesc.BOOLEAN, null);
        if (mi6 != null) {
            mi6.addException(TypeDesc.forClass(PersistException.class));
            b6 = new CodeBuilder(mi6);
            b6.loadThis();
            b6.loadConstant(true);
            b6.invokePrivate(PRIVATE_DELETE_METHOD_NAME, TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.BOOLEAN});
            b6.returnValue(TypeDesc.BOOLEAN);
        }
        TypeDesc type = TypeDesc.forClass(this.mStorableType);
        TypeDesc storableClassType = TypeDesc.forClass(Class.class);
        MethodInfo mi7 = this.addMethodIfNotFinal(Modifiers.PUBLIC, "storableType", storableClassType, null);
        if (mi7 != null) {
            CodeBuilder b7 = new CodeBuilder(mi7);
            b7.loadConstant(type);
            b7.returnValue(storableClassType);
        }
        type = TypeDesc.forClass(this.mInfo.getStorableType());
        MethodInfo mi8 = this.addMethodIfNotFinal(Modifiers.PUBLIC.toSynchronized(true), "copy", this.mClassFile.getType(), null);
        if (mi8 != null) {
            CodeBuilder b8 = new CodeBuilder(mi8);
            b8.loadThis();
            b8.invokeVirtual("clone", TypeDesc.OBJECT, null);
            b8.checkCast(this.mClassFile.getType());
            b8.returnValue(type);
        }
        CodeBuilderUtil.defineCopyBridges(this.mClassFile, this.mInfo.getStorableType());
        this.addCopyPropertiesMethod("copyAllProperties", true, true, true, false, false);
        this.addCopyPropertiesMethod("copyPrimaryKeyProperties", true, false, false, false, false);
        this.addCopyPropertiesMethod("copyVersionProperty", false, true, false, false, false);
        this.addCopyPropertiesMethod("copyUnequalProperties", false, true, true, true, false);
        this.addCopyPropertiesMethod("copyDirtyProperties", false, true, true, false, true);
        mi6 = this.addMethodIfNotFinal(Modifiers.PUBLIC, "hasDirtyProperties", TypeDesc.BOOLEAN, null);
        if (mi6 != null) {
            b6 = new CodeBuilder(mi6);
            Label isDirty = b6.createLabel();
            this.branchIfDirty(b6, false, isDirty);
            b6.loadConstant(false);
            b6.returnValue(TypeDesc.BOOLEAN);
            isDirty.setLocation();
            b6.loadConstant(true);
            b6.returnValue(TypeDesc.BOOLEAN);
        }
        this.addPropertyStateExtractMethod();
        this.addPropertyStateCheckMethod("isPropertyUninitialized", 0);
        this.addPropertyStateCheckMethod("isPropertyDirty", 3);
        this.addPropertyStateCheckMethod("isPropertyClean", 1);
        mi6 = this.addMethodIfNotFinal(Modifiers.PUBLIC, "isPropertySupported", TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.STRING});
        if (mi6 != null) {
            b6 = new CodeBuilder(mi6);
            b6.loadThis();
            b6.loadField(SUPPORT_FIELD_NAME, this.mSupportType);
            b6.loadLocal(b6.getParameter(0));
            b6.invokeInterface(this.mSupportType, "isPropertySupported", TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.STRING});
            b6.returnValue(TypeDesc.BOOLEAN);
        }
        this.addGetPropertyValueMethod();
        this.addSetPropertyValueMethod();
        this.addPropertyMapMethod();
        this.addWriteToMethod();
        this.addReadFromMethod();
        this.addHashCodeMethod();
        this.addEqualsMethod(2);
        this.addEqualsMethod(0);
        this.addEqualsMethod(1);
        this.addToStringMethod(false);
        this.addToStringMethod(true);
        this.addMarkCleanMethod("markPropertiesClean");
        this.addMarkCleanMethod("markAllPropertiesClean");
        this.addMarkDirtyMethod("markPropertiesDirty");
        this.addMarkDirtyMethod("markAllPropertiesDirty");
        mi6 = this.mClassFile.addMethod(Modifiers.PROTECTED, LOAD_COMPLETED_METHOD_NAME, null, null);
        mi6.addException(TypeDesc.forClass(FetchException.class));
        b6 = new CodeBuilder(mi6);
        b6.loadThis();
        b6.invokeVirtual("markAllPropertiesClean", null, null);
        b6.loadThis();
        b6.loadField(SUPPORT_FIELD_NAME, this.mSupportType);
        b6.invoke(StorableGenerator.lookupMethod(this.mSupportType.toClass(), "getLoadTrigger", new Class[0]));
        LocalVariable triggerVar2 = b6.createLocalVariable(null, TypeDesc.forClass(Trigger.class));
        b6.storeLocal(triggerVar2);
        b6.loadLocal(triggerVar2);
        Label noTrigger = b6.createLabel();
        b6.ifNullBranch((Location)noTrigger, true);
        b6.loadLocal(triggerVar2);
        b6.loadThis();
        b6.invoke(StorableGenerator.lookupMethod(triggerVar2.getType().toClass(), "afterLoad", Object.class));
        b6.loadThis();
        b6.invokeVirtual("markAllPropertiesClean", null, null);
        noTrigger.setLocation();
        b6.returnVoid();
        this.addIsInitializedMethod(IS_PK_INITIALIZED_METHOD_NAME, this.mInfo.getPrimaryKeyProperties());
        LinkedHashMap<String, StorableProperty<S>> partitionProperties = new LinkedHashMap<String, StorableProperty<S>>();
        for (StorableProperty<S> property : this.mAllProperties.values()) {
            if (property.isDerived() || !property.isPartitionKeyMember()) continue;
            partitionProperties.put(property.getName(), property);
        }
        this.addIsInitializedMethod(IS_PARTITION_KEY_INITIALIZED_METHOD_NAME, partitionProperties);
        block19: for (int i = 0; i < this.mInfo.getAlternateKeyCount(); ++i) {
            LinkedHashMap<String, StorableProperty<S>> altProps = new LinkedHashMap<String, StorableProperty<S>>();
            StorableKey<S> altKey = this.mInfo.getAlternateKey(i);
            for (OrderedProperty<S> op : altKey.getProperties()) {
                ChainedProperty<S> cp = op.getChainedProperty();
                if (cp.getChainCount() > 0) continue block19;
                StorableProperty<S> property = cp.getPrimeProperty();
                altProps.put(property.getName(), property);
            }
            this.addIsInitializedMethod(IS_ALT_KEY_INITIALIZED_PREFIX + i, altProps);
        }
        LinkedHashMap<String, StorableProperty<S>> requiredProperties = new LinkedHashMap<String, StorableProperty<S>>();
        for (StorableProperty<S> property : this.mAllProperties.values()) {
            if (property.isDerived() || property.isPrimaryKeyMember() || property.isJoin() || property.isNullable()) continue;
            requiredProperties.put(property.getName(), property);
        }
        this.addIsInitializedMethod(IS_REQUIRED_DATA_INITIALIZED_METHOD_NAME, requiredProperties);
        if (versionOrdinal >= 0) {
            mi = this.mClassFile.addMethod(Modifiers.PROTECTED, IS_VERSION_INITIALIZED_METHOD_NAME, TypeDesc.BOOLEAN, null);
            b6 = new CodeBuilder(mi);
            b6.loadThis();
            b6.loadField(PROPERTY_STATE_FIELD_NAME + (versionOrdinal >> 4), TypeDesc.INT);
            b6.loadConstant(3 << (versionOrdinal & 0xF) * 2);
            b6.math((byte)126);
            b6.returnValue(TypeDesc.BOOLEAN);
        }
    }

    private static Method lookupMethod(Class type, String name, Class ... args) {
        try {
            return type.getMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            NoSuchMethodError error = new NoSuchMethodError();
            error.initCause(e);
            throw error;
        }
    }

    private void addPropertyBridges(StorableProperty<S> property) {
        Class<?>[] covariantTypes = property.getCovariantTypes();
        if (covariantTypes == null || covariantTypes.length == 0) {
            return;
        }
        for (Class<?> type : covariantTypes) {
            CodeBuilder b;
            MethodInfo mi;
            TypeDesc desc = TypeDesc.forClass(type);
            if (property.getReadMethod() != null && property.getReadMethod().getReturnType() != type && (mi = this.addMethodIfNotFinal(Modifiers.PUBLIC.toBridge(true), property.getReadMethodName(), desc, null)) != null) {
                b = new CodeBuilder(mi);
                b.loadThis();
                b.invoke(property.getReadMethod());
                b.returnValue(desc);
            }
            if (property.getWriteMethod() == null || property.getWriteMethod().getParameterTypes()[0] == type || (mi = this.addMethodIfNotFinal(Modifiers.PUBLIC, property.getWriteMethodName(), null, new TypeDesc[]{desc})) == null) continue;
            b = new CodeBuilder(mi);
            b.loadThis();
            b.loadLocal(b.getParameter(0));
            b.checkCast(TypeDesc.forClass(property.getType()));
            b.invoke(property.getWriteMethod());
            b.returnVoid();
        }
    }

    private void addCopyPropertiesMethod(String methodName, boolean pkProperties, boolean versionProperty, boolean dataProperties, boolean unequalOnly, boolean dirtyOnly) {
        TypeDesc[] param = new TypeDesc[]{TypeDesc.forClass(Storable.class)};
        TypeDesc storableTypeDesc = TypeDesc.forClass(this.mStorableType);
        MethodInfo mi = this.addMethodIfNotFinal(Modifiers.PUBLIC.toSynchronized(true), methodName, null, param);
        if (mi == null) {
            return;
        }
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable target = CodeBuilderUtil.uneraseGenericParameter(b, storableTypeDesc, 0);
        LocalVariable stateBits = null;
        int mask = 3;
        for (StorableProperty<S> property : this.mAllProperties.values()) {
            boolean shouldCopy;
            boolean bl = shouldCopy = (!property.isDerived() || property.shouldCopyDerived()) && !property.isJoin() && (property.isPrimaryKeyMember() && pkProperties || property.isVersion() && versionProperty || !property.isPrimaryKeyMember() && dataProperties);
            if (shouldCopy) {
                int ordinal = property.getNumber();
                if (stateBits == null && !property.isDerived()) {
                    stateBits = b.createLocalVariable(null, TypeDesc.INT);
                    String stateFieldName = PROPERTY_STATE_FIELD_NAME + (ordinal >> 4);
                    b.loadThis();
                    b.loadField(stateFieldName, TypeDesc.INT);
                    b.storeLocal(stateBits);
                }
                Label skipCopy = b.createLabel();
                if (property.isIndependent()) {
                    this.addSkipIndependent(b, target, property, skipCopy);
                }
                if (stateBits != null && !property.isDerived()) {
                    b.loadLocal(stateBits);
                    b.loadConstant(mask);
                    b.math((byte)126);
                    b.ifZeroComparisonBranch((Location)skipCopy, "==");
                    if (dirtyOnly) {
                        b.loadLocal(stateBits);
                        b.loadConstant(mask);
                        b.math((byte)126);
                        b.loadConstant(3 << (ordinal & 0xF) * 2);
                        b.ifComparisonBranch((Location)skipCopy, "!=");
                    }
                }
                TypeDesc type = TypeDesc.forClass(property.getType());
                if (unequalOnly) {
                    this.loadThisProperty(b, property, type);
                    b.loadLocal(target);
                    b.invoke(property.getReadMethod());
                    CodeBuilderUtil.addValuesEqualCall(b, TypeDesc.forClass(property.getType()), true, skipCopy, true);
                }
                b.loadLocal(target);
                this.loadThisProperty(b, property, type);
                if (property.getWriteMethod() != null) {
                    b.invoke(property.getWriteMethod());
                } else {
                    b.storeField(property.getName(), type);
                }
                skipCopy.setLocation();
            }
            if ((mask <<= 2) != 0) continue;
            mask = 3;
            stateBits = null;
        }
        b.returnVoid();
    }

    private void addSkipIndependent(CodeBuilder b, LocalVariable target, StorableProperty property, Label skipCopy) {
        TypeDesc storableTypeDesc = TypeDesc.forClass(Storable.class);
        if (target != null) {
            b.loadLocal(target);
            b.loadConstant(property.getName());
            b.invokeInterface(storableTypeDesc, "isPropertySupported", TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.STRING});
            b.ifZeroComparisonBranch((Location)skipCopy, "==");
        }
        b.loadThis();
        b.loadConstant(property.getName());
        b.invokeInterface(storableTypeDesc, "isPropertySupported", TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.STRING});
        b.ifZeroComparisonBranch((Location)skipCopy, "==");
    }

    private void loadThisProperty(CodeBuilder b, StorableProperty property) {
        this.loadThisProperty(b, property, TypeDesc.forClass(property.getType()));
    }

    private void loadThisProperty(CodeBuilder b, StorableProperty property, TypeDesc type) {
        b.loadThis();
        if (property.isDerived()) {
            b.invoke(property.getReadMethod());
        } else {
            b.loadField(property.getName(), type);
        }
    }

    private void loadPropertyAnnotation(CodeBuilder b, StorableProperty property, StorablePropertyAnnotation annotation) {
        String methodName = annotation.getAnnotatedMethod().getName();
        boolean isAccessor = !methodName.startsWith("set");
        b.loadConstant(TypeDesc.forClass(property.getEnclosingType()));
        b.loadConstant(methodName);
        if (isAccessor) {
            b.loadNull();
        } else {
            b.loadConstant(1);
            b.newObject(TypeDesc.forClass(Class[].class));
            b.dup();
            b.loadConstant(0);
            b.loadConstant(TypeDesc.forClass(property.getType()));
            b.storeToArray(TypeDesc.forClass(Class[].class));
        }
        b.invokeVirtual(Class.class.getName(), "getMethod", TypeDesc.forClass(Method.class), new TypeDesc[]{TypeDesc.STRING, TypeDesc.forClass(Class[].class)});
        b.loadConstant(TypeDesc.forClass(annotation.getAnnotationType()));
        b.invokeVirtual(Method.class.getName(), "getAnnotation", TypeDesc.forClass(Annotation.class), new TypeDesc[]{TypeDesc.forClass(Class.class)});
        b.checkCast(TypeDesc.forClass(annotation.getAnnotationType()));
    }

    private void loadStorageForFetch(CodeBuilder b, TypeDesc type) {
        b.loadThis();
        b.loadField(SUPPORT_FIELD_NAME, this.mSupportType);
        TypeDesc storageType = TypeDesc.forClass(Storage.class);
        TypeDesc repositoryType = TypeDesc.forClass(Repository.class);
        b.invokeInterface(this.mSupportType, "getRootRepository", repositoryType, null);
        b.loadConstant(type);
        Label tryStart = b.createLabel().setLocation();
        b.invokeInterface(repositoryType, "storageFor", storageType, new TypeDesc[]{TypeDesc.forClass(Class.class)});
        Label tryEnd = b.createLabel().setLocation();
        Label noException = b.createLabel();
        b.branch((Location)noException);
        b.exceptionHandler((Location)tryStart, (Location)tryEnd, RepositoryException.class.getName());
        b.invokeVirtual(RepositoryException.class.getName(), "toFetchException", TypeDesc.forClass(FetchException.class), null);
        b.throwObject();
        noException.setLocation();
    }

    private void addMarkCleanMethod(String name) {
        MethodInfo mi = this.addMethodIfNotFinal(Modifiers.PUBLIC.toSynchronized(true), name, null, null);
        if (mi == null) {
            return;
        }
        CodeBuilder b = new CodeBuilder(mi);
        int count = this.mAllProperties.size();
        int ordinal = 0;
        int andMask = 0;
        int orMask = 0;
        boolean anyNonDerived = false;
        for (StorableProperty<S> property : this.mAllProperties.values()) {
            if (!property.isDerived()) {
                anyNonDerived = true;
                if (property.isQuery()) {
                    andMask |= 3 << (ordinal & 0xF) * 2;
                } else if (!property.isJoin()) {
                    if (name == "markAllPropertiesClean") {
                        orMask |= 1 << (ordinal & 0xF) * 2;
                    } else if (name == "markPropertiesClean") {
                        andMask |= 1 << (ordinal & 0xF) * 2;
                    }
                }
            }
            if ((++ordinal & 0xF) != 0 && ordinal < count) continue;
            if (anyNonDerived) {
                String stateFieldName = PROPERTY_STATE_FIELD_NAME + (ordinal - 1 >> 4);
                b.loadThis();
                if (andMask == 0) {
                    b.loadConstant(orMask);
                } else {
                    b.loadThis();
                    b.loadField(stateFieldName, TypeDesc.INT);
                    b.loadConstant(andMask);
                    b.math((byte)126);
                    if (orMask != 0) {
                        b.loadConstant(orMask);
                        b.math((byte)-128);
                    }
                }
                b.storeField(stateFieldName, TypeDesc.INT);
            }
            andMask = 0;
            orMask = 0;
            anyNonDerived = false;
        }
        b.returnVoid();
    }

    private void addMarkDirtyMethod(String name) {
        MethodInfo mi = this.addMethodIfNotFinal(Modifiers.PUBLIC.toSynchronized(true), name, null, null);
        if (mi == null) {
            return;
        }
        CodeBuilder b = new CodeBuilder(mi);
        int count = this.mAllProperties.size();
        int ordinal = 0;
        int andMask = 0;
        int orMask = 0;
        boolean anyNonDerived = false;
        for (StorableProperty<S> property : this.mAllProperties.values()) {
            if (!property.isDerived()) {
                anyNonDerived = true;
                if (property.isJoin()) {
                    if (!property.isQuery()) {
                        andMask |= 3 << (ordinal & 0xF) * 2;
                    }
                } else if (name == "markAllPropertiesDirty") {
                    orMask |= 3 << (ordinal & 0xF) * 2;
                }
            }
            if ((++ordinal & 0xF) != 0 && ordinal < count) continue;
            if (anyNonDerived) {
                String stateFieldName = PROPERTY_STATE_FIELD_NAME + (ordinal - 1 >> 4);
                if (name == "markAllPropertiesDirty") {
                    if (orMask != 0 || andMask != 0) {
                        b.loadThis();
                        b.loadThis();
                        b.loadField(stateFieldName, TypeDesc.INT);
                        if (andMask != 0) {
                            b.loadConstant(~andMask);
                            b.math((byte)126);
                        }
                        if (orMask != 0) {
                            b.loadConstant(orMask);
                            b.math((byte)-128);
                        }
                        b.storeField(stateFieldName, TypeDesc.INT);
                    }
                } else {
                    b.loadThis();
                    b.loadThis();
                    b.loadField(stateFieldName, TypeDesc.INT);
                    if (andMask != 0) {
                        b.loadConstant(~andMask);
                        b.math((byte)126);
                    }
                    b.dup();
                    b.loadConstant(0x55555555);
                    b.math((byte)126);
                    b.loadConstant(1);
                    b.math((byte)120);
                    b.math((byte)-128);
                    b.storeField(stateFieldName, TypeDesc.INT);
                }
            }
            andMask = 0;
            orMask = 0;
            anyNonDerived = false;
        }
        b.returnVoid();
    }

    private void markOrdinaryPropertyDirty(CodeBuilder b, StorableProperty ordinaryProperty) {
        int count = this.mAllProperties.size();
        int ordinal = 0;
        int andMask = -1;
        int orMask = 0;
        boolean anyNonDerived = false;
        for (StorableProperty<S> property : this.mAllProperties.values()) {
            if (!property.isDerived()) {
                anyNonDerived = true;
                if (property == ordinaryProperty) {
                    orMask |= 3 << (ordinal & 0xF) * 2;
                } else if (property.isJoin()) {
                    int i = property.getJoinElementCount();
                    while (--i >= 0) {
                        if (ordinaryProperty != property.getInternalJoinElement(i)) continue;
                        andMask &= ~(3 << (ordinal & 0xF) * 2);
                    }
                }
            }
            if ((++ordinal & 0xF) != 0 && ordinal < count) continue;
            if (anyNonDerived && (andMask != -1 || orMask != 0)) {
                String stateFieldName = PROPERTY_STATE_FIELD_NAME + (ordinal - 1 >> 4);
                b.loadThis();
                b.loadThis();
                b.loadField(stateFieldName, TypeDesc.INT);
                if (andMask != -1) {
                    b.loadConstant(andMask);
                    b.math((byte)126);
                }
                if (orMask != 0) {
                    b.loadConstant(orMask);
                    b.math((byte)-128);
                }
                b.storeField(stateFieldName, TypeDesc.INT);
            }
            andMask = -1;
            orMask = 0;
            anyNonDerived = false;
        }
    }

    private void branchIfDirty(CodeBuilder b, boolean includePk, Label label) {
        int count = this.mAllProperties.size();
        int ordinal = 0;
        int andMask = 0;
        boolean anyNonDerived = false;
        for (StorableProperty<S> property : this.mAllProperties.values()) {
            if (!property.isDerived()) {
                anyNonDerived = true;
                if (!(property.isJoin() || property.isPrimaryKeyMember() && !includePk)) {
                    andMask |= 2 << (ordinal & 0xF) * 2;
                }
            }
            if ((++ordinal & 0xF) != 0 && ordinal < count) continue;
            if (anyNonDerived) {
                String stateFieldName = PROPERTY_STATE_FIELD_NAME + (ordinal - 1 >> 4);
                b.loadThis();
                b.loadField(stateFieldName, TypeDesc.INT);
                b.loadConstant(andMask);
                b.math((byte)126);
                b.ifZeroComparisonBranch((Location)label, "!=");
            }
            andMask = 0;
            anyNonDerived = false;
        }
    }

    private void addIsInitializedMethod(String name, Map<String, ? extends StorableProperty<S>> properties) {
        boolean cloned = false;
        for (StorableProperty<S> prop : properties.values()) {
            if (!prop.isAutomatic() && !prop.isIndependent() && !prop.isVersion()) continue;
            if (!cloned) {
                properties = new LinkedHashMap<String, StorableProperty<S>>(properties);
                cloned = true;
            }
            properties.remove(prop.getName());
        }
        MethodInfo mi = this.mClassFile.addMethod(Modifiers.PROTECTED, name, TypeDesc.BOOLEAN, null);
        CodeBuilder b = new CodeBuilder(mi);
        if (properties.size() == 0) {
            b.loadConstant(true);
            b.returnValue(TypeDesc.BOOLEAN);
            return;
        }
        if (properties.size() == 1) {
            int ordinal = properties.values().iterator().next().getNumber();
            b.loadThis();
            b.loadField(PROPERTY_STATE_FIELD_NAME + (ordinal >> 4), TypeDesc.INT);
            b.loadConstant(3 << (ordinal & 0xF) * 2);
            b.math((byte)126);
            b.returnValue(TypeDesc.BOOLEAN);
            return;
        }
        int ordinal = 0;
        int mask = 0;
        boolean anyNonDerived = false;
        for (StorableProperty<S> property : this.mAllProperties.values()) {
            if (!property.isDerived()) {
                anyNonDerived = true;
                if (properties.containsKey(property.getName())) {
                    mask |= 3 << (ordinal & 0xF) * 2;
                }
            }
            if ((++ordinal & 0xF) != 0 && ordinal < this.mAllProperties.size()) continue;
            if (anyNonDerived && mask != 0) {
                b.loadThis();
                b.loadField(PROPERTY_STATE_FIELD_NAME + (ordinal - 1 >> 4), TypeDesc.INT);
                b.dup();
                b.loadConstant(0x55555555);
                b.math((byte)126);
                b.loadConstant(1);
                b.math((byte)120);
                b.math((byte)-128);
                b.loadConstant(mask);
                b.math((byte)-126);
                if (mask != -1) {
                    b.loadConstant(mask);
                    b.math((byte)126);
                }
                Label cont = b.createLabel();
                b.ifZeroComparisonBranch((Location)cont, "==");
                b.loadConstant(false);
                b.returnValue(TypeDesc.BOOLEAN);
                cont.setLocation();
            }
            mask = 0;
            anyNonDerived = false;
        }
        b.loadConstant(true);
        b.returnValue(TypeDesc.BOOLEAN);
    }

    private void requirePkInitialized(CodeBuilder b, String methodName) {
        b.loadThis();
        b.invokeVirtual(methodName, null, null);
        b = new CodeBuilder(this.mClassFile.addMethod(Modifiers.PROTECTED, methodName, null, null));
        b.loadThis();
        b.invokeVirtual(IS_PK_INITIALIZED_METHOD_NAME, TypeDesc.BOOLEAN, null);
        Label pkInitialized = b.createLabel();
        b.ifZeroComparisonBranch((Location)pkInitialized, "!=");
        CodeBuilderUtil.throwException(b, IllegalStateException.class, "Primary key not fully specified");
        pkInitialized.setLocation();
        b.returnVoid();
    }

    private void addPropertyStateExtractMethod() {
        MethodInfo mi = this.mClassFile.addMethod(Modifiers.PRIVATE, PROPERTY_STATE_EXTRACT_METHOD_NAME, TypeDesc.INT, new TypeDesc[]{TypeDesc.STRING});
        this.addPropertySwitch(new CodeBuilder(mi), 1);
    }

    private void addPropertySwitch(CodeBuilder b, int switchFor) {
        BigInteger capacity = BigInteger.valueOf(this.mAllProperties.size() * 2 + 1);
        while (!capacity.isProbablePrime(100)) {
            capacity = capacity.add(BigInteger.valueOf(2L));
        }
        int caseCount = capacity.intValue();
        int[] cases = new int[caseCount];
        for (int i = 0; i < caseCount; ++i) {
            cases[i] = i;
        }
        Label[] switchLabels = new Label[caseCount];
        Label noMatch = b.createLabel();
        List<StorableProperty<?>>[] caseMatches = this.caseMatches(caseCount);
        for (int i = 0; i < caseCount; ++i) {
            List<StorableProperty<?>> matches = caseMatches[i];
            switchLabels[i] = matches == null || matches.size() == 0 ? noMatch : b.createLabel();
        }
        b.loadLocal(b.getParameter(0));
        b.invokeVirtual(String.class.getName(), "hashCode", TypeDesc.INT, null);
        b.loadConstant(Integer.MAX_VALUE);
        b.math((byte)126);
        b.loadConstant(caseCount);
        b.math((byte)112);
        b.switchBranch(cases, (Location[])switchLabels, (Location)noMatch);
        TypeDesc[] params = new TypeDesc[]{TypeDesc.OBJECT};
        Label derivedMatch = null;
        Label joinMatch = null;
        Label unreadable = null;
        Label unwritable = null;
        Label readException = null;
        Label writeException = null;
        for (int i = 0; i < caseCount; ++i) {
            List<StorableProperty<?>> matches = caseMatches[i];
            if (matches == null || matches.size() == 0) continue;
            switchLabels[i].setLocation();
            int matchCount = matches.size();
            for (int j = 0; j < matchCount; ++j) {
                Label notEqual;
                StorableProperty<?> prop = matches.get(j);
                b.loadConstant(prop.getName());
                b.loadLocal(b.getParameter(0));
                b.invokeVirtual(String.class.getName(), "equals", TypeDesc.BOOLEAN, params);
                if (j == matchCount - 1) {
                    notEqual = null;
                    b.ifZeroComparisonBranch((Location)noMatch, "==");
                } else {
                    notEqual = b.createLabel();
                    b.ifZeroComparisonBranch((Location)notEqual, "==");
                }
                if (switchFor == 1) {
                    if (prop.isDerived()) {
                        if (derivedMatch == null) {
                            derivedMatch = b.createLabel();
                        }
                        b.branch((Location)derivedMatch);
                    } else if (prop.isJoin()) {
                        if (joinMatch == null) {
                            joinMatch = b.createLabel();
                        }
                        b.branch((Location)joinMatch);
                    } else {
                        int ordinal = prop.getNumber();
                        b.loadThis();
                        b.loadField(PROPERTY_STATE_FIELD_NAME + (ordinal >> 4), TypeDesc.INT);
                        int shift = (ordinal & 0xF) * 2;
                        if (shift != 0) {
                            b.loadConstant(shift);
                            b.math((byte)122);
                        }
                        b.loadConstant(3);
                        b.math((byte)126);
                        b.returnValue(TypeDesc.INT);
                    }
                } else if (switchFor == 2) {
                    if (prop.getReadMethod() == null) {
                        if (unreadable == null) {
                            unreadable = b.createLabel();
                        }
                        b.branch((Location)unreadable);
                    } else if (StorableGenerator.throwsCheckedException(prop.getReadMethod())) {
                        if (readException == null) {
                            readException = b.createLabel();
                        }
                        b.branch((Location)readException);
                    } else {
                        b.loadThis();
                        b.invoke(prop.getReadMethod());
                        TypeDesc type = TypeDesc.forClass(prop.getType());
                        b.convert(type, type.toObjectType());
                        b.returnValue(TypeDesc.OBJECT);
                    }
                } else if (switchFor == 3) {
                    if (prop.getWriteMethod() == null) {
                        if (unwritable == null) {
                            unwritable = b.createLabel();
                        }
                        b.branch((Location)unwritable);
                    } else if (StorableGenerator.throwsCheckedException(prop.getWriteMethod())) {
                        if (writeException == null) {
                            writeException = b.createLabel();
                        }
                        b.branch((Location)writeException);
                    } else {
                        b.loadThis();
                        b.loadLocal(b.getParameter(1));
                        TypeDesc type = TypeDesc.forClass(prop.getType());
                        b.checkCast(type.toObjectType());
                        b.convert(type.toObjectType(), type);
                        b.invoke(prop.getWriteMethod());
                        b.returnVoid();
                    }
                }
                if (notEqual == null) continue;
                notEqual.setLocation();
            }
        }
        noMatch.setLocation();
        StorableGenerator.throwIllegalArgException(b, "Unknown property: ", b.getParameter(0));
        if (derivedMatch != null) {
            derivedMatch.setLocation();
            StorableGenerator.throwIllegalArgException(b, "Cannot get state for derived property: ", b.getParameter(0));
        }
        if (joinMatch != null) {
            joinMatch.setLocation();
            StorableGenerator.throwIllegalArgException(b, "Cannot get state for join property: ", b.getParameter(0));
        }
        if (unreadable != null) {
            unreadable.setLocation();
            StorableGenerator.throwIllegalArgException(b, "No accessor method for property: ", b.getParameter(0));
        }
        if (unwritable != null) {
            unwritable.setLocation();
            StorableGenerator.throwIllegalArgException(b, "No mutator method for property: ", b.getParameter(0));
        }
        if (readException != null) {
            readException.setLocation();
            StorableGenerator.throwIllegalArgException(b, "Accessor method declares throwing a checked exception: ", b.getParameter(0));
        }
        if (writeException != null) {
            writeException.setLocation();
            StorableGenerator.throwIllegalArgException(b, "Mutator method declares throwing a checked exception: ", b.getParameter(0));
        }
    }

    private static boolean throwsCheckedException(Method method) {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes == null) {
            return false;
        }
        for (Class<?> exceptionType : exceptionTypes) {
            if (RuntimeException.class.isAssignableFrom(exceptionType) || Error.class.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static void throwIllegalArgException(CodeBuilder b, String message, LocalVariable concatStr) {
        TypeDesc exceptionType = TypeDesc.forClass(IllegalArgumentException.class);
        TypeDesc[] params = new TypeDesc[]{TypeDesc.STRING};
        b.newObject(exceptionType);
        b.dup();
        b.loadConstant(message);
        b.loadLocal(concatStr);
        b.invokeVirtual(TypeDesc.STRING, "concat", TypeDesc.STRING, params);
        b.invokeConstructor(exceptionType, params);
        b.throwObject();
    }

    private List<StorableProperty<?>>[] caseMatches(int caseCount) {
        List[] cases = new List[caseCount];
        for (StorableProperty<S> prop : this.mAllProperties.values()) {
            int hashCode = prop.getName().hashCode();
            int caseValue = (hashCode & Integer.MAX_VALUE) % caseCount;
            ArrayList<StorableProperty<S>> matches = cases[caseValue];
            if (matches == null) {
                matches = cases[caseValue] = new ArrayList<StorableProperty<S>>();
            }
            matches.add(prop);
        }
        return cases;
    }

    private void addPropertyStateCheckMethod(String name, int state) {
        MethodInfo mi = this.addMethodIfNotFinal(Modifiers.PUBLIC, name, TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.STRING});
        if (mi == null) {
            return;
        }
        CodeBuilder b = new CodeBuilder(mi);
        b.loadThis();
        b.loadLocal(b.getParameter(0));
        b.invokePrivate(PROPERTY_STATE_EXTRACT_METHOD_NAME, TypeDesc.INT, new TypeDesc[]{TypeDesc.STRING});
        Label isFalse = b.createLabel();
        if (state == 0) {
            b.ifZeroComparisonBranch((Location)isFalse, "!=");
        } else {
            b.loadConstant(state);
            b.ifComparisonBranch((Location)isFalse, "!=");
        }
        b.loadConstant(true);
        b.returnValue(TypeDesc.BOOLEAN);
        isFalse.setLocation();
        b.loadConstant(false);
        b.returnValue(TypeDesc.BOOLEAN);
    }

    private void addGetPropertyValueMethod() {
        MethodInfo mi = this.addMethodIfNotFinal(Modifiers.PUBLIC, "getPropertyValue", TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.STRING});
        if (mi == null) {
            return;
        }
        CodeBuilder b = new CodeBuilder(mi);
        this.addPropertySwitch(b, 2);
    }

    private void addSetPropertyValueMethod() {
        MethodInfo mi = this.addMethodIfNotFinal(Modifiers.PUBLIC, "setPropertyValue", null, new TypeDesc[]{TypeDesc.STRING, TypeDesc.OBJECT});
        if (mi == null) {
            return;
        }
        CodeBuilder b = new CodeBuilder(mi);
        this.addPropertySwitch(b, 3);
    }

    private void addPropertyMapMethod() {
        TypeDesc mapType = TypeDesc.forClass(Map.class);
        MethodInfo mi = this.addMethodIfNotFinal(Modifiers.PUBLIC, "propertyMap", mapType, null);
        if (mi == null) {
            return;
        }
        CodeBuilder b = new CodeBuilder(mi);
        TypeDesc propertyMapType = TypeDesc.forClass(StorablePropertyMap.class);
        b.loadConstant(TypeDesc.forClass(this.mStorableType));
        b.loadThis();
        b.invokeStatic(propertyMapType, "createMap", propertyMapType, new TypeDesc[]{TypeDesc.forClass(Class.class), TypeDesc.forClass(Storable.class)});
        b.returnValue(mapType);
    }

    private void addWriteToMethod() {
        LocalVariable encodedVar;
        TypeDesc streamType = TypeDesc.forClass(OutputStream.class);
        MethodInfo mi = this.addMethodIfNotFinal(Modifiers.PUBLIC.toSynchronized(true), "writeTo", null, new TypeDesc[]{streamType});
        if (mi == null) {
            return;
        }
        GenericEncodingStrategy encoder = new GenericEncodingStrategy(this.mStorableType, null);
        CodeBuilder b = new CodeBuilder(mi);
        try {
            encodedVar = encoder.buildSerialEncoding((CodeAssembler)b, null);
        }
        catch (SupportException e) {
            b = new CodeBuilder(mi);
            CodeBuilderUtil.throwException(b, SupportException.class, e.getMessage());
            return;
        }
        b.loadLocal(encodedVar);
        b.arrayLength();
        b.loadLocal(b.getParameter(0));
        b.invokeStatic(TypeDesc.forClass(DataEncoder.class), "writeLength", TypeDesc.INT, new TypeDesc[]{TypeDesc.INT, streamType});
        b.pop();
        b.loadLocal(b.getParameter(0));
        b.loadLocal(encodedVar);
        b.invokeVirtual(streamType, "write", null, new TypeDesc[]{encodedVar.getType()});
        b.returnVoid();
    }

    private void addReadFromMethod() {
        TypeDesc streamType = TypeDesc.forClass(InputStream.class);
        MethodInfo mi = this.addMethodIfNotFinal(Modifiers.PUBLIC.toSynchronized(true), "readFrom", null, new TypeDesc[]{streamType});
        if (mi == null) {
            return;
        }
        CodeBuilder b = new CodeBuilder(mi);
        TypeDesc dataDecoderType = TypeDesc.forClass(DataDecoder.class);
        b.loadLocal(b.getParameter(0));
        b.invokeStatic(dataDecoderType, "readLength", TypeDesc.INT, new TypeDesc[]{streamType});
        LocalVariable encodedVar = b.createLocalVariable(null, TypeDesc.forClass(byte[].class));
        b.newObject(encodedVar.getType());
        b.storeLocal(encodedVar);
        b.loadLocal(b.getParameter(0));
        b.loadLocal(encodedVar);
        b.invokeStatic(dataDecoderType, "readFully", null, new TypeDesc[]{streamType, encodedVar.getType()});
        GenericEncodingStrategy encoder = new GenericEncodingStrategy(this.mStorableType, null);
        try {
            encoder.buildSerialDecoding((CodeAssembler)b, null, encodedVar);
        }
        catch (SupportException e) {
            b = new CodeBuilder(mi);
            CodeBuilderUtil.throwException(b, SupportException.class, e.getMessage());
            return;
        }
        b.returnVoid();
    }

    private void addHashCodeMethod() {
        Modifiers modifiers = Modifiers.PUBLIC.toSynchronized(true);
        MethodInfo mi = this.addMethodIfNotFinal(modifiers, "hashCode", TypeDesc.INT, null);
        if (mi == null) {
            return;
        }
        CodeBuilder b = new CodeBuilder(mi);
        boolean mixIn = false;
        for (StorableProperty<S> property : this.mAllProperties.values()) {
            if (property.isDerived() || property.isJoin()) continue;
            TypeDesc fieldType = TypeDesc.forClass(property.getType());
            b.loadThis();
            b.loadField(property.getName(), fieldType);
            CodeBuilderUtil.addValueHashCodeCall(b, fieldType, true, mixIn);
            mixIn = true;
        }
        b.returnValue(TypeDesc.INT);
    }

    private void addEqualsMethod(int equalityType) {
        String equalsMethodName;
        TypeDesc[] objectParam = new TypeDesc[]{TypeDesc.OBJECT};
        switch (equalityType) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: {
                equalsMethodName = "equalPrimaryKeys";
                break;
            }
            case 1: {
                equalsMethodName = "equalProperties";
                break;
            }
            case 2: {
                equalsMethodName = "equals";
            }
        }
        Modifiers modifiers = Modifiers.PUBLIC.toSynchronized(true);
        MethodInfo mi = this.addMethodIfNotFinal(modifiers, equalsMethodName, TypeDesc.BOOLEAN, objectParam);
        if (mi == null) {
            return;
        }
        CodeBuilder b = new CodeBuilder(mi);
        b.loadThis();
        b.loadLocal(b.getParameter(0));
        Label notEqual = b.createLabel();
        b.ifEqualBranch((Location)notEqual, false);
        b.loadConstant(true);
        b.returnValue(TypeDesc.BOOLEAN);
        notEqual.setLocation();
        TypeDesc userStorableTypeDesc = TypeDesc.forClass(this.mStorableType);
        b.loadLocal(b.getParameter(0));
        b.instanceOf(userStorableTypeDesc);
        Label fail = b.createLabel();
        b.ifZeroComparisonBranch((Location)fail, "==");
        LocalVariable other = b.createLocalVariable(null, userStorableTypeDesc);
        b.loadLocal(b.getParameter(0));
        b.checkCast(userStorableTypeDesc);
        b.storeLocal(other);
        for (StorableProperty<S> property : this.mAllProperties.values()) {
            if (property.isDerived() || property.isJoin() || equalityType == 0 && !property.isPrimaryKeyMember()) continue;
            Label skipCheck = b.createLabel();
            if (equalityType != 0 && property.isIndependent()) {
                this.addSkipIndependent(b, other, property, skipCheck);
            }
            TypeDesc fieldType = TypeDesc.forClass(property.getType());
            this.loadThisProperty(b, property);
            b.loadLocal(other);
            b.invoke(property.getReadMethod());
            CodeBuilderUtil.addValuesEqualCall(b, fieldType, true, fail, false);
            skipCheck.setLocation();
        }
        b.loadConstant(true);
        b.returnValue(TypeDesc.BOOLEAN);
        fail.setLocation();
        b.loadConstant(false);
        b.returnValue(TypeDesc.BOOLEAN);
    }

    private void addToStringMethod(boolean keyOnly) {
        TypeDesc stringBuilder = TypeDesc.forClass(StringBuilder.class);
        Modifiers modifiers = Modifiers.PUBLIC.toSynchronized(true);
        MethodInfo mi = this.addMethodIfNotFinal(modifiers, keyOnly ? "toStringKeyOnly" : "toString", TypeDesc.STRING, null);
        if (mi == null) {
            return;
        }
        CodeBuilder b = new CodeBuilder(mi);
        b.newObject(stringBuilder);
        b.dup();
        b.invokeConstructor(stringBuilder, null);
        b.loadConstant(this.mStorableType.getName());
        this.invokeAppend(b, TypeDesc.STRING);
        String detail = keyOnly ? " (key only) {" : " {";
        b.loadConstant(detail);
        this.invokeAppend(b, TypeDesc.STRING);
        LocalVariable commaCountVar = b.createLocalVariable(null, TypeDesc.INT);
        b.loadConstant(-1);
        b.storeLocal(commaCountVar);
        for (StorableProperty<S> property : this.mInfo.getPrimaryKeyProperties().values()) {
            this.addPropertyAppendCall(b, property, commaCountVar);
        }
        if (!keyOnly) {
            for (StorableProperty<S> property : this.mAllProperties.values()) {
                if (property.isPrimaryKeyMember() || property.isDerived() || property.isJoin()) continue;
                this.addPropertyAppendCall(b, property, commaCountVar);
            }
        }
        b.loadConstant(125);
        this.invokeAppend(b, TypeDesc.CHAR);
        if (keyOnly) {
            int altKeyCount = this.mInfo.getAlternateKeyCount();
            for (int i = 0; i < altKeyCount; ++i) {
                b.loadConstant(-1);
                b.storeLocal(commaCountVar);
                b.loadConstant(", {");
                this.invokeAppend(b, TypeDesc.STRING);
                StorableKey<S> key = this.mInfo.getAlternateKey(i);
                for (OrderedProperty<S> op : key.getProperties()) {
                    StorableProperty<S> property = op.getChainedProperty().getPrimeProperty();
                    this.addPropertyAppendCall(b, property, commaCountVar);
                }
                b.loadConstant(125);
                this.invokeAppend(b, TypeDesc.CHAR);
            }
        }
        b.invokeVirtual(stringBuilder, "toString", TypeDesc.STRING, null);
        b.returnValue(TypeDesc.STRING);
    }

    private void invokeAppend(CodeBuilder b, TypeDesc type) {
        TypeDesc stringBuilder = TypeDesc.forClass(StringBuilder.class);
        b.invokeVirtual(stringBuilder, "append", stringBuilder, new TypeDesc[]{type});
    }

    private void addPropertyAppendCall(CodeBuilder b, StorableProperty property, LocalVariable commaCountVar) {
        Label skipPrint = b.createLabel();
        if (property.isIndependent()) {
            this.addSkipIndependent(b, null, property, skipPrint);
        }
        int ordinal = property.getNumber();
        b.loadThis();
        b.loadField(PROPERTY_STATE_FIELD_NAME + (ordinal >> 4), TypeDesc.INT);
        b.loadConstant(3 << (ordinal & 0xF) * 2);
        b.math((byte)126);
        b.ifZeroComparisonBranch((Location)skipPrint, "==");
        b.integerIncrement(commaCountVar, 1);
        b.loadLocal(commaCountVar);
        Label noComma = b.createLabel();
        b.ifZeroComparisonBranch((Location)noComma, "==");
        b.loadConstant(", ");
        this.invokeAppend(b, TypeDesc.STRING);
        noComma.setLocation();
        this.addPropertyAppendCall(b, property);
        skipPrint.setLocation();
    }

    private void addPropertyAppendCall(CodeBuilder b, StorableProperty property) {
        b.loadConstant(property.getName());
        this.invokeAppend(b, TypeDesc.STRING);
        b.loadConstant(61);
        this.invokeAppend(b, TypeDesc.CHAR);
        this.loadThisProperty(b, property);
        TypeDesc type = TypeDesc.forClass(property.getType());
        if (type.isPrimitive()) {
            if (type == TypeDesc.BYTE || type == TypeDesc.SHORT) {
                type = TypeDesc.INT;
            }
        } else if (type != TypeDesc.STRING) {
            if (type.isArray()) {
                if (!type.getComponentType().isPrimitive()) {
                    b.invokeStatic("java.util.Arrays", "deepToString", TypeDesc.STRING, new TypeDesc[]{TypeDesc.OBJECT.toArrayType()});
                } else {
                    b.invokeStatic("java.util.Arrays", "toString", TypeDesc.STRING, new TypeDesc[]{type});
                }
            }
            type = TypeDesc.OBJECT;
        }
        this.invokeAppend(b, type);
    }

    private Label addGetTriggerAndEnterTxn(CodeBuilder b, String opType, LocalVariable forTryVar, boolean forTry, LocalVariable triggerVar, LocalVariable txnVar, LocalVariable stateVar) {
        b.loadThis();
        b.loadField(SUPPORT_FIELD_NAME, this.mSupportType);
        Method m = StorableGenerator.lookupMethod(this.mSupportType.toClass(), "get" + opType + "Trigger", new Class[0]);
        b.invoke(m);
        b.storeLocal(triggerVar);
        b.loadNull();
        b.storeLocal(stateVar);
        b.loadLocal(triggerVar);
        Label hasTrigger = b.createLabel();
        b.ifNullBranch((Location)hasTrigger, false);
        b.loadNull();
        b.storeLocal(txnVar);
        Label cont = b.createLabel();
        b.branch((Location)cont);
        hasTrigger.setLocation();
        TypeDesc repositoryType = TypeDesc.forClass(Repository.class);
        TypeDesc transactionType = TypeDesc.forClass(Transaction.class);
        b.loadThis();
        b.loadField(SUPPORT_FIELD_NAME, this.mSupportType);
        b.invokeInterface(this.mSupportType, "getRootRepository", repositoryType, null);
        b.invokeInterface(repositoryType, "enterTransaction", transactionType, null);
        b.storeLocal(txnVar);
        Label tryStart = b.createLabel().setLocation();
        b.loadLocal(triggerVar);
        b.loadThis();
        if (forTryVar == null) {
            if (forTry) {
                b.invokeVirtual(triggerVar.getType(), "beforeTry" + opType, TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.OBJECT});
            } else {
                b.invokeVirtual(triggerVar.getType(), "before" + opType, TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.OBJECT});
            }
            b.storeLocal(stateVar);
        } else {
            b.loadLocal(forTryVar);
            Label isForTry = b.createLabel();
            b.ifZeroComparisonBranch((Location)isForTry, "!=");
            b.invokeVirtual(triggerVar.getType(), "before" + opType, TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.OBJECT});
            b.storeLocal(stateVar);
            b.branch((Location)cont);
            isForTry.setLocation();
            b.invokeVirtual(triggerVar.getType(), "beforeTry" + opType, TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.OBJECT});
            b.storeLocal(stateVar);
        }
        cont.setLocation();
        return tryStart;
    }

    private void addTriggerAfterAndExitTxn(CodeBuilder b, String opType, LocalVariable forTryVar, boolean forTry, LocalVariable triggerVar, LocalVariable txnVar, LocalVariable stateVar) {
        b.loadLocal(triggerVar);
        Label cont = b.createLabel();
        b.ifNullBranch((Location)cont, true);
        b.loadLocal(triggerVar);
        b.loadThis();
        b.loadLocal(stateVar);
        if (forTryVar == null) {
            if (forTry) {
                b.invokeVirtual(TypeDesc.forClass(Trigger.class), "afterTry" + opType, null, new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.OBJECT});
            } else {
                b.invokeVirtual(TypeDesc.forClass(Trigger.class), "after" + opType, null, new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.OBJECT});
            }
        } else {
            b.loadLocal(forTryVar);
            Label isForTry = b.createLabel();
            b.ifZeroComparisonBranch((Location)isForTry, "!=");
            b.invokeVirtual(TypeDesc.forClass(Trigger.class), "after" + opType, null, new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.OBJECT});
            Label commitAndExit = b.createLabel();
            b.branch((Location)commitAndExit);
            isForTry.setLocation();
            b.invokeVirtual(TypeDesc.forClass(Trigger.class), "afterTry" + opType, null, new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.OBJECT});
            commitAndExit.setLocation();
        }
        TypeDesc transactionType = TypeDesc.forClass(Transaction.class);
        b.loadLocal(txnVar);
        b.invokeInterface(transactionType, "commit", null, null);
        b.loadLocal(txnVar);
        b.invokeInterface(transactionType, "exit", null, null);
        cont.setLocation();
    }

    private void addTriggerFailedAndExitTxn(CodeBuilder b, String opType, LocalVariable triggerVar, LocalVariable txnVar, LocalVariable stateVar) {
        TypeDesc transactionType = TypeDesc.forClass(Transaction.class);
        b.loadLocal(triggerVar);
        Label isNull = b.createLabel();
        b.ifNullBranch((Location)isNull, true);
        Label tryStart = b.createLabel().setLocation();
        b.loadLocal(triggerVar);
        b.loadThis();
        b.loadLocal(stateVar);
        b.invokeVirtual(TypeDesc.forClass(Trigger.class), "failed" + opType, null, new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.OBJECT});
        Label tryEnd = b.createLabel().setLocation();
        Label cont = b.createLabel();
        b.branch((Location)cont);
        b.exceptionHandler((Location)tryStart, (Location)tryEnd, Throwable.class.getName());
        b.invokeStatic(UNCAUGHT_METHOD_NAME, null, new TypeDesc[]{TypeDesc.forClass(Throwable.class)});
        cont.setLocation();
        b.loadLocal(txnVar);
        b.invokeInterface(transactionType, "exit", null, null);
        isNull.setLocation();
    }

    private void addTriggerFailedAndExitTxn(CodeBuilder b, String opType, LocalVariable forTryVar, boolean forTry, LocalVariable triggerVar, LocalVariable txnVar, LocalVariable stateVar, Label tryStart) {
        if (tryStart == null) {
            this.addTriggerFailedAndExitTxn(b, opType, triggerVar, txnVar, stateVar);
            return;
        }
        Label tryEnd = b.createLabel().setLocation();
        b.exceptionHandler((Location)tryStart, (Location)tryEnd, null);
        LocalVariable exceptionVar = b.createLocalVariable(null, TypeDesc.OBJECT);
        b.storeLocal(exceptionVar);
        this.addTriggerFailedAndExitTxn(b, opType, triggerVar, txnVar, stateVar);
        b.loadLocal(exceptionVar);
        TypeDesc abortException = TypeDesc.forClass(Trigger.Abort.class);
        b.instanceOf(abortException);
        Label nextCheck = b.createLabel();
        b.ifZeroComparisonBranch((Location)nextCheck, "==");
        if (forTryVar == null) {
            if (forTry) {
                b.loadConstant(false);
                b.returnValue(TypeDesc.BOOLEAN);
            } else {
                b.loadLocal(exceptionVar);
                b.checkCast(abortException);
                b.invokeVirtual(abortException, "withStackTrace", abortException, null);
                b.throwObject();
            }
        } else {
            b.loadLocal(forTryVar);
            Label isForTry = b.createLabel();
            b.ifZeroComparisonBranch((Location)isForTry, "!=");
            b.loadLocal(exceptionVar);
            b.checkCast(abortException);
            b.invokeVirtual(abortException, "withStackTrace", abortException, null);
            b.throwObject();
            isForTry.setLocation();
            b.loadConstant(false);
            b.returnValue(TypeDesc.BOOLEAN);
        }
        nextCheck.setLocation();
        b.loadLocal(exceptionVar);
        TypeDesc repException = TypeDesc.forClass(RepositoryException.class);
        b.instanceOf(repException);
        Label throwAny = b.createLabel();
        b.ifZeroComparisonBranch((Location)throwAny, "==");
        b.loadLocal(exceptionVar);
        b.checkCast(repException);
        b.invokeVirtual(repException, "toPersistException", TypeDesc.forClass(PersistException.class), null);
        b.throwObject();
        throwAny.setLocation();
        b.loadLocal(exceptionVar);
        b.throwObject();
    }

    private void defineUncaughtExceptionHandler() {
        MethodInfo mi = this.mClassFile.addMethod(Modifiers.PRIVATE.toStatic(true), UNCAUGHT_METHOD_NAME, null, new TypeDesc[]{TypeDesc.forClass(Throwable.class)});
        CodeBuilder b = new CodeBuilder(mi);
        TypeDesc threadType = TypeDesc.forClass(Thread.class);
        b.invokeStatic(Thread.class.getName(), "currentThread", threadType, null);
        LocalVariable threadVar = b.createLocalVariable(null, threadType);
        b.storeLocal(threadVar);
        b.loadLocal(threadVar);
        TypeDesc handlerType = TypeDesc.forClass(Thread.UncaughtExceptionHandler.class);
        b.invokeVirtual(threadType, "getUncaughtExceptionHandler", handlerType, null);
        b.loadLocal(threadVar);
        b.loadLocal(b.getParameter(0));
        b.invokeInterface(handlerType, "uncaughtException", null, new TypeDesc[]{threadType, TypeDesc.forClass(Throwable.class)});
        b.returnVoid();
    }

    private MethodInfo addMethodIfNotFinal(Modifiers modifiers, String name, TypeDesc retType, TypeDesc[] params) {
        if (CodeBuilderUtil.isPublicMethodFinal(this.mStorableType, name, retType, params)) {
            return null;
        }
        return this.mClassFile.addMethod(modifiers, name, retType, params);
    }

    static {
        String value = System.getProperty(StorableGenerator.class.getName() + ".strictAccess");
        cStrictAccess = value != null && value.equals("true");
    }
}

