/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.filter;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.PropertyFilterList;
import com.amazon.carbonado.util.Appender;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterValues<S extends Storable>
implements Serializable,
Appender {
    private static final long serialVersionUID = 1L;
    private static final Object[] NO_VALUES = new Object[0];
    private final transient Filter<S> mFilter;
    private final transient PropertyFilterList<S> mCurrentProperty;
    private final transient FilterValues<S> mPrevValues;
    private final transient Object mPrevValue;
    private volatile transient Map<PropertyFilter<S>, Object> mValueMap;

    static <S extends Storable> FilterValues<S> create(Filter<S> filter, PropertyFilterList<S> propFilterList) {
        return FilterValues.create(filter, propFilterList, null, null);
    }

    private static <S extends Storable> FilterValues<S> create(Filter<S> filter, PropertyFilterList<S> propFilterList, FilterValues<S> prevValues, Object prevValue) {
        PropertyFilter<S> propFilter;
        FilterValues<S> fv = new FilterValues<S>(filter, propFilterList, prevValues, prevValue);
        while (propFilterList != null && (propFilter = propFilterList.getPropertyFilter()).isConstant()) {
            propFilterList = propFilterList.getNext();
            fv = new FilterValues<S>(filter, propFilterList, fv, propFilter.constant());
        }
        return fv;
    }

    private FilterValues(Filter<S> filter, PropertyFilterList<S> propFilterList, FilterValues<S> prevValues, Object prevValue) {
        this.mFilter = filter;
        this.mCurrentProperty = propFilterList;
        this.mPrevValues = prevValues;
        this.mPrevValue = prevValue;
    }

    public Filter<S> getFilter() {
        return this.mFilter;
    }

    public FilterValues<S> with(int value) {
        Object obj;
        PropertyFilterList<S> current = this.currentProperty();
        try {
            obj = current.getPropertyFilter().adaptValue(value);
        }
        catch (IllegalArgumentException e) {
            throw this.mismatch(e);
        }
        return this.with(current, obj);
    }

    public FilterValues<S> with(long value) {
        Object obj;
        PropertyFilterList<S> current = this.currentProperty();
        try {
            obj = current.getPropertyFilter().adaptValue(value);
        }
        catch (IllegalArgumentException e) {
            throw this.mismatch(e);
        }
        return this.with(current, obj);
    }

    public FilterValues<S> with(float value) {
        Object obj;
        PropertyFilterList<S> current = this.currentProperty();
        try {
            obj = current.getPropertyFilter().adaptValue(value);
        }
        catch (IllegalArgumentException e) {
            throw this.mismatch(e);
        }
        return this.with(current, obj);
    }

    public FilterValues<S> with(double value) {
        Object obj;
        PropertyFilterList<S> current = this.currentProperty();
        try {
            obj = current.getPropertyFilter().adaptValue(value);
        }
        catch (IllegalArgumentException e) {
            throw this.mismatch(e);
        }
        return this.with(current, obj);
    }

    public FilterValues<S> with(boolean value) {
        Object obj;
        PropertyFilterList<S> current = this.currentProperty();
        try {
            obj = current.getPropertyFilter().adaptValue(value);
        }
        catch (IllegalArgumentException e) {
            throw this.mismatch(e);
        }
        return this.with(current, obj);
    }

    public FilterValues<S> with(char value) {
        Object obj;
        PropertyFilterList<S> current = this.currentProperty();
        try {
            obj = current.getPropertyFilter().adaptValue(value);
        }
        catch (IllegalArgumentException e) {
            throw this.mismatch(e);
        }
        return this.with(current, obj);
    }

    public FilterValues<S> with(byte value) {
        Object obj;
        PropertyFilterList<S> current = this.currentProperty();
        try {
            obj = current.getPropertyFilter().adaptValue(value);
        }
        catch (IllegalArgumentException e) {
            throw this.mismatch(e);
        }
        return this.with(current, obj);
    }

    public FilterValues<S> with(short value) {
        Object obj;
        PropertyFilterList<S> current = this.currentProperty();
        try {
            obj = current.getPropertyFilter().adaptValue(value);
        }
        catch (IllegalArgumentException e) {
            throw this.mismatch(e);
        }
        return this.with(current, obj);
    }

    public FilterValues<S> with(Object value) {
        Object obj;
        PropertyFilterList<S> current = this.currentProperty();
        try {
            obj = current.getPropertyFilter().adaptValue(value);
        }
        catch (IllegalArgumentException e) {
            throw this.mismatch(e);
        }
        return this.with(current, obj);
    }

    public FilterValues<S> withValues(Object ... values) {
        if (values == null) {
            return this;
        }
        if (values.length > this.getBlankParameterCount()) {
            throw new IllegalStateException("Too many values supplied");
        }
        FilterValues<S> filterValues = this;
        for (Object value : values) {
            filterValues = filterValues.with(value);
        }
        return filterValues;
    }

    private FilterValues<S> with(PropertyFilterList<S> current, Object value) {
        return FilterValues.create(this.mFilter, current.getNext(), this, value);
    }

    public int getBlankParameterCount() {
        return this.mCurrentProperty == null ? 0 : this.mCurrentProperty.getNextBlankRemaining() + 1;
    }

    public Object getValue(PropertyFilter<S> propFilter) {
        return this.getValue(propFilter, false);
    }

    public Object getAssignedValue(PropertyFilter<S> propFilter) throws IllegalStateException {
        return this.getValue(propFilter, true);
    }

    private Object getValue(PropertyFilter<S> propFilter, boolean mustBeAssigned) {
        Object value;
        if (propFilter.isConstant()) {
            return propFilter.constant();
        }
        Map<PropertyFilter<S>, Object> map = this.mValueMap;
        if (map == null) {
            FilterValues<S> prevValues = this.mPrevValues;
            if (prevValues == null) {
                if (mustBeAssigned) {
                    throw this.valueNotFound(propFilter);
                }
                return null;
            }
            if (prevValues.mCurrentProperty.getPreviousRemaining() < 3) {
                FilterValues<S> filterValues = this;
                do {
                    if (propFilter == prevValues.mCurrentProperty.getPropertyFilter()) {
                        return filterValues.mPrevValue;
                    }
                    filterValues = prevValues;
                } while ((prevValues = prevValues.mPrevValues) != null);
                if (mustBeAssigned) {
                    throw super.valueNotFound(propFilter);
                }
                return null;
            }
            map = this.buildValueMap();
        }
        if ((value = map.get(propFilter)) == null && mustBeAssigned && !map.containsKey(propFilter)) {
            throw this.valueNotFound(propFilter);
        }
        return value;
    }

    public boolean isAssigned(PropertyFilter<S> propFilter) {
        if (propFilter.isConstant()) {
            return true;
        }
        Map<PropertyFilter<S>, Object> map = this.mValueMap;
        if (map == null) {
            FilterValues<S> prevValues = this.mPrevValues;
            if (prevValues == null) {
                return false;
            }
            if (prevValues.mCurrentProperty.getPreviousRemaining() < 3) {
                do {
                    if (propFilter != prevValues.mCurrentProperty.getPropertyFilter()) continue;
                    return true;
                } while ((prevValues = prevValues.mPrevValues) != null);
                return false;
            }
            map = this.buildValueMap();
        }
        return map.containsKey(propFilter);
    }

    private Map<PropertyFilter<S>, Object> buildValueMap() {
        IdentityHashMap<PropertyFilter<S>, Object> map = new IdentityHashMap<PropertyFilter<S>, Object>();
        FilterValues<S> filterValues = this;
        FilterValues<S> prevValues = this.mPrevValues;
        do {
            map.put(prevValues.mCurrentProperty.getPropertyFilter(), filterValues.mPrevValue);
            filterValues = prevValues;
        } while ((prevValues = prevValues.mPrevValues) != null);
        this.mValueMap = map;
        return map;
    }

    public Object[] getValues() throws IllegalStateException {
        return this.getValuesFor(this.mFilter);
    }

    public Object[] getSuppliedValues() {
        FilterValues<S> prevValues = this.mPrevValues;
        if (prevValues == null) {
            return NO_VALUES;
        }
        int i = prevValues.mCurrentProperty.getBlankCount();
        if (i == 0) {
            return NO_VALUES;
        }
        Object[] values = new Object[i];
        FilterValues<S> filterValues = this;
        while (true) {
            if (!filterValues.mPrevValues.mCurrentProperty.getPropertyFilter().isConstant()) {
                values[--i] = filterValues.mPrevValue;
                if (i <= 0) break;
            }
            filterValues = prevValues;
            prevValues = prevValues.mPrevValues;
        }
        return values;
    }

    public Object[] getValuesFor(Filter<S> filter) throws IllegalStateException {
        PropertyFilterList<S> list = filter.getTailPropertyFilterList();
        if (list == null) {
            return NO_VALUES;
        }
        int i = list.getPreviousRemaining() + 1;
        Object[] values = new Object[i];
        FilterValues<S> filterValues = this;
        FilterValues<S> prevValues = this.mPrevValues;
        while (--i >= 0) {
            Object value;
            block8: {
                PropertyFilter<S> propFilter = list.getPropertyFilter();
                if (prevValues != null && propFilter == prevValues.mCurrentProperty.getPropertyFilter()) {
                    value = filterValues.mPrevValue;
                    filterValues = prevValues;
                    prevValues = prevValues.mPrevValues;
                } else if (i > 0 || this.mValueMap != null) {
                    value = this.getAssignedValue(propFilter);
                } else {
                    filterValues = this;
                    prevValues = this.mPrevValues;
                    while (prevValues != null) {
                        if (propFilter == prevValues.mCurrentProperty.getPropertyFilter()) {
                            value = filterValues.mPrevValue;
                            break block8;
                        }
                        filterValues = prevValues;
                        prevValues = prevValues.mPrevValues;
                    }
                    throw super.valueNotFound(propFilter);
                }
            }
            values[i] = value;
            list = list.getPrevious();
        }
        return values;
    }

    /*
     * Unable to fully structure code
     */
    public Object[] getSuppliedValuesFor(Filter<S> filter) throws IllegalStateException {
        list = filter.getTailPropertyFilterList();
        if (list == null) {
            return FilterValues.NO_VALUES;
        }
        prevValues = this.mPrevValues;
        if (prevValues == null) {
            return FilterValues.NO_VALUES;
        }
        valuesPos = i = list.getPreviousRemaining() + 1;
        values = new Object[valuesPos];
        filterValues = this;
        while (--i >= 0) {
            block10: {
                block11: {
                    block9: {
                        propFilter = list.getPropertyFilter();
                        if (prevValues == null || propFilter != prevValues.mCurrentProperty.getPropertyFilter()) break block9;
                        value = filterValues.mPrevValue;
                        filterValues = prevValues;
                        prevValues = prevValues.mPrevValues;
                        if (!propFilter.isConstant()) ** GOTO lbl34
                        break block10;
                    }
                    if (propFilter.isConstant()) break block10;
                    if (i <= 0 && this.mValueMap == null) break block11;
                    if (!this.isAssigned(propFilter)) break block10;
                    value = this.getAssignedValue(propFilter);
                    ** GOTO lbl34
                }
                filterValues = this;
                prevValues = this.mPrevValues;
                while (prevValues != null) {
                    if (propFilter == prevValues.mCurrentProperty.getPropertyFilter()) {
                        value = filterValues.mPrevValue;
                    } else {
                        filterValues = prevValues;
                        prevValues = prevValues.mPrevValues;
                        continue;
                    }
lbl34:
                    // 3 sources

                    values[--valuesPos] = value;
                    break;
                }
            }
            list = list.getPrevious();
        }
        if (valuesPos != 0) {
            newValuesSize = values.length - valuesPos;
            if (newValuesSize == 0) {
                values = FilterValues.NO_VALUES;
            } else {
                newValues = new Object[newValuesSize];
                System.arraycopy(values, valuesPos, newValues, 0, newValuesSize);
                values = newValues;
            }
        }
        return values;
    }

    private IllegalStateException valueNotFound(PropertyFilter<S> propFilter) {
        return new IllegalStateException("Property value not found for: \"" + propFilter + "\" in filter \"" + this + '\"');
    }

    public int hashCode() {
        int hash = this.mFilter.hashCode();
        if (this.mPrevValue != null) {
            hash += this.mPrevValue.hashCode();
        }
        if (this.mPrevValues != null) {
            hash += this.mPrevValues.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FilterValues) {
            FilterValues other = (FilterValues)obj;
            return this.mFilter.equals(other.mFilter) && this.mCurrentProperty == other.mCurrentProperty && (this.mPrevValues == null ? other.mPrevValues == null : this.mPrevValues.equals(other.mPrevValues)) && (this.mPrevValue == null ? other.mPrevValue == null : this.mPrevValue.equals(other.mPrevValue));
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        try {
            this.appendTo(buf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    @Override
    public void appendTo(Appendable app) throws IOException {
        this.mFilter.appendTo(app, this);
    }

    private PropertyFilterList<S> currentProperty() {
        PropertyFilterList<S> current = this.mCurrentProperty;
        if (current == null) {
            throw new IllegalStateException("No blank parameters");
        }
        return current;
    }

    private IllegalArgumentException mismatch(IllegalArgumentException e) {
        PropertyFilterList<S> current = this.currentProperty();
        PropertyFilter<S> propFilter = current.getPropertyFilter();
        StringBuilder b = new StringBuilder();
        b.append(e.getMessage());
        int subFilterCount = current.getPreviousRemaining() + current.getNextRemaining() + 1;
        if (subFilterCount <= 1) {
            b.append(" for filter \"");
            b.append(propFilter);
            b.append('\"');
        } else {
            b.append(" for ");
            this.appendOrdinal(b, current.getPreviousRemaining() + 1);
            b.append(" sub filter in \"");
            try {
                this.appendTo(b);
            }
            catch (IOException e2) {
                // empty catch block
            }
            b.append('\"');
        }
        return new IllegalArgumentException(b.toString());
    }

    private void appendOrdinal(StringBuilder b, int value) {
        b.append(value);
        if (value != 11 && value != 12 && value != 13) {
            switch (value %= 10) {
                default: {
                    break;
                }
                case 1: {
                    b.append("st");
                    return;
                }
                case 2: {
                    b.append("nd");
                    return;
                }
                case 3: {
                    b.append("rd");
                    return;
                }
            }
        }
        b.append("th");
    }

    private Object writeReplace() {
        return new FaV(this.mFilter, this.getSuppliedValues());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FaV
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private Filter<?> mFilter;
        private Object[] mValues;

        public FaV() {
        }

        FaV(Filter<?> filter, Object[] values) {
            this.mFilter = filter;
            this.mValues = values;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.mFilter);
            out.writeObject(this.mValues);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.mFilter = (Filter)in.readObject();
            this.mValues = (Object[])in.readObject();
        }

        private Object readResolve() {
            return this.mFilter.initialFilterValues().withValues(this.mValues);
        }
    }
}

