/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.cursor.AbstractCursor;
import java.util.Comparator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionCursor<S>
extends AbstractCursor<S> {
    private final Cursor<S> mLeftCursor;
    private final Cursor<S> mRightCursor;
    private final Comparator<S> mOrder;
    private S mNextLeft;
    private S mNextRight;

    public UnionCursor(Cursor<S> left, Cursor<S> right, Comparator<S> order) {
        if (left == null || right == null || order == null) {
            throw new IllegalArgumentException();
        }
        this.mLeftCursor = left;
        this.mRightCursor = right;
        this.mOrder = order;
    }

    @Override
    public void close() throws FetchException {
        this.mLeftCursor.close();
        this.mRightCursor.close();
        this.mNextLeft = null;
        this.mNextRight = null;
    }

    @Override
    public boolean hasNext() throws FetchException {
        try {
            if (this.mNextLeft == null && this.mLeftCursor.hasNext()) {
                this.mNextLeft = this.mLeftCursor.next();
            }
            if (this.mNextRight == null && this.mRightCursor.hasNext()) {
                this.mNextRight = this.mRightCursor.next();
            }
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        return this.mNextLeft != null || this.mNextRight != null;
    }

    @Override
    public S next() throws FetchException {
        try {
            if (this.hasNext()) {
                S next;
                if (this.mNextLeft == null) {
                    next = this.mNextRight;
                    this.mNextRight = null;
                } else if (this.mNextRight == null) {
                    next = this.mNextLeft;
                    this.mNextLeft = null;
                } else {
                    int result = this.mOrder.compare(this.mNextLeft, this.mNextRight);
                    if (result < 0) {
                        next = this.mNextLeft;
                        this.mNextLeft = null;
                    } else if (result > 0) {
                        next = this.mNextRight;
                        this.mNextRight = null;
                    } else {
                        next = this.mNextLeft;
                        this.mNextLeft = null;
                        this.mNextRight = null;
                    }
                }
                return next;
            }
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        throw new NoSuchElementException();
    }
}

