/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchInterruptedException;
import com.amazon.carbonado.cursor.AbstractCursor;
import com.amazon.carbonado.util.Throttle;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrottledCursor<S>
extends AbstractCursor<S> {
    private static final int WINDOW_SIZE = 10;
    private static final int SLEEP_PRECISION_MILLIS = 50;
    private final Cursor<S> mCursor;
    private final Throttle mThrottle;
    private final double mDesiredSpeed;

    public ThrottledCursor(Cursor<S> cursor, double throttle) {
        this.mCursor = cursor;
        if (throttle < 1.0) {
            if (throttle < 0.0) {
                throttle = 0.0;
            }
            this.mThrottle = new Throttle(10);
            this.mDesiredSpeed = throttle;
        } else {
            this.mThrottle = null;
            this.mDesiredSpeed = 1.0;
        }
    }

    @Override
    public void close() throws FetchException {
        this.mCursor.close();
    }

    @Override
    public boolean hasNext() throws FetchException {
        try {
            return this.mCursor.hasNext();
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public S next() throws FetchException {
        try {
            this.throttle();
            return this.mCursor.next();
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public int skipNext(int amount) throws FetchException {
        if (amount <= 0) {
            if (amount < 0) {
                throw new IllegalArgumentException("Cannot skip negative amount: " + amount);
            }
            return 0;
        }
        try {
            int count = 0;
            while (--amount >= 0) {
                this.throttle();
                if (this.skipNext(1) <= 0) break;
                ++count;
            }
            return count;
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private void throttle() throws FetchInterruptedException {
        if (this.mThrottle != null) {
            try {
                this.mThrottle.throttle(this.mDesiredSpeed, 50L);
            }
            catch (InterruptedException e) {
                throw new FetchInterruptedException(e);
            }
        }
    }
}

