/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.cursor.AbstractCursor;
import com.amazon.carbonado.cursor.SortedCursor;
import java.util.Comparator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroupedCursor<S, G>
extends AbstractCursor<G> {
    private final Cursor<S> mCursor;
    private final Comparator<S> mGroupComparator;
    private S mGroupLeader;
    private G mNextAggregate;

    protected GroupedCursor(Cursor<S> cursor, Comparator<S> groupComparator) {
        if (cursor == null || groupComparator == null) {
            throw new IllegalArgumentException();
        }
        this.mCursor = cursor;
        this.mGroupComparator = groupComparator;
    }

    protected GroupedCursor(Cursor<S> cursor, Class<S> type, String ... groupProperties) {
        if (cursor == null) {
            throw new IllegalArgumentException();
        }
        this.mCursor = cursor;
        this.mGroupComparator = SortedCursor.createComparator(type, groupProperties);
    }

    public Comparator<S> comparator() {
        return this.mGroupComparator;
    }

    protected abstract void beginGroup(S var1) throws FetchException;

    protected abstract void addToGroup(S var1) throws FetchException;

    protected abstract G finishGroup() throws FetchException;

    @Override
    public void close() throws FetchException {
        this.mCursor.close();
        this.mGroupLeader = null;
        this.mNextAggregate = null;
    }

    @Override
    public boolean hasNext() throws FetchException {
        G aggregate;
        if (this.mNextAggregate != null) {
            return true;
        }
        try {
            if (this.mCursor.hasNext()) {
                if (this.mGroupLeader == null) {
                    this.mGroupLeader = this.mCursor.next();
                    this.beginGroup(this.mGroupLeader);
                }
                while (this.mCursor.hasNext()) {
                    S groupMember = this.mCursor.next();
                    if (this.mGroupComparator.compare(this.mGroupLeader, groupMember) == 0) {
                        this.addToGroup(groupMember);
                        continue;
                    }
                    G aggregate2 = this.finishGroup();
                    this.mGroupLeader = groupMember;
                    this.beginGroup(this.mGroupLeader);
                    if (aggregate2 == null) continue;
                    this.mNextAggregate = aggregate2;
                    return true;
                }
                aggregate = this.finishGroup();
                this.mGroupLeader = null;
                if (aggregate != null) {
                    this.mNextAggregate = aggregate;
                    return true;
                }
            }
        }
        catch (NoSuchElementException e) {
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        if (this.mGroupLeader != null) {
            aggregate = this.finishGroup();
            this.mGroupLeader = null;
            if (aggregate != null) {
                this.mNextAggregate = aggregate;
                return true;
            }
        }
        return false;
    }

    @Override
    public G next() throws FetchException {
        try {
            if (this.hasNext()) {
                G next = this.mNextAggregate;
                this.mNextAggregate = null;
                return next;
            }
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int skipNext(int amount) throws FetchException {
        if (amount <= 0) {
            if (amount < 0) {
                throw new IllegalArgumentException("Cannot skip negative amount: " + amount);
            }
            return 0;
        }
        try {
            int count = 0;
            while (--amount >= 0 && this.hasNext()) {
                ++count;
                this.mNextAggregate = null;
            }
            return count;
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }
}

