/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.constraint;

import com.amazon.carbonado.MalformedTypeException;
import com.amazon.carbonado.constraint.ConstraintDefinition;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@ConstraintDefinition
public @interface LengthConstraint {
    public int min() default 0;

    public int max() default 0x7FFFFFFF;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Constraint {
        private final String mPropertyName;
        private final int mMinLength;
        private final int mMaxLength;

        public Constraint(Class<?> type, String propertyName, LengthConstraint ann) {
            this(type, propertyName, ann.min(), ann.max());
        }

        public Constraint(Class<?> type, String propertyName, int min, int max) {
            this.mPropertyName = propertyName;
            this.mMinLength = min;
            this.mMaxLength = max;
            if (this.mMinLength < 0 || this.mMaxLength < this.mMinLength) {
                throw new MalformedTypeException(type, "Illegal length constraint for property \"" + propertyName + "\": " + this.rangeString());
            }
        }

        public void constrain(CharSequence str) {
            if (str != null) {
                this.constrainLength(str.length());
            }
        }

        public void constrain(boolean[] array) {
            if (array != null) {
                this.constrainLength(array.length);
            }
        }

        public void constrain(byte[] array) {
            if (array != null) {
                this.constrainLength(array.length);
            }
        }

        public void constrain(short[] array) {
            if (array != null) {
                this.constrainLength(array.length);
            }
        }

        public void constrain(char[] array) {
            if (array != null) {
                this.constrainLength(array.length);
            }
        }

        public void constrain(int[] array) {
            if (array != null) {
                this.constrainLength(array.length);
            }
        }

        public void constrain(long[] array) {
            if (array != null) {
                this.constrainLength(array.length);
            }
        }

        public void constrain(float[] array) {
            if (array != null) {
                this.constrainLength(array.length);
            }
        }

        public void constrain(double[] array) {
            if (array != null) {
                this.constrainLength(array.length);
            }
        }

        public void constrain(Object[] array) {
            if (array != null) {
                this.constrainLength(array.length);
            }
        }

        private void constrainLength(int length) {
            if (length < this.mMinLength || length > this.mMaxLength) {
                throw new IllegalArgumentException("Value length for \"" + this.mPropertyName + "\" must be in range " + this.rangeString() + ": " + length);
            }
        }

        private String rangeString() {
            StringBuilder b = new StringBuilder();
            b.append('(');
            b.append(this.mMinLength);
            b.append("..");
            if (this.mMaxLength < Integer.MAX_VALUE) {
                b.append(this.mMaxLength);
            }
            b.append(')');
            return b.toString();
        }
    }
}

