/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.sleepycat;

import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.repo.sleepycat.BDBCursor;
import com.amazon.carbonado.repo.sleepycat.DBX_Cursor;
import com.amazon.carbonado.repo.sleepycat.DBX_Repository;
import com.amazon.carbonado.repo.sleepycat.DB_Storage;
import com.amazon.carbonado.txn.TransactionScope;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Transaction;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DBX_Storage<S extends Storable>
extends DB_Storage<S> {
    final ReadWriteLock mRWLock;

    DBX_Storage(DBX_Repository repository, Class<S> type) throws DatabaseException, RepositoryException {
        super(repository, type);
        this.mRWLock = repository.mRWLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean db_exists(Transaction txn, byte[] key, boolean rmw) throws Exception {
        Lock lock = this.mRWLock.readLock();
        lock.lock();
        try {
            boolean bl = super.db_exists(txn, key, rmw);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] db_get(Transaction txn, byte[] key, boolean rmw) throws Exception {
        Lock lock = this.mRWLock.readLock();
        lock.lock();
        try {
            byte[] byArray = super.db_get(txn, key, rmw);
            return byArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object db_putNoOverwrite(Transaction txn, byte[] key, byte[] value) throws Exception {
        if (txn != null) {
            return super.db_putNoOverwrite(txn, key, value);
        }
        Lock lock = this.mRWLock.writeLock();
        lock.lock();
        try {
            Object object = super.db_putNoOverwrite(txn, key, value);
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean db_put(Transaction txn, byte[] key, byte[] value) throws Exception {
        if (txn != null) {
            return super.db_put(txn, key, value);
        }
        Lock lock = this.mRWLock.writeLock();
        lock.lock();
        try {
            boolean bl = super.db_put(txn, key, value);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean db_delete(Transaction txn, byte[] key) throws Exception {
        if (txn != null) {
            return super.db_delete(txn, key);
        }
        Lock lock = this.mRWLock.writeLock();
        lock.lock();
        try {
            boolean bl = super.db_delete(txn, key);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean db_isEmpty(Transaction txn, Object database, boolean rmw) throws Exception {
        ReadWriteLock rwLock = this.mRWLock;
        if (rwLock == null) {
            return super.db_isEmpty(txn, database, rmw);
        }
        Lock lock = rwLock.readLock();
        lock.lock();
        try {
            boolean bl = super.db_isEmpty(txn, database, rmw);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    protected BDBCursor<Transaction, S> openCursor(TransactionScope<Transaction> scope, byte[] startBound, boolean inclusiveStart, byte[] endBound, boolean inclusiveEnd, int maxPrefix, boolean reverse, Object database) throws Exception {
        return new DBX_Cursor(scope, startBound, inclusiveStart, endBound, inclusiveEnd, maxPrefix, reverse, this, (Database)database);
    }
}

