/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.util;

import java.util.Date;

public class Throttle {
    private final double[] mWorkTimeSamples;
    private int mSampleIndex;
    private double mWorkTimeSum;
    private int mSampleCount;
    private long mLastTimestampNanos;
    private double mSleepRequiredNanos;

    public Throttle(int windowSize) {
        if (windowSize < 1) {
            throw new IllegalArgumentException();
        }
        this.mWorkTimeSamples = new double[windowSize];
    }

    public void throttle(double desiredSpeed, long sleepPrecisionMillis) throws InterruptedException {
        long timestampNanos = System.nanoTime();
        int sampleCount = this.mSampleCount;
        int index = this.mSampleIndex;
        double workTime = timestampNanos - this.mLastTimestampNanos;
        double workTimeSum = this.mWorkTimeSum + workTime;
        double[] workTimeSamples = this.mWorkTimeSamples;
        if (sampleCount >= workTimeSamples.length) {
            double average = (workTimeSum -= workTimeSamples[index]) / (double)sampleCount;
            double sleepTimeNanos = average / desiredSpeed - average;
            double sleepRequiredNanos = this.mSleepRequiredNanos + sleepTimeNanos;
            if (sleepRequiredNanos > 0.0) {
                double sleepRequiredMillis = sleepRequiredNanos * 1.0E-6;
                long millis = sleepRequiredMillis > 9.223372036854776E18 ? Long.MAX_VALUE : Math.max(sleepPrecisionMillis, (long)sleepRequiredMillis);
                Thread.sleep(millis);
                long nextNanos = System.nanoTime();
                sleepRequiredNanos -= (double)(nextNanos - timestampNanos);
                timestampNanos = nextNanos;
            }
            this.mSleepRequiredNanos = sleepRequiredNanos;
        }
        workTimeSamples[index] = workTime;
        if (++index >= workTimeSamples.length) {
            index = 0;
        }
        this.mSampleIndex = index;
        this.mWorkTimeSum = workTimeSum;
        if (sampleCount < workTimeSamples.length) {
            this.mSampleCount = sampleCount + 1;
        }
        this.mLastTimestampNanos = timestampNanos;
    }

    public static void main(String[] args) throws Exception {
        Throttle t = new Throttle(50);
        double desiredSpeed = Double.parseDouble(args[0]);
        while (true) {
            new Date().toString();
            t.throttle(desiredSpeed, 100L);
        }
    }
}

