/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.util;

import com.amazon.carbonado.util.AnnotationVisitor;
import java.lang.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationPrinter
extends AnnotationVisitor<Object, Object> {
    private final StringBuilder mBuilder;

    public AnnotationPrinter(boolean sort, StringBuilder b) {
        super(sort);
        this.mBuilder = b;
    }

    public Object visit(Annotation value) {
        return this.visit(value, null);
    }

    @Override
    public Object visit(String name, int pos, Annotation value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append('@');
        this.mBuilder.append(value.annotationType().getName());
        this.mBuilder.append('(');
        super.visit(name, pos, value, param);
        this.mBuilder.append(')');
        return null;
    }

    @Override
    public Object visit(String name, int pos, int value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append(value);
        return null;
    }

    @Override
    public Object visit(String name, int pos, long value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append(value);
        this.mBuilder.append('L');
        return null;
    }

    @Override
    public Object visit(String name, int pos, float value, Object param) {
        this.appendName(name, pos);
        if (Float.isNaN(value)) {
            this.mBuilder.append("java.lang.Float.NaN");
        } else if (value == Float.POSITIVE_INFINITY) {
            this.mBuilder.append("java.lang.Float.POSITIVE_INFINITY");
        } else if (value == Float.NEGATIVE_INFINITY) {
            this.mBuilder.append("java.lang.Float.NEGATIVE_INFINITY");
        } else {
            this.mBuilder.append(value);
            this.mBuilder.append('f');
        }
        return null;
    }

    @Override
    public Object visit(String name, int pos, double value, Object param) {
        this.appendName(name, pos);
        if (Double.isNaN(value)) {
            this.mBuilder.append("java.lang.Double.NaN");
        } else if (value == Double.POSITIVE_INFINITY) {
            this.mBuilder.append("java.lang.Double.POSITIVE_INFINITY");
        } else if (value == Double.NEGATIVE_INFINITY) {
            this.mBuilder.append("java.lang.Double.NEGATIVE_INFINITY");
        } else {
            this.mBuilder.append(value);
            this.mBuilder.append('d');
        }
        return null;
    }

    @Override
    public Object visit(String name, int pos, boolean value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append(value);
        return null;
    }

    @Override
    public Object visit(String name, int pos, byte value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append(value);
        return null;
    }

    @Override
    public Object visit(String name, int pos, short value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append(value);
        return null;
    }

    @Override
    public Object visit(String name, int pos, char value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append('\'');
        this.appendChar(value, false);
        this.mBuilder.append('\'');
        return null;
    }

    private void appendChar(char c, boolean forString) {
        switch (c) {
            case '\b': 
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case '\"': 
            case '\'': 
            case '\\': {
                if (forString) {
                    if (c != '\'') {
                        this.mBuilder.append('\\');
                    }
                } else if (c != '\"') {
                    this.mBuilder.append('\\');
                }
                char e = c;
                switch (c) {
                    case '\b': {
                        e = 'b';
                        break;
                    }
                    case '\t': {
                        e = 't';
                        break;
                    }
                    case '\n': {
                        e = 'n';
                        break;
                    }
                    case '\f': {
                        e = 'f';
                        break;
                    }
                    case '\r': {
                        e = 'r';
                    }
                }
                this.mBuilder.append(e);
                break;
            }
            default: {
                if (c >= ' ' && c <= '~') {
                    if (forString) {
                        if (c == '\"') {
                            this.mBuilder.append('\\');
                        }
                    } else if (c == '\'') {
                        this.mBuilder.append('\\');
                    }
                    this.mBuilder.append(c);
                    break;
                }
                this.mBuilder.append('\\');
                this.mBuilder.append('u');
                if (c < '\u1000') {
                    this.mBuilder.append('0');
                    if (c < '\u0100') {
                        this.mBuilder.append('0');
                        if (c < '\u0010') {
                            this.mBuilder.append('0');
                        }
                    }
                }
                this.mBuilder.append(Integer.toHexString(c));
            }
        }
    }

    @Override
    public Object visit(String name, int pos, String value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append('\"');
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            this.appendChar(value.charAt(i), true);
        }
        this.mBuilder.append('\"');
        return null;
    }

    @Override
    public Object visit(String name, int pos, Class value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append(value.getName());
        this.mBuilder.append(".class");
        return null;
    }

    @Override
    public Object visit(String name, int pos, Enum value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append(value.getDeclaringClass().getName());
        this.mBuilder.append('.');
        this.mBuilder.append(value.name());
        return null;
    }

    @Override
    public Object visit(String name, int pos, Annotation[] value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append('{');
        super.visit(name, pos, value, param);
        this.mBuilder.append('}');
        return null;
    }

    @Override
    public Object visit(String name, int pos, int[] value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append('{');
        super.visit(name, pos, value, param);
        this.mBuilder.append('}');
        return null;
    }

    @Override
    public Object visit(String name, int pos, long[] value, Object param) {
        this.appendName(name, pos);
        super.visit(name, pos, value, param);
        this.mBuilder.append('}');
        return null;
    }

    @Override
    public Object visit(String name, int pos, float[] value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append('{');
        super.visit(name, pos, value, param);
        this.mBuilder.append('}');
        return null;
    }

    @Override
    public Object visit(String name, int pos, double[] value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append('{');
        super.visit(name, pos, value, param);
        this.mBuilder.append('}');
        return null;
    }

    @Override
    public Object visit(String name, int pos, boolean[] value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append('{');
        super.visit(name, pos, value, param);
        this.mBuilder.append('}');
        return null;
    }

    @Override
    public Object visit(String name, int pos, byte[] value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append('{');
        super.visit(name, pos, value, param);
        this.mBuilder.append('}');
        return null;
    }

    @Override
    public Object visit(String name, int pos, short[] value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append('{');
        super.visit(name, pos, value, param);
        this.mBuilder.append('}');
        return null;
    }

    @Override
    public Object visit(String name, int pos, char[] value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append('{');
        super.visit(name, pos, value, param);
        this.mBuilder.append('}');
        return null;
    }

    @Override
    public Object visit(String name, int pos, String[] value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append('{');
        super.visit(name, pos, value, param);
        this.mBuilder.append('}');
        return null;
    }

    @Override
    public Object visit(String name, int pos, Class[] value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append('{');
        super.visit(name, pos, value, param);
        this.mBuilder.append('}');
        return null;
    }

    @Override
    public Object visit(String name, int pos, Enum[] value, Object param) {
        this.appendName(name, pos);
        this.mBuilder.append('{');
        super.visit(name, pos, value, param);
        this.mBuilder.append('}');
        return null;
    }

    private void appendName(String name, int pos) {
        if (pos > 0) {
            this.mBuilder.append(", ");
        }
        if (name != null) {
            this.mBuilder.append(name);
            this.mBuilder.append('=');
        }
    }
}

