/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.synthetic;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.gen.CodeBuilderUtil;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.synthetic.ClassFileBuilder;
import com.amazon.carbonado.synthetic.SyntheticBuilder;
import com.amazon.carbonado.synthetic.SyntheticIndex;
import com.amazon.carbonado.synthetic.SyntheticKey;
import com.amazon.carbonado.synthetic.SyntheticProperty;
import com.amazon.carbonado.synthetic.SyntheticStorableBuilder;
import com.amazon.carbonado.synthetic.SyntheticStorableReferenceAccess;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.BeanComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntheticStorableReferenceBuilder<S extends Storable>
implements SyntheticBuilder {
    private static final String COPY_FROM_MASTER_PREFIX = "copyFromMaster_";
    private static final String COPY_TO_MASTER_PK_PREFIX = "copyToMasterPk_";
    private static final String IS_CONSISTENT_PREFIX = "getIsConsistent_";
    private Class<S> mMasterStorableClass;
    private StorableInfo<S> mMasterStorableInfo;
    private SyntheticStorableBuilder mBuilder;
    SyntheticKey mPrimaryKey;
    private Set<String> mExtraPkProps;
    private boolean mIsUnique = true;
    private List<SyntheticProperty> mUserProps;
    private List<StorableProperty> mCommonProps;
    String mCopyFromMasterMethodName;
    String mIsConsistentMethodName;
    String mCopyToMasterPkMethodName;
    private SyntheticStorableReferenceAccess<S> mReferenceAccess;

    public SyntheticStorableReferenceBuilder(Class<S> storableClass, boolean isUnique) {
        this(storableClass, null, isUnique);
    }

    public SyntheticStorableReferenceBuilder(Class<S> storableClass, String baseName, boolean isUnique) {
        this.mMasterStorableClass = storableClass;
        this.mMasterStorableInfo = StorableIntrospector.examine(storableClass);
        this.mIsUnique = isUnique;
        this.mBuilder = new SyntheticStorableBuilder(storableClass.getCanonicalName() + (baseName != null ? "_" + baseName : ""), storableClass.getClassLoader());
        this.mBuilder.setClassNameProvider(new ReferenceClassNameProvider(isUnique));
        this.mPrimaryKey = this.mBuilder.addPrimaryKey();
        this.mExtraPkProps = new LinkedHashSet<String>();
        this.mUserProps = new ArrayList<SyntheticProperty>();
        this.mCommonProps = new ArrayList<StorableProperty>();
    }

    @Override
    public ClassFileBuilder prepare() throws SupportException {
        StorableProperty<S> versionProperty;
        ArrayList<StorableProperty<S>> masterPkProps = new ArrayList<StorableProperty<S>>(this.mMasterStorableInfo.getPrimaryKeyProperties().values());
        Collections.sort(masterPkProps, BeanComparator.forClass(StorableProperty.class).orderBy("name"));
        for (StorableProperty storableProperty : masterPkProps) {
            if (this.mBuilder.hasProperty(storableProperty.getName())) continue;
            this.addProperty(storableProperty);
            if (this.mIsUnique) continue;
            this.mPrimaryKey.addProperty(storableProperty.getName());
            this.mExtraPkProps.add(storableProperty.getName());
        }
        if (!this.mBuilder.isVersioned() && (versionProperty = this.mMasterStorableInfo.getVersionProperty()) != null) {
            this.addProperty(versionProperty);
        }
        ClassFileBuilder cfg = this.mBuilder.prepare();
        this.addSpecialMethods(cfg.getClassFile());
        return cfg;
    }

    public SyntheticStorableReferenceAccess<S> getReferenceAccess() {
        if (this.mReferenceAccess == null) {
            Class<? extends Storable> referenceClass = this.mBuilder.getStorableClass();
            this.mReferenceAccess = new SyntheticStorableReferenceAccess<S>(this.mMasterStorableClass, referenceClass, this);
        }
        return this.mReferenceAccess;
    }

    @Override
    public Class<? extends Storable> getStorableClass() throws IllegalStateException {
        return this.getReferenceAccess().getReferenceClass();
    }

    @Override
    public Class<? extends Storable> build() throws SupportException {
        this.prepare();
        return this.getStorableClass();
    }

    public SyntheticProperty addKeyProperty(String name, Direction direction) {
        StorableProperty<S> prop = this.mMasterStorableInfo.getAllProperties().get(name);
        if (prop == null) {
            throw new IllegalArgumentException(name + " is not a property of " + this.mMasterStorableInfo.getName());
        }
        this.mPrimaryKey.addProperty(name, direction);
        SyntheticProperty result = this.addProperty(prop);
        this.mUserProps.add(result);
        return result;
    }

    @Override
    public SyntheticProperty addProperty(String name, Class type) {
        SyntheticProperty result = this.mBuilder.addProperty(name, type);
        this.mUserProps.add(result);
        return result;
    }

    @Override
    public SyntheticProperty addProperty(SyntheticProperty prop) {
        SyntheticProperty result = this.mBuilder.addProperty(prop);
        this.mUserProps.add(result);
        return result;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.mBuilder.hasProperty(name);
    }

    public List<SyntheticProperty> getUserProps() {
        return this.mUserProps;
    }

    @Override
    public SyntheticKey addPrimaryKey() {
        return this.mBuilder.addPrimaryKey();
    }

    @Override
    public SyntheticKey addAlternateKey() {
        return this.mBuilder.addAlternateKey();
    }

    @Override
    public SyntheticIndex addIndex() {
        return this.mBuilder.addIndex();
    }

    public Object getName() {
        return this.mBuilder.getName();
    }

    public boolean isUnique() {
        return this.mIsUnique;
    }

    @Override
    public boolean isVersioned() {
        return this.mBuilder.isVersioned();
    }

    @Deprecated
    public void copyToMasterPrimaryKey(Storable indexEntry, S master) throws FetchException {
        this.getReferenceAccess().copyToMasterPrimaryKey(indexEntry, master);
    }

    @Deprecated
    public void copyFromMaster(Storable indexEntry, S master) throws FetchException {
        this.getReferenceAccess().copyFromMaster(indexEntry, master);
    }

    @Deprecated
    public boolean isConsistent(Storable indexEntry, S master) throws FetchException {
        return this.getReferenceAccess().isConsistent(indexEntry, master);
    }

    @Deprecated
    public Comparator<? extends Storable> getComparator() {
        return this.getReferenceAccess().getComparator();
    }

    private void addSpecialMethods(ClassFile cf) throws SupportException {
        this.mCopyToMasterPkMethodName = this.generateSafeMethodName(this.mMasterStorableInfo, COPY_TO_MASTER_PK_PREFIX);
        this.mCopyFromMasterMethodName = this.generateSafeMethodName(this.mMasterStorableInfo, COPY_FROM_MASTER_PREFIX);
        this.mIsConsistentMethodName = this.generateSafeMethodName(this.mMasterStorableInfo, IS_CONSISTENT_PREFIX);
        this.addCopyMethod(cf, this.mCopyFromMasterMethodName);
        this.addCopyMethod(cf, this.mCopyToMasterPkMethodName);
        TypeDesc masterStorableType = TypeDesc.forClass(this.mMasterStorableClass);
        TypeDesc[] params = new TypeDesc[]{masterStorableType};
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, this.mIsConsistentMethodName, TypeDesc.BOOLEAN, params);
        CodeBuilder b = new CodeBuilder(mi);
        for (StorableProperty prop : this.mCommonProps) {
            if (prop.isVersion() || prop.isDerived()) continue;
            Label propsAreEqual = b.createLabel();
            SyntheticStorableReferenceBuilder.addPropertyTest(b, prop, b.getParameter(0), propsAreEqual);
            propsAreEqual.setLocation();
        }
        b.loadConstant(true);
        b.returnValue(TypeDesc.BOOLEAN);
    }

    private void addCopyMethod(ClassFile cf, String methodName) throws SupportException {
        boolean toMasterPk;
        TypeDesc masterStorableType = TypeDesc.forClass(this.mMasterStorableClass);
        TypeDesc[] params = new TypeDesc[]{masterStorableType};
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, methodName, null, params);
        CodeBuilder b = new CodeBuilder(mi);
        if (methodName.equals(this.mCopyToMasterPkMethodName)) {
            toMasterPk = true;
        } else if (methodName.equals(this.mCopyFromMasterMethodName)) {
            toMasterPk = false;
        } else {
            throw new IllegalArgumentException();
        }
        for (StorableProperty prop : this.mCommonProps) {
            if (toMasterPk && !prop.isPrimaryKeyMember()) continue;
            TypeDesc propType = TypeDesc.forClass(prop.getType());
            if (toMasterPk) {
                if (prop.getWriteMethod() == null) {
                    throw new SupportException("Property does not have a public mutator method: " + prop);
                }
                b.loadLocal(b.getParameter(0));
                b.loadThis();
                b.invokeVirtual(prop.getReadMethodName(), propType, null);
                b.invoke(prop.getWriteMethod());
                continue;
            }
            if (!methodName.equals(this.mCopyFromMasterMethodName)) continue;
            if (prop.getReadMethod() == null) {
                throw new SupportException("Property does not have a public accessor method: " + prop);
            }
            b.loadThis();
            b.loadLocal(b.getParameter(0));
            b.invoke(prop.getReadMethod());
            b.invokeVirtual(prop.getWriteMethodName(), null, new TypeDesc[]{propType});
        }
        b.returnVoid();
    }

    private static void addPropertyTest(CodeBuilder b, StorableProperty<?> property, LocalVariable otherInstance, Label propsAreEqual) {
        TypeDesc propertyType = TypeDesc.forClass(property.getType());
        b.loadThis();
        b.invokeVirtual(property.getReadMethodName(), propertyType, null);
        b.loadLocal(otherInstance);
        b.invoke(property.getReadMethod());
        CodeBuilderUtil.addValuesEqualCall(b, propertyType, true, propsAreEqual, true);
        b.loadConstant(false);
        b.returnValue(TypeDesc.BOOLEAN);
    }

    private String generateSafeMethodName(StorableInfo info, String prefix) {
        Class type = info.getStorableType();
        int value = 0;
        for (int i = 0; i < 100; ++i) {
            String name = prefix + value;
            if (!this.methodExists(type, name)) {
                return name;
            }
            value = name.hashCode();
        }
        throw new InternalError("Unable to create unique method name starting with: " + prefix);
    }

    private boolean methodExists(Class clazz, String name) {
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            return true;
        }
        if (clazz.getSuperclass() != null && this.methodExists(clazz.getSuperclass(), name)) {
            return true;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!this.methodExists(interfaces[i], name)) continue;
            return true;
        }
        return false;
    }

    private SyntheticProperty addProperty(StorableProperty prop) {
        SyntheticProperty refProp = this.mBuilder.addProperty(prop.getName(), prop.getType());
        refProp.setReadMethodName(prop.getReadMethodName());
        refProp.setWriteMethodName(prop.getWriteMethodName());
        refProp.setIsNullable(prop.isNullable());
        refProp.setIsVersion(prop.isVersion());
        if (prop.getAdapter() != null) {
            refProp.setAdapter(prop.getAdapter());
        }
        this.mCommonProps.add(prop);
        return refProp;
    }

    class ReferenceClassNameProvider
    implements SyntheticBuilder.ClassNameProvider {
        boolean mUniquely;

        public ReferenceClassNameProvider(boolean unique) {
            this.mUniquely = unique;
        }

        public String getName() {
            StringBuilder b = new StringBuilder();
            b.append(SyntheticStorableReferenceBuilder.this.getName());
            b.append('~');
            b.append(this.mUniquely ? (char)'U' : 'N');
            Iterator<String> props = SyntheticStorableReferenceBuilder.this.mPrimaryKey.getProperties();
            while (props.hasNext()) {
                String prop = props.next();
                if (SyntheticStorableReferenceBuilder.this.mExtraPkProps.contains(prop)) continue;
                if (prop.charAt(0) != '+' && prop.charAt(0) != '-') {
                    b.append('~');
                }
                b.append(prop);
            }
            return b.toString();
        }

        public boolean isExplicit() {
            return true;
        }
    }
}

