/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.spi;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchNoneException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistNoneException;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.Trigger;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.lob.AbstractBlob;
import com.amazon.carbonado.lob.Blob;
import com.amazon.carbonado.lob.BlobClob;
import com.amazon.carbonado.lob.Clob;
import com.amazon.carbonado.lob.Lob;
import com.amazon.carbonado.sequence.SequenceValueGenerator;
import com.amazon.carbonado.sequence.SequenceValueProducer;
import com.amazon.carbonado.spi.BlobProperty;
import com.amazon.carbonado.spi.ClobProperty;
import com.amazon.carbonado.spi.LobEngineTrigger;
import com.amazon.carbonado.spi.StoredLob;
import com.amazon.carbonado.util.SoftValuedCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import org.cojen.util.KeyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LobEngine {
    final Repository mRepo;
    final Storage<StoredLob> mLobStorage;
    final Storage<StoredLob.Block> mLobBlockStorage;
    final SequenceValueProducer mLocatorSequence;
    private SoftValuedCache mTriggers;

    public static <S extends Storable> boolean hasLobs(Class<S> type) {
        StorableInfo<S> info = StorableIntrospector.examine(type);
        for (StorableProperty<S> prop : info.getAllProperties().values()) {
            if (!Lob.class.isAssignableFrom(prop.getType())) continue;
            return true;
        }
        return false;
    }

    static IOException toIOException(RepositoryException e) {
        IOException ioe = new IOException(e.getMessage());
        ioe.initCause(e);
        return ioe;
    }

    public LobEngine(Repository lobRepo, Repository locatorRepo) throws RepositoryException {
        this(lobRepo, new SequenceValueGenerator(locatorRepo, StoredLob.class.getName()));
    }

    public LobEngine(Repository lobRepo, SequenceValueProducer locatorSequenceProducer) throws RepositoryException {
        this.mRepo = lobRepo;
        this.mLobStorage = lobRepo.storageFor(StoredLob.class);
        this.mLobBlockStorage = lobRepo.storageFor(StoredLob.Block.class);
        this.mLocatorSequence = locatorSequenceProducer;
    }

    public Blob createNewBlob(int blockSize) throws PersistException {
        StoredLob lob = this.mLobStorage.prepare();
        lob.setLocator(this.mLocatorSequence.nextLongValue());
        lob.setBlockSize(blockSize);
        lob.setLength(0L);
        lob.insert();
        return new BlobImpl(lob.getLocator());
    }

    public Clob createNewClob(int blockSize) throws PersistException {
        StoredLob lob = this.mLobStorage.prepare();
        lob.setLocator(this.mLocatorSequence.nextLongValue());
        lob.setBlockSize(blockSize);
        lob.setLength(0L);
        lob.insert();
        return new ClobImpl(lob.getLocator());
    }

    public long getLocator(Lob lob) {
        if (lob == null) {
            return 0L;
        }
        Long locator = (Long)lob.getLocator();
        return locator == null ? 0L : locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLob(long locator) throws PersistException {
        if (locator == 0L) {
            return;
        }
        Transaction txn = this.mRepo.enterTransaction(IsolationLevel.READ_COMMITTED);
        try {
            StoredLob lob = this.mLobStorage.prepare();
            lob.setLocator(locator);
            if (lob.tryDelete()) {
                try {
                    this.mLobBlockStorage.query("locator = ?").with(lob.getLocator()).deleteAll();
                }
                catch (FetchException e) {
                    throw e.toPersistException();
                }
            }
            txn.commit();
        }
        finally {
            txn.exit();
        }
    }

    public void deleteLob(Lob lob) throws PersistException {
        this.deleteLob(this.getLocator(lob));
    }

    public Blob getBlobValue(long locator) {
        if (locator == 0L) {
            return null;
        }
        return new BlobImpl(locator);
    }

    public Clob getClobValue(long locator) {
        if (locator == 0L) {
            return null;
        }
        return new ClobImpl(locator);
    }

    public void setBlobValue(long locator, Blob data) throws PersistException, IOException {
        BlobImpl impl;
        if (data == null) {
            this.deleteLob(locator);
            return;
        }
        if (locator == 0L) {
            throw new IllegalArgumentException("Cannot use locator zero");
        }
        if (data instanceof BlobImpl && (impl = (BlobImpl)data).getEnclosing() == this && impl.mLocator == locator) {
            return;
        }
        try {
            this.setBlobValue(locator, data.openInputStream(0L, 0));
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlobValue(long locator, InputStream data) throws PersistException, IOException {
        if (data == null) {
            this.deleteLob(locator);
            return;
        }
        if (locator == 0L) {
            throw new IllegalArgumentException("Cannot use locator zero");
        }
        Transaction txn = this.mRepo.enterTransaction(IsolationLevel.READ_COMMITTED);
        txn.setForUpdate(true);
        try {
            StoredLob lob = this.mLobStorage.prepare();
            lob.setLocator(locator);
            try {
                lob.load();
            }
            catch (FetchNoneException e) {
                throw new PersistNoneException("Lob deleted: " + this);
            }
            Output out = new Output(lob, 0L, txn);
            byte[] buffer = new byte[lob.getBlockSize()];
            long total = 0L;
            try {
                int amt;
                while ((amt = data.read(buffer)) > 0) {
                    out.write(buffer, 0, amt);
                    total += (long)amt;
                }
            }
            finally {
                data.close();
            }
            out.close(false);
            if (total < lob.getLength()) {
                new BlobImpl(lob).setLength(total);
            }
            txn.commit();
        }
        catch (IOException e) {
            if (e.getCause() instanceof RepositoryException) {
                RepositoryException re = (RepositoryException)e.getCause();
                throw re.toPersistException();
            }
            throw e;
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
        finally {
            txn.exit();
        }
    }

    public void setClobValue(long locator, Clob data) throws PersistException, IOException {
        BlobImpl impl;
        if (data == null) {
            this.deleteLob(locator);
            return;
        }
        if (locator == 0L) {
            throw new IllegalArgumentException("Cannot use locator zero");
        }
        if (data instanceof ClobImpl && (impl = ((ClobImpl)data).getWrappedBlob()).getEnclosing() == this && impl.mLocator == locator) {
            return;
        }
        try {
            this.setClobValue(locator, data.openReader(0L, 0));
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClobValue(long locator, Reader data) throws PersistException, IOException {
        if (data == null) {
            this.deleteLob(locator);
            return;
        }
        if (locator == 0L) {
            throw new IllegalArgumentException("Cannot use locator zero");
        }
        Transaction txn = this.mRepo.enterTransaction(IsolationLevel.READ_COMMITTED);
        txn.setForUpdate(true);
        try {
            StoredLob lob = this.mLobStorage.prepare();
            lob.setLocator(locator);
            try {
                lob.load();
            }
            catch (FetchNoneException e) {
                throw new PersistNoneException("Lob deleted: " + this);
            }
            ClobImpl clob = new ClobImpl(lob);
            Writer writer = clob.openWriter(0L, 0);
            char[] buffer = new char[lob.getBlockSize() >> 1];
            long total = 0L;
            try {
                int amt;
                while ((amt = data.read(buffer)) > 0) {
                    writer.write(buffer, 0, amt);
                    total += (long)amt;
                }
            }
            finally {
                data.close();
            }
            writer.close();
            if (total < lob.getLength()) {
                clob.setLength(total);
            }
            txn.commit();
        }
        catch (IOException e) {
            if (e.getCause() instanceof RepositoryException) {
                RepositoryException re = (RepositoryException)e.getCause();
                throw re.toPersistException();
            }
            throw e;
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
        finally {
            txn.exit();
        }
    }

    public synchronized <S extends Storable> Trigger<S> getSupportTrigger(Class<S> type, int blockSize) {
        LobEngineTrigger<S> trigger;
        Object key = KeyFactory.createKey((Object[])new Object[]{type, blockSize});
        LobEngineTrigger<S> lobEngineTrigger = trigger = this.mTriggers == null ? null : (LobEngineTrigger<S>)this.mTriggers.get(key);
        if (trigger == null) {
            StorableInfo<S> info = StorableIntrospector.examine(type);
            ArrayList<BlobProperty> lobProperties = null;
            for (StorableProperty<S> prop : info.getAllProperties().values()) {
                if (Blob.class.isAssignableFrom(prop.getType())) {
                    if (lobProperties == null) {
                        lobProperties = new ArrayList<BlobProperty>();
                    }
                    lobProperties.add(new BlobProperty(this, prop.getName()));
                    continue;
                }
                if (!Clob.class.isAssignableFrom(prop.getType())) continue;
                if (lobProperties == null) {
                    lobProperties = new ArrayList();
                }
                lobProperties.add((BlobProperty)((Object)new ClobProperty(this, prop.getName())));
            }
            if (lobProperties != null) {
                trigger = new LobEngineTrigger<S>(this, type, blockSize, lobProperties);
            }
            if (this.mTriggers == null) {
                this.mTriggers = SoftValuedCache.newCache(7);
            }
            this.mTriggers.put(key, trigger);
        }
        return trigger;
    }

    private class Output
    extends OutputStream {
        private final StoredLob mStoredLob;
        private long mPos;
        private int mBlockNumber;
        private int mBlockPos;
        private Transaction mTxn;
        private StoredLob.Block mStoredBlock;
        private byte[] mBlockData;
        private int mBlockLength;
        private boolean mDoInsert;

        Output(StoredLob lob, long pos, Transaction txn) throws PersistException {
            this.mStoredLob = lob;
            this.mPos = pos;
            this.mBlockNumber = (int)(pos / (long)lob.getBlockSize()) - Integer.MIN_VALUE;
            this.mBlockPos = (int)(pos % (long)lob.getBlockSize());
            this.mTxn = txn;
        }

        public synchronized void write(int b) throws IOException {
            if (this.mTxn == null) {
                throw new IOException("Closed");
            }
            this.prepareBlockData();
            int blockPos = this.mBlockPos;
            if (blockPos >= this.mBlockData.length) {
                byte[] newBlockData = new byte[this.mStoredLob.getBlockSize()];
                System.arraycopy(this.mBlockData, 0, newBlockData, 0, this.mBlockData.length);
                this.mBlockData = newBlockData;
            }
            this.mBlockData[blockPos++] = (byte)b;
            if (blockPos > this.mBlockLength) {
                this.mBlockLength = blockPos;
            }
            if (blockPos >= this.mStoredLob.getBlockSize()) {
                ++this.mBlockNumber;
                blockPos = 0;
            }
            this.mBlockPos = blockPos;
            ++this.mPos;
        }

        public void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }

        public synchronized void write(byte[] bytes, int offset, int length) throws IOException {
            if (length <= 0) {
                return;
            }
            if (this.mTxn == null) {
                throw new IOException("Closed");
            }
            while (length > 0) {
                this.prepareBlockData();
                int avail = this.mStoredLob.getBlockSize() - this.mBlockPos;
                if (avail > length) {
                    avail = length;
                }
                if (this.mBlockPos + avail >= this.mBlockData.length) {
                    byte[] newBlockData = new byte[this.mStoredLob.getBlockSize()];
                    System.arraycopy(this.mBlockData, 0, newBlockData, 0, this.mBlockData.length);
                    this.mBlockData = newBlockData;
                }
                System.arraycopy(bytes, offset, this.mBlockData, this.mBlockPos, avail);
                offset += avail;
                length -= avail;
                this.mBlockPos += avail;
                if (this.mBlockPos > this.mBlockLength) {
                    this.mBlockLength = this.mBlockPos;
                }
                if (this.mBlockPos >= this.mStoredLob.getBlockSize()) {
                    ++this.mBlockNumber;
                    this.mBlockPos = 0;
                }
                this.mPos += (long)avail;
            }
        }

        public synchronized void flush() throws IOException {
            if (this.mTxn == null) {
                throw new IOException("Closed");
            }
            try {
                this.updateBlock();
            }
            catch (PersistException e) {
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw LobEngine.toIOException(e);
            }
        }

        public void close() throws IOException {
            this.close(true);
        }

        synchronized void close(boolean commit) throws IOException {
            if (this.mTxn != null) {
                try {
                    this.updateBlock();
                    if (this.mPos > this.mStoredLob.getLength()) {
                        this.mStoredLob.setLength(this.mPos);
                        this.mStoredLob.update();
                    }
                    if (commit) {
                        this.mTxn.commit();
                    }
                }
                catch (PersistException e) {
                    throw LobEngine.toIOException(e);
                }
                finally {
                    if (commit) {
                        try {
                            this.mTxn.exit();
                        }
                        catch (PersistException e) {
                            throw LobEngine.toIOException(e);
                        }
                    }
                }
                this.mTxn = null;
            }
        }

        private void updateBlock() throws PersistException {
            if (this.mStoredBlock != null) {
                byte[] blockData = this.mBlockData;
                if (blockData.length != this.mBlockLength) {
                    byte[] truncated = new byte[this.mBlockLength];
                    System.arraycopy(blockData, 0, truncated, 0, truncated.length);
                    blockData = truncated;
                }
                this.mStoredBlock.setData(blockData);
                if (this.mDoInsert) {
                    this.mStoredBlock.insert();
                    this.mDoInsert = false;
                } else {
                    this.mStoredBlock.update();
                }
            }
        }

        private void prepareBlockData() throws IOException {
            if (this.mStoredBlock == null || this.mBlockNumber > this.mStoredBlock.getBlockNumber()) {
                try {
                    this.updateBlock();
                    this.mStoredBlock = LobEngine.this.mLobBlockStorage.prepare();
                    this.mStoredBlock.setLocator(this.mStoredLob.getLocator());
                    this.mStoredBlock.setBlockNumber(this.mBlockNumber);
                    try {
                        if (this.mStoredBlock.tryLoad()) {
                            this.mBlockData = this.mStoredBlock.getData();
                            this.mBlockLength = this.mBlockData.length;
                            this.mDoInsert = false;
                        } else {
                            this.mBlockData = new byte[this.mStoredLob.getBlockSize()];
                            this.mBlockLength = 0;
                            this.mDoInsert = true;
                        }
                    }
                    catch (FetchException e) {
                        throw e.toPersistException();
                    }
                }
                catch (PersistException e) {
                    try {
                        this.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw LobEngine.toIOException(e);
                }
            }
        }
    }

    private class Input
    extends InputStream {
        private final long mLocator;
        private final int mBlockSize;
        private final long mLength;
        private long mPos;
        private int mBlockNumber;
        private int mBlockPos;
        private Transaction mTxn;
        private Cursor<StoredLob.Block> mCursor;
        private StoredLob.Block mStoredBlock;

        Input(StoredLob lob, long pos, Transaction txn) throws FetchException {
            this.mLocator = lob.getLocator();
            this.mBlockSize = lob.getBlockSize();
            this.mLength = lob.getLength();
            this.mPos = pos;
            this.mBlockNumber = (int)(pos / (long)this.mBlockSize) - Integer.MIN_VALUE;
            this.mBlockPos = (int)(pos % (long)this.mBlockSize);
            this.mTxn = txn;
            this.mCursor = LobEngine.this.mLobBlockStorage.query("locator = ? & blockNumber >= ?").with(this.mLocator).with(this.mBlockNumber).fetch();
        }

        public synchronized int read() throws IOException {
            if (this.mCursor == null) {
                throw new IOException("Closed");
            }
            if (this.mPos >= this.mLength) {
                return -1;
            }
            byte[] block = this.getBlockData();
            int blockPos = this.mBlockPos;
            int b = block == null || blockPos >= block.length ? 0 : block[blockPos] & 0xFF;
            ++this.mPos;
            if (++blockPos >= this.mBlockSize) {
                ++this.mBlockNumber;
                blockPos = 0;
            }
            this.mBlockPos = blockPos;
            return b;
        }

        public int read(byte[] bytes) throws IOException {
            return this.read(bytes, 0, bytes.length);
        }

        public synchronized int read(byte[] bytes, int offset, int length) throws IOException {
            if (length <= 0) {
                return 0;
            }
            if (this.mCursor == null) {
                throw new IOException("Closed");
            }
            int avail = Math.min((int)(this.mLength - this.mPos), this.mBlockSize - this.mBlockPos);
            if (avail <= 0) {
                return -1;
            }
            if (length > avail) {
                length = avail;
            }
            byte[] block = this.getBlockData();
            int blockPos = this.mBlockPos;
            if (block == null) {
                Arrays.fill(bytes, offset, offset + length, (byte)0);
            } else {
                int blockAvail = block.length - blockPos;
                if (blockAvail >= length) {
                    System.arraycopy(block, blockPos, bytes, offset, length);
                } else {
                    System.arraycopy(block, blockPos, bytes, offset, blockAvail);
                    Arrays.fill(bytes, offset + blockAvail, offset + length, (byte)0);
                }
            }
            this.mPos += (long)length;
            if ((blockPos += length) >= this.mBlockSize) {
                ++this.mBlockNumber;
                blockPos = 0;
            }
            this.mBlockPos = blockPos;
            return length;
        }

        public synchronized long skip(long n) throws IOException {
            long newPos;
            if (n <= 0L) {
                return 0L;
            }
            if (this.mCursor == null) {
                throw new IOException("Closed");
            }
            long oldPos = this.mPos;
            if (n > Integer.MAX_VALUE) {
                n = Integer.MAX_VALUE;
            }
            if ((newPos = oldPos + n) >= this.mLength && (n = (newPos = this.mLength) - oldPos) <= 0L) {
                return 0L;
            }
            this.mPos = newPos;
            this.mBlockNumber = (int)(newPos / (long)this.mBlockSize) - Integer.MIN_VALUE;
            this.mBlockPos = (int)(newPos % (long)this.mBlockSize);
            return n;
        }

        public synchronized void close() throws IOException {
            if (this.mTxn != null) {
                try {
                    this.mTxn.exit();
                }
                catch (PersistException e) {
                    throw LobEngine.toIOException(e);
                }
                this.mTxn = null;
            }
            if (this.mCursor != null) {
                try {
                    this.mCursor.close();
                }
                catch (FetchException e) {
                    throw LobEngine.toIOException(e);
                }
                this.mCursor = null;
                this.mStoredBlock = null;
            }
        }

        private byte[] getBlockData() throws IOException {
            while (this.mStoredBlock == null || this.mBlockNumber > this.mStoredBlock.getBlockNumber()) {
                try {
                    if (!this.mCursor.hasNext()) {
                        this.mStoredBlock = null;
                        return null;
                    }
                    this.mStoredBlock = this.mCursor.next();
                }
                catch (FetchException e) {
                    try {
                        this.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw LobEngine.toIOException(e);
                }
            }
            if (this.mBlockNumber < this.mStoredBlock.getBlockNumber()) {
                return null;
            }
            return this.mStoredBlock.getData();
        }
    }

    private class ClobImpl
    extends BlobClob
    implements Lob {
        ClobImpl(long locator) {
            super(new BlobImpl(locator));
        }

        ClobImpl(StoredLob lob) {
            super(new BlobImpl(lob));
        }

        public Long getLocator() {
            return ((BlobImpl)super.getWrappedBlob()).getLocator();
        }

        public int hashCode() {
            return super.getWrappedBlob().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ClobImpl) {
                return this.getWrappedBlob().equals(((ClobImpl)obj).getWrappedBlob());
            }
            return false;
        }

        public String toString() {
            return "Clob@" + this.getLocator();
        }

        protected BlobImpl getWrappedBlob() {
            return (BlobImpl)super.getWrappedBlob();
        }
    }

    private class BlobImpl
    extends AbstractBlob
    implements Lob {
        final Long mLocator;
        final StoredLob mStoredLob;

        BlobImpl(long locator) {
            super(LobEngine.this.mRepo);
            this.mLocator = locator;
            this.mStoredLob = null;
        }

        BlobImpl(StoredLob lob) {
            super(LobEngine.this.mRepo);
            this.mLocator = lob.getLocator();
            this.mStoredLob = lob;
        }

        public InputStream openInputStream() throws FetchException {
            return this.openInputStream(0L);
        }

        public InputStream openInputStream(long pos) throws FetchException {
            if (pos < 0L) {
                throw new IllegalArgumentException("Position is negative: " + pos);
            }
            StoredLob lob = this.mStoredLob;
            Transaction txn = LobEngine.this.mRepo.enterTransaction(IsolationLevel.READ_COMMITTED);
            if (lob == null) {
                lob = LobEngine.this.mLobStorage.prepare();
                lob.setLocator(this.mLocator);
                try {
                    lob.load();
                }
                catch (FetchException e) {
                    try {
                        txn.exit();
                    }
                    catch (PersistException e2) {
                        // empty catch block
                    }
                    if (e instanceof FetchNoneException) {
                        throw new FetchNoneException("Lob deleted: " + this);
                    }
                    throw e;
                }
            }
            return new Input(lob, pos, txn);
        }

        public InputStream openInputStream(long pos, int bufferSize) throws FetchException {
            return this.openInputStream(pos);
        }

        public long getLength() throws FetchException {
            StoredLob lob = this.mStoredLob;
            if (lob == null) {
                lob = LobEngine.this.mLobStorage.prepare();
                lob.setLocator(this.mLocator);
                try {
                    lob.load();
                }
                catch (FetchNoneException e) {
                    throw new FetchNoneException("Lob deleted: " + this);
                }
            }
            return lob.getLength();
        }

        public OutputStream openOutputStream() throws PersistException {
            return this.openOutputStream(0L);
        }

        public OutputStream openOutputStream(long pos) throws PersistException {
            if (pos < 0L) {
                throw new IllegalArgumentException("Position is negative: " + pos);
            }
            StoredLob lob = this.mStoredLob;
            Transaction txn = LobEngine.this.mRepo.enterTransaction(IsolationLevel.READ_COMMITTED);
            txn.setForUpdate(true);
            try {
                if (lob == null) {
                    lob = LobEngine.this.mLobStorage.prepare();
                    lob.setLocator(this.mLocator);
                    try {
                        lob.load();
                    }
                    catch (FetchNoneException e) {
                        throw new PersistNoneException("Lob deleted: " + this);
                    }
                    catch (FetchException e) {
                        throw e.toPersistException();
                    }
                }
                return new Output(lob, pos, txn);
            }
            catch (PersistException e) {
                try {
                    txn.exit();
                }
                catch (PersistException e2) {
                    // empty catch block
                }
                throw e;
            }
        }

        public OutputStream openOutputStream(long pos, int bufferSize) throws PersistException {
            return this.openOutputStream(pos);
        }

        public void setLength(long length) throws PersistException {
            if (length < 0L) {
                throw new IllegalArgumentException("Length is negative: " + length);
            }
            Transaction txn = LobEngine.this.mRepo.enterTransaction();
            try {
                long oldLength;
                StoredLob lob = this.mStoredLob;
                if (lob == null) {
                    lob = LobEngine.this.mLobStorage.prepare();
                    lob.setLocator(this.mLocator);
                    txn.setForUpdate(true);
                    try {
                        lob.load();
                    }
                    catch (FetchNoneException e) {
                        throw new PersistNoneException("Lob deleted: " + this);
                    }
                    txn.setForUpdate(false);
                }
                if (length == (oldLength = lob.getLength())) {
                    return;
                }
                long oldBlockCount = lob.getBlockCount();
                lob.setLength(length);
                if (length < oldLength) {
                    int lastBlockLength;
                    long newBlockCount = lob.getBlockCount();
                    if (newBlockCount < oldBlockCount) {
                        LobEngine.this.mLobBlockStorage.query("locator = ? & blockNumber >= ?").with(lob.getLocator()).with((int)newBlockCount - Integer.MIN_VALUE).deleteAll();
                    }
                    if ((lastBlockLength = lob.getLastBlockLength()) != 0) {
                        byte[] data;
                        StoredLob.Block block = LobEngine.this.mLobBlockStorage.prepare();
                        block.setLocator(this.mLocator);
                        block.setBlockNumber((int)newBlockCount - -2147483647);
                        txn.setForUpdate(true);
                        if (block.tryLoad() && (data = block.getData()).length > lastBlockLength) {
                            byte[] newData = new byte[lastBlockLength];
                            System.arraycopy(data, 0, newData, 0, lastBlockLength);
                            block.setData(newData);
                            block.update();
                        }
                        txn.setForUpdate(false);
                    }
                }
                lob.update();
                txn.commit();
            }
            catch (FetchException e) {
                throw e.toPersistException();
            }
            finally {
                txn.exit();
            }
        }

        public Long getLocator() {
            return this.mLocator;
        }

        public int hashCode() {
            return this.mLocator.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof BlobImpl) {
                BlobImpl other = (BlobImpl)obj;
                return LobEngine.this == other.getEnclosing() && this.mLocator.equals(other.mLocator);
            }
            return false;
        }

        public String toString() {
            return "Blob@" + this.getLocator();
        }

        LobEngine getEnclosing() {
            return LobEngine.this;
        }
    }
}

