/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.spi;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchInterruptedException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistInterruptedException;
import com.amazon.carbonado.RepositoryException;
import java.io.InterruptedIOException;
import java.nio.channels.ClosedByInterruptException;

public class ExceptionTransformer {
    private static ExceptionTransformer cInstance;

    public static ExceptionTransformer getInstance() {
        if (cInstance == null) {
            cInstance = new ExceptionTransformer();
        }
        return cInstance;
    }

    public FetchException toFetchException(Throwable e) {
        FetchException fe = this.transformIntoFetchException(e);
        if (fe != null) {
            return fe;
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            fe = this.transformIntoFetchException(cause);
            if (fe != null) {
                return fe;
            }
        } else {
            cause = e;
        }
        return new FetchException(cause);
    }

    public PersistException toPersistException(Throwable e) {
        PersistException pe = this.transformIntoPersistException(e);
        if (pe != null) {
            return pe;
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            pe = this.transformIntoPersistException(cause);
            if (pe != null) {
                return pe;
            }
        } else {
            cause = e;
        }
        return new PersistException(cause);
    }

    public RepositoryException toRepositoryException(Throwable e) {
        RepositoryException re = this.transformIntoRepositoryException(e);
        if (re != null) {
            return re;
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            re = this.transformIntoRepositoryException(cause);
            if (re != null) {
                return re;
            }
        } else {
            cause = e;
        }
        return new RepositoryException(cause);
    }

    protected FetchException transformIntoFetchException(Throwable e) {
        if (e instanceof FetchException) {
            return (FetchException)e;
        }
        if (e instanceof InterruptedIOException || e instanceof ClosedByInterruptException) {
            return new FetchInterruptedException(e);
        }
        return null;
    }

    protected PersistException transformIntoPersistException(Throwable e) {
        if (e instanceof PersistException) {
            return (PersistException)e;
        }
        if (e instanceof InterruptedIOException) {
            return new PersistInterruptedException(e);
        }
        if (e instanceof FetchException) {
            return ((FetchException)e).toPersistException();
        }
        return null;
    }

    protected RepositoryException transformIntoRepositoryException(Throwable e) {
        if (e instanceof RepositoryException) {
            return (RepositoryException)e;
        }
        RepositoryException re = this.transformIntoFetchException(e);
        if (re != null) {
            return re;
        }
        re = this.transformIntoPersistException(e);
        if (re != null) {
            return re;
        }
        return null;
    }
}

