/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.sleepycat;

import com.amazon.carbonado.ConfigurationException;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.raw.CompressedStorableCodecFactory;
import com.amazon.carbonado.raw.CompressionType;
import com.amazon.carbonado.raw.StorableCodecFactory;
import com.amazon.carbonado.repo.indexed.IndexedRepositoryBuilder;
import com.amazon.carbonado.repo.sleepycat.BDBProduct;
import com.amazon.carbonado.repo.sleepycat.BDBRepository;
import com.amazon.carbonado.spi.AbstractRepositoryBuilder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.cojen.util.ThrowUnchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BDBRepositoryBuilder
extends AbstractRepositoryBuilder {
    private static final BDBProduct DEFAULT_PRODUCT = BDBProduct.JE;
    private static final int DEFAULT_CHECKPOINT_INTERVAL = 10000;
    private String mName;
    private boolean mIsMaster = true;
    private BDBProduct mProduct = DEFAULT_PRODUCT;
    private File mEnvHome;
    private File mDataHome;
    private String mSingleFileName;
    private Map<String, String> mFileNames;
    private boolean mIndexSupport = true;
    private boolean mIndexRepairEnabled = true;
    private double mIndexThrottle = 1.0;
    private boolean mReadOnly;
    private Long mCacheSize;
    private Integer mCachePercent;
    private Integer mLogRegionSize;
    private double mLockTimeout = 0.5;
    private Integer mMaxLocks;
    private double mTxnTimeout = 300.0;
    private boolean mTxnNoSync;
    private boolean mTxnWriteNoSync;
    private Integer mTxnMaxActive = 1000;
    private Boolean mDatabasesTransactional = null;
    private boolean mReverseSplitOff;
    private Map<Class<?>, Integer> mDatabasePageSizes;
    private boolean mPrivate;
    private boolean mMultiversion;
    private boolean mLogInMemory;
    private Integer mLogFileMaxSize;
    private boolean mInitializeLogging;
    private boolean mRunFullRecovery;
    private boolean mRunCheckpointer = true;
    private int mCheckpointInterval = 10000;
    private int mCheckpointThresholdKB = 1024;
    private int mCheckpointThresholdMinutes = 1;
    private boolean mKeepOldLogFiles;
    private boolean mRunDeadlockDetector = true;
    private Boolean mChecksumEnabled;
    private Object mInitialEnvConfig = null;
    private Object mInitialDBConfig = null;
    private StorableCodecFactory mStorableCodecFactory;
    private Runnable mPreShutdownHook;
    private Runnable mPostShutdownHook;
    private DatabaseHook mDatabaseHook;
    private Map<String, CompressionType> mCompressionMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository build(AtomicReference<Repository> rootRef) throws RepositoryException {
        BDBRepository repo;
        if (this.mIndexSupport) {
            this.mIndexSupport = false;
            try {
                IndexedRepositoryBuilder ixBuilder = new IndexedRepositoryBuilder();
                ixBuilder.setWrappedRepository(this);
                ixBuilder.setMaster(this.isMaster());
                ixBuilder.setIndexRepairEnabled(this.mIndexRepairEnabled);
                ixBuilder.setIndexRepairThrottle(this.mIndexThrottle);
                Repository repository = ixBuilder.build(rootRef);
                return repository;
            }
            finally {
                this.mIndexSupport = true;
            }
        }
        if (this.mStorableCodecFactory == null) {
            this.mStorableCodecFactory = new CompressedStorableCodecFactory(this.mCompressionMap);
        }
        this.assertReady();
        File homeFile = this.getEnvironmentHomeFile();
        if (!homeFile.exists() && !homeFile.mkdirs()) {
            throw new RepositoryException("Unable to make environment home directory: " + homeFile);
        }
        try {
            repo = this.getRepositoryConstructor().newInstance(rootRef, this);
        }
        catch (Exception e) {
            ThrowUnchecked.fireFirstDeclaredCause((Throwable)e, (Class[])new Class[]{RepositoryException.class});
            return null;
        }
        rootRef.set(repo);
        return repo;
    }

    /*
     * Loose catch block
     */
    public boolean verify(PrintStream out) throws RepositoryException {
        StorableCodecFactory codecFactory = this.mStorableCodecFactory;
        String name = this.mName;
        boolean readOnly = this.mReadOnly;
        boolean runCheckpointer = this.mRunCheckpointer;
        boolean runDeadlockDetector = this.mRunDeadlockDetector;
        boolean isPrivate = this.mPrivate;
        if (this.mName == null) {
            this.mName = "BDB verification";
        }
        if (this.mStorableCodecFactory == null) {
            this.mStorableCodecFactory = new CompressedStorableCodecFactory(this.mCompressionMap);
        }
        this.mReadOnly = true;
        this.mRunCheckpointer = false;
        this.mRunDeadlockDetector = false;
        try {
            BDBRepository repo;
            this.assertReady();
            File homeFile = this.getEnvironmentHomeFile();
            if (!homeFile.exists()) {
                throw new RepositoryException("Environment home directory does not exist: " + homeFile);
            }
            AtomicReference<BDBRepository> rootRef = new AtomicReference<BDBRepository>();
            try {
                repo = this.getRepositoryConstructor().newInstance(rootRef, this);
            }
            catch (Exception e) {
                ThrowUnchecked.fireFirstDeclaredCause((Throwable)e, (Class[])new Class[]{RepositoryException.class});
                boolean bl = false;
                this.mName = name;
                this.mStorableCodecFactory = codecFactory;
                this.mReadOnly = readOnly;
                this.mRunCheckpointer = runCheckpointer;
                this.mRunDeadlockDetector = runDeadlockDetector;
                return bl;
            }
            rootRef.set(repo);
            try {
                boolean e = repo.verify(out);
                return e;
            }
            catch (Exception e) {
                throw repo.toRepositoryException(e);
            }
            finally {
                repo.close();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.mName = name;
            this.mStorableCodecFactory = codecFactory;
            this.mReadOnly = readOnly;
            this.mRunCheckpointer = runCheckpointer;
            this.mRunDeadlockDetector = runDeadlockDetector;
        }
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public boolean isMaster() {
        return this.mIsMaster;
    }

    @Override
    public void setMaster(boolean b) {
        this.mIsMaster = b;
    }

    public void setProduct(String product) {
        this.mProduct = product == null ? DEFAULT_PRODUCT : BDBProduct.forString(product);
    }

    public String getProduct() {
        return this.mProduct.toString();
    }

    public void setBDBProduct(BDBProduct product) {
        this.mProduct = product == null ? DEFAULT_PRODUCT : product;
    }

    public BDBProduct getBDBProduct() {
        return this.mProduct;
    }

    public void setEnvironmentHomeFile(File envHome) {
        try {
            envHome = envHome.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mEnvHome = envHome;
    }

    public File getEnvironmentHomeFile() {
        return this.mEnvHome;
    }

    public void setEnvironmentHome(String envHome) {
        this.setEnvironmentHomeFile(new File(envHome));
    }

    public String getEnvironmentHome() {
        return this.mEnvHome.getPath();
    }

    public void setDataHomeFile(File dir) {
        if (dir != null) {
            try {
                dir = dir.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mDataHome = dir;
    }

    public File getDataHomeFile() {
        if (this.mDataHome == null) {
            return this.getEnvironmentHomeFile();
        }
        return this.mDataHome;
    }

    public void setDataHome(String dir) {
        if (dir == null) {
            this.mDataHome = null;
        } else {
            this.setDataHomeFile(new File(dir));
        }
    }

    public String getDataHome() {
        return this.getDataHomeFile().getPath();
    }

    public void setSingleFileName(String filename) {
        this.mSingleFileName = filename;
        this.mFileNames = null;
    }

    public String getSingleFileName() {
        return this.mSingleFileName;
    }

    public void setFileName(String filename, String typeName) {
        this.mSingleFileName = null;
        if (this.mFileNames == null) {
            this.mFileNames = new HashMap<String, String>();
        }
        this.mFileNames.put(typeName, filename);
    }

    Map<String, String> getFileNameMap() {
        if (this.mFileNames == null) {
            return null;
        }
        return new HashMap<String, String>(this.mFileNames);
    }

    public void setIndexSupport(boolean indexSupport) {
        this.mIndexSupport = indexSupport;
    }

    public boolean getIndexSupport() {
        return this.mIndexSupport;
    }

    public boolean isIndexRepairEnabled() {
        return this.mIndexRepairEnabled;
    }

    public void setIndexRepairEnabled(boolean enabled) {
        this.mIndexRepairEnabled = enabled;
    }

    public double getIndexRepairThrottle() {
        return this.mIndexThrottle;
    }

    public void setIndexRepairThrottle(double desiredSpeed) {
        this.mIndexThrottle = desiredSpeed;
    }

    public void setReadOnly(boolean readOnly) {
        this.mReadOnly = readOnly;
    }

    public boolean getReadOnly() {
        return this.mReadOnly;
    }

    public void setCacheSize(long cacheSize) {
        this.mCacheSize = cacheSize;
    }

    public void setCacheSize(Long cacheSize) {
        this.mCacheSize = cacheSize;
    }

    public Long getCacheSize() {
        return this.mCacheSize;
    }

    public void setLogRegionSize(int logRegionSize) {
        this.mLogRegionSize = logRegionSize;
    }

    public void setLogRegionSize(Integer logRegionSize) {
        this.mLogRegionSize = logRegionSize;
    }

    public Integer getLogRegionSize() {
        return this.mLogRegionSize;
    }

    public void setCachePercent(int cachePercent) {
        this.mCachePercent = cachePercent;
    }

    public void setCachePercent(Integer cachePercent) {
        this.mCachePercent = cachePercent;
    }

    public Integer getCachePercent() {
        return this.mCachePercent;
    }

    public void setLockTimeout(double lockTimeout) {
        this.mLockTimeout = lockTimeout;
    }

    public double getLockTimeout() {
        return this.mLockTimeout;
    }

    public long getLockTimeoutInMicroseconds() {
        return this.inMicros(this.mLockTimeout);
    }

    public void setMaxLocks(Integer max) {
        this.mMaxLocks = max;
    }

    public Integer getMaxLocks() {
        return this.mMaxLocks;
    }

    public void setTransactionTimeout(double txnTimeout) {
        this.mTxnTimeout = txnTimeout;
    }

    public double getTransactionTimeout() {
        return this.mTxnTimeout;
    }

    public long getTransactionTimeoutInMicroseconds() {
        return this.inMicros(this.mTxnTimeout);
    }

    public void setTransactionNoSync(boolean noSync) {
        this.mTxnNoSync = noSync;
    }

    public boolean getTransactionNoSync() {
        return this.mTxnNoSync;
    }

    public void setTransactionWriteNoSync(boolean noSync) {
        this.mTxnWriteNoSync = noSync;
    }

    public boolean getTransactionWriteNoSync() {
        return this.mTxnWriteNoSync;
    }

    public void setTransactionMaxActive(Integer max) {
        this.mTxnMaxActive = max;
    }

    public Integer getTransactionMaxActive() {
        return this.mTxnMaxActive;
    }

    public void setDatabasesTransactional(Boolean transactional) {
        this.mDatabasesTransactional = transactional;
    }

    public Boolean getDatabasesTransactional() {
        return this.mDatabasesTransactional;
    }

    public void setReverseSplitOff(boolean off) {
        this.mReverseSplitOff = off;
    }

    public boolean isReverseSplitOff() {
        return this.mReverseSplitOff;
    }

    public void setDatabasePageSize(Integer bytes, Class<? extends Storable> type) {
        if (this.mDatabasePageSizes == null) {
            this.mDatabasePageSizes = new HashMap();
        }
        this.mDatabasePageSizes.put(type, bytes);
    }

    Map<Class<?>, Integer> getDatabasePagesMap() {
        if (this.mDatabasePageSizes == null) {
            return null;
        }
        return new HashMap(this.mDatabasePageSizes);
    }

    public void setPrivate(boolean b) {
        this.mPrivate = b;
    }

    public boolean isPrivate() {
        return this.mPrivate;
    }

    public void setMultiversion(boolean multiversion) {
        this.mMultiversion = multiversion;
    }

    public boolean isMultiversion() {
        return this.mMultiversion;
    }

    public void setLogInMemory(boolean logInMemory) {
        this.mLogInMemory = logInMemory;
    }

    public boolean getLogInMemory() {
        return this.mLogInMemory;
    }

    public void setLogFileMaxSize(Integer sizeInBytes) {
        this.mLogFileMaxSize = sizeInBytes;
    }

    public Integer getLogFileMaxSize() {
        return this.mLogFileMaxSize;
    }

    public void setInitializeLogging(boolean b) {
        this.mInitializeLogging = b;
    }

    public boolean getInitializeLogging() {
        return this.mInitializeLogging;
    }

    public void setRunFullRecovery(boolean runRecovery) {
        this.mRunFullRecovery = runRecovery;
    }

    public boolean getRunFullRecovery() {
        return this.mRunFullRecovery;
    }

    public void setRunCheckpointer(boolean runCheckpointer) {
        this.mRunCheckpointer = runCheckpointer;
    }

    public boolean getRunCheckpointer() {
        return this.mRunCheckpointer;
    }

    public void setCheckpointInterval(int intervalMillis) {
        this.mCheckpointInterval = intervalMillis;
    }

    public int getCheckpointInterval() {
        return this.mCheckpointInterval;
    }

    public void setCheckpointThresholdKB(int thresholdKB) {
        this.mCheckpointThresholdKB = thresholdKB;
    }

    public int getCheckpointThresholdKB() {
        return this.mCheckpointThresholdKB;
    }

    public void setCheckpointThresholdMinutes(int thresholdMinutes) {
        this.mCheckpointThresholdMinutes = thresholdMinutes;
    }

    public int getCheckpointThresholdMinutes() {
        return this.mCheckpointThresholdMinutes;
    }

    public void setKeepOldLogFiles(boolean keep) {
        this.mKeepOldLogFiles = keep;
    }

    public boolean getKeepOldLogFiles() {
        return this.mKeepOldLogFiles;
    }

    public void setRunDeadlockDetector(boolean runDeadlockDetector) {
        this.mRunDeadlockDetector = runDeadlockDetector;
    }

    public boolean getRunDeadlockDetector() {
        return this.mRunDeadlockDetector;
    }

    public void setChecksumEnabled(Boolean checksumEnabled) {
        this.mChecksumEnabled = checksumEnabled;
    }

    public Boolean getChecksumEnabled() {
        return this.mChecksumEnabled;
    }

    public void setInitialEnvironmentConfig(Object envConfig) {
        this.mInitialEnvConfig = envConfig;
    }

    public Object getInitialEnvironmentConfig() {
        return this.mInitialEnvConfig;
    }

    public void setInitialDatabaseConfig(Object dbConfig) {
        this.mInitialDBConfig = dbConfig;
    }

    public Object getInitialDatabaseConfig() {
        return this.mInitialDBConfig;
    }

    public void setStorableCodecFactory(StorableCodecFactory factory) {
        this.mStorableCodecFactory = factory;
    }

    public StorableCodecFactory getStorableCodecFactory() {
        return this.mStorableCodecFactory;
    }

    public void setPreShutdownHook(Runnable hook) {
        this.mPreShutdownHook = hook;
    }

    public Runnable getPreShutdownHook() {
        return this.mPreShutdownHook;
    }

    public void setShutdownHook(Runnable hook) {
        this.mPostShutdownHook = hook;
    }

    public Runnable getShutdownHook() {
        return this.mPostShutdownHook;
    }

    public void setDatabaseHook(DatabaseHook hook) {
        this.mDatabaseHook = hook;
    }

    public DatabaseHook getDatabaseHook() {
        return this.mDatabaseHook;
    }

    public void setCompressor(String type, String compressionType) {
        CompressionType compressionEnum;
        this.mStorableCodecFactory = null;
        compressionType = compressionType.toUpperCase();
        if (this.mCompressionMap == null) {
            this.mCompressionMap = new HashMap<String, CompressionType>();
        }
        if ((compressionEnum = CompressionType.valueOf(compressionType)) != null) {
            this.mCompressionMap.put(type, compressionEnum);
        }
    }

    public String getCompressor(String type) {
        if (this.mCompressionMap == null) {
            return null;
        }
        return this.mCompressionMap.get(type).toString();
    }

    private long inMicros(double seconds) {
        if (seconds >= 9.223372036854776E18) {
            return Long.MAX_VALUE;
        }
        if (seconds <= 0.0 || Double.isNaN(seconds)) {
            return 0L;
        }
        return (long)(seconds * 1000000.0);
    }

    @Override
    public void errorCheck(Collection<String> messages) throws ConfigurationException {
        block7: {
            Exception error;
            super.errorCheck(messages);
            try {
                this.getRepositoryConstructor();
                break block7;
            }
            catch (ClassCastException e) {
                error = e;
            }
            catch (ClassNotFoundException e) {
                error = e;
            }
            catch (NoSuchMethodException e) {
                error = e;
            }
            messages.add("BDB product \"" + this.getProduct() + "\" not supported: " + error);
        }
        File envHome = this.getEnvironmentHomeFile();
        if (envHome == null) {
            messages.add("environmentHome missing");
        } else if (envHome.exists() && !envHome.isDirectory()) {
            messages.add("environment home is not a directory: " + envHome);
        }
    }

    private Constructor<BDBRepository> getRepositoryConstructor() throws ClassCastException, ClassNotFoundException, NoSuchMethodException {
        String thisClassName = this.getClass().getName();
        String packageName = thisClassName.substring(0, thisClassName.lastIndexOf(46));
        String className = packageName + '.' + this.getBDBProduct().name() + "_Repository";
        Class<?> repoClass = Class.forName(className);
        if (BDBRepository.class.isAssignableFrom(repoClass)) {
            return repoClass.getDeclaredConstructor(AtomicReference.class, BDBRepositoryBuilder.class);
        }
        throw new ClassCastException("Not an instance of BDBRepository: " + repoClass.getName());
    }

    public static interface DatabaseHook {
        public String databaseName(String var1);

        public void prepareForOpening(Object var1) throws RepositoryException;
    }
}

