/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.replicated;

import com.amazon.carbonado.ConfigurationException;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryBuilder;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.TriggerFactory;
import com.amazon.carbonado.repo.replicated.ReplicatedRepository;
import com.amazon.carbonado.spi.AbstractRepositoryBuilder;
import com.amazon.carbonado.spi.BelatedRepositoryCreator;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicatedRepositoryBuilder
extends AbstractRepositoryBuilder {
    static final int DEFAULT_MASTER_TIMEOUT_MILLIS = 15000;
    static final int DEFAULT_RETRY_MILLIS = 30000;
    private String mName;
    private boolean mIsMaster = true;
    private RepositoryBuilder mReplicaRepositoryBuilder;
    private RepositoryBuilder mMasterRepositoryBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository build(AtomicReference<Repository> rootRef) throws RepositoryException {
        Repository replica;
        this.assertReady();
        final boolean originalOption = this.mReplicaRepositoryBuilder.isMaster();
        try {
            this.mReplicaRepositoryBuilder.setMaster(false);
            for (TriggerFactory factory : this.getTriggerFactories()) {
                this.mReplicaRepositoryBuilder.addTriggerFactory(factory);
            }
            replica = this.mReplicaRepositoryBuilder.build(rootRef);
        }
        finally {
            this.mReplicaRepositoryBuilder.setMaster(originalOption);
        }
        originalOption = this.mMasterRepositoryBuilder.isMaster();
        this.mMasterRepositoryBuilder.setMaster(this.mIsMaster);
        Log log = LogFactory.getLog(ReplicatedRepositoryBuilder.class);
        BelatedRepositoryCreator creator = new BelatedRepositoryCreator(log, this.mMasterRepositoryBuilder, rootRef, 30000){

            protected void createdNotification(Repository repo) {
                ReplicatedRepositoryBuilder.this.mMasterRepositoryBuilder.setMaster(originalOption);
            }
        };
        Repository master = (Repository)creator.get(15000);
        ReplicatedRepository repo = new ReplicatedRepository(this.getName(), replica, master);
        rootRef.set(repo);
        return repo;
    }

    @Override
    public String getName() {
        String name = this.mName;
        if (name == null) {
            if (this.mReplicaRepositoryBuilder != null && this.mReplicaRepositoryBuilder.getName() != null) {
                name = this.mReplicaRepositoryBuilder.getName();
            } else if (this.mMasterRepositoryBuilder != null) {
                name = this.mMasterRepositoryBuilder.getName();
            }
        }
        return name;
    }

    @Override
    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public boolean isMaster() {
        return this.mIsMaster;
    }

    @Override
    public void setMaster(boolean b) {
        this.mIsMaster = b;
    }

    public RepositoryBuilder getReplicaRepositoryBuilder() {
        return this.mReplicaRepositoryBuilder;
    }

    public void setReplicaRepositoryBuilder(RepositoryBuilder replicaRepositoryBuilder) {
        this.mReplicaRepositoryBuilder = replicaRepositoryBuilder;
    }

    public RepositoryBuilder getMasterRepositoryBuilder() {
        return this.mMasterRepositoryBuilder;
    }

    public void setMasterRepositoryBuilder(RepositoryBuilder masterRepositoryBuilder) {
        this.mMasterRepositoryBuilder = masterRepositoryBuilder;
    }

    @Override
    public void errorCheck(Collection<String> messages) throws ConfigurationException {
        super.errorCheck(messages);
        if (null == this.getReplicaRepositoryBuilder()) {
            messages.add("replicaRepositoryBuilder missing");
        }
        if (null == this.getMasterRepositoryBuilder()) {
            messages.add("masterRepositoryBuilder missing");
        }
    }
}

