/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.map;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchInterruptedException;
import com.amazon.carbonado.FetchTimeoutException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistInterruptedException;
import com.amazon.carbonado.PersistTimeoutException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.repo.map.MapStorage;
import com.amazon.carbonado.repo.map.UpgradableLock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapTransaction {
    private final MapTransaction mParent;
    private final IsolationLevel mLevel;
    private final Object mLocker;
    private final int mLockTimeout;
    private final TimeUnit mLockTimeoutUnit;
    private Set<UpgradableLock> mUpgradeLocks;
    private Set<UpgradableLock> mWriteLocks;
    private List<Undoable> mUndoLog;

    MapTransaction(MapTransaction parent, IsolationLevel level, int lockTimeout, TimeUnit lockTimeoutUnit) {
        this.mParent = parent;
        this.mLevel = level;
        this.mLocker = parent == null ? this : parent.mLocker;
        this.mLockTimeout = lockTimeout;
        this.mLockTimeoutUnit = lockTimeoutUnit;
    }

    void lockForUpgrade(UpgradableLock lock, boolean isForUpdate) throws FetchException {
        if (!isForUpdate && this.mLevel.isAtMost(IsolationLevel.READ_COMMITTED)) {
            this.doLockForUpgrade(lock);
        } else {
            Set<UpgradableLock> locks = this.mUpgradeLocks;
            if (locks == null) {
                this.mUpgradeLocks = locks = new HashSet<UpgradableLock>();
                this.doLockForUpgrade(lock);
                locks.add(lock);
            } else if (!locks.contains(lock)) {
                this.doLockForUpgrade(lock);
                locks.add(lock);
            }
        }
    }

    private void doLockForUpgrade(UpgradableLock lock) throws FetchException {
        try {
            if (!lock.tryLockForUpgrade(this.mLocker, this.mLockTimeout, this.mLockTimeoutUnit)) {
                throw new FetchTimeoutException("" + this.mLockTimeout + ' ' + this.mLockTimeoutUnit.toString().toLowerCase());
            }
        }
        catch (InterruptedException e) {
            throw new FetchInterruptedException(e);
        }
    }

    void unlockFromUpgrade(UpgradableLock lock, boolean isForUpdate) {
        if (!isForUpdate && this.mLevel.isAtMost(IsolationLevel.READ_COMMITTED)) {
            lock.unlockFromUpgrade(this.mLocker);
        }
    }

    void lockForWrite(UpgradableLock lock) throws PersistException {
        Set<UpgradableLock> locks = this.mWriteLocks;
        if (locks == null) {
            this.mWriteLocks = locks = new HashSet<UpgradableLock>();
            this.doLockForWrite(lock);
            locks.add(lock);
        } else if (!locks.contains(lock)) {
            this.doLockForWrite(lock);
            locks.add(lock);
        }
    }

    private void doLockForWrite(UpgradableLock lock) throws PersistException {
        try {
            if (!lock.tryLockForWrite(this.mLocker, this.mLockTimeout, this.mLockTimeoutUnit)) {
                throw new PersistTimeoutException("" + this.mLockTimeout + ' ' + this.mLockTimeoutUnit.toString().toLowerCase());
            }
        }
        catch (InterruptedException e) {
            throw new PersistInterruptedException(e);
        }
    }

    <S extends Storable> void inserted(final MapStorage<S> storage, final S key) {
        this.addToUndoLog(new Undoable(){

            public void undo() {
                storage.mapRemove(key);
            }

            public String toString() {
                return "undo insert by remove: " + key;
            }
        });
    }

    <S extends Storable> void updated(final MapStorage<S> storage, final S old) {
        this.addToUndoLog(new Undoable(){

            public void undo() {
                storage.mapPut(old);
            }

            public String toString() {
                return "undo update by put: " + old;
            }
        });
    }

    <S extends Storable> void deleted(final MapStorage<S> storage, final S old) {
        this.addToUndoLog(new Undoable(){

            public void undo() {
                storage.mapPut(old);
            }

            public String toString() {
                return "undo delete by put: " + old;
            }
        });
    }

    void commit() {
        MapTransaction parent = this.mParent;
        if (parent == null) {
            this.releaseLocks();
            return;
        }
        if (parent.mUndoLog == null) {
            parent.mUndoLog = this.mUndoLog;
        } else if (this.mUndoLog != null) {
            parent.mUndoLog.addAll(this.mUndoLog);
        }
        this.mUndoLog = null;
        Set<UpgradableLock> locks = this.mWriteLocks;
        if (locks != null) {
            Set<UpgradableLock> parentLocks = parent.mWriteLocks;
            if (parentLocks == null) {
                parent.mWriteLocks = locks;
            } else {
                for (UpgradableLock lock : locks) {
                    if (parentLocks.add(lock)) continue;
                    lock.unlockFromWrite(this.mLocker);
                }
            }
            this.mWriteLocks = null;
        }
        this.releaseUpgradeLocks();
    }

    void abort() {
        List<Undoable> log = this.mUndoLog;
        if (log != null) {
            int i = log.size();
            while (--i >= 0) {
                log.get(i).undo();
            }
        }
        this.mUndoLog = null;
        this.releaseLocks();
    }

    private void addToUndoLog(Undoable entry) {
        List<Undoable> log = this.mUndoLog;
        if (log == null) {
            this.mUndoLog = log = new ArrayList<Undoable>();
        }
        log.add(entry);
    }

    private void releaseLocks() {
        this.releaseWriteLocks();
        this.releaseUpgradeLocks();
    }

    private void releaseWriteLocks() {
        Set<UpgradableLock> locks = this.mWriteLocks;
        if (locks != null) {
            for (UpgradableLock lock : locks) {
                lock.unlockFromWrite(this.mLocker);
            }
            this.mWriteLocks = null;
        }
    }

    private void releaseUpgradeLocks() {
        Set<UpgradableLock> locks = this.mUpgradeLocks;
        if (locks != null) {
            for (UpgradableLock lock : locks) {
                lock.unlockFromUpgrade(this.mLocker);
            }
            this.mUpgradeLocks = null;
        }
    }

    private static interface Undoable {
        public void undo();
    }
}

