/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.repo.jdbc.LoggingCallableStatement;
import com.amazon.carbonado.repo.jdbc.LoggingPreparedStatement;
import com.amazon.carbonado.repo.jdbc.LoggingStatement;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LoggingConnection
implements Connection {
    private final Log mLog;
    private final Connection mCon;

    LoggingConnection(Log log, Connection con) {
        this.mLog = log;
        this.mCon = con;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new LoggingStatement(this.mLog, this, this.mCon.createStatement());
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new LoggingStatement(this.mLog, this, this.mCon.createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new LoggingStatement(this.mLog, this, this.mCon.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new LoggingPreparedStatement(this.mLog, this, this.mCon.prepareStatement(sql), sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new LoggingPreparedStatement(this.mLog, this, this.mCon.prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new LoggingPreparedStatement(this.mLog, this, this.mCon.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new LoggingPreparedStatement(this.mLog, this, this.mCon.prepareStatement(sql, autoGeneratedKeys), sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new LoggingPreparedStatement(this.mLog, this, this.mCon.prepareStatement(sql, columnIndexes), sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new LoggingPreparedStatement(this.mLog, this, this.mCon.prepareStatement(sql, columnNames), sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return new LoggingCallableStatement(this.mLog, (Connection)this, this.mCon.prepareCall(sql), sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new LoggingCallableStatement(this.mLog, (Connection)this, this.mCon.prepareCall(sql, resultSetType, resultSetConcurrency), sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new LoggingCallableStatement(this.mLog, (Connection)this, this.mCon.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.mCon.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.mLog.debug((Object)("Connection.setAutoCommit(" + autoCommit + ')'));
        this.mCon.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.mCon.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.mLog.debug((Object)"Connection.commit()");
        this.mCon.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.mLog.debug((Object)"Connection.rollback()");
        this.mCon.rollback();
    }

    @Override
    public void close() throws SQLException {
        this.mLog.debug((Object)"Connection.close()");
        this.mCon.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.mCon.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.mLog.debug((Object)"Connection.getMetaData()");
        return this.mCon.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.mCon.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.mCon.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.mCon.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.mCon.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        String levelStr;
        switch (level) {
            default: {
                levelStr = String.valueOf(level);
                break;
            }
            case 0: {
                levelStr = "TRANSACTION_NONE";
                break;
            }
            case 1: {
                levelStr = "TRANSACTION_READ_UNCOMMITTED";
                break;
            }
            case 2: {
                levelStr = "TRANSACTION_READ_COMMITTED";
                break;
            }
            case 4: {
                levelStr = "TRANSACTION_REPEATABLE_READ";
                break;
            }
            case 8: {
                levelStr = "TRANSACTION_SERIALIZABLE";
            }
        }
        this.mLog.debug((Object)("Connection.setTransactionIsolation(" + levelStr + ')'));
        this.mCon.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.mCon.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.mCon.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.mCon.clearWarnings();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.mCon.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.mCon.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.mCon.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.mCon.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.mLog.debug((Object)"Connection.setSavepoint()");
        return this.mCon.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.mLog.debug((Object)"Connection.setSavepoint(name)");
        return this.mCon.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.mLog.debug((Object)"Connection.rollback(savepoint)");
        this.mCon.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.mLog.debug((Object)"Connection.releaseSavepoint(savepoint)");
        this.mCon.releaseSavepoint(savepoint);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.mCon.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.mCon.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.mCon.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.mCon.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.mCon.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.mCon.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.mCon.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.mCon.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.mCon.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.mCon.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.mCon.createStruct(typeName, attributes);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

