/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.repo.jdbc.JDBCExceptionTransformer;
import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import com.amazon.carbonado.repo.jdbc.JDBCTransaction;
import com.amazon.carbonado.txn.TransactionManager;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JDBCTransactionManager
extends TransactionManager<JDBCTransaction> {
    private final JDBCExceptionTransformer mExTransformer;
    private final WeakReference<JDBCRepository> mRepositoryRef;

    JDBCTransactionManager(JDBCRepository repository) {
        this.mExTransformer = repository.getExceptionTransformer();
        this.mRepositoryRef = new WeakReference<JDBCRepository>(repository);
    }

    @Override
    protected IsolationLevel selectIsolationLevel(Transaction parent, IsolationLevel level) {
        JDBCRepository repo = (JDBCRepository)this.mRepositoryRef.get();
        if (repo == null) {
            throw new IllegalStateException("Repository closed");
        }
        return repo.selectIsolationLevel(parent, level);
    }

    @Override
    protected boolean supportsForUpdate() {
        JDBCRepository repo = (JDBCRepository)this.mRepositoryRef.get();
        return repo != null && repo.supportsSelectForUpdate();
    }

    @Override
    protected JDBCTransaction createTxn(JDBCTransaction parent, IsolationLevel level) throws SQLException, FetchException {
        JDBCRepository repo = (JDBCRepository)this.mRepositoryRef.get();
        if (repo == null) {
            throw new IllegalStateException("Repository closed");
        }
        if (parent != null) {
            if (!repo.supportsSavepoints()) {
                return parent;
            }
            return new JDBCTransaction(parent, level);
        }
        return new JDBCTransaction(repo.getConnectionForTxn(level));
    }

    @Override
    protected void reuseTxn(JDBCTransaction txn) throws SQLException {
        txn.reuse();
    }

    @Override
    protected boolean commitTxn(JDBCTransaction txn) throws PersistException {
        try {
            txn.commit();
            return true;
        }
        catch (Throwable e) {
            throw this.mExTransformer.toPersistException(e);
        }
    }

    @Override
    protected void abortTxn(JDBCTransaction txn) throws PersistException {
        try {
            Connection con = txn.abort();
            if (con != null) {
                JDBCRepository repo = (JDBCRepository)this.mRepositoryRef.get();
                if (repo == null) {
                    con.close();
                } else {
                    repo.closeConnection(con);
                }
            }
        }
        catch (Throwable e) {
            throw this.mExTransformer.toPersistException(e);
        }
    }
}

