/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.ConstraintException;
import com.amazon.carbonado.FetchDeadlockException;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchTimeoutException;
import com.amazon.carbonado.PersistDeadlockException;
import com.amazon.carbonado.PersistDeniedException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistTimeoutException;
import com.amazon.carbonado.UniqueConstraintException;
import com.amazon.carbonado.spi.ExceptionTransformer;
import java.sql.SQLException;

class JDBCExceptionTransformer
extends ExceptionTransformer {
    public static String SQLSTATE_CONSTRAINT_VIOLATION_CLASS_CODE = "23";
    public static String SQLSTATE_UNIQUE_CONSTRAINT_VIOLATION = "23505";
    public static String SQLSTATE_DEADLOCK_WITH_ROLLBACK = "40001";
    public static String SQLSTATE_PROCESSING_CANCELED = "57014";

    public boolean isConstraintError(SQLException e) {
        String sqlstate;
        if (e != null && (sqlstate = e.getSQLState()) != null) {
            return sqlstate.startsWith(SQLSTATE_CONSTRAINT_VIOLATION_CLASS_CODE);
        }
        return false;
    }

    public boolean isUniqueConstraintError(SQLException e) {
        if (this.isConstraintError(e)) {
            String sqlstate = e.getSQLState();
            return SQLSTATE_UNIQUE_CONSTRAINT_VIOLATION.equals(sqlstate);
        }
        return false;
    }

    public boolean isInsufficientPrivilegesError(SQLException e) {
        return false;
    }

    public boolean isDeadlockError(SQLException e) {
        String sqlstate;
        if (e != null && (sqlstate = e.getSQLState()) != null) {
            return sqlstate.startsWith(SQLSTATE_DEADLOCK_WITH_ROLLBACK);
        }
        return false;
    }

    public boolean isTimeoutError(SQLException e) {
        String sqlstate;
        if (e != null && (sqlstate = e.getSQLState()) != null) {
            return SQLSTATE_PROCESSING_CANCELED.equals(sqlstate);
        }
        return false;
    }

    JDBCExceptionTransformer() {
    }

    protected FetchException transformIntoFetchException(Throwable e) {
        FetchException fe = super.transformIntoFetchException(e);
        if (fe != null) {
            return fe;
        }
        if (e instanceof SQLException) {
            SQLException se = (SQLException)e;
            if (this.isDeadlockError(se)) {
                return new FetchDeadlockException(e);
            }
            if (this.isTimeoutError(se)) {
                return new FetchTimeoutException(e);
            }
        }
        return null;
    }

    protected PersistException transformIntoPersistException(Throwable e) {
        PersistException pe = super.transformIntoPersistException(e);
        if (pe != null) {
            return pe;
        }
        if (e instanceof SQLException) {
            SQLException se = (SQLException)e;
            if (this.isUniqueConstraintError(se)) {
                return new UniqueConstraintException(e);
            }
            if (this.isConstraintError(se)) {
                return new ConstraintException(e);
            }
            if (this.isInsufficientPrivilegesError(se)) {
                return new PersistDeniedException(e);
            }
            if (this.isDeadlockError(se)) {
                return new PersistDeadlockException(e);
            }
            if (this.isTimeoutError(se)) {
                return new PersistTimeoutException(e);
            }
        }
        return null;
    }
}

