/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.raw;

import com.amazon.carbonado.CorruptEncodingException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.gen.TriggerSupport;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.info.StorablePropertyAdapter;
import com.amazon.carbonado.lob.Blob;
import com.amazon.carbonado.lob.Clob;
import com.amazon.carbonado.lob.Lob;
import com.amazon.carbonado.raw.DataDecoder;
import com.amazon.carbonado.raw.DataEncoder;
import com.amazon.carbonado.raw.GenericPropertyInfo;
import com.amazon.carbonado.raw.KeyDecoder;
import com.amazon.carbonado.raw.KeyEncoder;
import com.amazon.carbonado.raw.RawSupport;
import com.amazon.carbonado.raw.StorablePropertyInfo;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.cojen.classfile.CodeAssembler;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.BeanComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericEncodingStrategy<S extends Storable> {
    private final Class<S> mType;
    private final StorableIndex<S> mPkIndex;
    private final int mKeyPrefixPadding;
    private final int mKeySuffixPadding;
    private final int mDataPrefixPadding;
    private final int mDataSuffixPadding;

    public GenericEncodingStrategy(Class<S> type, StorableIndex<S> pkIndex) {
        this(type, pkIndex, 0, 0, 0, 0);
    }

    public GenericEncodingStrategy(Class<S> type, StorableIndex<S> pkIndex, int keyPrefixPadding, int keySuffixPadding, int dataPrefixPadding, int dataSuffixPadding) {
        this.mType = type;
        if (keyPrefixPadding < 0 || keySuffixPadding < 0 || dataPrefixPadding < 0 || dataSuffixPadding < 0) {
            throw new IllegalArgumentException();
        }
        this.mKeyPrefixPadding = keyPrefixPadding;
        this.mKeySuffixPadding = keySuffixPadding;
        this.mDataPrefixPadding = dataPrefixPadding;
        this.mDataSuffixPadding = dataSuffixPadding;
        if (pkIndex == null) {
            Map<String, StorableProperty<S>> map = StorableIntrospector.examine(this.mType).getPrimaryKeyProperties();
            StorableProperty[] properties = new StorableProperty[map.size()];
            map.values().toArray(properties);
            Direction[] directions = new Direction[map.size()];
            Arrays.fill((Object[])directions, (Object)Direction.UNSPECIFIED);
            pkIndex = new StorableIndex(properties, directions, true);
        }
        this.mPkIndex = pkIndex;
    }

    public LocalVariable buildKeyEncoding(CodeAssembler assembler, OrderedProperty<S>[] properties, LocalVariable instanceVar, Class<?> adapterInstanceClass, boolean useReadMethods, LocalVariable partialStartVar, LocalVariable partialEndVar) throws SupportException {
        properties = this.ensureKeyProperties(properties);
        return this.buildEncoding(Mode.KEY, assembler, this.extractProperties(properties), this.extractDirections(properties), instanceVar, adapterInstanceClass, useReadMethods, -1, partialStartVar, partialEndVar);
    }

    public void buildKeyDecoding(CodeAssembler assembler, OrderedProperty<S>[] properties, LocalVariable instanceVar, Class<?> adapterInstanceClass, boolean useWriteMethods, LocalVariable encodedVar) throws SupportException {
        properties = this.ensureKeyProperties(properties);
        this.buildDecoding(Mode.KEY, assembler, this.extractProperties(properties), this.extractDirections(properties), instanceVar, adapterInstanceClass, useWriteMethods, -1, null, encodedVar);
    }

    public LocalVariable buildDataEncoding(CodeAssembler assembler, StorableProperty<S>[] properties, LocalVariable instanceVar, Class<?> adapterInstanceClass, boolean useReadMethods, int generation) throws SupportException {
        properties = this.ensureDataProperties(properties);
        return this.buildEncoding(Mode.DATA, assembler, properties, null, instanceVar, adapterInstanceClass, useReadMethods, generation, null, null);
    }

    public void buildDataDecoding(CodeAssembler assembler, StorableProperty<S>[] properties, LocalVariable instanceVar, Class<?> adapterInstanceClass, boolean useWriteMethods, int generation, Label altGenerationHandler, LocalVariable encodedVar) throws SupportException {
        properties = this.ensureDataProperties(properties);
        this.buildDecoding(Mode.DATA, assembler, properties, null, instanceVar, adapterInstanceClass, useWriteMethods, generation, altGenerationHandler, encodedVar);
    }

    public LocalVariable buildSerialEncoding(CodeAssembler assembler, StorableProperty<S>[] properties) throws SupportException {
        properties = this.ensureAllProperties(properties);
        return this.buildEncoding(Mode.SERIAL, assembler, properties, null, null, null, false, -1, null, null);
    }

    public void buildSerialDecoding(CodeAssembler assembler, StorableProperty<S>[] properties, LocalVariable encodedVar) throws SupportException {
        properties = this.ensureAllProperties(properties);
        this.buildDecoding(Mode.SERIAL, assembler, properties, null, null, null, false, -1, null, encodedVar);
    }

    public final Class<S> getType() {
        return this.mType;
    }

    public boolean isSupported(Class<?> propertyType) {
        return this.isSupported(TypeDesc.forClass(propertyType));
    }

    public boolean isSupported(TypeDesc propertyType) {
        if (propertyType.toPrimitiveType() != null) {
            return true;
        }
        if (propertyType == TypeDesc.STRING || propertyType == TypeDesc.forClass(byte[].class)) {
            return true;
        }
        Class clazz = propertyType.toClass();
        if (clazz != null) {
            return Lob.class.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz) || BigDecimal.class.isAssignableFrom(clazz);
        }
        return false;
    }

    public int getKeyPrefixPadding() {
        return this.mKeyPrefixPadding;
    }

    public int getKeySuffixPadding() {
        return this.mKeySuffixPadding;
    }

    public int getDataPrefixPadding() {
        return this.mDataPrefixPadding;
    }

    public int getDataSuffixPadding() {
        return this.mDataSuffixPadding;
    }

    public int getConstantKeyPrefixLength() {
        return 0;
    }

    public int hashCode() {
        return this.mType.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            GenericEncodingStrategy other = (GenericEncodingStrategy)obj;
            return this.mType == other.mType && this.mKeyPrefixPadding == other.mKeyPrefixPadding && this.mKeySuffixPadding == other.mKeySuffixPadding && this.mDataPrefixPadding == other.mDataPrefixPadding && this.mDataSuffixPadding == other.mDataSuffixPadding;
        }
        return false;
    }

    protected StorableIndex<S> getPrimaryKeyIndex() {
        return this.mPkIndex;
    }

    protected OrderedProperty<S>[] gatherAllKeyProperties() {
        return this.mPkIndex.getOrderedProperties();
    }

    protected StorableProperty<S>[] gatherAllDataProperties() {
        Map<String, StorableProperty<S>> map = StorableIntrospector.examine(this.mType).getDataProperties();
        ArrayList<StorableProperty<S>> list = new ArrayList<StorableProperty<S>>(map.size());
        for (StorableProperty<S> property : map.values()) {
            if (property.isDerived()) continue;
            list.add(property);
        }
        return list.toArray(new StorableProperty[list.size()]);
    }

    protected StorableProperty<S>[] gatherAllProperties() {
        Map<String, StorableProperty<S>> map = StorableIntrospector.examine(this.mType).getAllProperties();
        ArrayList<StorableProperty<S>> list = new ArrayList<StorableProperty<S>>(map.size());
        for (StorableProperty<S> property : map.values()) {
            if (property.isJoin() || property.isDerived()) continue;
            list.add(property);
        }
        return list.toArray(new StorableProperty[list.size()]);
    }

    protected StorablePropertyInfo checkSupport(StorableProperty<S> property) throws SupportException {
        if (this.isSupported(property.getType())) {
            return new StorablePropertyInfo(property);
        }
        if (property.getAdapter() != null) {
            StorablePropertyAdapter adapter = property.getAdapter();
            for (Class storageType : adapter.getStorageTypePreferences()) {
                Method toStorage;
                Method fromStorage;
                if (!this.isSupported(storageType) || property.isNullable() && storageType.isPrimitive() || (fromStorage = adapter.findAdaptMethod(storageType, property.getType())) == null || (toStorage = adapter.findAdaptMethod(property.getType(), storageType)) == null) continue;
                return new StorablePropertyInfo(property, storageType, fromStorage, toStorage);
            }
        }
        throw this.notSupported(property);
    }

    protected StorablePropertyInfo[] checkSupport(StorableProperty<S>[] properties) throws SupportException {
        int length = properties.length;
        StorablePropertyInfo[] infos = new StorablePropertyInfo[length];
        for (int i = 0; i < length; ++i) {
            infos[i] = this.checkSupport(properties[i]);
        }
        return infos;
    }

    protected void extraDataEncoding(CodeAssembler a, LocalVariable dataVar, int prefix, int suffix) {
    }

    protected void extraDataDecoding(CodeAssembler a, LocalVariable dataVar, int prefix, int suffix) {
    }

    private SupportException notSupported(StorableProperty<S> property) {
        return this.notSupported(property.getName(), TypeDesc.forClass(property.getType()).getFullName());
    }

    private SupportException notSupported(String propertyName, String typeName) {
        return new SupportException("Type \"" + typeName + "\" not supported for property \"" + propertyName + '\"');
    }

    private OrderedProperty<S>[] ensureKeyProperties(OrderedProperty<S>[] properties) {
        if (properties == null) {
            properties = this.gatherAllKeyProperties();
        } else {
            for (OrderedProperty<S> prop : properties) {
                if (prop != null) continue;
                throw new IllegalArgumentException();
            }
        }
        return properties;
    }

    private StorableProperty<S>[] extractProperties(OrderedProperty<S>[] ordered) {
        StorableProperty[] properties = new StorableProperty[ordered.length];
        for (int i = 0; i < ordered.length; ++i) {
            ChainedProperty<S> chained = ordered[i].getChainedProperty();
            if (chained.getChainCount() > 0) {
                throw new IllegalArgumentException();
            }
            properties[i] = chained.getPrimeProperty();
        }
        return properties;
    }

    private Direction[] extractDirections(OrderedProperty<S>[] ordered) {
        Direction[] directions = new Direction[ordered.length];
        for (int i = 0; i < ordered.length; ++i) {
            directions[i] = ordered[i].getDirection();
        }
        return directions;
    }

    private StorableProperty<S>[] ensureDataProperties(StorableProperty<S>[] properties) {
        if (properties == null) {
            properties = this.gatherAllDataProperties();
        } else {
            for (StorableProperty<S> prop : properties) {
                if (prop != null) continue;
                throw new IllegalArgumentException();
            }
        }
        return properties;
    }

    private StorableProperty<S>[] ensureAllProperties(StorableProperty<S>[] properties) {
        if (properties == null) {
            properties = this.gatherAllProperties();
        } else {
            for (StorableProperty<S> prop : properties) {
                if (prop != null) continue;
                throw new IllegalArgumentException();
            }
            properties = (StorableProperty[])properties.clone();
            Arrays.sort(properties, BeanComparator.forClass(StorableProperty.class).orderBy("number"));
        }
        return properties;
    }

    private LocalVariable buildEncoding(Mode mode, CodeAssembler a, StorableProperty<S>[] properties, Direction[] directions, LocalVariable instanceVar, Class<?> adapterInstanceClass, boolean useReadMethods, int generation, LocalVariable partialStartVar, LocalVariable partialEndVar) throws SupportException {
        int suffix;
        int prefix;
        if (a == null) {
            throw new IllegalArgumentException();
        }
        if (partialStartVar != null && partialStartVar.getType() != TypeDesc.INT) {
            throw new IllegalArgumentException();
        }
        if (partialEndVar != null && partialEndVar.getType() != TypeDesc.INT) {
            throw new IllegalArgumentException();
        }
        switch (mode) {
            default: {
                prefix = 0;
                break;
            }
            case KEY: {
                prefix = this.mKeyPrefixPadding;
                break;
            }
            case DATA: {
                prefix = this.mDataPrefixPadding;
            }
        }
        int generationPrefix = generation < 0 ? 0 : (generation < 128 ? 1 : 4);
        switch (mode) {
            default: {
                suffix = 0;
                break;
            }
            case KEY: {
                suffix = this.mKeySuffixPadding;
                break;
            }
            case DATA: {
                suffix = this.mDataSuffixPadding;
            }
        }
        TypeDesc byteArrayType = TypeDesc.forClass(byte[].class);
        LocalVariable encodedVar = a.createLocalVariable(null, byteArrayType);
        StorablePropertyInfo[] infos = this.checkSupport(properties);
        if (properties.length == 1) {
            partialStartVar = null;
            partialEndVar = null;
            StorableProperty<S> property = properties[0];
            StorablePropertyInfo info = infos[0];
            if (mode != Mode.SERIAL && info.getStorageType().toClass() == byte[].class) {
                TypeDesc[] params;
                boolean descending;
                this.loadPropertyValue(a, info, 0, useReadMethods, instanceVar, adapterInstanceClass, partialStartVar);
                boolean bl = descending = mode == Mode.KEY && directions != null && directions[0] == Direction.DESCENDING;
                if (prefix > 0 || generationPrefix > 0 || suffix > 0) {
                    a.loadConstant(prefix + generationPrefix);
                    a.loadConstant(suffix);
                    params = new TypeDesc[]{byteArrayType, TypeDesc.INT, TypeDesc.INT};
                } else {
                    params = new TypeDesc[]{byteArrayType};
                }
                if (property.isNullable()) {
                    if (descending) {
                        a.invokeStatic(KeyEncoder.class.getName(), "encodeSingleNullableDesc", byteArrayType, params);
                    } else {
                        a.invokeStatic(DataEncoder.class.getName(), "encodeSingleNullable", byteArrayType, params);
                    }
                } else if (descending) {
                    a.invokeStatic(KeyEncoder.class.getName(), "encodeSingleDesc", byteArrayType, params);
                } else if (prefix > 0 || generationPrefix > 0 || suffix > 0) {
                    a.invokeStatic(DataEncoder.class.getName(), "encodeSingle", byteArrayType, params);
                }
                a.storeLocal(encodedVar);
                this.encodeGeneration(a, encodedVar, prefix, generation);
                if (mode == Mode.DATA) {
                    this.extraDataEncoding(a, encodedVar, prefix + generationPrefix, suffix);
                }
                return encodedVar;
            }
        }
        boolean doPartial = mode == Mode.SERIAL || mode == Mode.KEY && partialStartVar != null || mode == Mode.KEY && (properties.length == 0 || partialEndVar != null);
        int staticLength = 0;
        if (mode != Mode.KEY || partialStartVar == null) {
            staticLength += prefix + generationPrefix;
        }
        if (mode != Mode.KEY || properties.length != 0 && partialEndVar == null) {
            staticLength += suffix;
        }
        if (mode == Mode.SERIAL) {
            staticLength += (properties.length + 3) / 4;
        }
        LocalVariable[] stashedProperties = null;
        Boolean[] stashedFromInstances = null;
        boolean hasVariableLength = doPartial;
        for (int i = 0; i < infos.length; ++i) {
            LocalVariable propVar;
            StorablePropertyInfo info = infos[i];
            int len = this.staticEncodingLength(info);
            if (len >= 0) {
                if (doPartial) continue;
                staticLength += len;
                continue;
            }
            if (!doPartial) {
                staticLength += ~len;
                hasVariableLength = true;
            }
            if (info.getPropertyType() == info.getStorageType()) continue;
            if (stashedProperties == null) {
                stashedProperties = new LocalVariable[infos.length];
                stashedFromInstances = new Boolean[infos.length];
            }
            stashedProperties[i] = propVar = a.createLocalVariable(null, info.getStorageType());
            if (!doPartial) continue;
            this.loadBlankValue(a, propVar.getType());
            a.storeLocal(propVar);
        }
        boolean hasStackVar = false;
        if (hasVariableLength) {
            Label[] entryPoints = null;
            if (mode == Mode.SERIAL || partialStartVar != null) {
                a.loadConstant(0);
                hasStackVar = true;
            }
            if (partialStartVar != null) {
                entryPoints = this.jumpToPartialEntryPoints(a, partialStartVar, properties.length);
            }
            Label exitPoint = a.createLabel();
            LocalVariable stateFieldVar = null;
            for (int i = 0; i < properties.length; ++i) {
                TypeDesc storageType;
                StorableProperty<S> property = properties[i];
                StorablePropertyInfo info = infos[i];
                if (doPartial) {
                    if (entryPoints != null) {
                        entryPoints[i].setLocation();
                    }
                    if (partialEndVar != null) {
                        a.loadConstant(i);
                        a.loadLocal(partialEndVar);
                        a.ifComparisonBranch((Location)exitPoint, ">=");
                    }
                } else if (this.staticEncodingLength(info) >= 0) continue;
                Label nextProperty = null;
                if (mode == Mode.SERIAL) {
                    nextProperty = a.createLabel();
                    int fieldOrdinal = property.getNumber() >> 4;
                    if (stateFieldVar != null) {
                        a.loadLocal(stateFieldVar);
                    } else {
                        a.loadThis();
                        a.loadField("propertyState$" + fieldOrdinal, TypeDesc.INT);
                    }
                    if (i + 1 < properties.length && properties[i + 1].getNumber() >> 4 == fieldOrdinal) {
                        if (stateFieldVar == null) {
                            stateFieldVar = a.createLocalVariable(null, TypeDesc.INT);
                            a.storeLocal(stateFieldVar);
                            a.loadLocal(stateFieldVar);
                        }
                    } else {
                        stateFieldVar = null;
                    }
                    a.loadConstant(3 << (property.getNumber() & 0xF) * 2);
                    a.math((byte)126);
                    a.ifZeroComparisonBranch((Location)nextProperty, "==");
                }
                if ((storageType = info.getStorageType()).isPrimitive()) {
                    a.loadConstant(this.staticEncodingLength(info));
                    if (hasStackVar) {
                        a.math((byte)96);
                    } else {
                        hasStackVar = true;
                    }
                } else if (storageType.toPrimitiveType() != null) {
                    int amt = 0;
                    switch (storageType.toPrimitiveType().getTypeCode()) {
                        case 4: 
                        case 8: {
                            amt = 1;
                            break;
                        }
                        case 5: 
                        case 9: {
                            amt = 2;
                            break;
                        }
                        case 6: 
                        case 10: {
                            amt = 4;
                            break;
                        }
                        case 7: 
                        case 11: {
                            amt = 8;
                        }
                    }
                    int extra = 0;
                    if (doPartial) {
                        switch (storageType.toPrimitiveType().getTypeCode()) {
                            case 5: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: {
                                extra = 1;
                            }
                        }
                    }
                    if (!property.isNullable() || doPartial && extra == 0) {
                        a.loadConstant(amt);
                        if (hasStackVar) {
                            a.math((byte)96);
                        }
                        hasStackVar = true;
                    } else {
                        this.loadPropertyValue(stashedProperties, stashedFromInstances, a, info, i, useReadMethods, instanceVar, adapterInstanceClass, partialStartVar);
                        Label isNull = a.createLabel();
                        a.ifNullBranch((Location)isNull, true);
                        a.loadConstant(amt);
                        if (hasStackVar) {
                            a.math((byte)96);
                            isNull.setLocation();
                            if (extra > 0) {
                                a.loadConstant(extra);
                                a.math((byte)96);
                            }
                        } else {
                            hasStackVar = true;
                            Label notNull = a.createLabel();
                            a.branch((Location)notNull);
                            isNull.setLocation();
                            a.loadConstant(extra);
                            notNull.setLocation();
                        }
                    }
                } else if (storageType == TypeDesc.STRING || storageType.toClass() == byte[].class || storageType.toClass() == BigInteger.class || storageType.toClass() == BigDecimal.class) {
                    this.loadPropertyValue(stashedProperties, stashedFromInstances, a, info, i, useReadMethods, instanceVar, adapterInstanceClass, partialStartVar);
                    String methodName = storageType == TypeDesc.STRING ? "calculateEncodedStringLength" : "calculateEncodedLength";
                    String className = (mode == Mode.KEY ? KeyEncoder.class : DataEncoder.class).getName();
                    a.invokeStatic(className, methodName, TypeDesc.INT, new TypeDesc[]{storageType});
                    if (hasStackVar) {
                        a.math((byte)96);
                    } else {
                        hasStackVar = true;
                    }
                } else if (info.isLob()) {
                    a.loadConstant(8);
                    if (hasStackVar) {
                        a.math((byte)96);
                    } else {
                        hasStackVar = true;
                    }
                } else {
                    throw this.notSupported(property);
                }
                if (nextProperty == null) continue;
                nextProperty.setLocation();
            }
            exitPoint.setLocation();
            if (mode == Mode.KEY && partialStartVar != null && (prefix > 0 || generationPrefix > 0)) {
                a.loadLocal(partialStartVar);
                Label noPrefix = a.createLabel();
                a.ifZeroComparisonBranch((Location)noPrefix, "!=");
                a.loadConstant(prefix + generationPrefix);
                if (hasStackVar) {
                    a.math((byte)96);
                } else {
                    hasStackVar = true;
                }
                noPrefix.setLocation();
            }
            if (mode == Mode.KEY && partialEndVar != null && suffix > 0) {
                a.loadLocal(partialEndVar);
                Label noSuffix = a.createLabel();
                a.loadConstant(properties.length);
                a.ifComparisonBranch((Location)noSuffix, "!=");
                a.loadConstant(suffix);
                if (hasStackVar) {
                    a.math((byte)96);
                } else {
                    hasStackVar = true;
                }
                noSuffix.setLocation();
            }
        }
        if (hasStackVar) {
            if (staticLength > 0) {
                a.loadConstant(staticLength);
                a.math((byte)96);
            }
        } else {
            a.loadConstant(staticLength);
        }
        a.newObject(byteArrayType);
        a.storeLocal(encodedVar);
        int constantOffset = 0;
        LocalVariable offsetVar = null;
        if (mode != Mode.KEY || partialStartVar == null) {
            this.encodeGeneration(a, encodedVar, constantOffset += prefix, generation);
            constantOffset += generationPrefix;
        }
        if (mode == Mode.SERIAL) {
            this.encodePropertyStates(a, encodedVar, constantOffset, properties);
            offsetVar = a.createLocalVariable(null, TypeDesc.INT);
            a.loadConstant(constantOffset += (properties.length + 3) / 4);
            a.storeLocal(offsetVar);
        }
        Label[] entryPoints = null;
        if (mode == Mode.KEY && partialStartVar != null) {
            offsetVar = a.createLocalVariable(null, TypeDesc.INT);
            a.loadConstant(constantOffset);
            if (prefix > 0) {
                a.loadLocal(partialStartVar);
                Label noPrefix = a.createLabel();
                a.ifZeroComparisonBranch((Location)noPrefix, "!=");
                a.loadConstant(prefix + generationPrefix);
                a.math((byte)96);
                this.encodeGeneration(a, encodedVar, prefix, generation);
                noPrefix.setLocation();
            }
            a.storeLocal(offsetVar);
            entryPoints = this.jumpToPartialEntryPoints(a, partialStartVar, properties.length);
        }
        Label exitPoint = a.createLabel();
        LocalVariable stateFieldVar = mode != Mode.SERIAL ? null : a.createLocalVariable(null, TypeDesc.INT);
        int lastFieldOrdinal = -1;
        for (int i = 0; i < properties.length; ++i) {
            StorableProperty<S> property = properties[i];
            StorablePropertyInfo info = infos[i];
            Label nextProperty = a.createLabel();
            if (doPartial) {
                if (entryPoints != null) {
                    entryPoints[i].setLocation();
                }
                if (partialEndVar != null) {
                    a.loadConstant(i);
                    a.loadLocal(partialEndVar);
                    a.ifComparisonBranch((Location)exitPoint, ">=");
                }
            }
            if (mode == Mode.SERIAL) {
                int fieldOrdinal = property.getNumber() >> 4;
                if (fieldOrdinal == lastFieldOrdinal) {
                    a.loadLocal(stateFieldVar);
                } else {
                    a.loadThis();
                    a.loadField("propertyState$" + fieldOrdinal, TypeDesc.INT);
                    a.storeLocal(stateFieldVar);
                    a.loadLocal(stateFieldVar);
                    lastFieldOrdinal = fieldOrdinal;
                }
                a.loadConstant(3 << (property.getNumber() & 0xF) * 2);
                a.math((byte)126);
                a.ifZeroComparisonBranch((Location)nextProperty, "==");
            }
            if (info.isLob()) {
                this.pushRawSupport(a, instanceVar);
            }
            boolean fromInstance = this.loadPropertyValue(stashedProperties, stashedFromInstances, a, info, i, useReadMethods, instanceVar, adapterInstanceClass, partialStartVar);
            TypeDesc storageType = info.getStorageType();
            if (!property.isNullable() && storageType.toPrimitiveType() != null) {
                if (!fromInstance && !storageType.isPrimitive()) {
                    a.dup();
                    Label notNull = a.createLabel();
                    a.ifNullBranch((Location)notNull, false);
                    TypeDesc errorType = TypeDesc.forClass(IllegalArgumentException.class);
                    a.newObject(errorType);
                    a.dup();
                    a.loadConstant("Value for property \"" + property.getName() + "\" cannot be null");
                    a.invokeConstructor(errorType, new TypeDesc[]{TypeDesc.STRING});
                    a.throwObject();
                    notNull.setLocation();
                }
                a.convert(storageType, storageType.toPrimitiveType());
                storageType = storageType.toPrimitiveType();
            }
            if (info.isLob()) {
                this.getLobLocator(a, info);
                storageType = TypeDesc.LONG;
            }
            a.loadLocal(encodedVar);
            if (offsetVar == null) {
                a.loadConstant(constantOffset);
            } else {
                a.loadLocal(offsetVar);
            }
            boolean descending = mode == Mode.KEY && directions != null && directions[i] == Direction.DESCENDING;
            int amt = this.encodeProperty(a, storageType, mode, descending);
            if (amt > 0) {
                if (i + 1 < properties.length) {
                    if (offsetVar == null) {
                        constantOffset += amt;
                    } else {
                        a.loadConstant(amt);
                        a.loadLocal(offsetVar);
                        a.math((byte)96);
                        a.storeLocal(offsetVar);
                    }
                }
            } else if (i + 1 >= properties.length) {
                a.pop();
            } else {
                if (offsetVar == null) {
                    if (constantOffset > 0) {
                        a.loadConstant(constantOffset);
                        a.math((byte)96);
                    }
                    offsetVar = a.createLocalVariable(null, TypeDesc.INT);
                } else {
                    a.loadLocal(offsetVar);
                    a.math((byte)96);
                }
                a.storeLocal(offsetVar);
            }
            nextProperty.setLocation();
        }
        exitPoint.setLocation();
        if (mode == Mode.DATA) {
            this.extraDataEncoding(a, encodedVar, prefix + generationPrefix, suffix);
        }
        return encodedVar;
    }

    protected boolean loadPropertyValue(LocalVariable[] stashedProperties, Boolean[] stashedFromInstances, CodeAssembler a, StorablePropertyInfo info, int ordinal, boolean useReadMethod, LocalVariable instanceVar, Class<?> adapterInstanceClass, LocalVariable partialStartVar) {
        LocalVariable propVar;
        if (stashedFromInstances != null && stashedFromInstances[ordinal] != null) {
            a.loadLocal(stashedProperties[ordinal]);
            return stashedFromInstances[ordinal];
        }
        boolean fromInstance = this.loadPropertyValue(a, info, ordinal, useReadMethod, instanceVar, adapterInstanceClass, partialStartVar);
        if (stashedProperties != null && (propVar = stashedProperties[ordinal]) != null) {
            a.storeLocal(propVar);
            a.loadLocal(propVar);
            stashedFromInstances[ordinal] = fromInstance;
        }
        return fromInstance;
    }

    protected boolean loadPropertyValue(CodeAssembler a, StorablePropertyInfo info, int ordinal, boolean useReadMethod, LocalVariable instanceVar, Class<?> adapterInstanceClass, LocalVariable partialStartVar) {
        boolean useAdapterInstance;
        if (info.isDerived()) {
            useReadMethod = true;
        }
        TypeDesc type = info.getPropertyType();
        TypeDesc storageType = info.getStorageType();
        boolean isObjectArrayInstanceVar = instanceVar != null && instanceVar.getType() == TypeDesc.forClass(Object[].class);
        boolean bl = useAdapterInstance = adapterInstanceClass != null && info.getToStorageAdapter() != null && (useReadMethod || isObjectArrayInstanceVar);
        if (useAdapterInstance) {
            String fieldName = info.getPropertyName() + "$adapter$" + 0;
            TypeDesc adapterType = TypeDesc.forClass(info.getToStorageAdapter().getDeclaringClass());
            a.loadStaticField(TypeDesc.forClass(adapterInstanceClass), fieldName, adapterType);
        }
        if (instanceVar == null) {
            a.loadThis();
            if (useReadMethod) {
                info.addInvokeReadMethod(a);
            } else if (info.getToStorageAdapter() == null) {
                a.loadField(info.getPropertyName(), type);
            } else {
                a.invokeVirtual(info.getReadMethodName() + '$', storageType, null);
            }
        } else if (!isObjectArrayInstanceVar) {
            a.loadLocal(instanceVar);
            if (useReadMethod) {
                info.addInvokeReadMethod(a, instanceVar.getType());
            } else if (info.getToStorageAdapter() == null) {
                a.loadField(instanceVar.getType(), info.getPropertyName(), type);
            } else {
                a.invokeVirtual(instanceVar.getType(), info.getReadMethodName() + '$', storageType, null);
            }
        } else {
            a.loadLocal(instanceVar);
            a.loadConstant(ordinal);
            if (ordinal > 0 && partialStartVar != null) {
                a.loadLocal(partialStartVar);
                a.math((byte)100);
            }
            a.loadFromArray(TypeDesc.OBJECT);
            a.checkCast(type.toObjectType());
            if (type.isPrimitive()) {
                a.convert(type.toObjectType(), type);
            }
        }
        if (useAdapterInstance) {
            a.invoke(info.getToStorageAdapter());
        }
        return !isObjectArrayInstanceVar;
    }

    private void loadBlankValue(CodeAssembler a, TypeDesc type) {
        switch (type.getTypeCode()) {
            case 0: {
                a.loadNull();
                break;
            }
            case 11: {
                a.loadConstant(0L);
                break;
            }
            case 6: {
                a.loadConstant(0.0f);
                break;
            }
            case 7: {
                a.loadConstant(0.0);
                break;
            }
            default: {
                a.loadConstant(0);
            }
        }
    }

    private int staticEncodingLength(GenericPropertyInfo info) {
        TypeDesc type = info.getStorageType();
        TypeDesc primType = type.toPrimitiveType();
        if (primType == null) {
            if (info.isLob()) {
                return 8;
            }
        } else if (info.isNullable()) {
            switch (primType.getTypeCode()) {
                case 8: {
                    return -2;
                }
                case 4: {
                    return 1;
                }
                case 5: 
                case 9: {
                    return -2;
                }
                case 10: {
                    return -2;
                }
                case 6: {
                    return 4;
                }
                case 11: {
                    return -2;
                }
                case 7: {
                    return 8;
                }
            }
        } else {
            switch (type.getTypeCode()) {
                case 4: 
                case 8: {
                    return 1;
                }
                case 5: 
                case 9: {
                    return 2;
                }
                case 6: 
                case 10: {
                    return 4;
                }
                case 7: 
                case 11: {
                    return 8;
                }
            }
        }
        return -1;
    }

    private Label[] jumpToPartialEntryPoints(CodeAssembler a, LocalVariable partialStartVar, int propertyCount) {
        int[] cases = new int[propertyCount];
        Label[] entryPoints = new Label[propertyCount];
        for (int i = 0; i < propertyCount; ++i) {
            cases[i] = i;
            entryPoints[i] = a.createLabel();
        }
        Label errorLoc = a.createLabel();
        a.loadLocal(partialStartVar);
        a.switchBranch(cases, (Location[])entryPoints, (Location)errorLoc);
        errorLoc.setLocation();
        TypeDesc errorType = TypeDesc.forClass(IllegalArgumentException.class);
        a.newObject(errorType);
        a.dup();
        a.loadConstant("Illegal partial start offset");
        a.invokeConstructor(errorType, new TypeDesc[]{TypeDesc.STRING});
        a.throwObject();
        return entryPoints;
    }

    private int encodeProperty(CodeAssembler a, TypeDesc type, Mode mode, boolean descending) {
        TypeDesc[] params = new TypeDesc[]{type, TypeDesc.forClass(byte[].class), TypeDesc.INT};
        if (type.isPrimitive()) {
            if (mode == Mode.KEY && descending) {
                a.invokeStatic(KeyEncoder.class.getName(), "encodeDesc", null, params);
            } else {
                a.invokeStatic(DataEncoder.class.getName(), "encode", null, params);
            }
            switch (type.getTypeCode()) {
                case 4: 
                case 8: {
                    return 1;
                }
                case 5: 
                case 9: {
                    return 2;
                }
                default: {
                    return 4;
                }
                case 7: 
                case 11: 
            }
            return 8;
        }
        if (type.toPrimitiveType() != null) {
            TypeDesc retType;
            int adjust;
            switch (type.toPrimitiveType().getTypeCode()) {
                case 4: {
                    adjust = 1;
                    retType = null;
                    break;
                }
                case 6: {
                    adjust = 4;
                    retType = null;
                    break;
                }
                case 7: {
                    adjust = 8;
                    retType = null;
                    break;
                }
                default: {
                    adjust = 0;
                    retType = TypeDesc.INT;
                }
            }
            if (mode == Mode.KEY && descending) {
                a.invokeStatic(KeyEncoder.class.getName(), "encodeDesc", retType, params);
            } else {
                a.invokeStatic(DataEncoder.class.getName(), "encode", retType, params);
            }
            return adjust;
        }
        if (mode == Mode.KEY) {
            if (descending) {
                a.invokeStatic(KeyEncoder.class.getName(), "encodeDesc", TypeDesc.INT, params);
            } else {
                a.invokeStatic(KeyEncoder.class.getName(), "encode", TypeDesc.INT, params);
            }
        } else {
            a.invokeStatic(DataEncoder.class.getName(), "encode", TypeDesc.INT, params);
        }
        return 0;
    }

    private void encodeGeneration(CodeAssembler a, LocalVariable encodedVar, int offset, int generation) {
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        if (generation < 0) {
            return;
        }
        if (generation < 128) {
            a.loadLocal(encodedVar);
            a.loadConstant(offset);
            a.loadConstant((int)((byte)generation));
            a.storeToArray(TypeDesc.BYTE);
        } else {
            generation |= Integer.MIN_VALUE;
            for (int i = 0; i < 4; ++i) {
                a.loadLocal(encodedVar);
                a.loadConstant(offset + i);
                a.loadConstant((int)((byte)(generation >> 8 * (3 - i))));
                a.storeToArray(TypeDesc.BYTE);
            }
        }
    }

    private void encodePropertyStates(CodeAssembler a, LocalVariable encodedVar, int offset, StorableProperty<S>[] properties) {
        LocalVariable stateFieldVar = a.createLocalVariable(null, TypeDesc.INT);
        int lastFieldOrdinal = -1;
        LocalVariable accumVar = a.createLocalVariable(null, TypeDesc.INT);
        int accumShift = 0;
        for (int i = 0; i < properties.length; ++i) {
            StorableProperty<S> property = properties[i];
            int fieldOrdinal = property.getNumber() >> 4;
            if (fieldOrdinal == lastFieldOrdinal) {
                a.loadLocal(stateFieldVar);
            } else {
                a.loadThis();
                a.loadField("propertyState$" + fieldOrdinal, TypeDesc.INT);
                a.storeLocal(stateFieldVar);
                a.loadLocal(stateFieldVar);
                lastFieldOrdinal = fieldOrdinal;
            }
            int stateShift = (property.getNumber() & 0xF) * 2;
            int accumPack = 2;
            int mask = 3 << stateShift;
            while (accumShift + accumPack < 8 && i + 1 < properties.length) {
                StorableProperty<S> nextProperty = properties[i + 1];
                if (property.getNumber() + 1 != nextProperty.getNumber() || fieldOrdinal != nextProperty.getNumber() >> 4) break;
                accumPack += 2;
                mask |= 3 << (nextProperty.getNumber() & 0xF) * 2;
                property = nextProperty;
                ++i;
            }
            a.loadConstant(mask);
            a.math((byte)126);
            if (stateShift < accumShift) {
                a.loadConstant(accumShift - stateShift);
                a.math((byte)120);
            } else if (stateShift > accumShift) {
                a.loadConstant(stateShift - accumShift);
                a.math((byte)124);
            }
            if (accumShift != 0) {
                a.loadLocal(accumVar);
                a.math((byte)-128);
            }
            a.storeLocal(accumVar);
            if ((accumShift += accumPack) < 8) continue;
            a.loadLocal(encodedVar);
            a.loadConstant(offset++);
            a.loadLocal(accumVar);
            a.storeToArray(TypeDesc.BYTE);
            accumShift = 0;
        }
        if (accumShift > 0) {
            a.loadLocal(encodedVar);
            a.loadConstant(offset++);
            a.loadLocal(accumVar);
            a.storeToArray(TypeDesc.BYTE);
        }
    }

    protected void pushRawSupport(CodeAssembler a, LocalVariable instanceVar) throws SupportException {
        boolean isObjectArrayInstanceVar;
        boolean bl = isObjectArrayInstanceVar = instanceVar != null && instanceVar.getType() == TypeDesc.forClass(Object[].class);
        if (isObjectArrayInstanceVar) {
            throw new SupportException("Lob properties not supported");
        }
        if (instanceVar == null) {
            a.loadThis();
        } else {
            a.loadLocal(instanceVar);
        }
        a.loadField("support$", TypeDesc.forClass(TriggerSupport.class));
        a.checkCast(TypeDesc.forClass(RawSupport.class));
    }

    private void getLobLocator(CodeAssembler a, StorablePropertyInfo info) {
        if (!info.isLob()) {
            throw new IllegalArgumentException();
        }
        a.invokeInterface(TypeDesc.forClass(RawSupport.class), "getLocator", TypeDesc.LONG, new TypeDesc[]{info.getStorageType()});
    }

    private void getLobFromLocator(CodeAssembler a, StorablePropertyInfo info) {
        String name;
        if (!info.isLob()) {
            throw new IllegalArgumentException();
        }
        TypeDesc type = info.getStorageType();
        if (Blob.class.isAssignableFrom(type.toClass())) {
            name = "getBlob";
        } else if (Clob.class.isAssignableFrom(type.toClass())) {
            name = "getClob";
        } else {
            throw new IllegalArgumentException();
        }
        a.invokeInterface(TypeDesc.forClass(RawSupport.class), name, type, new TypeDesc[]{TypeDesc.forClass(Storable.class), TypeDesc.STRING, TypeDesc.LONG});
    }

    private void buildDecoding(Mode mode, CodeAssembler a, StorableProperty<S>[] properties, Direction[] directions, LocalVariable instanceVar, Class<?> adapterInstanceClass, boolean useWriteMethods, int generation, Label altGenerationHandler, LocalVariable encodedVar) throws SupportException {
        int i;
        int suffix;
        int prefix;
        if (a == null) {
            throw new IllegalArgumentException();
        }
        if (encodedVar == null || encodedVar.getType() != TypeDesc.forClass(byte[].class)) {
            throw new IllegalArgumentException();
        }
        switch (mode) {
            default: {
                prefix = 0;
                break;
            }
            case KEY: {
                prefix = this.mKeyPrefixPadding;
                break;
            }
            case DATA: {
                prefix = this.mDataPrefixPadding;
            }
        }
        this.decodeGeneration(a, encodedVar, prefix, generation, altGenerationHandler);
        int generationPrefix = generation < 0 ? 0 : (generation < 128 ? 1 : 4);
        switch (mode) {
            default: {
                suffix = 0;
                break;
            }
            case KEY: {
                suffix = this.mKeySuffixPadding;
                break;
            }
            case DATA: {
                suffix = this.mDataSuffixPadding;
                this.extraDataDecoding(a, encodedVar, prefix + generationPrefix, suffix);
            }
        }
        TypeDesc byteArrayType = TypeDesc.forClass(byte[].class);
        StorablePropertyInfo[] infos = this.checkSupport(properties);
        if (properties.length == 1) {
            StorableProperty<S> property = properties[0];
            StorablePropertyInfo info = infos[0];
            if (mode != Mode.SERIAL && info.getStorageType().toClass() == byte[].class) {
                TypeDesc[] params;
                boolean descending;
                this.pushDecodingInstanceVar(a, 0, instanceVar);
                a.loadLocal(encodedVar);
                boolean bl = descending = mode == Mode.KEY && directions != null && directions[0] == Direction.DESCENDING;
                if (prefix > 0 || generationPrefix > 0 || suffix > 0) {
                    a.loadConstant(prefix + generationPrefix);
                    a.loadConstant(suffix);
                    params = new TypeDesc[]{byteArrayType, TypeDesc.INT, TypeDesc.INT};
                } else {
                    params = new TypeDesc[]{byteArrayType};
                }
                if (property.isNullable()) {
                    if (descending) {
                        a.invokeStatic(KeyDecoder.class.getName(), "decodeSingleNullableDesc", byteArrayType, params);
                    } else {
                        a.invokeStatic(DataDecoder.class.getName(), "decodeSingleNullable", byteArrayType, params);
                    }
                } else if (descending) {
                    a.invokeStatic(KeyDecoder.class.getName(), "decodeSingleDesc", byteArrayType, params);
                } else if (prefix > 0 || generationPrefix > 0 || suffix > 0) {
                    a.invokeStatic(DataDecoder.class.getName(), "decodeSingle", byteArrayType, params);
                } else {
                    a.invokeVirtual(TypeDesc.OBJECT, "clone", TypeDesc.OBJECT, null);
                    a.checkCast(byteArrayType);
                }
                this.storePropertyValue(a, info, useWriteMethods, instanceVar, adapterInstanceClass);
                return;
            }
        }
        int constantOffset = prefix + generationPrefix;
        LocalVariable offsetVar = null;
        LocalVariable[] stringRefRef = new LocalVariable[1];
        LocalVariable[] byteArrayRefRef = new LocalVariable[1];
        LocalVariable[] bigIntegerRefRef = new LocalVariable[1];
        LocalVariable[] bigDecimalRefRef = new LocalVariable[1];
        LocalVariable[] valueRefRef = new LocalVariable[1];
        List<LocalVariable> stateVars = null;
        if (mode == Mode.SERIAL) {
            stateVars = this.decodePropertyStates(a, encodedVar, constantOffset, properties);
            offsetVar = a.createLocalVariable(null, TypeDesc.INT);
            a.loadConstant(constantOffset += (properties.length + 3) / 4);
            a.storeLocal(offsetVar);
            for (i = 0; i < properties.length; ++i) {
                TypeDesc refType;
                TypeDesc storageType = infos[i].getStorageType();
                if (storageType == TypeDesc.STRING) {
                    if (stringRefRef[0] != null) continue;
                    refType = TypeDesc.forClass(String[].class);
                    stringRefRef[0] = a.createLocalVariable(null, refType);
                    a.loadConstant(1);
                    a.newObject(refType);
                    a.storeLocal(stringRefRef[0]);
                    continue;
                }
                if (storageType.toClass() == byte[].class) {
                    if (byteArrayRefRef[0] != null) continue;
                    refType = TypeDesc.forClass(byte[][].class);
                    byteArrayRefRef[0] = a.createLocalVariable(null, refType);
                    a.loadConstant(1);
                    a.newObject(refType);
                    a.storeLocal(byteArrayRefRef[0]);
                    continue;
                }
                if (storageType.toClass() == BigInteger.class) {
                    if (bigIntegerRefRef[0] != null) continue;
                    refType = TypeDesc.forClass(BigInteger[].class);
                    bigIntegerRefRef[0] = a.createLocalVariable(null, refType);
                    a.loadConstant(1);
                    a.newObject(refType);
                    a.storeLocal(bigIntegerRefRef[0]);
                    continue;
                }
                if (storageType.toClass() != BigDecimal.class || bigDecimalRefRef[0] != null) continue;
                refType = TypeDesc.forClass(BigDecimal[].class);
                bigDecimalRefRef[0] = a.createLocalVariable(null, refType);
                a.loadConstant(1);
                a.newObject(refType);
                a.storeLocal(bigDecimalRefRef[0]);
            }
        }
        for (i = 0; i < properties.length; ++i) {
            StorableProperty<S> property = properties[i];
            StorablePropertyInfo info = infos[i];
            Label storePropertyLocation = a.createLabel();
            Label nextPropertyLocation = a.createLabel();
            this.pushDecodingInstanceVar(a, i, instanceVar);
            if (mode == Mode.SERIAL) {
                a.loadLocal(stateVars.get(property.getNumber() >> 4));
                a.loadConstant(3 << (property.getNumber() & 0xF) * 2);
                a.math((byte)126);
                Label isInitialized = a.createLabel();
                a.ifZeroComparisonBranch((Location)isInitialized, "!=");
                this.loadBlankValue(a, TypeDesc.forClass(property.getType()));
                if (info.getToStorageAdapter() != null) {
                    a.storeField(info.getPropertyName(), info.getPropertyType());
                    a.branch((Location)nextPropertyLocation);
                } else {
                    a.branch((Location)storePropertyLocation);
                }
                isInitialized.setLocation();
            }
            TypeDesc storageType = info.getStorageType();
            if (info.isLob()) {
                this.pushRawSupport(a, instanceVar);
                a.loadThis();
                a.loadConstant(info.getPropertyName());
                storageType = TypeDesc.LONG;
            }
            a.loadLocal(encodedVar);
            if (offsetVar == null) {
                a.loadConstant(constantOffset);
            } else {
                a.loadLocal(offsetVar);
            }
            boolean descending = mode == Mode.KEY && directions != null && directions[i] == Direction.DESCENDING;
            int amt = this.decodeProperty(a, info, storageType, mode, descending, stringRefRef, byteArrayRefRef, bigIntegerRefRef, bigDecimalRefRef, valueRefRef);
            if (info.isLob()) {
                this.getLobFromLocator(a, info);
            }
            if (amt != 0) {
                if (i + 1 < properties.length) {
                    if (amt > 0) {
                        if (offsetVar == null) {
                            constantOffset += amt;
                        } else {
                            a.loadConstant(amt);
                            a.loadLocal(offsetVar);
                            a.math((byte)96);
                            a.storeLocal(offsetVar);
                        }
                    } else {
                        a.dup();
                        Label notNull = a.createLabel();
                        a.ifNullBranch((Location)notNull, false);
                        a.loadConstant(1 + (offsetVar == null ? constantOffset : 0));
                        Label cont = a.createLabel();
                        a.branch((Location)cont);
                        notNull.setLocation();
                        a.loadConstant(~amt + (offsetVar == null ? constantOffset : 0));
                        cont.setLocation();
                        if (offsetVar == null) {
                            offsetVar = a.createLocalVariable(null, TypeDesc.INT);
                        } else {
                            a.loadLocal(offsetVar);
                            a.math((byte)96);
                        }
                        a.storeLocal(offsetVar);
                    }
                }
            } else {
                if (i + 1 >= properties.length) {
                    a.pop();
                } else {
                    if (offsetVar == null) {
                        if (constantOffset > 0) {
                            a.loadConstant(constantOffset);
                            a.math((byte)96);
                        }
                        offsetVar = a.createLocalVariable(null, TypeDesc.INT);
                    } else {
                        a.loadLocal(offsetVar);
                        a.math((byte)96);
                    }
                    a.storeLocal(offsetVar);
                }
                a.loadLocal(valueRefRef[0]);
                a.loadConstant(0);
                a.loadFromArray(valueRefRef[0].getType());
            }
            storePropertyLocation.setLocation();
            this.storePropertyValue(a, info, useWriteMethods, instanceVar, adapterInstanceClass);
            nextPropertyLocation.setLocation();
        }
        if (stateVars != null) {
            for (i = 0; i < stateVars.size(); ++i) {
                LocalVariable stateVar = stateVars.get(i);
                if (stateVar == null) continue;
                a.loadThis();
                a.loadLocal(stateVar);
                a.storeField("propertyState$" + i, TypeDesc.INT);
            }
        }
    }

    private int decodeProperty(CodeAssembler a, GenericPropertyInfo info, TypeDesc storageType, Mode mode, boolean descending, LocalVariable[] stringRefRef, LocalVariable[] byteArrayRefRef, LocalVariable[] bigIntegerRefRef, LocalVariable[] bigDecimalRefRef, LocalVariable[] valueRefRef) throws SupportException {
        TypeDesc refType;
        String methodName;
        TypeDesc primType = storageType.toPrimitiveType();
        if (primType != null) {
            int adjust;
            String methodName2;
            TypeDesc returnType;
            if (primType != storageType && info.isNullable()) {
                returnType = storageType;
                switch (primType.getTypeCode()) {
                    case 8: {
                        methodName2 = "decodeByteObj";
                        adjust = -3;
                        break;
                    }
                    case 4: {
                        methodName2 = "decodeBooleanObj";
                        adjust = 1;
                        break;
                    }
                    case 9: {
                        methodName2 = "decodeShortObj";
                        adjust = -4;
                        break;
                    }
                    case 5: {
                        methodName2 = "decodeCharacterObj";
                        adjust = -4;
                        break;
                    }
                    default: {
                        methodName2 = "decodeIntegerObj";
                        adjust = -6;
                        break;
                    }
                    case 6: {
                        methodName2 = "decodeFloatObj";
                        adjust = 4;
                        break;
                    }
                    case 11: {
                        methodName2 = "decodeLongObj";
                        adjust = -10;
                        break;
                    }
                    case 7: {
                        methodName2 = "decodeDoubleObj";
                        adjust = 8;
                        break;
                    }
                }
            } else {
                returnType = primType;
                switch (primType.getTypeCode()) {
                    case 8: {
                        methodName2 = "decodeByte";
                        adjust = 1;
                        break;
                    }
                    case 4: {
                        methodName2 = "decodeBoolean";
                        adjust = 1;
                        break;
                    }
                    case 9: {
                        methodName2 = "decodeShort";
                        adjust = 2;
                        break;
                    }
                    case 5: {
                        methodName2 = "decodeChar";
                        adjust = 2;
                        break;
                    }
                    default: {
                        methodName2 = "decodeInt";
                        adjust = 4;
                        break;
                    }
                    case 6: {
                        methodName2 = "decodeFloat";
                        adjust = 4;
                        break;
                    }
                    case 11: {
                        methodName2 = "decodeLong";
                        adjust = 8;
                        break;
                    }
                    case 7: {
                        methodName2 = "decodeDouble";
                        adjust = 8;
                    }
                }
            }
            TypeDesc[] params = new TypeDesc[]{TypeDesc.forClass(byte[].class), TypeDesc.INT};
            if (mode == Mode.KEY && descending) {
                a.invokeStatic(KeyDecoder.class.getName(), methodName2 + "Desc", returnType, params);
            } else {
                a.invokeStatic(DataDecoder.class.getName(), methodName2, returnType, params);
            }
            if (returnType.isPrimitive() && !storageType.isPrimitive()) {
                a.convert(returnType, storageType);
            }
            return adjust;
        }
        String className = (mode == Mode.KEY ? KeyDecoder.class : DataDecoder.class).getName();
        if (storageType == TypeDesc.STRING) {
            methodName = mode == Mode.KEY && descending ? "decodeStringDesc" : "decodeString";
            refType = TypeDesc.forClass(String[].class);
            if (stringRefRef[0] == null) {
                stringRefRef[0] = a.createLocalVariable(null, refType);
                a.loadConstant(1);
                a.newObject(refType);
                a.storeLocal(stringRefRef[0]);
            }
            a.loadLocal(stringRefRef[0]);
            valueRefRef[0] = stringRefRef[0];
        } else if (storageType.toClass() == byte[].class) {
            methodName = mode == Mode.KEY && descending ? "decodeDesc" : "decode";
            refType = TypeDesc.forClass(byte[][].class);
            if (byteArrayRefRef[0] == null) {
                byteArrayRefRef[0] = a.createLocalVariable(null, refType);
                a.loadConstant(1);
                a.newObject(refType);
                a.storeLocal(byteArrayRefRef[0]);
            }
            a.loadLocal(byteArrayRefRef[0]);
            valueRefRef[0] = byteArrayRefRef[0];
        } else if (storageType.toClass() == BigInteger.class) {
            methodName = mode == Mode.KEY && descending ? "decodeDesc" : "decode";
            refType = TypeDesc.forClass(BigInteger[].class);
            if (bigIntegerRefRef[0] == null) {
                bigIntegerRefRef[0] = a.createLocalVariable(null, refType);
                a.loadConstant(1);
                a.newObject(refType);
                a.storeLocal(bigIntegerRefRef[0]);
            }
            a.loadLocal(bigIntegerRefRef[0]);
            valueRefRef[0] = bigIntegerRefRef[0];
        } else if (storageType.toClass() == BigDecimal.class) {
            methodName = mode == Mode.KEY && descending ? "decodeDesc" : "decode";
            refType = TypeDesc.forClass(BigDecimal[].class);
            if (bigDecimalRefRef[0] == null) {
                bigDecimalRefRef[0] = a.createLocalVariable(null, refType);
                a.loadConstant(1);
                a.newObject(refType);
                a.storeLocal(bigDecimalRefRef[0]);
            }
            a.loadLocal(bigDecimalRefRef[0]);
            valueRefRef[0] = bigDecimalRefRef[0];
        } else {
            throw this.notSupported(info.getPropertyName(), storageType.getFullName());
        }
        TypeDesc[] params = new TypeDesc[]{TypeDesc.forClass(byte[].class), TypeDesc.INT, refType};
        a.invokeStatic(className, methodName, TypeDesc.INT, params);
        return 0;
    }

    protected void pushDecodingInstanceVar(CodeAssembler a, int ordinal, LocalVariable instanceVar) {
        if (instanceVar == null) {
            a.loadThis();
        } else if (instanceVar.getType() != TypeDesc.forClass(Object[].class)) {
            a.loadLocal(instanceVar);
        } else {
            a.loadLocal(instanceVar);
            a.loadConstant(ordinal);
        }
    }

    /*
     * Exception decompiling
     */
    protected void storePropertyValue(CodeAssembler a, StorablePropertyInfo info, boolean useWriteMethod, LocalVariable instanceVar, Class<?> adapterInstanceClass) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void decodeGeneration(CodeAssembler a, LocalVariable encodedVar, int offset, int generation, Label altGenerationHandler) {
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        if (generation < 0) {
            return;
        }
        LocalVariable actualGeneration = a.createLocalVariable(null, TypeDesc.INT);
        a.loadLocal(encodedVar);
        a.loadConstant(offset);
        a.loadFromArray(TypeDesc.BYTE);
        a.storeLocal(actualGeneration);
        a.loadLocal(actualGeneration);
        Label compareGeneration = a.createLabel();
        a.ifZeroComparisonBranch((Location)compareGeneration, ">=");
        a.loadLocal(actualGeneration);
        a.loadConstant(24);
        a.math((byte)120);
        a.loadConstant(Integer.MAX_VALUE);
        a.math((byte)126);
        for (int i = 1; i < 4; ++i) {
            a.loadLocal(encodedVar);
            a.loadConstant(offset + i);
            a.loadFromArray(TypeDesc.BYTE);
            a.loadConstant(255);
            a.math((byte)126);
            int shift = 8 * (3 - i);
            if (shift > 0) {
                a.loadConstant(shift);
                a.math((byte)120);
            }
            a.math((byte)-128);
        }
        a.storeLocal(actualGeneration);
        compareGeneration.setLocation();
        a.loadConstant(generation);
        a.loadLocal(actualGeneration);
        Label generationMatches = a.createLabel();
        a.ifComparisonBranch((Location)generationMatches, "==");
        if (altGenerationHandler != null) {
            a.loadLocal(actualGeneration);
            a.branch((Location)altGenerationHandler);
        } else {
            TypeDesc corruptEncodingEx = TypeDesc.forClass(CorruptEncodingException.class);
            a.newObject(corruptEncodingEx);
            a.dup();
            a.loadConstant(generation);
            a.loadLocal(actualGeneration);
            a.invokeConstructor(corruptEncodingEx, new TypeDesc[]{TypeDesc.INT, TypeDesc.INT});
            a.throwObject();
        }
        generationMatches.setLocation();
    }

    private List<LocalVariable> decodePropertyStates(CodeAssembler a, LocalVariable encodedVar, int offset, StorableProperty<S>[] properties) {
        Vector<LocalVariable> stateVars = new Vector<LocalVariable>();
        LocalVariable accumVar = a.createLocalVariable(null, TypeDesc.INT);
        int accumShift = 8;
        for (int i = 0; i < properties.length; ++i) {
            StorableProperty<S> property = properties[i];
            int stateVarOrdinal = property.getNumber() >> 4;
            stateVars.setSize(Math.max(stateVars.size(), stateVarOrdinal + 1));
            if (stateVars.get(stateVarOrdinal) == null) {
                stateVars.set(stateVarOrdinal, a.createLocalVariable(null, TypeDesc.INT));
                a.loadThis();
                a.loadField("propertyState$" + stateVarOrdinal, TypeDesc.INT);
                a.storeLocal(stateVars.get(stateVarOrdinal));
            }
            if (accumShift >= 8) {
                a.loadLocal(encodedVar);
                a.loadConstant(offset++);
                a.loadFromArray(TypeDesc.BYTE);
                a.loadConstant(255);
                a.math((byte)126);
                a.storeLocal(accumVar);
                accumShift = 0;
            }
            int stateShift = (property.getNumber() & 0xF) * 2;
            int accumPack = 2;
            int mask = 3 << stateShift;
            while (accumShift + accumPack < 8 && i + 1 < properties.length) {
                StorableProperty<S> nextProperty = properties[i + 1];
                if (property.getNumber() + 1 != nextProperty.getNumber() || stateVarOrdinal != nextProperty.getNumber() >> 4) break;
                accumPack += 2;
                mask |= 3 << (nextProperty.getNumber() & 0xF) * 2;
                property = nextProperty;
                ++i;
            }
            a.loadLocal(accumVar);
            if (stateShift < accumShift) {
                a.loadConstant(accumShift - stateShift);
                a.math((byte)124);
            } else if (stateShift > accumShift) {
                a.loadConstant(stateShift - accumShift);
                a.math((byte)120);
            }
            a.loadConstant(mask);
            a.math((byte)126);
            a.loadLocal(stateVars.get(stateVarOrdinal));
            a.loadConstant(~mask);
            a.math((byte)126);
            a.math((byte)-128);
            a.storeLocal(stateVars.get(stateVarOrdinal));
            accumShift += accumPack;
        }
        return stateVars;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        KEY,
        DATA,
        SERIAL;

    }
}

