/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.raw;

import com.amazon.carbonado.CorruptEncodingException;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.raw.RawStorableGenerator;
import com.amazon.carbonado.raw.RawSupport;
import com.amazon.carbonado.raw.StorableCodec;
import com.amazon.carbonado.util.QuickConstructorGenerator;
import java.util.Map;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.ClassInjector;
import org.cojen.util.WeakIdentityMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CustomStorableCodec<S extends Storable>
implements StorableCodec<S> {
    private static final String CUSTOM_STORABLE_CODEC_FIELD_NAME = "customStorableCodec$";
    private static Map<Class, RawStorableGenerator.Flavors<? extends Storable>> cCache = new WeakIdentityMap();
    private final Class<S> mType;
    private final int mPkPropertyCount;
    private final InstanceFactory mInstanceFactory;
    RawSupport<S> mSupport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <S extends Storable> Class<? extends S> getStorableClass(Class<S> type, boolean isMaster) throws SupportException {
        Map<Class, RawStorableGenerator.Flavors<? extends Storable>> map = cCache;
        synchronized (map) {
            Class storableClass;
            RawStorableGenerator.Flavors<Storable<? extends Storable>> flavors = cCache.get(type);
            if (flavors == null) {
                flavors = new RawStorableGenerator.Flavors();
                cCache.put(type, flavors);
            } else {
                storableClass = flavors.getClass(isMaster);
                if (storableClass != null) {
                    return storableClass;
                }
            }
            storableClass = CustomStorableCodec.generateStorableClass(type, isMaster);
            flavors.setClass(storableClass, isMaster);
            return storableClass;
        }
    }

    private static <S extends Storable> Class<? extends S> generateStorableClass(Class<S> type, boolean isMaster) throws SupportException {
        Class<S> abstractClass = RawStorableGenerator.getAbstractClass(type, isMaster);
        ClassInjector ci = ClassInjector.create((String)type.getName(), (ClassLoader)abstractClass.getClassLoader());
        ClassFile cf = new ClassFile(ci.getClassName(), abstractClass);
        cf.markSynthetic();
        cf.setSourceFile(CustomStorableCodec.class.getName());
        cf.setTarget("1.5");
        TypeDesc rawSupportType = TypeDesc.forClass(RawSupport.class);
        TypeDesc byteArrayType = TypeDesc.forClass(byte[].class);
        TypeDesc[] byteArrayParam = new TypeDesc[]{byteArrayType};
        TypeDesc customStorableCodecType = TypeDesc.forClass(CustomStorableCodec.class);
        cf.addField(Modifiers.PRIVATE.toFinal(true), CUSTOM_STORABLE_CODEC_FIELD_NAME, customStorableCodecType);
        TypeDesc[] params = new TypeDesc[]{rawSupportType, customStorableCodecType};
        MethodInfo mi = cf.addConstructor(Modifiers.PUBLIC, params);
        CodeBuilder b = new CodeBuilder(mi);
        b.loadThis();
        b.loadLocal(b.getParameter(0));
        params = new TypeDesc[]{rawSupportType};
        b.invokeSuperConstructor(params);
        b.loadThis();
        b.loadLocal(b.getParameter(1));
        b.storeField(CUSTOM_STORABLE_CODEC_FIELD_NAME, customStorableCodecType);
        b.returnVoid();
        params = new TypeDesc[]{rawSupportType, byteArrayType, byteArrayType, customStorableCodecType};
        mi = cf.addConstructor(Modifiers.PUBLIC, params);
        b = new CodeBuilder(mi);
        b.loadThis();
        b.loadLocal(b.getParameter(3));
        b.storeField(CUSTOM_STORABLE_CODEC_FIELD_NAME, customStorableCodecType);
        b.loadThis();
        b.loadLocal(b.getParameter(0));
        b.loadLocal(b.getParameter(1));
        b.loadLocal(b.getParameter(2));
        params = new TypeDesc[]{rawSupportType, byteArrayType, byteArrayType};
        b.invokeSuperConstructor(params);
        b.returnVoid();
        MethodInfo mi2 = cf.addMethod(Modifiers.PROTECTED, "encodeKey$", byteArrayType, null);
        CodeBuilder b2 = new CodeBuilder(mi2);
        b2.loadThis();
        b2.loadField(CUSTOM_STORABLE_CODEC_FIELD_NAME, customStorableCodecType);
        TypeDesc[] params2 = new TypeDesc[]{TypeDesc.forClass(Storable.class)};
        b2.loadThis();
        b2.invokeVirtual(customStorableCodecType, "encodePrimaryKey", byteArrayType, params2);
        b2.returnValue(byteArrayType);
        mi2 = cf.addMethod(Modifiers.PROTECTED, "encodeData$", byteArrayType, null);
        b2 = new CodeBuilder(mi2);
        b2.loadThis();
        b2.loadField(CUSTOM_STORABLE_CODEC_FIELD_NAME, customStorableCodecType);
        params2 = new TypeDesc[]{TypeDesc.forClass(Storable.class)};
        b2.loadThis();
        b2.invokeVirtual(customStorableCodecType, "encodeData", byteArrayType, params2);
        b2.returnValue(byteArrayType);
        mi2 = cf.addMethod(Modifiers.PROTECTED, "decodeKey$", null, byteArrayParam);
        b2 = new CodeBuilder(mi2);
        b2.loadThis();
        b2.loadField(CUSTOM_STORABLE_CODEC_FIELD_NAME, customStorableCodecType);
        params2 = new TypeDesc[]{TypeDesc.forClass(Storable.class), byteArrayType};
        b2.loadThis();
        b2.loadLocal(b2.getParameter(0));
        b2.invokeVirtual(customStorableCodecType, "decodePrimaryKey", null, params2);
        b2.returnVoid();
        mi2 = cf.addMethod(Modifiers.PROTECTED, "decodeData$", null, byteArrayParam);
        b2 = new CodeBuilder(mi2);
        b2.loadThis();
        b2.loadField(CUSTOM_STORABLE_CODEC_FIELD_NAME, customStorableCodecType);
        params2 = new TypeDesc[]{TypeDesc.forClass(Storable.class), byteArrayType};
        b2.loadThis();
        b2.loadLocal(b2.getParameter(0));
        b2.invokeVirtual(customStorableCodecType, "decodeData", null, params2);
        b2.returnVoid();
        return ci.defineClass(cf);
    }

    public CustomStorableCodec(Class<S> type, boolean isMaster) throws SupportException {
        this(type, isMaster, null);
    }

    public CustomStorableCodec(Class<S> type, boolean isMaster, RawSupport<S> support) throws SupportException {
        this.mType = type;
        this.mPkPropertyCount = this.getPrimaryKeyIndex().getPropertyCount();
        Class<S> storableClass = CustomStorableCodec.getStorableClass(type, isMaster);
        this.mInstanceFactory = QuickConstructorGenerator.getInstance(storableClass, InstanceFactory.class);
        this.mSupport = support;
    }

    @Override
    public Class<S> getStorableType() {
        return this.mType;
    }

    @Override
    public S instantiate() {
        return (S)this.mInstanceFactory.instantiate(this.support(), this);
    }

    @Override
    public S instantiate(byte[] key, byte[] value) throws FetchException {
        return (S)this.mInstanceFactory.instantiate(this.support(), key, value, this);
    }

    @Override
    public S instantiate(RawSupport<S> support) {
        return (S)this.mInstanceFactory.instantiate(support, this);
    }

    @Override
    public S instantiate(RawSupport<S> support, byte[] key, byte[] value) throws FetchException {
        return (S)this.mInstanceFactory.instantiate(support, key, value, this);
    }

    @Override
    public byte[] encodePrimaryKey(S storable) {
        return this.encodePrimaryKey(storable, 0, this.mPkPropertyCount);
    }

    @Override
    public byte[] encodePrimaryKey(Object[] values) {
        return this.encodePrimaryKey(values, 0, this.mPkPropertyCount);
    }

    @Override
    public RawSupport<S> getSupport() {
        return this.mSupport;
    }

    private RawSupport<S> support() {
        RawSupport<S> support = this.mSupport;
        if (support == null) {
            throw new IllegalStateException("No RawSupport");
        }
        return support;
    }

    public Map<String, ? extends StorableProperty<S>> getAllProperties() {
        return StorableIntrospector.examine(this.getStorableType()).getAllProperties();
    }

    public StorableIndex<S> buildPkIndex(String ... propertyNames) {
        Map<String, StorableProperty<S>> map = this.getAllProperties();
        int length = propertyNames.length;
        StorableProperty[] properties = new StorableProperty[length];
        Direction[] directions = new Direction[length];
        for (int i = 0; i < length; ++i) {
            String name = propertyNames[i];
            char c = name.charAt(0);
            Direction dir = Direction.fromCharacter(c);
            if (dir != Direction.UNSPECIFIED || c == Direction.UNSPECIFIED.toCharacter()) {
                name = name.substring(1);
            } else {
                dir = Direction.ASCENDING;
            }
            properties[i] = map.get(name);
            if (properties[i] == null) {
                throw new IllegalArgumentException("Unknown property: " + name);
            }
            directions[i] = dir;
        }
        return new StorableIndex(properties, directions, true, true);
    }

    public abstract void decodePrimaryKey(S var1, byte[] var2) throws CorruptEncodingException;

    public abstract byte[] encodeData(S var1);

    public abstract void decodeData(S var1, byte[] var2) throws CorruptEncodingException;

    public static interface InstanceFactory {
        public Storable instantiate(RawSupport var1, CustomStorableCodec var2);

        public Storable instantiate(RawSupport var1, byte[] var2, byte[] var3, CustomStorableCodec var4) throws FetchException;
    }
}

