/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.filter.AndFilter;
import com.amazon.carbonado.filter.ExistsFilter;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.OrFilter;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.Visitor;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableKey;
import com.amazon.carbonado.qe.IndexedQueryAnalyzer;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.qe.OrderingScore;
import com.amazon.carbonado.qe.PropertyFilterList;
import com.amazon.carbonado.qe.QueryExecutor;
import com.amazon.carbonado.qe.QueryExecutorFactory;
import com.amazon.carbonado.qe.QueryHints;
import com.amazon.carbonado.qe.RepositoryAccess;
import com.amazon.carbonado.qe.UnionQueryExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionQueryAnalyzer<S extends Storable>
implements QueryExecutorFactory<S> {
    final IndexedQueryAnalyzer<S> mIndexAnalyzer;
    final RepositoryAccess mRepoAccess;

    public UnionQueryAnalyzer(Class<S> type, RepositoryAccess access) {
        this.mIndexAnalyzer = new IndexedQueryAnalyzer<S>(type, access);
        this.mRepoAccess = access;
    }

    @Override
    public Class<S> getStorableType() {
        return this.mIndexAnalyzer.getStorableType();
    }

    public Result analyze(Filter<S> filter, OrderingList<S> ordering, QueryHints hints) throws SupportException, RepositoryException {
        if (filter != null && !filter.isBound()) {
            throw new IllegalArgumentException("Filter must be bound");
        }
        if (ordering == null) {
            ordering = OrderingList.emptyList();
        }
        return this.buildResult(filter, ordering, hints);
    }

    @Override
    public QueryExecutor<S> executor(Filter<S> filter, OrderingList<S> ordering, QueryHints hints) throws RepositoryException {
        return this.analyze(filter, ordering, hints).createExecutor();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private Result buildResult(Filter<S> filter, OrderingList<S> ordering, QueryHints hints) throws SupportException, RepositoryException {
        subResults = filter == null ? Collections.singletonList(this.mIndexAnalyzer.analyze(filter, ordering, hints)) : this.splitIntoSubResults(filter, ordering, hints);
        if (subResults.size() <= 1) {
            return new Result(subResults);
        }
        for (pos = 0; pos < ordering.size(); ++pos) {
            op = ordering.get(pos);
            if (op.getDirection() != Direction.UNSPECIFIED) continue;
            tally = new Tally(op.getChainedProperty());
            for (IndexedQueryAnalyzer.Result result : subResults) {
                tally.increment(this.findHandledDirection(result, (OrderedProperty<S>)op));
            }
            subResults = this.splitIntoSubResults(filter, ordering = ordering.replace(pos, op.direction(tally.getBestDirection())), hints);
            if (subResults.size() > 1) continue;
            return new Result(subResults);
        }
        keys = this.getKeys();
        for (OrderedProperty op : ordering) {
            property = op.getChainedProperty();
            if (!this.pruneKeys(keys, property)) continue;
            return new Result(subResults, ordering);
        }
        superKey = new LinkedHashMap<ChainedProperty<S>, Tally>();
        for (Set<ChainedProperty<S>> key : keys) {
            for (ChainedProperty<S> property : key) {
                if (superKey.containsKey(property)) continue;
                superKey.put(property, new Tally(property));
            }
        }
        while (true) {
            for (IndexedQueryAnalyzer.Result result : subResults) {
                score = result.getCompositeScore().getOrderingScore();
                unused = score.getUnusedOrdering();
                if (unused.size() > 0) {
                    for (Object prop : unused) {
                        chainedProp = prop.getChainedProperty();
                        tally = (Tally)superKey.get(chainedProp);
                        if (tally == null) continue;
                        tally.increment(prop.getDirection());
                    }
                }
                if ((free = score.getFreeOrdering()).size() <= 0 || (tally = (Tally)superKey.get(chainedProp = (prop = free.get(0)).getChainedProperty())) == null) continue;
                tally.increment(prop.getDirection());
            }
            best = this.bestTally(superKey.values());
            bestProperty = best.getProperty();
            subResults = this.splitIntoSubResults(filter, ordering = ordering.concat(OrderedProperty.get(bestProperty, best.getBestDirection())), hints);
            if (subResults.size() <= 1) break;
            superKey.remove(bestProperty);
            if (superKey.size() == 0 || this.pruneKeys(keys, bestProperty)) break;
            i$ = superKey.values().iterator();
            while (true) {
                if (!i$.hasNext()) ** continue;
                tally = (Tally)i$.next();
                tally.clear();
            }
            break;
        }
        return new Result(subResults, ordering);
    }

    private List<Set<ChainedProperty<S>>> getKeys() throws SupportException, RepositoryException {
        StorableInfo<S> info = StorableIntrospector.examine(this.mIndexAnalyzer.getStorableType());
        ArrayList<Set<ChainedProperty<S>>> keys = new ArrayList<Set<ChainedProperty<S>>>();
        keys.add(this.stripOrdering(info.getPrimaryKey().getProperties()));
        for (StorableKey<S> altKey : info.getAlternateKeys()) {
            keys.add(this.stripOrdering(altKey.getProperties()));
        }
        Collection<StorableIndex<S>> indexes = this.mRepoAccess.storageAccessFor(this.getStorableType()).getAllIndexes();
        for (StorableIndex<S> index : indexes) {
            if (!index.isUnique()) continue;
            int propCount = index.getPropertyCount();
            LinkedHashSet<ChainedProperty<S>> props = new LinkedHashSet<ChainedProperty<S>>(propCount);
            for (int i = 0; i < propCount; ++i) {
                props.add(index.getOrderedProperty(i).getChainedProperty());
            }
            keys.add(props);
        }
        return keys;
    }

    private Set<ChainedProperty<S>> stripOrdering(Set<? extends OrderedProperty<S>> orderedProps) {
        LinkedHashSet<ChainedProperty<S>> props = new LinkedHashSet<ChainedProperty<S>>(orderedProps.size());
        for (OrderedProperty<S> ordering : orderedProps) {
            props.add(ordering.getChainedProperty());
        }
        return props;
    }

    private boolean pruneKeys(List<Set<ChainedProperty<S>>> keys, ChainedProperty<S> property) {
        boolean result = false;
        for (Set<ChainedProperty<S>> key : keys) {
            key.remove(property);
            if (key.size() != 0) continue;
            result = true;
        }
        return result;
    }

    private Tally bestTally(Iterable<Tally> tallies) {
        Tally best = null;
        for (Tally tally : tallies) {
            if (best != null && tally.compareTo(best) <= 0) continue;
            best = tally;
        }
        return best;
    }

    private Direction findHandledDirection(IndexedQueryAnalyzer.Result result, OrderedProperty<S> unspecified) {
        ChainedProperty<S> chained = unspecified.getChainedProperty();
        OrderingScore score = result.getCompositeScore().getOrderingScore();
        OrderingList handled = score.getHandledOrdering();
        for (OrderedProperty orderedProperty : handled) {
            if (!chained.equals(orderedProperty.getChainedProperty())) continue;
            return orderedProperty.getDirection();
        }
        return Direction.UNSPECIFIED;
    }

    private List<IndexedQueryAnalyzer.Result> splitIntoSubResults(Filter<S> filter, OrderingList<S> ordering, QueryHints hints) throws SupportException, RepositoryException {
        Splitter splitter;
        Filter<S> dnfFilter = filter.disjunctiveNormalForm();
        RepositoryException e = (RepositoryException)dnfFilter.accept(splitter = new Splitter(ordering, hints), null);
        if (e != null) {
            throw e;
        }
        List<IndexedQueryAnalyzer.Result> subResults = splitter.mSubResults;
        IndexedQueryAnalyzer.Result full = null;
        for (IndexedQueryAnalyzer.Result result : subResults) {
            if (!result.handlesAnything()) {
                full = result;
                break;
            }
            if (result.getCompositeScore().getFilteringScore().hasAnyMatches() || full != null) continue;
            full = result;
        }
        if (full == null) {
            return subResults;
        }
        ArrayList<IndexedQueryAnalyzer.Result> mergedResults = new ArrayList<IndexedQueryAnalyzer.Result>();
        for (IndexedQueryAnalyzer.Result result : subResults) {
            boolean exempt;
            block9: {
                if (result == full) continue;
                exempt = result.getCompositeScore().getFilteringScore().hasAnyMatches();
                if (exempt) {
                    PropertyFilterList subFilters = PropertyFilterList.get(result.getFilter());
                    for (PropertyFilter propertyFilter : subFilters) {
                        if (propertyFilter.getChainedProperty().getChainCount() <= 0) continue;
                        break block9;
                    }
                    exempt = false;
                }
            }
            if (exempt) {
                mergedResults.add(result);
                continue;
            }
            full = full.mergeRemainderFilter(result.getFilter());
        }
        if (mergedResults.size() == 0) {
            full = full.withRemainderFilter(filter.reduce());
        }
        mergedResults.add(full);
        return mergedResults;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Splitter
    extends Visitor<S, RepositoryException, Object> {
        private final OrderingList<S> mOrdering;
        private final QueryHints mHints;
        final List<IndexedQueryAnalyzer.Result> mSubResults;

        Splitter(OrderingList<S> ordering, QueryHints hints) {
            this.mOrdering = ordering;
            this.mHints = hints;
            this.mSubResults = new ArrayList<IndexedQueryAnalyzer.Result>();
        }

        @Override
        public RepositoryException visit(OrFilter<S> filter, Object param) {
            try {
                Filter left = filter.getLeftFilter();
                if (!(left instanceof OrFilter)) {
                    this.subAnalyze(left);
                } else {
                    RepositoryException e = (RepositoryException)left.accept(this, param);
                    if (e != null) {
                        return e;
                    }
                }
                Filter right = filter.getRightFilter();
                if (!(right instanceof OrFilter)) {
                    this.subAnalyze(right);
                } else {
                    RepositoryException e = (RepositoryException)right.accept(this, param);
                    if (e != null) {
                        return e;
                    }
                }
                return null;
            }
            catch (RepositoryException e) {
                return e;
            }
        }

        @Override
        public RepositoryException visit(AndFilter<S> filter, Object param) {
            try {
                this.subAnalyze(filter);
                return null;
            }
            catch (RepositoryException e) {
                return e;
            }
        }

        @Override
        public RepositoryException visit(PropertyFilter<S> filter, Object param) {
            try {
                this.subAnalyze(filter);
                return null;
            }
            catch (RepositoryException e) {
                return e;
            }
        }

        @Override
        public RepositoryException visit(ExistsFilter<S> filter, Object param) {
            try {
                this.subAnalyze(filter);
                return null;
            }
            catch (RepositoryException e) {
                return e;
            }
        }

        private void subAnalyze(Filter<S> subFilter) throws SupportException, RepositoryException {
            IndexedQueryAnalyzer.Result subResult = UnionQueryAnalyzer.this.mIndexAnalyzer.analyze(subFilter, this.mOrdering, this.mHints);
            int size = this.mSubResults.size();
            for (int i = 0; i < size; ++i) {
                IndexedQueryAnalyzer.Result existing = this.mSubResults.get(i);
                if (!existing.canMergeRemainder(subResult)) continue;
                this.mSubResults.set(i, existing.mergeRemainder(subResult));
                return;
            }
            this.mSubResults.add(subResult);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Tally
    implements Comparable<Tally> {
        private final ChainedProperty<S> mProperty;
        private int mAscendingCount;
        private int mDescendingCount;

        Tally(ChainedProperty<S> property) {
            this.mProperty = property;
        }

        ChainedProperty<S> getProperty() {
            return this.mProperty;
        }

        void increment(Direction dir) {
            switch (dir) {
                case UNSPECIFIED: {
                    ++this.mAscendingCount;
                    ++this.mDescendingCount;
                    break;
                }
                case ASCENDING: {
                    ++this.mAscendingCount;
                    break;
                }
                case DESCENDING: {
                    ++this.mDescendingCount;
                }
            }
        }

        Direction getBestDirection() {
            if (this.mAscendingCount >= this.mDescendingCount) {
                return Direction.ASCENDING;
            }
            return Direction.DESCENDING;
        }

        int getBestCount() {
            if (this.mAscendingCount >= this.mDescendingCount) {
                return this.mAscendingCount;
            }
            return this.mDescendingCount;
        }

        void clear() {
            this.mAscendingCount = 0;
            this.mDescendingCount = 0;
        }

        @Override
        public int compareTo(Tally other) {
            int otherBest;
            int thisBest = this.getBestCount();
            if (thisBest < (otherBest = other.getBestCount())) {
                return -1;
            }
            if (thisBest > otherBest) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "Tally: {property=" + this.mProperty + ", asc=" + this.mAscendingCount + ", desc=" + this.mDescendingCount + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Result {
        private final List<IndexedQueryAnalyzer.Result> mSubResults;
        private final OrderingList<S> mTotalOrdering;

        Result(List<IndexedQueryAnalyzer.Result> subResults) {
            this(subResults, null);
        }

        Result(List<IndexedQueryAnalyzer.Result> subResults, OrderingList<S> totalOrdering) {
            if (subResults.size() < 1) {
                throw new IllegalArgumentException();
            }
            this.mSubResults = Collections.unmodifiableList(subResults);
            this.mTotalOrdering = totalOrdering;
        }

        public List<IndexedQueryAnalyzer.Result> getSubResults() {
            return this.mSubResults;
        }

        public OrderingList<S> getTotalOrdering() {
            return this.mTotalOrdering;
        }

        public QueryExecutor<S> createExecutor() throws SupportException, FetchException, RepositoryException {
            List<IndexedQueryAnalyzer.Result> subResults = this.getSubResults();
            int size = subResults.size();
            if (size == 1) {
                return subResults.get(0).createExecutor();
            }
            ArrayList executors = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                executors.add(subResults.get(i).createExecutor());
            }
            return new UnionQueryExecutor(executors, this.mTotalOrdering);
        }
    }
}

