/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.AndFilter;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.OrFilter;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.RelOp;
import com.amazon.carbonado.filter.Visitor;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.qe.PropertyFilterList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringScore<S extends Storable> {
    private final OrderedProperty<S>[] mIndexProperties;
    private final boolean mIndexClustered;
    private final boolean mIndexUnique;
    private final List<PropertyFilter<S>> mIdentityFilters;
    private final List<PropertyFilter<S>> mRangeStartFilters;
    private final List<PropertyFilter<S>> mRangeEndFilters;
    private final int mArrangementScore;
    private final BigInteger mPreferenceScore;
    private final List<? extends Filter<S>> mRemainderFilters;
    private final List<? extends Filter<S>> mCoveringFilters;
    private final boolean mShouldReverseRange;
    private transient Filter<S> mIdentityFilter;
    private transient Filter<S> mRemainderFilter;
    private transient Filter<S> mCoveringFilter;
    private transient Filter<S> mCoveringRemainderFilter;

    public static <S extends Storable> FilteringScore<S> evaluate(StorableIndex<S> index, Filter<S> filter) {
        if (index == null) {
            throw new IllegalArgumentException("Index required");
        }
        return FilteringScore.evaluate(index.getOrderedProperties(), index.isUnique(), index.isClustered(), filter);
    }

    public static <S extends Storable> FilteringScore<S> evaluate(OrderedProperty<S>[] indexProperties, boolean unique, boolean clustered, Filter<S> filter) {
        ArrayList<S> remainderFilters;
        boolean shouldReverseRange;
        List<PropertyFilter<S>> rangeEndFilters;
        List<PropertyFilter<S>> rangeStartFilters;
        int indexPropPos;
        if (indexProperties == null) {
            throw new IllegalArgumentException("Index properties required");
        }
        PropertyFilterList<S> originalFilterList = PropertyFilterList.get(filter);
        ArrayList<S> filterList = new ArrayList<S>(originalFilterList);
        ArrayList<PropertyFilter<S>> identityFilters = new ArrayList<PropertyFilter<S>>();
        int arrangementScore = 0;
        BigInteger preferenceScore = BigInteger.ZERO;
        int lastFilterPos = 0;
        block7: for (indexPropPos = 0; indexPropPos < indexProperties.length; ++indexPropPos) {
            PropertyFilter subFilter;
            ChainedProperty<S> indexProp = indexProperties[indexPropPos].getChainedProperty();
            for (int pos = 0; pos < filterList.size() && (subFilter = (PropertyFilter)filterList.get(pos)).getOperator() == RelOp.EQ; ++pos) {
                if (!subFilter.getChainedProperty().equals(indexProp)) continue;
                identityFilters.add(subFilter);
                int shift = originalFilterList.size() - originalFilterList.getOriginalPosition(subFilter) - 1;
                preferenceScore = preferenceScore.or(BigInteger.ONE.shiftLeft(shift));
                if (pos >= lastFilterPos) {
                    ++arrangementScore;
                }
                filterList.remove(pos);
                lastFilterPos = pos;
                continue block7;
            }
        }
        if (indexPropPos >= indexProperties.length) {
            rangeStartFilters = Collections.emptyList();
            rangeEndFilters = Collections.emptyList();
            shouldReverseRange = false;
        } else {
            ChainedProperty<S> indexProp = indexProperties[indexPropPos].getChainedProperty();
            rangeStartFilters = new ArrayList();
            rangeEndFilters = new ArrayList();
            block9: for (int pos = 0; pos < filterList.size(); ++pos) {
                PropertyFilter subFilter = (PropertyFilter)filterList.get(pos);
                RelOp op = subFilter.getOperator();
                switch (op) {
                    case NE: {
                        break block9;
                    }
                    case GT: 
                    case GE: 
                    case LT: 
                    case LE: {
                        if (subFilter.getChainedProperty().equals(indexProp)) {
                            switch (op) {
                                case GT: 
                                case GE: {
                                    rangeStartFilters.add(subFilter);
                                    break;
                                }
                                default: {
                                    rangeEndFilters.add(subFilter);
                                }
                            }
                            filterList.remove(pos);
                            int shift = originalFilterList.size() - originalFilterList.getOriginalPosition(subFilter) - 1;
                            preferenceScore = preferenceScore.or(BigInteger.ONE.shiftLeft(shift));
                            --pos;
                        }
                    }
                    default: {
                        continue block9;
                    }
                }
            }
            boolean bl = shouldReverseRange = (rangeStartFilters.size() > 0 || rangeEndFilters.size() > 0) && indexProperties[indexPropPos].getDirection() == Direction.DESCENDING;
        }
        if (originalFilterList.getExistsFilters().size() == 0) {
            remainderFilters = filterList;
        } else {
            remainderFilters = new ArrayList<S>(filterList);
            remainderFilters.addAll(originalFilterList.getExistsFilters());
        }
        return new FilteringScore<S>(indexProperties, clustered, unique, identityFilters, rangeStartFilters, rangeEndFilters, arrangementScore, preferenceScore, remainderFilters, shouldReverseRange);
    }

    public static Comparator<FilteringScore<?>> rangeComparator() {
        return Range.INSTANCE;
    }

    public static Comparator<FilteringScore<?>> fullComparator() {
        return Full.INSTANCE;
    }

    static <E> List<E> prepareList(List<E> list) {
        if (list == null || list.size() == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    static int nullCompare(Object first, Object second) {
        if (first == null) {
            if (second != null) {
                return 1;
            }
        } else if (second == null) {
            return -1;
        }
        return 0;
    }

    static <S extends Storable> List<Filter<S>> split(Filter<S> filter) {
        return filter == null ? null : filter.conjunctiveNormalFormSplit();
    }

    private FilteringScore(OrderedProperty<S>[] indexProperties, boolean indexClustered, boolean indexUnique, List<PropertyFilter<S>> identityFilters, List<PropertyFilter<S>> rangeStartFilters, List<PropertyFilter<S>> rangeEndFilters, int arrangementScore, BigInteger preferenceScore, List<? extends Filter<S>> remainderFilters, boolean shouldReverseRange) {
        this.mIndexProperties = indexProperties;
        this.mIndexClustered = indexClustered;
        this.mIndexUnique = indexUnique;
        this.mIdentityFilters = FilteringScore.prepareList(identityFilters);
        this.mRangeStartFilters = FilteringScore.prepareList(rangeStartFilters);
        this.mRangeEndFilters = FilteringScore.prepareList(rangeEndFilters);
        this.mArrangementScore = arrangementScore;
        this.mPreferenceScore = preferenceScore;
        this.mRemainderFilters = FilteringScore.prepareList(remainderFilters);
        this.mShouldReverseRange = shouldReverseRange;
        this.mCoveringFilters = this.findCoveringMatches();
    }

    private FilteringScore(FilteringScore<S> score, Filter<S> remainderFilter) {
        this.mIndexProperties = score.mIndexProperties;
        this.mIndexClustered = score.mIndexClustered;
        this.mIndexUnique = score.mIndexUnique;
        this.mIdentityFilters = score.mIdentityFilters;
        this.mRangeStartFilters = score.mRangeStartFilters;
        this.mRangeEndFilters = score.mRangeEndFilters;
        this.mArrangementScore = score.mArrangementScore;
        this.mPreferenceScore = score.mPreferenceScore;
        this.mRemainderFilters = FilteringScore.prepareList(FilteringScore.split(remainderFilter));
        this.mShouldReverseRange = score.mShouldReverseRange;
        this.mCoveringFilters = this.findCoveringMatches();
        this.mIdentityFilter = score.mIdentityFilter;
        this.mRemainderFilter = remainderFilter;
    }

    public boolean isIndexClustered() {
        return this.mIndexClustered;
    }

    public boolean isIndexUnique() {
        return this.mIndexUnique;
    }

    public int getIndexPropertyCount() {
        return this.mIndexProperties.length;
    }

    public int getIdentityCount() {
        return this.mIdentityFilters.size();
    }

    public List<PropertyFilter<S>> getIdentityFilters() {
        return this.mIdentityFilters;
    }

    public Filter<S> getIdentityFilter() {
        if (this.mIdentityFilter == null) {
            this.mIdentityFilter = this.buildCompositeFilter(this.getIdentityFilters());
        }
        return this.mIdentityFilter;
    }

    public boolean hasRangeStart() {
        return this.mRangeStartFilters.size() > 0;
    }

    public List<PropertyFilter<S>> getRangeStartFilters() {
        return this.mRangeStartFilters;
    }

    public List<PropertyFilter<S>> getExclusiveRangeStartFilters() {
        return this.reduce(this.getRangeStartFilters(), RelOp.GT);
    }

    public List<PropertyFilter<S>> getInclusiveRangeStartFilters() {
        return this.reduce(this.getRangeStartFilters(), RelOp.GE);
    }

    public boolean hasRangeEnd() {
        return this.mRangeEndFilters.size() > 0;
    }

    public List<PropertyFilter<S>> getRangeEndFilters() {
        return this.mRangeEndFilters;
    }

    public List<PropertyFilter<S>> getExclusiveRangeEndFilters() {
        return this.reduce(this.getRangeEndFilters(), RelOp.LT);
    }

    public List<PropertyFilter<S>> getInclusiveRangeEndFilters() {
        return this.reduce(this.getRangeEndFilters(), RelOp.LE);
    }

    public int getHandledCount() {
        return this.getIdentityCount() + this.mRangeStartFilters.size() + this.mRangeEndFilters.size();
    }

    public Filter<S> getHandledFilter() {
        Filter<S> identity = this.getIdentityFilter();
        Filter<S> rangeStart = this.buildCompositeFilter(this.getRangeStartFilters());
        Filter<S> rangeEnd = this.buildCompositeFilter(this.getRangeEndFilters());
        return this.and(this.and(identity, rangeStart), rangeEnd);
    }

    private Filter<S> and(Filter<S> a, Filter<S> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.and(b);
    }

    public boolean hasRangeMatch() {
        return this.hasRangeStart() && this.hasRangeEnd();
    }

    public boolean hasAnyMatches() {
        return this.getIdentityCount() > 0 || this.hasRangeStart() || this.hasRangeEnd();
    }

    public int getArrangementScore() {
        return this.mArrangementScore;
    }

    public Comparable getPreferenceScore() {
        return this.mPreferenceScore;
    }

    public int getRemainderCount() {
        return this.mRemainderFilters.size();
    }

    public List<? extends Filter<S>> getRemainderFilters() {
        return this.mRemainderFilters;
    }

    public Filter<S> getRemainderFilter() {
        if (this.mRemainderFilter == null) {
            this.mRemainderFilter = this.buildCompositeFilter(this.getRemainderFilters());
        }
        return this.mRemainderFilter;
    }

    public int getCoveringCount() {
        return this.mCoveringFilters.size();
    }

    public List<? extends Filter<S>> getCoveringFilters() {
        return this.mCoveringFilters;
    }

    public Filter<S> getCoveringFilter() {
        if (this.mCoveringFilter == null) {
            this.mCoveringFilter = this.buildCompositeFilter(this.getCoveringFilters());
        }
        return this.mCoveringFilter;
    }

    public Filter<S> getCoveringRemainderFilter() {
        if (this.mCoveringRemainderFilter == null) {
            List<Filter<S>> remainderFilters = this.mRemainderFilters;
            List<Filter<S>> coveringFilters = this.mCoveringFilters;
            if (coveringFilters.size() < remainderFilters.size()) {
                Filter<S> composite = null;
                for (int i = 0; i < remainderFilters.size(); ++i) {
                    Filter<S> subFilter = remainderFilters.get(i);
                    if (coveringFilters.contains(subFilter)) continue;
                    composite = composite == null ? subFilter : composite.and(subFilter);
                }
                this.mCoveringRemainderFilter = composite;
            }
        }
        return this.mCoveringRemainderFilter;
    }

    public boolean isKeyMatch() {
        return this.isIndexUnique() && this.getIndexPropertyCount() == this.getIdentityCount();
    }

    public boolean shouldReverseRange() {
        return this.mShouldReverseRange;
    }

    public boolean canMergeRemainderFilter(FilteringScore<S> other) {
        if (this == other || !this.hasAnyMatches() && !other.hasAnyMatches()) {
            return true;
        }
        return this.isIndexClustered() == other.isIndexClustered() && this.isIndexUnique() == other.isIndexUnique() && this.getIndexPropertyCount() == other.getIndexPropertyCount() && this.getArrangementScore() == other.getArrangementScore() && this.getPreferenceScore().equals(other.getPreferenceScore()) && this.shouldReverseRange() == other.shouldReverseRange() && ((Object)this.getIdentityFilters()).equals(other.getIdentityFilters()) && ((Object)this.getRangeStartFilters()).equals(other.getRangeStartFilters()) && ((Object)this.getRangeEndFilters()).equals(other.getRangeEndFilters());
    }

    public Filter<S> mergeRemainderFilter(FilteringScore<S> other) {
        Filter<S> thisRemainderFilter = this.getRemainderFilter();
        if (this == other) {
            return thisRemainderFilter;
        }
        Filter<S> otherRemainderFilter = other.getRemainderFilter();
        if (thisRemainderFilter == null) {
            return otherRemainderFilter;
        }
        if (otherRemainderFilter == null) {
            return thisRemainderFilter;
        }
        if (thisRemainderFilter.equals(otherRemainderFilter)) {
            return thisRemainderFilter;
        }
        return thisRemainderFilter.or(otherRemainderFilter);
    }

    public FilteringScore<S> withRemainderFilter(Filter<S> filter) {
        return new FilteringScore<S>(this, filter);
    }

    public String toString() {
        return "FilteringScore {identityCount=" + this.getIdentityCount() + ", hasRangeStart=" + this.hasRangeStart() + ", hasRangeEnd=" + this.hasRangeEnd() + ", remainderCount=" + this.getRemainderCount() + ", coveringCount=" + this.getCoveringCount() + '}';
    }

    private List<PropertyFilter<S>> reduce(List<PropertyFilter<S>> filters, RelOp op) {
        ArrayList<PropertyFilter<S>> reduced = null;
        for (int i = 0; i < filters.size(); ++i) {
            PropertyFilter<S> filter = filters.get(i);
            if (filter.getOperator() != op) {
                if (reduced != null) continue;
                reduced = new ArrayList<PropertyFilter<S>>(filters.size());
                for (int j = 0; j < i; ++j) {
                    reduced.add(filters.get(j));
                }
                continue;
            }
            if (reduced == null) continue;
            reduced.add(filter);
        }
        return reduced == null ? filters : reduced;
    }

    private Filter<S> buildCompositeFilter(List<? extends Filter<S>> filterList) {
        if (filterList.size() == 0) {
            return null;
        }
        Filter<S> composite = filterList.get(0);
        for (int i = 1; i < filterList.size(); ++i) {
            composite = composite.and(filterList.get(i));
        }
        return composite;
    }

    private List<Filter<S>> findCoveringMatches() {
        boolean check;
        ArrayList<Filter<S>> coveringFilters = null;
        boolean bl = check = !this.mRemainderFilters.isEmpty() && (this.mIdentityFilters.size() > 0 || this.mRangeStartFilters.size() > 0 || this.mRangeEndFilters.size() > 0);
        if (check) {
            for (Filter<S> subFilter : this.mRemainderFilters) {
                if (!this.isProvidedByIndex(subFilter)) continue;
                if (coveringFilters == null) {
                    coveringFilters = new ArrayList<Filter<S>>();
                }
                coveringFilters.add(subFilter);
            }
        }
        return FilteringScore.prepareList(coveringFilters);
    }

    private boolean isProvidedByIndex(Filter<S> filter) {
        Boolean result = (Boolean)filter.accept(new Visitor<S, Boolean, Object>(){

            @Override
            public Boolean visit(OrFilter<S> filter, Object param) {
                return (Boolean)filter.getLeftFilter().accept(this, param) != false && (Boolean)filter.getRightFilter().accept(this, param) != false;
            }

            @Override
            public Boolean visit(AndFilter<S> filter, Object param) {
                return (Boolean)filter.getLeftFilter().accept(this, param) != false && (Boolean)filter.getRightFilter().accept(this, param) != false;
            }

            @Override
            public Boolean visit(PropertyFilter<S> filter, Object param) {
                ChainedProperty filterProp = filter.getChainedProperty();
                for (OrderedProperty indexProp : FilteringScore.this.mIndexProperties) {
                    if (!indexProp.getChainedProperty().equals(filterProp)) continue;
                    return true;
                }
                return false;
            }
        }, null);
        return result == null ? false : result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Full
    implements Comparator<FilteringScore<?>> {
        static final Comparator<FilteringScore<?>> INSTANCE = new Full();

        private Full() {
        }

        @Override
        public int compare(FilteringScore<?> first, FilteringScore<?> second) {
            int result = Range.INSTANCE.compare(first, second);
            if (result != 0) {
                return result;
            }
            if (first.hasAnyMatches()) {
                if (!second.hasAnyMatches()) {
                    return -1;
                }
            } else if (second.hasAnyMatches()) {
                return 1;
            }
            if (first.getArrangementScore() > second.getArrangementScore()) {
                return -1;
            }
            if (first.getArrangementScore() < second.getArrangementScore()) {
                return 1;
            }
            if (first.isIndexClustered()) {
                if (!second.isIndexClustered()) {
                    return -1;
                }
            } else if (second.isIndexClustered()) {
                return 1;
            }
            if (first.getRemainderCount() < second.getRemainderCount()) {
                return -1;
            }
            if (first.getRemainderCount() > second.getRemainderCount()) {
                return 1;
            }
            if (first.getCoveringCount() > second.getCoveringCount()) {
                return -1;
            }
            if (first.getCoveringCount() < second.getCoveringCount()) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Range
    implements Comparator<FilteringScore<?>> {
        static final Comparator<FilteringScore<?>> INSTANCE = new Range();

        private Range() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(FilteringScore<?> first, FilteringScore<?> second) {
            if (first == second) {
                return 0;
            }
            int result = FilteringScore.nullCompare(first, second);
            if (result != 0) {
                return result;
            }
            if (first.getIdentityCount() > second.getIdentityCount()) {
                return -1;
            }
            if (first.getIdentityCount() < second.getIdentityCount()) {
                return 1;
            }
            if (first.hasRangeMatch()) {
                if (!second.hasRangeMatch()) return -1;
                if (first.isIndexClustered()) {
                    if (!second.isIndexClustered()) {
                        return -1;
                    }
                } else if (second.isIndexClustered()) {
                    return 1;
                }
            } else if (second.hasRangeMatch()) {
                return 1;
            }
            if (first.getIdentityCount() <= 0) return 0;
            if (first.isIndexClustered()) {
                if (second.isIndexClustered()) return 0;
                return -1;
            }
            if (!second.isIndexClustered()) return 0;
            return 1;
        }
    }
}

