/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.gen;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.gen.TriggerSupport;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.ClassInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeBuilderUtil {
    public static void assertParameterNotNull(CodeBuilder b, int paramIndex) {
        b.loadLocal(b.getParameter(paramIndex));
        Label notNull = b.createLabel();
        b.ifNullBranch((Location)notNull, false);
        CodeBuilderUtil.throwException(b, IllegalArgumentException.class, null);
        notNull.setLocation();
    }

    public static LocalVariable uneraseGenericParameter(CodeBuilder b, TypeDesc paramType, int paramIndex) {
        b.loadLocal(b.getParameter(paramIndex));
        b.checkCast(paramType);
        LocalVariable result = b.createLocalVariable(null, paramType);
        b.storeLocal(result);
        return result;
    }

    public static void throwException(CodeBuilder b, Class type, String message) {
        TypeDesc desc = TypeDesc.forClass((Class)type);
        b.newObject(desc);
        b.dup();
        if (message == null) {
            b.invokeConstructor(desc, null);
        } else {
            b.loadConstant(message);
            b.invokeConstructor(desc, new TypeDesc[]{TypeDesc.STRING});
        }
        b.throwObject();
    }

    public static void throwConcatException(CodeBuilder b, Class type, String ... messages) {
        if (messages == null || messages.length == 0) {
            CodeBuilderUtil.throwException(b, type, null);
            return;
        }
        if (messages.length == 1) {
            CodeBuilderUtil.throwException(b, type, messages[0]);
            return;
        }
        TypeDesc desc = TypeDesc.forClass((Class)type);
        b.newObject(desc);
        b.dup();
        TypeDesc[] params = new TypeDesc[]{TypeDesc.STRING};
        for (int i = 0; i < messages.length; ++i) {
            b.loadConstant(String.valueOf(messages[i]));
            if (i <= 0) continue;
            b.invokeVirtual(TypeDesc.STRING, "concat", TypeDesc.STRING, params);
        }
        b.invokeConstructor(desc, params);
        b.throwObject();
    }

    public static Set<Class> gatherAllBridgeTypes(Set<Class> set, Class leaf) {
        set.add(leaf);
        for (Class<?> c : leaf.getInterfaces()) {
            CodeBuilderUtil.gatherAllBridgeTypes(set, c);
        }
        if ((leaf = leaf.getSuperclass()) != null) {
            CodeBuilderUtil.gatherAllBridgeTypes(set, leaf);
        }
        return set;
    }

    public static void defineCopyBridges(ClassFile cf, Class leaf) {
        for (Class c : CodeBuilderUtil.gatherAllBridgeTypes(new HashSet<Class>(), leaf)) {
            if (c == Object.class) continue;
            CodeBuilderUtil.defineCopyBridge(cf, leaf, c);
        }
    }

    private static void defineCopyBridge(ClassFile cf, Class leaf, Class returnClass) {
        TypeDesc returnType = TypeDesc.forClass((Class)returnClass);
        if (CodeBuilderUtil.isPublicMethodFinal(leaf, "copy", returnType, null)) {
            return;
        }
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC.toBridge(true), "copy", returnType, null);
        CodeBuilder b = new CodeBuilder(mi);
        b.loadThis();
        b.invokeVirtual("copy", cf.getType(), null);
        b.returnValue(returnType);
    }

    public static void definePrepareMethod(ClassFile cf, Class storableClass, TypeDesc supportCtorType) {
        CodeBuilderUtil.definePrepareMethod(cf, storableClass, supportCtorType, "support$", TypeDesc.forClass(TriggerSupport.class));
    }

    public static void definePrepareMethod(ClassFile cf, Class storableClass, TypeDesc supportCtorType, String supportFieldName, TypeDesc supportFieldType) {
        TypeDesc storableType = TypeDesc.forClass((Class)storableClass);
        if (!CodeBuilderUtil.isPublicMethodFinal(storableClass, "prepare", storableType, null)) {
            MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, "prepare", cf.getType(), null);
            CodeBuilder b = new CodeBuilder(mi);
            b.newObject(cf.getType());
            b.dup();
            b.loadThis();
            b.loadField(supportFieldName, supportFieldType);
            if (supportFieldType != supportCtorType) {
                b.checkCast(supportCtorType);
            }
            b.invokeConstructor(new TypeDesc[]{supportCtorType});
            b.returnValue(cf.getType());
        }
        CodeBuilderUtil.definePrepareBridges(cf, storableClass);
    }

    public static void definePrepareBridges(ClassFile cf, Class leaf) {
        for (Class c : CodeBuilderUtil.gatherAllBridgeTypes(new HashSet<Class>(), leaf)) {
            if (c == Object.class) continue;
            CodeBuilderUtil.definePrepareBridge(cf, leaf, c);
        }
    }

    private static void definePrepareBridge(ClassFile cf, Class leaf, Class returnClass) {
        TypeDesc returnType = TypeDesc.forClass((Class)returnClass);
        if (CodeBuilderUtil.isPublicMethodFinal(leaf, "prepare", returnType, null)) {
            return;
        }
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC.toBridge(true), "prepare", returnType, null);
        CodeBuilder b = new CodeBuilder(mi);
        b.loadThis();
        b.invokeVirtual("prepare", cf.getType(), null);
        b.returnValue(returnType);
    }

    public static boolean isPublicMethodFinal(Class clazz, String name, TypeDesc retType, TypeDesc[] params) {
        if (!clazz.isInterface()) {
            Class[] paramClasses;
            if (params == null || params.length == 0) {
                paramClasses = null;
            } else {
                paramClasses = new Class[params.length];
                for (int i = 0; i < params.length; ++i) {
                    paramClasses[i] = params[i].toClass();
                }
            }
            try {
                Method existing = clazz.getMethod(name, paramClasses);
                if (Modifier.isFinal(existing.getModifiers())) {
                    if (retType == null) {
                        retType = TypeDesc.forClass(Void.TYPE);
                    }
                    if (TypeDesc.forClass(existing.getReturnType()) == retType) {
                        return true;
                    }
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return false;
    }

    public static <S extends Storable> ClassFile createStorableClassFile(ClassInjector ci, Class<S> type, boolean isAbstract, String aSourcefileName) {
        ClassFile cf;
        if (type.isInterface()) {
            cf = new ClassFile(ci.getClassName());
            cf.addInterface(type);
        } else {
            cf = new ClassFile(ci.getClassName(), type);
        }
        if (isAbstract) {
            Modifiers modifiers = cf.getModifiers().toAbstract(true);
            cf.setModifiers(modifiers);
        }
        cf.addInterface(Storable.class);
        cf.addInterface(Cloneable.class);
        cf.markSynthetic();
        cf.setSourceFile(aSourcefileName);
        cf.setTarget("1.5");
        return cf;
    }

    public static void addValueHashCodeCall(CodeBuilder b, TypeDesc valueType, boolean testForNull, boolean mixIn) {
        LocalVariable value = null;
        if (mixIn) {
            value = b.createLocalVariable(null, valueType);
            b.storeLocal(value);
            b.loadConstant(31);
            b.math((byte)104);
            b.loadLocal(value);
        }
        switch (valueType.getTypeCode()) {
            case 6: {
                b.invokeStatic(TypeDesc.FLOAT.toObjectType(), "floatToIntBits", TypeDesc.INT, new TypeDesc[]{TypeDesc.FLOAT});
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                if (!mixIn) break;
                b.math((byte)96);
                break;
            }
            case 7: {
                b.invokeStatic(TypeDesc.DOUBLE.toObjectType(), "doubleToLongBits", TypeDesc.LONG, new TypeDesc[]{TypeDesc.DOUBLE});
            }
            case 11: {
                b.dup2();
                b.loadConstant(32);
                b.math((byte)125);
                b.math((byte)-125);
                b.convert(TypeDesc.LONG, TypeDesc.INT);
                if (!mixIn) break;
                b.math((byte)96);
                break;
            }
            default: {
                if (testForNull && value == null) {
                    value = b.createLocalVariable(null, valueType);
                    b.storeLocal(value);
                    b.loadLocal(value);
                }
                if (mixIn) {
                    Label isNull = b.createLabel();
                    if (testForNull) {
                        b.ifNullBranch((Location)isNull, true);
                        b.loadLocal(value);
                    }
                    CodeBuilderUtil.addValueHashCodeCallTo(b, valueType);
                    b.math((byte)96);
                    if (!testForNull) break;
                    isNull.setLocation();
                    break;
                }
                Label cont = b.createLabel();
                if (testForNull) {
                    Label notNull = b.createLabel();
                    b.ifNullBranch((Location)notNull, false);
                    b.loadConstant(0);
                    b.branch((Location)cont);
                    notNull.setLocation();
                    b.loadLocal(value);
                }
                CodeBuilderUtil.addValueHashCodeCallTo(b, valueType);
                if (!testForNull) break;
                cont.setLocation();
            }
        }
    }

    private static void addValueHashCodeCallTo(CodeBuilder b, TypeDesc valueType) {
        if (valueType.isArray()) {
            if (!valueType.getComponentType().isPrimitive()) {
                b.invokeStatic("java.util.Arrays", "deepHashCode", TypeDesc.INT, new TypeDesc[]{TypeDesc.forClass(Object[].class)});
            } else {
                b.invokeStatic("java.util.Arrays", "hashCode", TypeDesc.INT, new TypeDesc[]{valueType});
            }
        } else {
            b.invokeVirtual(TypeDesc.OBJECT, "hashCode", TypeDesc.INT, null);
        }
    }

    public static void addEqualsCall(CodeBuilder b, String fieldName, TypeDesc fieldType, boolean testForNull, Label fail, LocalVariable other) {
        b.loadThis();
        b.loadField(fieldName, fieldType);
        b.loadLocal(other);
        b.loadField(fieldName, fieldType);
        CodeBuilderUtil.addValuesEqualCall(b, fieldType, testForNull, fail, false);
    }

    public static void addValuesEqualCall(CodeBuilder b, TypeDesc valueType, boolean testForNull, Label label, boolean choice) {
        if (valueType.getTypeCode() != 0) {
            if (valueType.getTypeCode() == 6) {
                b.invokeStatic(TypeDesc.FLOAT.toObjectType(), "compare", TypeDesc.INT, new TypeDesc[]{TypeDesc.FLOAT, TypeDesc.FLOAT});
                b.ifZeroComparisonBranch((Location)label, choice ? "==" : "!=");
            } else if (valueType.getTypeCode() == 7) {
                b.invokeStatic(TypeDesc.DOUBLE.toObjectType(), "compare", TypeDesc.INT, new TypeDesc[]{TypeDesc.DOUBLE, TypeDesc.DOUBLE});
                b.ifZeroComparisonBranch((Location)label, choice ? "==" : "!=");
            } else {
                b.ifComparisonBranch((Location)label, choice ? "==" : "!=", valueType);
            }
            return;
        }
        if (!testForNull) {
            String op = CodeBuilderUtil.addEqualsCallTo(b, valueType, choice);
            b.ifZeroComparisonBranch((Location)label, op);
            return;
        }
        Label isNotNull = b.createLabel();
        LocalVariable value = b.createLocalVariable(null, valueType);
        b.storeLocal(value);
        b.loadLocal(value);
        b.ifNullBranch((Location)isNotNull, false);
        b.ifNullBranch((Location)label, choice);
        Label cont = b.createLabel();
        b.branch((Location)cont);
        isNotNull.setLocation();
        if (CodeBuilderUtil.compareToType(valueType) == null) {
            b.loadLocal(value);
            b.swap();
        } else {
            LocalVariable value2 = b.createLocalVariable(null, valueType);
            b.storeLocal(value2);
            b.loadLocal(value2);
            b.ifNullBranch((Location)label, !choice);
            b.loadLocal(value);
            b.loadLocal(value2);
        }
        String op = CodeBuilderUtil.addEqualsCallTo(b, valueType, choice);
        b.ifZeroComparisonBranch((Location)label, op);
        cont.setLocation();
    }

    private static TypeDesc compareToType(TypeDesc fieldType) {
        if (fieldType.toPrimitiveType() == TypeDesc.FLOAT) {
            return TypeDesc.FLOAT.toObjectType();
        }
        if (fieldType.toPrimitiveType() == TypeDesc.DOUBLE) {
            return TypeDesc.DOUBLE.toObjectType();
        }
        if (BigDecimal.class.isAssignableFrom(fieldType.toClass())) {
            return TypeDesc.forClass(BigDecimal.class);
        }
        return null;
    }

    private static String addEqualsCallTo(CodeBuilder b, TypeDesc fieldType, boolean choice) {
        if (fieldType.isArray()) {
            if (!fieldType.getComponentType().isPrimitive()) {
                TypeDesc type = TypeDesc.forClass(Object[].class);
                b.invokeStatic("java.util.Arrays", "deepEquals", TypeDesc.BOOLEAN, new TypeDesc[]{type, type});
            } else {
                b.invokeStatic("java.util.Arrays", "equals", TypeDesc.BOOLEAN, new TypeDesc[]{fieldType, fieldType});
            }
            return choice ? "!=" : "==";
        }
        TypeDesc compareToType = CodeBuilderUtil.compareToType(fieldType);
        if (compareToType != null) {
            b.invokeVirtual(compareToType, "compareTo", TypeDesc.INT, new TypeDesc[]{compareToType});
            return choice ? "==" : "!=";
        }
        TypeDesc[] params = new TypeDesc[]{TypeDesc.OBJECT};
        if (fieldType.toClass() != null) {
            if (fieldType.toClass().isInterface()) {
                b.invokeInterface(fieldType, "equals", TypeDesc.BOOLEAN, params);
            } else {
                b.invokeVirtual(fieldType, "equals", TypeDesc.BOOLEAN, params);
            }
        } else {
            b.invokeVirtual(TypeDesc.OBJECT, "equals", TypeDesc.BOOLEAN, params);
        }
        return choice ? "!=" : "==";
    }

    public static void convertValue(CodeBuilder b, Class from, Class to) {
        if (from == to) {
            return;
        }
        TypeDesc fromType = TypeDesc.forClass((Class)from);
        TypeDesc toType = TypeDesc.forClass((Class)to);
        try {
            b.convert(fromType, toType);
            return;
        }
        catch (IllegalArgumentException e) {
            if (to != String.class && to != Object.class && to != CharSequence.class) {
                throw e;
            }
            if (fromType.isPrimitive()) {
                b.invokeStatic(TypeDesc.STRING, "valueOf", TypeDesc.STRING, new TypeDesc[]{fromType});
            } else {
                b.dup();
                Label isNull = b.createLabel();
                b.ifNullBranch((Location)isNull, true);
                b.invokeStatic(TypeDesc.STRING, "valueOf", TypeDesc.STRING, new TypeDesc[]{TypeDesc.OBJECT});
                isNull.setLocation();
            }
            return;
        }
    }

    public static void initialVersion(CodeBuilder b, TypeDesc type, int value) throws SupportException {
        CodeBuilderUtil.adjustVersion(b, type, value, false);
    }

    public static void incrementVersion(CodeBuilder b, TypeDesc type) throws SupportException {
        CodeBuilderUtil.adjustVersion(b, type, 0, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void adjustVersion(CodeBuilder b, TypeDesc type, int value, boolean increment) throws SupportException {
        TypeDesc primitiveType = type.toPrimitiveType();
        if (primitiveType == null) throw new SupportException("Unsupported version type: " + type.getFullName());
        switch (primitiveType.getTypeCode()) {
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw new SupportException("Unsupported version type: " + type.getFullName());
            }
        }
        if (!increment) {
            if (primitiveType == TypeDesc.LONG) {
                b.loadConstant((long)value);
            } else {
                b.loadConstant(value);
            }
        } else {
            Label setVersion = b.createLabel();
            if (!type.isPrimitive()) {
                b.dup();
                Label versionNotNull = b.createLabel();
                b.ifNullBranch((Location)versionNotNull, false);
                b.pop();
                if (primitiveType == TypeDesc.LONG) {
                    b.loadConstant(1L);
                } else {
                    b.loadConstant(1);
                }
                b.branch((Location)setVersion);
                versionNotNull.setLocation();
                b.convert(type, primitiveType);
            }
            if (primitiveType == TypeDesc.LONG) {
                b.loadConstant(1L);
                b.math((byte)97);
            } else {
                b.loadConstant(1);
                b.math((byte)96);
            }
            setVersion.setLocation();
        }
        b.convert(primitiveType, type);
    }

    public static void blankValue(CodeBuilder b, TypeDesc type) {
        switch (type.getTypeCode()) {
            default: {
                b.loadNull();
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                b.loadConstant(0);
                break;
            }
            case 4: {
                b.loadConstant(false);
                break;
            }
            case 11: {
                b.loadConstant(0L);
                break;
            }
            case 6: {
                b.loadConstant(0.0f);
                break;
            }
            case 7: {
                b.loadConstant(0.0);
            }
        }
    }

    public static TypeDesc bindQueryParam(Class clazz) {
        if (clazz.isPrimitive()) {
            TypeDesc type = TypeDesc.forClass((Class)clazz);
            switch (type.getTypeCode()) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    return type;
                }
            }
        }
        return TypeDesc.OBJECT;
    }

    public static void callStringBuilderAppendString(CodeBuilder b) {
        TypeDesc stringBuilder = TypeDesc.forClass(StringBuilder.class);
        b.invokeVirtual(stringBuilder, "append", stringBuilder, new TypeDesc[]{TypeDesc.STRING});
    }

    public static void callStringBuilderAppendChar(CodeBuilder b) {
        TypeDesc stringBuilder = TypeDesc.forClass(StringBuilder.class);
        b.invokeVirtual(stringBuilder, "append", stringBuilder, new TypeDesc[]{TypeDesc.CHAR});
    }

    public static void callStringBuilderLength(CodeBuilder b) {
        TypeDesc stringBuilder = TypeDesc.forClass(StringBuilder.class);
        b.invokeVirtual(stringBuilder, "length", TypeDesc.INT, null);
    }

    public static void callStringBuilderSetLength(CodeBuilder b) {
        TypeDesc stringBuilder = TypeDesc.forClass(StringBuilder.class);
        b.invokeVirtual(stringBuilder, "setLength", null, new TypeDesc[]{TypeDesc.INT});
    }

    public static void callStringBuilderToString(CodeBuilder b) {
        TypeDesc stringBuilder = TypeDesc.forClass(StringBuilder.class);
        b.invokeVirtual(stringBuilder, "toString", TypeDesc.STRING, null);
    }
}

