/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.filter;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.ClosedFilter;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.filter.PropertyFilterList;
import com.amazon.carbonado.filter.Visitor;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.StorableProperty;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExistsFilter<S extends Storable>
extends Filter<S> {
    private static final long serialVersionUID = 1L;
    private final ChainedProperty<S> mProperty;
    private final Filter<?> mSubFilter;
    private final boolean mNot;
    private volatile transient Filter<S> mJoinedSubFilter;
    private volatile transient boolean mNoParameters;

    static <S extends Storable> Filter<S> build(ChainedProperty<S> property, Filter<?> subFilter, boolean not) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        StorableProperty<?> joinProperty = property.getLastProperty();
        if (subFilter == null) {
            subFilter = Filter.getOpenFilter(joinProperty.getJoinedType());
        } else if (joinProperty.getJoinedType() != subFilter.getStorableType()) {
            throw new IllegalArgumentException("Filter not compatible with join property type: " + property + " joins to a " + joinProperty.getJoinedType().getName() + ", but filter is for a " + subFilter.getStorableType().getName());
        }
        if (subFilter.isClosed()) {
            ClosedFilter<S> f = Filter.getClosedFilter(property.getPrimeProperty().getEnclosingType());
            return not ? ((Filter)f).not() : f;
        }
        if (joinProperty.isQuery() || subFilter.isOpen()) {
            return ExistsFilter.getCanonical(property, subFilter, not);
        }
        return subFilter.asJoinedFrom(property);
    }

    private static <S extends Storable> ExistsFilter<S> getCanonical(ChainedProperty<S> property, Filter<?> subFilter, boolean not) {
        return (ExistsFilter)cCanonical.put(new ExistsFilter<S>(property, subFilter, not));
    }

    private ExistsFilter(ChainedProperty<S> property, Filter<?> subFilter, boolean not) {
        super(property.getPrimeProperty().getEnclosingType());
        this.mProperty = property;
        this.mSubFilter = subFilter;
        this.mNot = not;
    }

    public ChainedProperty<S> getChainedProperty() {
        return this.mProperty;
    }

    public Filter<?> getSubFilter() {
        return this.mSubFilter;
    }

    Filter<S> getJoinedSubFilter() {
        Filter<S> joined = this.mJoinedSubFilter;
        if (joined == null) {
            this.mJoinedSubFilter = joined = this.mSubFilter.asJoinedFromAny(this.mProperty);
        }
        return joined;
    }

    public boolean isNotExists() {
        return this.mNot;
    }

    @Override
    public Filter<S> not() {
        return ExistsFilter.getCanonical(this.mProperty, this.mSubFilter, !this.mNot);
    }

    @Override
    public FilterValues<S> initialFilterValues() {
        if (this.mNoParameters) {
            return null;
        }
        FilterValues filterValues = super.initialFilterValues();
        if (filterValues == null) {
            this.mNoParameters = true;
        }
        return filterValues;
    }

    @Override
    PropertyFilterList<S> getTailPropertyFilterList() {
        if (this.mNoParameters) {
            return null;
        }
        PropertyFilterList tail = super.getTailPropertyFilterList();
        if (tail == null) {
            this.mNoParameters = true;
        }
        return tail;
    }

    @Override
    public <R, P> R accept(Visitor<S, R, P> visitor, P param) {
        return visitor.visit(this, param);
    }

    @Override
    public ExistsFilter<S> bind() {
        Filter<?> boundSubFilter = this.mSubFilter.bind();
        if (boundSubFilter == this.mSubFilter) {
            return this;
        }
        return ExistsFilter.getCanonical(this.mProperty, boundSubFilter, this.mNot);
    }

    @Override
    public ExistsFilter<S> unbind() {
        Filter<?> unboundSubFilter = this.mSubFilter.unbind();
        if (unboundSubFilter == this.mSubFilter) {
            return this;
        }
        return ExistsFilter.getCanonical(this.mProperty, unboundSubFilter, this.mNot);
    }

    @Override
    public boolean isBound() {
        return this.mSubFilter.isBound();
    }

    @Override
    void markBound() {
    }

    @Override
    public <T extends Storable> ExistsFilter<T> asJoinedFromAny(ChainedProperty<T> joinProperty) {
        ChainedProperty<T> newProperty = joinProperty.append(this.getChainedProperty());
        return ExistsFilter.getCanonical(newProperty, this.mSubFilter, this.mNot);
    }

    @Override
    Filter.NotJoined notJoinedFromCNF(ChainedProperty<S> joinProperty) {
        ChainedProperty<Object> notJoinedProp = this.getChainedProperty();
        ChainedProperty<Object> jp = joinProperty;
        while (notJoinedProp.getPrimeProperty().equals(jp.getPrimeProperty())) {
            notJoinedProp = notJoinedProp.tail();
            if (jp.getChainCount() == 0) {
                jp = null;
                break;
            }
            jp = jp.tail();
        }
        if (jp != null || notJoinedProp.equals(this.getChainedProperty())) {
            return super.notJoinedFromCNF(joinProperty);
        }
        ExistsFilter<Object> notJoinedFilter = ExistsFilter.getCanonical(notJoinedProp, this.mSubFilter, this.mNot);
        return new Filter.NotJoined(this, notJoinedFilter, ExistsFilter.getOpenFilter(this.getStorableType()));
    }

    @Override
    Filter<S> buildDisjunctiveNormalForm() {
        return this;
    }

    @Override
    Filter<S> buildConjunctiveNormalForm() {
        return this;
    }

    @Override
    boolean isDisjunctiveNormalForm() {
        return true;
    }

    @Override
    boolean isConjunctiveNormalForm() {
        return true;
    }

    @Override
    boolean isReduced() {
        return true;
    }

    @Override
    void markReduced() {
    }

    @Override
    int generateHashCode() {
        int hash = this.mProperty.hashCode() * 31 + this.mSubFilter.hashCode();
        return this.mNot ? ~hash : hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExistsFilter) {
            ExistsFilter other = (ExistsFilter)obj;
            return this.getStorableType() == other.getStorableType() && this.mSubFilter == other.mSubFilter && this.mNot == other.mNot && this.mProperty.equals(other.mProperty);
        }
        return false;
    }

    @Override
    public void appendTo(Appendable app, FilterValues<S> values) throws IOException {
        if (this.mNot) {
            app.append('!');
        }
        this.mProperty.appendTo(app);
        app.append('(');
        Filter<?> subFilter = this.mSubFilter;
        if (subFilter != null && !subFilter.isOpen()) {
            FilterValues<?> subValues;
            if (values == null) {
                subValues = null;
            } else {
                FilterValues<?> subInitialValues = this.mSubFilter.initialFilterValues();
                if (subInitialValues == null) {
                    subValues = null;
                } else {
                    subValues = subInitialValues.withValues(values.getSuppliedValuesFor(this.getJoinedSubFilter()));
                    subFilter = subValues.getFilter();
                }
            }
            subFilter.appendTo(app, subValues);
        }
        app.append(')');
    }
}

