/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.filter;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.BinaryOpFilter;
import com.amazon.carbonado.filter.Distributer;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.filter.OrFilter;
import com.amazon.carbonado.filter.Visitor;
import com.amazon.carbonado.info.ChainedProperty;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndFilter<S extends Storable>
extends BinaryOpFilter<S> {
    private static final long serialVersionUID = 1L;

    static <S extends Storable> AndFilter<S> getCanonical(Filter<S> left, Filter<S> right) {
        return (AndFilter)cCanonical.put(new AndFilter<S>(left, right));
    }

    private AndFilter(Filter<S> left, Filter<S> right) {
        super(left, right);
    }

    @Override
    public Filter<S> not() {
        return this.mLeft.not().or(this.mRight.not());
    }

    @Override
    public <R, P> R accept(Visitor<S, R, P> visitor, P param) {
        return visitor.visit(this, param);
    }

    @Override
    public Filter<S> unbind() {
        if (!this.isBound()) {
            return this;
        }
        return this.mLeft.unbind().and(this.mRight.unbind());
    }

    @Override
    public <T extends Storable> Filter<T> asJoinedFromAny(ChainedProperty<T> joinProperty) {
        return this.mLeft.asJoinedFromAny(joinProperty).and(this.mRight.asJoinedFromAny(joinProperty));
    }

    @Override
    Filter.NotJoined notJoinedFromCNF(ChainedProperty<S> joinProperty) {
        Filter.NotJoined left = this.mLeft.notJoinedFromCNF(joinProperty);
        Filter.NotJoined right = this.mRight.notJoinedFromCNF(joinProperty);
        Filter<?> leftNotJoined = left.getNotJoinedFilter();
        Filter<?> rightNotJoined = right.getNotJoinedFilter();
        return new Filter.NotJoined(this, leftNotJoined.and(rightNotJoined), left.getRemainderFilter().and(right.getRemainderFilter()));
    }

    @Override
    Filter<S> buildDisjunctiveNormalForm() {
        Filter left = this.mLeft.reduce().dnf();
        Filter right = this.mRight.reduce().dnf();
        if (left instanceof OrFilter) {
            return ((Filter)left.accept(new Distributer(true, true), right)).reduce().dnf();
        }
        if (right instanceof OrFilter) {
            return ((Filter)right.accept(new Distributer(false, true), left)).reduce().dnf();
        }
        return left.and(right).reduce();
    }

    @Override
    Filter<S> buildConjunctiveNormalForm() {
        return this.mLeft.cnf().and(this.mRight.cnf()).reduce();
    }

    @Override
    boolean checkIsDisjunctiveNormalForm() {
        return !(this.mLeft instanceof OrFilter) && !(this.mRight instanceof OrFilter) && this.mLeft.isDisjunctiveNormalForm() && this.mRight.isDisjunctiveNormalForm();
    }

    @Override
    boolean checkIsConjunctiveNormalForm() {
        return this.mLeft.isConjunctiveNormalForm() && this.mRight.isConjunctiveNormalForm();
    }

    @Override
    int generateHashCode() {
        return this.mLeft.hashCode() * 31 + this.mRight.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AndFilter) {
            AndFilter other = (AndFilter)obj;
            return this.getStorableType() == other.getStorableType() && this.mLeft.equals(other.mLeft) && this.mRight.equals(other.mRight);
        }
        return false;
    }

    @Override
    public void appendTo(Appendable app, FilterValues<S> values) throws IOException {
        if (this.mLeft instanceof OrFilter) {
            app.append('(');
            this.mLeft.appendTo(app, values);
            app.append(')');
        } else {
            this.mLeft.appendTo(app, values);
        }
        app.append(" & ");
        if (this.mRight instanceof OrFilter) {
            app.append('(');
            this.mRight.appendTo(app, values);
            app.append(')');
        } else {
            this.mRight.appendTo(app, values);
        }
    }
}

