/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.cursor.AbstractCursor;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkipCursor<S>
extends AbstractCursor<S> {
    private final Cursor<S> mSource;
    private volatile long mSkip;

    public SkipCursor(Cursor<S> source, long skip) {
        if (source == null) {
            throw new IllegalArgumentException("Source is null");
        }
        if (skip < 0L) {
            throw new IllegalArgumentException("Skip is negative: " + skip);
        }
        this.mSource = source;
        this.mSkip = skip;
    }

    @Override
    public boolean hasNext() throws FetchException {
        try {
            this.doSkip();
            return this.mSource.hasNext();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    @Override
    public S next() throws FetchException {
        this.doSkip();
        return this.mSource.next();
    }

    @Override
    public int skipNext(int amount) throws FetchException {
        this.doSkip();
        return this.mSource.skipNext(amount);
    }

    @Override
    public void close() throws FetchException {
        this.mSource.close();
    }

    private void doSkip() throws FetchException {
        if (this.mSkip > 0L) {
            while (this.mSkip > Integer.MAX_VALUE) {
                this.mSkip -= (long)this.mSource.skipNext(Integer.MAX_VALUE);
            }
            this.mSource.skipNext((int)this.mSkip);
            this.mSkip = 0L;
        }
    }
}

