/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.cursor.AbstractCursor;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiTransformedCursor<S, T>
extends AbstractCursor<T> {
    private final Cursor<S> mCursor;
    private Cursor<T> mNextCursor;

    protected MultiTransformedCursor(Cursor<S> cursor) {
        if (cursor == null) {
            throw new IllegalArgumentException();
        }
        this.mCursor = cursor;
    }

    protected abstract Cursor<T> transform(S var1) throws FetchException;

    @Override
    public void close() throws FetchException {
        this.mCursor.close();
        if (this.mNextCursor != null) {
            this.mNextCursor.close();
            this.mNextCursor = null;
        }
    }

    @Override
    public boolean hasNext() throws FetchException {
        try {
            if (this.mNextCursor != null) {
                if (this.mNextCursor.hasNext()) {
                    return true;
                }
                this.mNextCursor.close();
                this.mNextCursor = null;
            }
            while (this.mCursor.hasNext()) {
                Cursor<T> nextCursor = this.transform(this.mCursor.next());
                if (nextCursor == null) continue;
                if (nextCursor.hasNext()) {
                    this.mNextCursor = nextCursor;
                    return true;
                }
                nextCursor.close();
            }
        }
        catch (NoSuchElementException e) {
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        return false;
    }

    @Override
    public T next() throws FetchException {
        try {
            if (this.hasNext()) {
                return this.mNextCursor.next();
            }
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int skipNext(int amount) throws FetchException {
        if (amount <= 0) {
            if (amount < 0) {
                throw new IllegalArgumentException("Cannot skip negative amount: " + amount);
            }
            return 0;
        }
        try {
            int count = 0;
            while (this.hasNext()) {
                int chunk = this.mNextCursor.skipNext(amount);
                count += chunk;
                if ((amount -= chunk) > 0) continue;
                break;
            }
            return count;
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }
}

