/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.cursor.SortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArraySortBuffer<S>
extends ArrayList<S>
implements SortBuffer<S> {
    private static final long serialVersionUID = -5622302375191321452L;
    private Comparator<S> mComparator;

    public ArraySortBuffer() {
    }

    public ArraySortBuffer(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public void prepare(Comparator<S> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException();
        }
        this.clear();
        this.mComparator = comparator;
    }

    @Override
    public void sort() {
        if (this.mComparator == null) {
            throw new IllegalStateException("Buffer was not prepared");
        }
        Collections.sort(this, this.mComparator);
    }

    @Override
    public void close() {
        this.clear();
    }
}

