/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.adapter;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.adapter.AdapterDefinition;
import com.amazon.carbonado.lob.Blob;
import com.amazon.carbonado.lob.ByteArrayBlob;
import com.amazon.carbonado.lob.Clob;
import com.amazon.carbonado.lob.StringClob;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@AdapterDefinition(storageTypePreferences={String.class, Clob.class, Blob.class})
public @interface TextAdapter {
    public String charset() default "UTF-8";

    public String[] altCharsets() default {};

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Adapter {
        private static byte[] EMPTY_BYTE_ARRAY = new byte[0];
        private final Charset mCharset;
        private final Charset[] mAltCharsets;

        static PersistException toPersistException(IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof PersistException) {
                return (PersistException)cause;
            }
            if (cause == null) {
                cause = e;
            }
            return new PersistException(cause);
        }

        private static final Charset[] prepareAltCharsets(TextAdapter ann) {
            if (ann == null) {
                return null;
            }
            String[] strs = ann.altCharsets();
            if (strs == null || strs.length == 0) {
                return null;
            }
            Charset[] altCharsets = new Charset[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                altCharsets[i] = Charset.forName(strs[i]);
            }
            return altCharsets;
        }

        public Adapter(Class<?> type, String propertyName, TextAdapter ann) {
            this(type, propertyName, ann == null ? null : Charset.forName(ann.charset()), Adapter.prepareAltCharsets(ann));
        }

        public Adapter(Class<?> type, String propertyName, String charset) {
            this(type, propertyName, charset == null ? null : Charset.forName(charset), null);
        }

        public Adapter(Class<?> type, String propertyName, Charset charset) {
            this(type, propertyName, charset, null);
        }

        public Adapter(Class<?> type, String propertyName, Charset charset, Charset[] altCharsets) {
            this.mCharset = charset == null ? Charset.forName("UTF-8") : charset;
            altCharsets = altCharsets == null || ((Charset[])altCharsets).length == 0 ? null : (Charset[])altCharsets.clone();
            this.mAltCharsets = altCharsets;
        }

        public String adaptToString(Clob clob) throws FetchException {
            return clob == null ? null : clob.asString();
        }

        public String adaptToString(Blob blob) throws FetchException {
            try {
                return blob == null ? null : blob.asString(this.mCharset);
            }
            catch (FetchException e) {
                if (this.mAltCharsets == null) {
                    throw e;
                }
                Throwable cause = e.getCause();
                if (!(cause instanceof CharacterCodingException)) {
                    throw e;
                }
                FetchException error = e;
                for (int i = 0; i < this.mAltCharsets.length; ++i) {
                    try {
                        return blob.asString(this.mAltCharsets[i]);
                    }
                    catch (FetchException e2) {
                        Throwable cause2 = e2.getCause();
                        if (cause2 instanceof CharacterCodingException) continue;
                        throw e2;
                    }
                }
                throw error;
            }
        }

        public Clob adaptToClob(String text) {
            if (text == null) {
                return null;
            }
            return new StringClob(text);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Blob adaptToBlob(String text) throws PersistException {
            if (text == null) {
                return null;
            }
            if (text.length() == 0) {
                return new ByteArrayBlob(EMPTY_BYTE_ARRAY);
            }
            CharsetEncoder encoder = this.mCharset.newEncoder();
            long byteLength = (long)((float)text.length() * encoder.averageBytesPerChar());
            if (byteLength >= Integer.MAX_VALUE) {
                byteLength = Integer.MAX_VALUE;
            }
            byte[] buffer = new byte[(int)byteLength];
            ByteArrayBlob blob = new ByteArrayBlob(buffer, 0);
            OutputStreamWriter w = new OutputStreamWriter(blob.openOutputStream(), encoder);
            try {
                try {
                    ((Writer)w).write(text, 0, text.length());
                }
                finally {
                    ((Writer)w).close();
                }
            }
            catch (IOException e) {
                throw Adapter.toPersistException(e);
            }
            return blob;
        }
    }
}

