/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado;

import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Storable;

public class OptimisticLockException
extends PersistException {
    private static final long serialVersionUID = 4081788711829580886L;
    private final transient Storable mStorable;

    public OptimisticLockException() {
        this.mStorable = null;
    }

    public OptimisticLockException(String message) {
        super(message);
        this.mStorable = null;
    }

    public OptimisticLockException(String message, Throwable cause) {
        super(message, cause);
        this.mStorable = null;
    }

    public OptimisticLockException(Throwable cause) {
        super(cause);
        this.mStorable = null;
    }

    public OptimisticLockException(long expectedVersion) {
        this((Object)expectedVersion);
    }

    public OptimisticLockException(Object expectedVersion) {
        this(expectedVersion, null);
    }

    public OptimisticLockException(Object expectedVersion, Object savedVersion) {
        this(expectedVersion, savedVersion, null);
    }

    public OptimisticLockException(Object expectedVersion, Object savedVersion, Storable s) {
        super(OptimisticLockException.makeMessage(expectedVersion, savedVersion, s));
        this.mStorable = s;
    }

    public OptimisticLockException(Object savedVersion, Storable s, Object newVersion) {
        super(OptimisticLockException.makeMessage(savedVersion, s, newVersion));
        this.mStorable = s;
    }

    public Storable getStorable() {
        return this.mStorable;
    }

    private static String makeMessage(Object expectedVersion, Object savedVersion, Storable s) {
        String message = expectedVersion == null && savedVersion == null ? null : "Update acted on version " + expectedVersion + ", but canonical version is " + savedVersion;
        if (s != null) {
            message = message == null ? s.toStringKeyOnly() : message + ": " + s.toStringKeyOnly();
        }
        return message;
    }

    private static String makeMessage(Object savedVersion, Storable s, Object newVersion) {
        String message = savedVersion == null && newVersion == null ? "New version is not larger than existing version" : "New version of " + newVersion + " is not larger than existing version of " + savedVersion;
        if (s != null) {
            message = message + ": " + s.toStringKeyOnly();
        }
        return message;
    }
}

