/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.repo.map.MapRepositoryBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class CorruptEncodingException
extends FetchException {
    private static final long serialVersionUID = 2L;
    private transient Storable mStorable;

    public CorruptEncodingException() {
    }

    public CorruptEncodingException(String message) {
        super(message);
    }

    public CorruptEncodingException(String message, Throwable cause) {
        super(message, cause);
    }

    public CorruptEncodingException(Throwable cause) {
        super(cause);
    }

    public CorruptEncodingException(int expectedGeneration, int actualGeneration) {
        super("Expected layout generation of " + expectedGeneration + ", but actual layout generation was " + actualGeneration);
    }

    public void setStorableWithPrimaryKey(Storable s) {
        if (s != null) {
            s.markAllPropertiesClean();
        }
        this.mStorable = s;
    }

    public Storable getStorableWithPrimaryKey() {
        return this.mStorable;
    }

    public String getMessage() {
        String message = super.getMessage();
        if (this.mStorable != null) {
            message = message + "; " + this.mStorable.toStringKeyOnly();
        }
        return message;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Storable s = this.mStorable;
        if (s == null) {
            out.write(0);
        } else {
            out.write(1);
            out.writeObject(s.storableType());
            try {
                s.writeTo(out);
            }
            catch (SupportException e) {
                throw new IOException(e);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int h = in.read();
        if (h == 1) {
            try {
                Class type = (Class)in.readObject();
                Object s = MapRepositoryBuilder.newRepository().storageFor(type).prepare();
                s.readFrom(in);
                this.mStorable = s;
            }
            catch (RepositoryException e) {
                throw new IOException(e);
            }
        }
    }
}

