/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.utilint.LoggerUtils;

public class ExceptionEvent {
    private Exception exception;
    private String threadName;

    public ExceptionEvent(Exception exception, String threadName) {
        this.exception = exception;
        this.threadName = threadName;
    }

    public ExceptionEvent(Exception exception) {
        this.exception = exception;
        this.threadName = Thread.currentThread().toString();
    }

    public Exception getException() {
        return this.exception;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<ExceptionEvent exception=\"");
        sb.append(this.exception);
        sb.append("\" threadName=\"");
        sb.append(this.threadName);
        sb.append("\">");
        sb.append(LoggerUtils.getStackTrace(this.exception));
        return sb.toString();
    }
}

