/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseEntry;
import java.math.BigDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalBinding
extends TupleBinding<BigDecimal> {
    @Override
    public BigDecimal entryToObject(TupleInput input) {
        return input.readBigDecimal();
    }

    @Override
    public void objectToEntry(BigDecimal object, TupleOutput output) {
        output.writeBigDecimal(object);
    }

    @Override
    protected TupleOutput getTupleOutput(BigDecimal object) {
        return BigDecimalBinding.sizedOutput(object);
    }

    public static BigDecimal entryToBigDecimal(DatabaseEntry entry) {
        return BigDecimalBinding.entryToInput(entry).readBigDecimal();
    }

    public static void bigDecimalToEntry(BigDecimal val, DatabaseEntry entry) {
        BigDecimalBinding.outputToEntry(BigDecimalBinding.sizedOutput(val).writeBigDecimal(val), entry);
    }

    private static TupleOutput sizedOutput(BigDecimal val) {
        int len = TupleOutput.getBigDecimalMaxByteLength(val);
        return new TupleOutput(new byte[len]);
    }
}

