/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.sleepycat;

import com.amazon.carbonado.FetchDeadlockException;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchTimeoutException;
import com.amazon.carbonado.PersistDeadlockException;
import com.amazon.carbonado.PersistDeniedException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistTimeoutException;
import com.amazon.carbonado.spi.ExceptionTransformer;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.LockNotGrantedException;

class JE_ExceptionTransformer
extends ExceptionTransformer {
    private static JE_ExceptionTransformer cInstance;

    public static JE_ExceptionTransformer getInstance() {
        if (cInstance == null) {
            cInstance = new JE_ExceptionTransformer();
        }
        return cInstance;
    }

    JE_ExceptionTransformer() {
    }

    protected FetchException transformIntoFetchException(Throwable e) {
        FetchException fe = super.transformIntoFetchException(e);
        if (fe != null) {
            return fe;
        }
        if (e instanceof DatabaseException) {
            if (JE_ExceptionTransformer.isTimeout(e)) {
                return new FetchTimeoutException(e);
            }
            if (JE_ExceptionTransformer.isDeadlock(e)) {
                return new FetchDeadlockException(e);
            }
        }
        return null;
    }

    protected PersistException transformIntoPersistException(Throwable e) {
        String message;
        PersistException pe = super.transformIntoPersistException(e);
        if (pe != null) {
            return pe;
        }
        if (e instanceof DatabaseException) {
            if (JE_ExceptionTransformer.isTimeout(e)) {
                return new PersistTimeoutException(e);
            }
            if (JE_ExceptionTransformer.isDeadlock(e)) {
                return new PersistDeadlockException(e);
            }
            String message2 = e.getMessage();
            if (message2 != null && message2.toUpperCase().indexOf("READ ONLY") >= 0) {
                return new PersistDeniedException(e);
            }
        } else if (e instanceof UnsupportedOperationException && (message = e.getMessage()) != null && message.toUpperCase().indexOf("READ ONLY") >= 0) {
            return new PersistDeniedException(e);
        }
        return null;
    }

    private static boolean isTimeout(Throwable e) {
        return e.getClass().equals(LockNotGrantedException.class) || e.getClass().getName().endsWith(".LockNotAvailableException") || e.getClass().getName().endsWith(".LockTimeoutException") || e.getClass().getName().endsWith(".TransactionTimeoutException");
    }

    private static boolean isDeadlock(Throwable e) {
        return e.getClass().equals(DeadlockException.class) || e.getClass().getName().endsWith(".LockConflictException");
    }
}

