/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.sleepycat;

import com.amazon.carbonado.repo.sleepycat.JE_TimeoutTransaction;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.Transaction;

class JE_Transaction {
    final JE_Transaction mParent;
    final Transaction mTxn;
    private UndoAction mUndoLog;

    JE_Transaction(Transaction txn) {
        this.mParent = null;
        this.mTxn = txn;
    }

    JE_Transaction(JE_Transaction parent) {
        this.mParent = parent;
        this.mTxn = parent.mTxn;
    }

    JE_Transaction createChild() throws DatabaseException {
        return new JE_Transaction(this);
    }

    JE_Transaction createChild(Environment env, long timeout) throws DatabaseException {
        return new JE_TimeoutTransaction(this, env, timeout);
    }

    void addUndo(final UndoAction action) {
        if (action != null && this.mParent != null) {
            final UndoAction prev = this.mUndoLog;
            this.mUndoLog = prev == null ? action : new UndoAction(){

                public void apply() throws DatabaseException {
                    action.apply();
                    prev.apply();
                }
            };
        }
    }

    void abort() throws DatabaseException {
        if (this.mParent == null) {
            this.mTxn.abort();
        } else {
            UndoAction undo = this.mUndoLog;
            if (undo != null) {
                undo.apply();
            }
        }
    }

    void commit() throws DatabaseException {
        if (this.mParent == null) {
            this.mTxn.commit();
        } else {
            this.mParent.addUndo(this.mUndoLog);
        }
    }

    void commitSync() throws DatabaseException {
        if (this.mParent == null) {
            this.mTxn.commitSync();
        } else {
            this.mParent.addUndo(this.mUndoLog);
        }
    }

    void commitNoSync() throws DatabaseException {
        if (this.mParent == null) {
            this.mTxn.commitNoSync();
        } else {
            this.mParent.addUndo(this.mUndoLog);
        }
    }

    void commitWriteNoSync() throws DatabaseException {
        if (this.mParent == null) {
            this.mTxn.commitWriteNoSync();
        } else {
            this.mParent.addUndo(this.mUndoLog);
        }
    }

    void setTxnTimeout(long timeout) throws DatabaseException {
        this.mTxn.setTxnTimeout(timeout);
    }

    void setLockTimeout(long timeout) throws DatabaseException {
        if (timeout <= 0L) {
            timeout = timeout < 0L ? 0L : 1L;
        }
        this.mTxn.setLockTimeout(timeout);
    }

    long getId() throws DatabaseException {
        return this.mTxn.getId();
    }

    void setName(String name) {
        this.mTxn.setName(name);
    }

    String getName() {
        return this.mTxn.getName();
    }

    public String toString() {
        return this.mTxn.toString();
    }

    static interface UndoAction {
        public void apply() throws DatabaseException;
    }
}

