/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.sleepycat;

import com.amazon.carbonado.ConfigurationException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.repo.sleepycat.BDBProduct;
import com.amazon.carbonado.repo.sleepycat.BDBRepository;
import com.amazon.carbonado.repo.sleepycat.BDBRepositoryBuilder;
import com.amazon.carbonado.repo.sleepycat.BDBStorage;
import com.amazon.carbonado.repo.sleepycat.JE_ExceptionTransformer;
import com.amazon.carbonado.repo.sleepycat.JE_SetConfigOption;
import com.amazon.carbonado.repo.sleepycat.JE_Storage;
import com.amazon.carbonado.repo.sleepycat.JE_Transaction;
import com.amazon.carbonado.spi.ExceptionTransformer;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.util.DbBackup;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JE_Repository
extends BDBRepository<JE_Transaction> {
    private static final TransactionConfig TXN_READ_UNCOMMITTED;
    private static final TransactionConfig TXN_READ_COMMITTED;
    private static final TransactionConfig TXN_REPEATABLE_READ;
    private static final TransactionConfig TXN_SERIALIZABLE;
    private static final TransactionConfig TXN_READ_UNCOMMITTED_NOWAIT;
    private static final TransactionConfig TXN_READ_COMMITTED_NOWAIT;
    private static final TransactionConfig TXN_REPEATABLE_READ_NOWAIT;
    private static final TransactionConfig TXN_SERIALIZABLE_NOWAIT;
    final Environment mEnv;
    final boolean mDatabasesTransactional;
    private DbBackup mBackup;

    JE_Repository(AtomicReference<Repository> rootRef, BDBRepositoryBuilder builder) throws RepositoryException {
        super(rootRef, builder, (ExceptionTransformer)JE_ExceptionTransformer.getInstance());
        EnvironmentConfig envConfig;
        if (JEVersion.CURRENT_VERSION.getMajor() < 3) {
            throw new SupportException("BDB-JE version is too old. Major version must at least be 3: " + JEVersion.CURRENT_VERSION);
        }
        try {
            envConfig = (EnvironmentConfig)builder.getInitialEnvironmentConfig();
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Unsupported initial environment config. Must be instance of " + EnvironmentConfig.class.getName(), (Throwable)e);
        }
        if (envConfig == null) {
            Long cacheSize;
            Integer cachePercent;
            envConfig = new EnvironmentConfig();
            JE_SetConfigOption.setBooleanParam(envConfig, "setTransactional", true);
            JE_SetConfigOption.setBooleanParam(envConfig, "setReadOnly", builder.getReadOnly());
            JE_SetConfigOption.setBooleanParam(envConfig, "setAllowCreate", !builder.getReadOnly());
            JE_SetConfigOption.setBooleanParam(envConfig, "setTxnNoSync", builder.getTransactionNoSync());
            JE_SetConfigOption.setBooleanParam(envConfig, "setTxnWriteNoSync", builder.getTransactionWriteNoSync());
            if (builder.getLogInMemory()) {
                JE_SetConfigOption.setNamedParam(envConfig, "je.log.memOnly", "true");
            }
            try {
                Integer maxSize = builder.getLogFileMaxSize();
                if (maxSize != null) {
                    JE_SetConfigOption.setNamedParam(envConfig, "je.log.fileMax", maxSize.toString());
                }
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
            Boolean checksumEnabled = builder.getChecksumEnabled();
            if (checksumEnabled != null) {
                JE_SetConfigOption.setNamedParam(envConfig, "je.log.checksumRead", checksumEnabled.toString());
            }
            if ((cachePercent = builder.getCachePercent()) != null && cachePercent > 0) {
                JE_SetConfigOption.setNamedParam(envConfig, "je.maxMemoryPercent", cachePercent.toString());
            }
            if ((cacheSize = builder.getCacheSize()) != null && cacheSize > 0L) {
                JE_SetConfigOption.setNamedParam(envConfig, "je.maxMemory", cacheSize.toString());
            }
            JE_SetConfigOption.setNamedParam(envConfig, "je.lock.timeout", String.valueOf(builder.getLockTimeoutInMicroseconds()));
            JE_SetConfigOption.setNamedParam(envConfig, "je.txn.timeout", String.valueOf(builder.getTransactionTimeoutInMicroseconds()));
            try {
                JE_SetConfigOption.setNamedParam(envConfig, "je.cleaner.expunge", String.valueOf(!this.mKeepOldLogFiles));
            }
            catch (NoSuchFieldError e) {}
        } else if (!envConfig.getTransactional()) {
            throw new IllegalArgumentException("EnvironmentConfig: getTransactional is false");
        }
        try {
            this.mEnv = new Environment(builder.getEnvironmentHomeFile(), envConfig);
        }
        catch (DatabaseException e) {
            throw JE_ExceptionTransformer.getInstance().toRepositoryException(e);
        }
        catch (Throwable e) {
            String message = "Unable to open environment";
            if (e.getMessage() != null) {
                message = message + ": " + e.getMessage();
            }
            throw new RepositoryException(message, e);
        }
        boolean databasesTransactional = envConfig.getTransactional();
        if (builder.getDatabasesTransactional() != null) {
            databasesTransactional = builder.getDatabasesTransactional();
        }
        this.mDatabasesTransactional = databasesTransactional;
        this.start(0L, 0L, builder);
    }

    public Object getEnvironment() {
        return this.mEnv;
    }

    public BDBProduct getBDBProduct() {
        return BDBProduct.JE;
    }

    public int[] getVersion() {
        JEVersion version = JEVersion.CURRENT_VERSION;
        return new int[]{version.getMajor(), version.getMinor(), version.getPatch()};
    }

    public File getHome() {
        return this.mEnvHome;
    }

    public File getDataHome() {
        return this.mEnvHome;
    }

    IsolationLevel selectIsolationLevel(Transaction parent, IsolationLevel level) {
        if (level == null) {
            if (parent == null) {
                return IsolationLevel.REPEATABLE_READ;
            }
            return parent.getIsolationLevel();
        }
        if (level == IsolationLevel.SNAPSHOT) {
            return null;
        }
        if (parent != null && parent.getIsolationLevel() != IsolationLevel.NONE && level != IsolationLevel.NONE) {
            IsolationLevel parentLevel = parent.getIsolationLevel();
            level = parentLevel.compareTo((Enum)level) >= 0 ? parentLevel : null;
        }
        return level;
    }

    protected JE_Transaction txn_begin(JE_Transaction parent, IsolationLevel level) throws Exception {
        TransactionConfig config;
        if (parent != null) {
            return parent.createChild();
        }
        switch (level) {
            case READ_UNCOMMITTED: {
                config = TXN_READ_UNCOMMITTED;
                break;
            }
            case READ_COMMITTED: {
                config = TXN_READ_COMMITTED;
                break;
            }
            default: {
                config = TXN_REPEATABLE_READ;
                break;
            }
            case SERIALIZABLE: {
                config = TXN_SERIALIZABLE;
            }
        }
        return new JE_Transaction(this.mEnv.beginTransaction(null, config));
    }

    protected JE_Transaction txn_begin(JE_Transaction parent, IsolationLevel level, int timeout, TimeUnit unit) throws Exception {
        if (parent != null) {
            return parent.createChild(this.mEnv, unit.toMicros(timeout));
        }
        JE_Transaction txn = this.txn_begin(null, level);
        txn.setLockTimeout(unit.toMicros(timeout));
        return txn;
    }

    protected JE_Transaction txn_begin_nowait(JE_Transaction parent, IsolationLevel level) throws Exception {
        TransactionConfig config;
        if (parent != null) {
            return parent.createChild(this.mEnv, 0L);
        }
        switch (level) {
            case READ_UNCOMMITTED: {
                config = TXN_READ_UNCOMMITTED_NOWAIT;
                break;
            }
            case READ_COMMITTED: {
                config = TXN_READ_COMMITTED_NOWAIT;
                break;
            }
            default: {
                config = TXN_REPEATABLE_READ_NOWAIT;
                break;
            }
            case SERIALIZABLE: {
                config = TXN_SERIALIZABLE_NOWAIT;
            }
        }
        return new JE_Transaction(this.mEnv.beginTransaction(null, config));
    }

    protected void txn_commit(JE_Transaction txn) throws Exception {
        txn.commit();
    }

    protected void txn_abort(JE_Transaction txn) throws Exception {
        txn.abort();
    }

    protected void env_checkpoint() throws Exception {
        CheckpointConfig cc = new CheckpointConfig();
        JE_SetConfigOption.setBooleanParam(cc, "setForce", true);
        this.mEnv.checkpoint(cc);
    }

    protected void env_sync() throws Exception {
        this.mEnv.sync();
    }

    protected void env_checkpoint(int kBytes, int minutes) throws Exception {
        CheckpointConfig cc = new CheckpointConfig();
        JE_SetConfigOption.setIntParam(cc, "setKBytes", kBytes);
        JE_SetConfigOption.setIntParam(cc, "setMinutes", minutes);
        this.mEnv.checkpoint(cc);
    }

    protected void env_detectDeadlocks() throws Exception {
    }

    protected void env_close() throws Exception {
        if (this.mEnv != null) {
            this.mEnv.close();
        }
    }

    protected <S extends Storable> BDBStorage<JE_Transaction, S> createBDBStorage(Class<S> type) throws Exception {
        return new JE_Storage<S>(this, type);
    }

    void enterBackupMode(boolean deleteOldLogFiles) throws Exception {
        DbBackup backup = new DbBackup(this.mEnv);
        backup.startBackup();
        this.mBackup = backup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exitBackupMode() throws Exception {
        DbBackup backup = this.mBackup;
        if (backup != null) {
            try {
                backup.endBackup();
            }
            finally {
                this.mBackup = null;
            }
        }
    }

    void enterIncrementalBackupMode(long lastLogNum, boolean deleteOldLogFiles) throws Exception {
        DbBackup backup = new DbBackup(this.mEnv, lastLogNum);
        backup.startBackup();
        this.mBackup = backup;
    }

    void exitIncrementalBackupMode() throws Exception {
        this.exitBackupMode();
    }

    File[] backupDataFiles() throws Exception {
        return new File[0];
    }

    File[] backupLogFiles(long[] newLastLogNum) throws Exception {
        File home = this.mEnv.getHome();
        String[] names = this.mBackup.getLogFilesInBackupSet();
        File[] files = new File[names.length];
        for (int i = 0; i < names.length; ++i) {
            files[i] = new File(home, names[i]);
        }
        newLastLogNum[0] = this.mBackup.getLastFileInBackupSet();
        return files;
    }

    File[] incrementalBackup(long lastLogNum, long[] newLastLogNum) throws Exception {
        return this.backupLogFiles(newLastLogNum);
    }

    static {
        TransactionConfig serializableNoWait;
        TransactionConfig repeatableReadNoWait;
        TransactionConfig readCommittedNoWait;
        TransactionConfig readUncommittedNoWait;
        TransactionConfig serializable;
        TransactionConfig repeatableRead;
        TransactionConfig readCommitted;
        TransactionConfig readUncommitted;
        try {
            readUncommitted = new TransactionConfig();
            JE_SetConfigOption.setBooleanParam(readUncommitted, "setReadUncommitted", true);
            readCommitted = new TransactionConfig();
            JE_SetConfigOption.setBooleanParam(readCommitted, "setReadCommitted", true);
            repeatableRead = TransactionConfig.DEFAULT;
            serializable = new TransactionConfig();
            JE_SetConfigOption.setBooleanParam(serializable, "setSerializableIsolation", true);
            readUncommittedNoWait = new TransactionConfig();
            JE_SetConfigOption.setBooleanParam(readUncommittedNoWait, "setReadUncommitted", true);
            JE_SetConfigOption.setBooleanParam(readUncommittedNoWait, "setNoWait", true);
            readCommittedNoWait = new TransactionConfig();
            JE_SetConfigOption.setBooleanParam(readCommittedNoWait, "setReadCommitted", true);
            JE_SetConfigOption.setBooleanParam(readCommittedNoWait, "setNoWait", true);
            repeatableReadNoWait = new TransactionConfig();
            JE_SetConfigOption.setBooleanParam(repeatableReadNoWait, "setNoWait", true);
            serializableNoWait = new TransactionConfig();
            JE_SetConfigOption.setBooleanParam(serializableNoWait, "setSerializableIsolation", true);
            JE_SetConfigOption.setBooleanParam(serializableNoWait, "setNoWait", true);
        }
        catch (RepositoryException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new ExceptionInInitializerError(cause);
        }
        TXN_READ_UNCOMMITTED = readUncommitted;
        TXN_READ_COMMITTED = readCommitted;
        TXN_REPEATABLE_READ = repeatableRead;
        TXN_SERIALIZABLE = serializable;
        TXN_READ_UNCOMMITTED_NOWAIT = readUncommittedNoWait;
        TXN_READ_COMMITTED_NOWAIT = readCommittedNoWait;
        TXN_REPEATABLE_READ_NOWAIT = repeatableReadNoWait;
        TXN_SERIALIZABLE_NOWAIT = serializableNoWait;
    }
}

